/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ComponentTypeRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.clientregistration.RegistrationAccessToken;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyManager;
import org.keycloak.services.clientregistration.policy.RegistrationAuth;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;
import org.keycloak.util.JsonSerialization;

public class ClientRegistrationPoliciesTest
extends AbstractClientRegistrationTest {
    private static final String PRIVATE_KEY = "MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=";
    private static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        super.addTestRealms(testRealms);
        testRealms.get(0).setId("test");
        testRealms.get(0).setPrivateKey(PRIVATE_KEY);
        testRealms.get(0).setPublicKey(PUBLIC_KEY);
    }

    @Override
    @After
    public void after() throws Exception {
        super.after();
        ComponentRepresentation trustedHostPolicy = this.findPolicyByProviderAndAuth("trusted-hosts", this.getPolicyAnon());
        trustedHostPolicy.getConfig().putSingle((Object)"host-sending-registration-request-must-match", (Object)"true");
        trustedHostPolicy.getConfig().putSingle((Object)"client-uris-must-match", (Object)"true");
        trustedHostPolicy.getConfig().put((Object)"trusted-hosts", Collections.emptyList());
        this.realmResource().components().component(trustedHostPolicy.getId()).update(trustedHostPolicy);
    }

    private RealmResource realmResource() {
        return this.adminClient.realm("test");
    }

    private ClientRepresentation createRep(String clientId) {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientId);
        client.setSecret("test-secret");
        return client;
    }

    private OIDCClientRepresentation createRepOidc() {
        return this.createRepOidc("http://localhost:8080/foo", "http://localhost:8080/foo");
    }

    private OIDCClientRepresentation createRepOidc(String clientBaseUri, String clientRedirectUri) {
        OIDCClientRepresentation client = new OIDCClientRepresentation();
        client.setClientName("RegistrationAccessTokenTest");
        client.setClientUri(clientBaseUri);
        client.setRedirectUris(Collections.singletonList(clientRedirectUri));
        return client;
    }

    public OIDCClientRepresentation create() throws ClientRegistrationException {
        OIDCClientRepresentation client = this.createRepOidc();
        OIDCClientRepresentation response = this.reg.oidc().create(client);
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        return response;
    }

    private void assertOidcFail(ClientRegOp operation, OIDCClientRepresentation client, int expectedStatusCode) {
        this.assertOidcFail(operation, client, expectedStatusCode, null);
    }

    private void assertOidcFail(ClientRegOp operation, OIDCClientRepresentation client, int expectedStatusCode, String expectedErrorContains) {
        block7: {
            try {
                switch (operation) {
                    case CREATE: {
                        this.reg.oidc().create(client);
                        break;
                    }
                    case UPDATE: {
                        this.reg.oidc().update(client);
                        break;
                    }
                    case DELETE: {
                        this.reg.oidc().delete(client);
                    }
                }
                Assert.fail((String)("Not expected to successfuly run operation " + operation.toString() + " on client"));
            }
            catch (ClientRegistrationException expected) {
                HttpErrorException httpEx = (HttpErrorException)expected.getCause();
                Assert.assertEquals((long)expectedStatusCode, (long)httpEx.getStatusLine().getStatusCode());
                if (expectedErrorContains == null) break block7;
                org.junit.Assert.assertTrue((String)("Error response doesn't contain expected text. The error response text is: " + httpEx.getErrorResponse()), (boolean)httpEx.getErrorResponse().contains(expectedErrorContains));
            }
        }
    }

    private void assertFail(ClientRegOp operation, ClientRepresentation client, int expectedStatusCode, String expectedErrorContains) {
        block7: {
            try {
                switch (operation) {
                    case CREATE: {
                        this.reg.create(client);
                        break;
                    }
                    case UPDATE: {
                        this.reg.update(client);
                        break;
                    }
                    case DELETE: {
                        this.reg.delete(client);
                    }
                }
                Assert.fail((String)("Not expected to successfuly run operation " + operation.toString() + " on client"));
            }
            catch (ClientRegistrationException expected) {
                HttpErrorException httpEx = (HttpErrorException)expected.getCause();
                Assert.assertEquals((long)expectedStatusCode, (long)httpEx.getStatusLine().getStatusCode());
                if (expectedErrorContains == null) break block7;
                org.junit.Assert.assertTrue((String)("Error response doesn't contain expected text. The error response text is: " + httpEx.getErrorResponse()), (boolean)httpEx.getErrorResponse().contains(expectedErrorContains));
            }
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testAnonCreateWithTrustedHost() throws Exception {
        OIDCClientRepresentation client = this.createRepOidc("http://root", "http://redirect");
        this.assertOidcFail(ClientRegOp.CREATE, client, 403, "Host not trusted");
        this.setTrustedHost("localhost");
        this.assertOidcFail(ClientRegOp.CREATE, client, 403, "URL doesn't match");
        client.setRedirectUris(Collections.singletonList("http://localhost:8080/foo"));
        this.assertOidcFail(ClientRegOp.CREATE, client, 403, "URL doesn't match");
        client.setClientUri("http://localhost:8080/foo");
        OIDCClientRepresentation oidcClientRep = this.reg.oidc().create(client);
        this.assertRegAccessToken(oidcClientRep.getRegistrationAccessToken(), RegistrationAuth.ANONYMOUS);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testAnonUpdateWithTrustedHost() throws Exception {
        this.setTrustedHost("localhost");
        OIDCClientRepresentation client = this.create();
        client.setRedirectUris(Collections.singletonList("http://bad:8080/foo"));
        this.assertOidcFail(ClientRegOp.UPDATE, client, 403, "URL doesn't match");
        client.setRedirectUris(Collections.singletonList("http://localhost:8080/foo"));
        this.reg.oidc().update(client);
    }

    @Test
    public void testRedirectUriWithDomain() throws Exception {
        ComponentRepresentation trustedHostPolicyRep = this.findPolicyByProviderAndAuth("trusted-hosts", this.getPolicyAnon());
        trustedHostPolicyRep.getConfig().putSingle((Object)"host-sending-registration-request-must-match", (Object)"false");
        trustedHostPolicyRep.getConfig().put((Object)"trusted-hosts", Arrays.asList("www.host.com", "*.example.com"));
        this.realmResource().components().component(trustedHostPolicyRep.getId()).update(trustedHostPolicyRep);
        OIDCClientRepresentation oidcClientRep = this.createRepOidc("http://www.host.com", "http://www.example.com");
        this.reg.oidc().create(oidcClientRep);
        trustedHostPolicyRep.getConfig().put((Object)"trusted-hosts", Arrays.asList("www.host.com", "www1.example.com"));
        this.realmResource().components().component(trustedHostPolicyRep.getId()).update(trustedHostPolicyRep);
        oidcClientRep = this.createRepOidc("http://www.host.com", "http://www.example.com");
        this.assertOidcFail(ClientRegOp.CREATE, oidcClientRep, 403, "URL doesn't match");
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testAnonConsentRequired() throws Exception {
        this.setTrustedHost("localhost");
        OIDCClientRepresentation client = this.create();
        String clientId = client.getClientId();
        ClientRepresentation clientRep = ApiUtil.findClientByClientId((RealmResource)this.realmResource(), (String)clientId).toRepresentation();
        Assert.assertTrue((boolean)clientRep.isConsentRequired());
        clientRep.setConsentRequired(Boolean.valueOf(false));
        this.assertFail(ClientRegOp.UPDATE, clientRep, 403, "Not permitted to update consentRequired to false");
        clientRep.setConsentRequired(Boolean.valueOf(true));
        this.reg.update(clientRep);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testAnonFullScopeAllowed() throws Exception {
        this.setTrustedHost("localhost");
        OIDCClientRepresentation client = this.create();
        String clientId = client.getClientId();
        ClientRepresentation clientRep = ApiUtil.findClientByClientId((RealmResource)this.realmResource(), (String)clientId).toRepresentation();
        Assert.assertFalse((boolean)clientRep.isFullScopeAllowed());
        clientRep.setFullScopeAllowed(Boolean.valueOf(true));
        this.assertFail(ClientRegOp.UPDATE, clientRep, 403, "Not permitted to enable fullScopeAllowed");
        clientRep.setFullScopeAllowed(Boolean.valueOf(false));
        this.reg.update(clientRep);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testClientDisabledPolicy() throws Exception {
        this.setTrustedHost("localhost");
        OIDCClientRepresentation client = this.create();
        String clientId = client.getClientId();
        ClientRepresentation clientRep = ApiUtil.findClientByClientId((RealmResource)this.realmResource(), (String)clientId).toRepresentation();
        Assert.assertTrue((boolean)clientRep.isEnabled());
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setName("Clients disabled");
        rep.setParentId("test");
        rep.setProviderId("client-disabled");
        rep.setProviderType(ClientRegistrationPolicy.class.getName());
        rep.setSubType(this.getPolicyAnon());
        Response response = this.realmResource().components().add(rep);
        String policyId = ApiUtil.getCreatedId((Response)response);
        response.close();
        client = this.create();
        clientId = client.getClientId();
        clientRep = ApiUtil.findClientByClientId((RealmResource)this.realmResource(), (String)clientId).toRepresentation();
        Assert.assertFalse((boolean)clientRep.isEnabled());
        clientRep.setEnabled(Boolean.valueOf(true));
        this.assertFail(ClientRegOp.UPDATE, clientRep, 403, "Not permitted to enable client");
        clientRep.setEnabled(Boolean.valueOf(false));
        this.reg.update(clientRep);
        this.realmResource().components().component(policyId).remove();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testMaxClientsPolicy() throws Exception {
        this.setTrustedHost("localhost");
        int clientsCount = this.realmResource().clients().findAll().size();
        int newClientsLimit = clientsCount + 1;
        ComponentRepresentation maxClientsPolicyRep = this.findPolicyByProviderAndAuth("max-clients", this.getPolicyAnon());
        maxClientsPolicyRep.getConfig().putSingle((Object)"max-clients", (Object)String.valueOf(newClientsLimit));
        this.realmResource().components().component(maxClientsPolicyRep.getId()).update(maxClientsPolicyRep);
        OIDCClientRepresentation client = this.create();
        this.assertOidcFail(ClientRegOp.CREATE, this.createRepOidc(), 403, "It's allowed to have max " + newClientsLimit + " clients per realm");
        maxClientsPolicyRep.getConfig().putSingle((Object)"max-clients", (Object)String.valueOf(10000));
        this.realmResource().components().component(maxClientsPolicyRep.getId()).update(maxClientsPolicyRep);
    }

    @Test
    public void testProviders() throws Exception {
        List reps = this.realmResource().clientRegistrationPolicy().getProviders();
        Map<String, ComponentTypeRepresentation> providersMap = reps.stream().collect(Collectors.toMap(rep -> rep.getId(), rep -> rep));
        ComponentTypeRepresentation protMappersRep = providersMap.get("allowed-protocol-mappers");
        List<String> availableMappers = this.getProviderConfigProperty(protMappersRep, "allowed-protocol-mapper-types");
        List<String> someExpectedMappers = Arrays.asList("saml-user-attribute-mapper", "oidc-usermodel-attribute-mapper", "saml-user-property-mapper", "oidc-usermodel-property-mapper", "oidc-hardcoded-role-mapper");
        availableMappers.containsAll(someExpectedMappers);
        ComponentTypeRepresentation clientScopeRep = providersMap.get("allowed-client-templates");
        List<String> clientScopes = this.getProviderConfigProperty(clientScopeRep, "allowed-client-scopes");
        Assert.assertFalse((boolean)clientScopes.isEmpty());
        Assert.assertTrue((boolean)clientScopes.contains("profile"));
        Assert.assertFalse((boolean)clientScopes.contains("foo"));
        Assert.assertFalse((boolean)clientScopes.contains("bar"));
        ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
        clientScope.setName("foo");
        clientScope.setProtocol("openid-connect");
        Response response = this.realmResource().clientScopes().create(clientScope);
        String fooScopeId = ApiUtil.getCreatedId((Response)response);
        response.close();
        clientScope = new ClientScopeRepresentation();
        clientScope.setName("bar");
        clientScope.setProtocol("openid-connect");
        response = this.realmResource().clientScopes().create(clientScope);
        String barScopeId = ApiUtil.getCreatedId((Response)response);
        response.close();
        reps = this.realmResource().clientRegistrationPolicy().getProviders();
        clientScopeRep = reps.stream().filter(rep1 -> rep1.getId().equals("allowed-client-templates")).findFirst().get();
        clientScopes = this.getProviderConfigProperty(clientScopeRep, "allowed-client-scopes");
        Assert.assertTrue((boolean)clientScopes.contains("foo"));
        Assert.assertTrue((boolean)clientScopes.contains("bar"));
        this.realmResource().clientScopes().get(fooScopeId).remove();
        this.realmResource().clientScopes().get(barScopeId).remove();
    }

    private List<String> getProviderConfigProperty(ComponentTypeRepresentation provider, String expectedConfigPropName) {
        Assert.assertNotNull((Object)provider);
        List list = provider.getProperties();
        list = list.stream().filter(rep -> rep.getName().equals(expectedConfigPropName)).collect(Collectors.toList());
        Assert.assertEquals((long)list.size(), (long)1L);
        ConfigPropertyRepresentation allowedProtocolMappers = (ConfigPropertyRepresentation)list.get(0);
        Assert.assertEquals((Object)allowedProtocolMappers.getName(), (Object)expectedConfigPropName);
        return allowedProtocolMappers.getOptions();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testClientScopesPolicy() throws Exception {
        this.setTrustedHost("localhost");
        ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
        clientScope.setName("foo");
        clientScope.setProtocol("openid-connect");
        Response response = this.realmResource().clientScopes().create(clientScope);
        String clientScopeId = ApiUtil.getCreatedId((Response)response);
        response.close();
        ClientRepresentation clientRep = this.createRep("test-app");
        clientRep.setDefaultClientScopes(Collections.singletonList("foo"));
        this.assertFail(ClientRegOp.CREATE, clientRep, 403, "Not permitted to use specified clientScope");
        clientRep.setDefaultClientScopes(null);
        ClientRepresentation registeredClient = this.reg.create(clientRep);
        this.reg.auth(Auth.token((ClientRepresentation)registeredClient));
        registeredClient.setDefaultClientScopes(Collections.singletonList("foo"));
        this.assertFail(ClientRegOp.UPDATE, registeredClient, 403, "Not permitted to use specified clientScope");
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.realmResource(), (String)"test-app");
        client.addDefaultClientScope(clientScopeId);
        this.reg.update(registeredClient);
        this.realmResource().clients().get(client.toRepresentation().getId()).remove();
        this.realmResource().clientScopes().get(clientScopeId).remove();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testClientScopesPolicyWithPermittedScope() throws Exception {
        this.setTrustedHost("localhost");
        ClientScopeRepresentation clientScope = new ClientScopeRepresentation();
        clientScope.setName("foo");
        clientScope.setProtocol("openid-connect");
        Response response = this.realmResource().clientScopes().create(clientScope);
        String clientScopeId = ApiUtil.getCreatedId((Response)response);
        response.close();
        ClientRepresentation clientRep = this.createRep("test-app");
        clientRep.setDefaultClientScopes(Collections.singletonList("foo"));
        this.assertFail(ClientRegOp.CREATE, clientRep, 403, "Not permitted to use specified clientScope");
        ComponentRepresentation clientScopesPolicyRep = this.findPolicyByProviderAndAuth("allowed-client-templates", this.getPolicyAnon());
        clientScopesPolicyRep.getConfig().putSingle((Object)"allowed-client-scopes", (Object)"foo");
        this.realmResource().components().component(clientScopesPolicyRep.getId()).update(clientScopesPolicyRep);
        ClientRepresentation registeredClient = this.reg.create(clientRep);
        Assert.assertNotNull((Object)registeredClient.getRegistrationAccessToken());
        ApiUtil.findClientResourceByClientId((RealmResource)this.realmResource(), (String)"test-app").remove();
        this.realmResource().clientScopes().get(clientScopeId).remove();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testProtocolMappersCreate() throws Exception {
        this.setTrustedHost("localhost");
        ClientRepresentation clientRep = this.createRep("test-app");
        clientRep.setProtocolMappers(Collections.singletonList(this.createHardcodedMapperRep()));
        this.assertFail(ClientRegOp.CREATE, clientRep, 403, "ProtocolMapper type not allowed");
        ClientInitialAccessPresentation token = this.adminClient.realm("test").clientInitialAccess().create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(10)));
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)token));
        this.assertFail(ClientRegOp.CREATE, clientRep, 403, "ProtocolMapper type not allowed");
        ComponentRepresentation protocolMapperPolicyRep = this.findPolicyByProviderAndAuth("allowed-protocol-mappers", this.getPolicyAuth());
        protocolMapperPolicyRep.getConfig().add((Object)"allowed-protocol-mapper-types", (Object)"oidc-hardcoded-role-mapper");
        this.realmResource().components().component(protocolMapperPolicyRep.getId()).update(protocolMapperPolicyRep);
        ClientRepresentation registeredClient = this.reg.create(clientRep);
        Assert.assertNotNull((Object)registeredClient.getRegistrationAccessToken());
        clientRep = this.createRep("test-app-2");
        clientRep.setProtocolMappers(Collections.singletonList(this.createHardcodedMapperRep()));
        this.reg.auth(null);
        this.assertFail(ClientRegOp.CREATE, clientRep, 403, "ProtocolMapper type not allowed");
        ApiUtil.findClientResourceByClientId((RealmResource)this.realmResource(), (String)"test-app").remove();
        protocolMapperPolicyRep.getConfig().remove((Object)"allowed-protocol-mapper-types", (Object)"oidc-hardcoded-role-mapper");
        this.realmResource().components().component(protocolMapperPolicyRep.getId()).update(protocolMapperPolicyRep);
    }

    private ProtocolMapperRepresentation createHardcodedMapperRep() {
        ProtocolMapperRepresentation protocolMapper = new ProtocolMapperRepresentation();
        protocolMapper.setName("Hardcoded foo role");
        protocolMapper.setProtocolMapper("oidc-hardcoded-role-mapper");
        protocolMapper.setProtocol("openid-connect");
        protocolMapper.getConfig().put("role", "foo-role");
        return protocolMapper;
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testProtocolMappersUpdate() throws Exception {
        this.setTrustedHost("localhost");
        ProtocolMapperRepresentation protocolMapper = new ProtocolMapperRepresentation();
        protocolMapper.setName("Full name");
        protocolMapper.setProtocolMapper("oidc-full-name-mapper");
        protocolMapper.setProtocol("openid-connect");
        ClientRepresentation clientRep = this.createRep("test-app");
        clientRep.setProtocolMappers(Collections.singletonList(protocolMapper));
        ClientRepresentation registeredClient = this.reg.create(clientRep);
        this.reg.auth(Auth.token((ClientRepresentation)registeredClient));
        registeredClient.getProtocolMappers().add(this.createHardcodedMapperRep());
        this.assertFail(ClientRegOp.UPDATE, registeredClient, 403, "ProtocolMapper type not allowed");
        registeredClient.getProtocolMappers().removeIf(mapper -> mapper.getProtocolMapper().equals("oidc-hardcoded-role-mapper"));
        this.reg.update(registeredClient);
        ApiUtil.findClientResourceByClientId((RealmResource)this.realmResource(), (String)"test-app").remove();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testProtocolMappersConsentRequired() throws Exception {
        this.setTrustedHost("localhost");
        ClientRepresentation clientRep = this.createRep("test-app");
        ClientRepresentation registeredClient = this.reg.create(clientRep);
        Assert.assertNull((Object)registeredClient.getProtocolMappers());
        ApiUtil.findClientResourceByClientId((RealmResource)this.realmResource(), (String)"test-app").remove();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testProtocolMappersRemoveBuiltins() throws Exception {
        this.setTrustedHost("localhost");
        ComponentRepresentation protocolMapperPolicyRep = this.findPolicyByProviderAndAuth("allowed-protocol-mappers", this.getPolicyAnon());
        protocolMapperPolicyRep.getConfig().add((Object)"allowed-protocol-mapper-types", (Object)"oidc-hardcoded-role-mapper");
        this.realmResource().components().component(protocolMapperPolicyRep.getId()).update(protocolMapperPolicyRep);
        ClientRepresentation clientRep = this.createRep("test-app");
        clientRep.setProtocolMappers(Collections.singletonList(this.createHardcodedMapperRep()));
        ClientRepresentation registeredClient = this.reg.create(clientRep);
        Assert.assertEquals((long)1L, (long)registeredClient.getProtocolMappers().size());
        ProtocolMapperRepresentation hardcodedMapper = (ProtocolMapperRepresentation)registeredClient.getProtocolMappers().get(0);
        ApiUtil.findClientResourceByClientId((RealmResource)this.realmResource(), (String)"test-app").remove();
        protocolMapperPolicyRep.getConfig().remove((Object)"allowed-protocol-mapper-types", (Object)"oidc-hardcoded-role-mapper");
        this.realmResource().components().component(protocolMapperPolicyRep.getId()).update(protocolMapperPolicyRep);
    }

    private String getPolicyAnon() {
        return ClientRegistrationPolicyManager.getComponentTypeKey((RegistrationAuth)RegistrationAuth.ANONYMOUS);
    }

    private String getPolicyAuth() {
        return ClientRegistrationPolicyManager.getComponentTypeKey((RegistrationAuth)RegistrationAuth.AUTHENTICATED);
    }

    private ComponentRepresentation findPolicyByProviderAndAuth(String providerId, String authType) {
        List reps = this.realmResource().components().query("test", ClientRegistrationPolicy.class.getName());
        for (ComponentRepresentation rep : reps) {
            if (!rep.getSubType().equals(authType) || !rep.getProviderId().equals(providerId)) continue;
            return rep;
        }
        return null;
    }

    private void setTrustedHost(String hostname) {
        ComponentRepresentation trustedHostRep = this.findPolicyByProviderAndAuth("trusted-hosts", this.getPolicyAnon());
        trustedHostRep.getConfig().putSingle((Object)"trusted-hosts", (Object)hostname);
        this.realmResource().components().component(trustedHostRep.getId()).update(trustedHostRep);
    }

    private void assertRegAccessToken(String registrationAccessToken, RegistrationAuth expectedRegAuth) throws Exception {
        byte[] content = new JWSInput(registrationAccessToken).getContent();
        RegistrationAccessToken regAccessToken = (RegistrationAccessToken)JsonSerialization.readValue((byte[])content, RegistrationAccessToken.class);
        Assert.assertEquals((Object)regAccessToken.getRegistrationAuth(), (Object)expectedRegAuth.toString().toLowerCase());
    }

    private static enum ClientRegOp {
        CREATE,
        READ,
        UPDATE,
        DELETE;

    }
}

