/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.common.util.Base64Url;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.Constants;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AuthorizationResponseToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.representations.oidc.TokenMetadataRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyEvent;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.executor.SecureRequestObjectExecutor;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.AbstractClientPoliciesTest;
import org.keycloak.testsuite.client.resources.TestApplicationResourceUrls;
import org.keycloak.testsuite.client.resources.TestOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.OAuth2DeviceVerificationPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.rest.resource.TestingOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientPoliciesUtil;
import org.keycloak.testsuite.util.MutualTLSUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

public class ClientPoliciesTest
extends AbstractClientPoliciesTest {
    private static final Logger logger = Logger.getLogger(ClientPoliciesTest.class);
    private static final String CLIENT_NAME = "Zahlungs-App";
    private static final String TEST_USER_NAME = "test-user@localhost";
    private static final String TEST_USER_PASSWORD = "password";
    public static final String DEVICE_APP = "test-device";
    public static final String DEVICE_APP_PUBLIC = "test-device-public";
    private static String userId;
    @Page
    protected OAuth2DeviceVerificationPage verificationPage;
    @Page
    protected OAuthGrantPage grantPage;
    @Page
    protected ErrorPage errorPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        List users = realm.getUsers();
        LinkedList<CredentialRepresentation> credentials = new LinkedList<CredentialRepresentation>();
        CredentialRepresentation password = new CredentialRepresentation();
        password.setType(TEST_USER_PASSWORD);
        password.setValue(TEST_USER_PASSWORD);
        credentials.add(password);
        UserRepresentation user = new UserRepresentation();
        user.setEnabled(Boolean.valueOf(true));
        user.setUsername("manage-clients");
        user.setCredentials(credentials);
        user.setClientRoles(Collections.singletonMap("realm-management", Collections.singletonList(AdminRoles.MANAGE_CLIENTS)));
        users.add(user);
        user = new UserRepresentation();
        user.setEnabled(Boolean.valueOf(true));
        user.setUsername("create-clients");
        user.setCredentials(credentials);
        user.setClientRoles(Collections.singletonMap("realm-management", Collections.singletonList(AdminRoles.CREATE_CLIENT)));
        user.setGroups(Arrays.asList("topGroup"));
        users.add(user);
        realm.setUsers(users);
        List clients = realm.getClients();
        ClientRepresentation app = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId(DEVICE_APP).secret("secret").attribute("oauth2.device.authorization.grant.enabled", "true").build();
        clients.add(app);
        ClientRepresentation appPublic = ClientBuilder.create().id(KeycloakModelUtils.generateId()).publicClient().clientId(DEVICE_APP_PUBLIC).attribute("oauth2.device.authorization.grant.enabled", "true").build();
        clients.add(appPublic);
        userId = KeycloakModelUtils.generateId();
        UserRepresentation deviceUser = UserBuilder.create().id(userId).username("device-login").email("device-login@localhost").password(TEST_USER_PASSWORD).build();
        users.add(deviceUser);
        testRealms.add(realm);
    }

    @Test
    public void testAdminClientRegisterUnacceptableAuthType() throws Exception {
        this.setupPolicyClientIdAndSecretNotAcceptableAuthType("MyPolicy");
        try {
            this.createClientByAdmin(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setClientAuthenticatorType("client-secret"));
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
    }

    @Test
    public void testAdminClientRegisterAcceptableAuthType() throws Exception {
        this.setupPolicyClientIdAndSecretNotAcceptableAuthType("MyPolicy");
        String cId = this.createClientByAdmin(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setClientAuthenticatorType("client-secret-jwt"));
        Assert.assertEquals((Object)"client-secret-jwt", (Object)this.getClientByAdmin(cId).getClientAuthenticatorType());
    }

    @Test
    public void testAdminClientRegisterDefaultAuthType() throws Exception {
        this.setupPolicyClientIdAndSecretNotAcceptableAuthType("MyPolicy");
        try {
            this.createClientByAdmin(this.generateSuffixedName(CLIENT_NAME), clientRep -> {});
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
    }

    @Test
    public void testAdminClientUpdateUnacceptableAuthType() throws Exception {
        this.setupPolicyClientIdAndSecretNotAcceptableAuthType("MyPolicy");
        String cId = this.createClientByAdmin(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setClientAuthenticatorType("client-secret-jwt"));
        Assert.assertEquals((Object)"client-secret-jwt", (Object)this.getClientByAdmin(cId).getClientAuthenticatorType());
        try {
            this.updateClientByAdmin(cId, clientRep -> clientRep.setClientAuthenticatorType("client-secret"));
            Assert.fail();
        }
        catch (ClientPolicyException cpe) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)cpe.getError());
        }
        Assert.assertEquals((Object)"client-secret-jwt", (Object)this.getClientByAdmin(cId).getClientAuthenticatorType());
    }

    @Test
    public void testTwoProfilesWithDifferentConfigurationOfSameExecutorType() throws Exception {
        this.setupPolicyClientIdAndSecretNotAcceptableAuthType("MyPolicy");
        String profileName = "UnusedProfile";
        String json = new ClientPoliciesUtil.ClientProfilesBuilder(this.getProfilesWithoutGlobals()).addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile(profileName, "Profile with SecureClientAuthEnforceExecutorFactory").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-jwt", "client-x509"), null)).toRepresentation()).toString();
        this.updateProfiles(json);
        String cId = this.createClientByAdmin(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setClientAuthenticatorType("client-secret-jwt"));
        Assert.assertEquals((Object)"client-secret-jwt", (Object)this.getClientByAdmin(cId).getClientAuthenticatorType());
    }

    @Test
    public void testAdminClientUpdateAcceptableAuthType() throws Exception {
        this.setupPolicyClientIdAndSecretNotAcceptableAuthType("MyPolicy");
        String cId = this.createClientByAdmin(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setClientAuthenticatorType("client-secret-jwt"));
        Assert.assertEquals((Object)"client-secret-jwt", (Object)this.getClientByAdmin(cId).getClientAuthenticatorType());
        this.updateClientByAdmin(cId, clientRep -> clientRep.setClientAuthenticatorType("client-jwt"));
        Assert.assertEquals((Object)"client-jwt", (Object)this.getClientByAdmin(cId).getClientAuthenticatorType());
    }

    @Test
    public void testAdminClientUpdateDefaultAuthType() throws Exception {
        this.setupPolicyClientIdAndSecretNotAcceptableAuthType("MyPolicy");
        String cId = this.createClientByAdmin(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setClientAuthenticatorType("client-secret-jwt"));
        Assert.assertEquals((Object)"client-secret-jwt", (Object)this.getClientByAdmin(cId).getClientAuthenticatorType());
        this.updateClientByAdmin(cId, clientRep -> clientRep.setServiceAccountsEnabled(Boolean.FALSE));
        Assert.assertEquals((Object)"client-secret-jwt", (Object)this.getClientByAdmin(cId).getClientAuthenticatorType());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.getClientByAdmin(cId).isServiceAccountsEnabled());
    }

    @Test
    public void testAdminClientAutoConfiguredClientAuthType() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Pershyy Profil").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-jwt", "client-secret-jwt", "client-x509"), "client-x509")).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Persha Polityka", Boolean.TRUE).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        try {
            this.createClientByAdmin(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setClientAuthenticatorType("client-secret"));
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        String cId = this.createClientByAdmin(this.generateSuffixedName(CLIENT_NAME), clientRep -> {});
        Assert.assertEquals((Object)"client-x509", (Object)this.getClientByAdmin(cId).getClientAuthenticatorType());
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Pershyy Profil").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-jwt", "client-secret-jwt", "client-x509"), "client-jwt")).toRepresentation()).toString();
        this.updateProfiles(json);
        this.updateClientByAdmin(cId, clientRep -> clientRep.setClientAuthenticatorType("client-secret-jwt"));
        Assert.assertEquals((Object)"client-secret-jwt", (Object)this.getClientByAdmin(cId).getClientAuthenticatorType());
    }

    @Test
    public void testSecureClientAuthenticatorDuringLogin() throws Exception {
        String profileName = "MyProfile";
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile(profileName, "Primum Profile").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-jwt", "client-secret-jwt", "client-x509"), null)).toRepresentation()).toString();
        this.updateProfiles(json);
        String roleAlphaName = "sample-client-role-alpha";
        String roleZetaName = "sample-client-role-zeta";
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Den Forste Politikken", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList(roleAlphaName, roleZetaName))).addProfile(profileName).toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String cId = this.createClientByAdmin(clientId, clientRep -> clientRep.setSecret("secret"));
        this.successfulLoginAndLogout(clientId, "secret");
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId);
        ClientRepresentation clientRep2 = clientResource.toRepresentation();
        Assert.assertEquals((Object)"client-secret", (Object)clientRep2.getClientAuthenticatorType());
        clientResource.roles().create(RoleBuilder.create().name(roleAlphaName).build());
        this.oauth.clientId(clientId);
        this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, "secret");
        Assert.assertEquals((long)400L, (long)res.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)res.getError());
        Assert.assertEquals((Object)"Configured client authentication method not allowed for client", (Object)res.getErrorDescription());
    }

    @Test
    public void testDynamicClientRegisterAndUpdate() throws Exception {
        this.setupPolicyClientIdAndSecretNotAcceptableAuthType("MyPolicy");
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {});
        Assert.assertEquals((Object)"client_secret_basic", (Object)this.getClientDynamically(clientId).getTokenEndpointAuthMethod());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.getClientDynamically(clientId).getTlsClientCertificateBoundAccessTokens());
        this.updateClientDynamically(clientId, clientRep -> {
            clientRep.setTokenEndpointAuthMethod("client_secret_basic");
            clientRep.setTlsClientCertificateBoundAccessTokens(Boolean.TRUE);
        });
        Assert.assertEquals((Object)"client_secret_basic", (Object)this.getClientDynamically(clientId).getTokenEndpointAuthMethod());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.getClientDynamically(clientId).getTlsClientCertificateBoundAccessTokens());
    }

    @Test
    public void testCreateDeletePolicyRuntime() throws Exception {
        String clientId = this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {});
        OIDCClientRepresentation clientRep2 = this.getClientDynamically(clientId);
        Assert.assertEquals((Object)"client_secret_basic", (Object)clientRep2.getTokenEndpointAuthMethod());
        this.events.expect(EventType.CLIENT_REGISTER).client(clientId).user((Matcher<String>)Matchers.isEmptyOrNullString()).assertEvent();
        this.events.expect(EventType.CLIENT_INFO).client(clientId).user((Matcher<String>)Matchers.isEmptyOrNullString()).assertEvent();
        this.adminClient.realm("test").clients().get(clientId).roles().create(RoleBuilder.create().name("sample-client-role").build());
        this.successfulLoginAndLogout(clientId, clientRep2.getClientSecret());
        this.setupPolicyAuthzCodeFlowUnderMultiPhasePolicy("MyPolicy");
        this.failLoginByNotFollowingPKCE(clientId);
        this.deletePolicy("MyPolicy");
        logger.info((Object)"... Deleted Policy : MyPolicy");
        this.successfulLoginAndLogout(clientId, clientRep2.getClientSecret());
    }

    @Test
    public void testCreateUpdateDeleteConditionRuntime() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Eichte profil").addExecutor("pkce-enforcer", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createPKCEEnforceExecutorConfig(Boolean.TRUE)).toRepresentation()).toString();
        this.updateProfiles(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secret";
        String cid = this.createClientByAdmin(clientId, clientRep -> clientRep.setSecret(clientSecret));
        this.adminClient.realm("test").clients().get(cid).roles().create(RoleBuilder.create().name("sample-client-role").build());
        this.successfulLoginAndLogout(clientId, clientSecret);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Dei Eischt Politik", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList("sample-client-role"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        this.failLoginByNotFollowingPKCE(clientId);
        this.updatePolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Dei Aktualiseiert Eischt Politik", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList("anothor-client-role"))).addProfile("MyProfile").toRepresentation());
        this.successfulLoginAndLogout(clientId, clientSecret);
        this.updatePolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Dei Aktualiseiert Eischt Politik", Boolean.TRUE).addProfile("MyProfile").toRepresentation());
        this.successfulLoginAndLogout(clientId, clientSecret);
    }

    @Test
    public void testCreateUpdateDeleteExecutorRuntime() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Purofairu Sono Ichi").addExecutor("pkce-enforcer", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createPKCEEnforceExecutorConfig(Boolean.FALSE)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Porishii Sono Ichi", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList("sample-client-role"))).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser"))).toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secret";
        String cid = this.createClientByAdmin(clientId, clientRep -> clientRep.setSecret(clientSecret));
        this.adminClient.realm("test").clients().get(cid).roles().create(RoleBuilder.create().name("sample-client-role").build());
        this.successfulLoginAndLogout(clientId, clientSecret);
        this.updatePolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Koushinsareta Porishii Sono Ichi", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList("sample-client-role"))).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser"))).addProfile("MyProfile").toRepresentation());
        this.failLoginByNotFollowingPKCE(clientId);
        this.updateProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Koushinsareta Purofairu Sono Ichi").addExecutor("pkce-enforcer", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createPKCEEnforceExecutorConfig(Boolean.TRUE)).toRepresentation());
        this.updateClientByAdmin(cid, clientRep -> clientRep.setServiceAccountsEnabled(Boolean.FALSE));
        Assert.assertEquals((Object)false, (Object)this.getClientByAdmin(cid).isServiceAccountsEnabled());
        Assert.assertEquals((Object)"S256", (Object)OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)this.getClientByAdmin(cid)).getPkceCodeChallengeMethod());
        this.updateProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Sarani Koushinsareta Purofairu Sono Ichi").toRepresentation());
        this.updateClientByAdmin(cid, clientRep -> OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setPkceCodeChallengeMethod(null));
        Assert.assertEquals(null, (Object)OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)this.getClientByAdmin(cid)).getPkceCodeChallengeMethod());
        this.successfulLoginAndLogout(clientId, clientSecret);
    }

    @Test
    public void testAuthzCodeFlowUnderMultiPhasePolicy() throws Exception {
        this.setupPolicyAuthzCodeFlowUnderMultiPhasePolicy("MyPolicy");
        String clientName = this.generateSuffixedName(CLIENT_NAME);
        String clientId = this.createClientDynamically(clientName, clientRep -> {});
        this.events.expect(EventType.CLIENT_REGISTER).client(clientId).user((Matcher<String>)Matchers.isEmptyOrNullString()).assertEvent();
        OIDCClientRepresentation response = this.getClientDynamically(clientId);
        String clientSecret = response.getClientSecret();
        Assert.assertEquals((Object)clientName, (Object)response.getClientName());
        Assert.assertEquals((Object)"client_secret_basic", (Object)response.getTokenEndpointAuthMethod());
        this.events.expect(EventType.CLIENT_INFO).client(clientId).user((Matcher<String>)Matchers.isEmptyOrNullString()).assertEvent();
        this.adminClient.realm("test").clients().get(clientId).roles().create(RoleBuilder.create().name("sample-client-role").build());
        this.successfulLoginAndLogoutWithPKCE(response.getClientId(), clientSecret, TEST_USER_NAME, TEST_USER_PASSWORD);
    }

    @Test
    public void testMultiplePolicies() throws Exception {
        String roleAlphaName = "sample-client-role-alpha";
        String roleBetaName = "sample-client-role-beta";
        String roleZetaName = "sample-client-role-zeta";
        String roleCommonName = "sample-client-role-common";
        String profileAlphaName = "MyProfile-alpha";
        String profileBetaName = "MyProfile-beta";
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile(profileAlphaName, "Pierwszy Profil").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-secret"), "client-secret")).toRepresentation()).addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile(profileBetaName, "Drugi Profil").addExecutor("pkce-enforcer", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createPKCEEnforceExecutorConfig(Boolean.TRUE)).toRepresentation()).toString();
        this.updateProfiles(json);
        String policyAlphaName = "MyPolicy-alpha";
        String policyBetaName = "MyPolicy-beta";
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy(policyAlphaName, "Pierwsza Zasada", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList(roleAlphaName, roleZetaName))).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser"))).addProfile(profileAlphaName).toRepresentation()).addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy(policyBetaName, "Drugi Zasada", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList(roleBetaName, roleZetaName))).addProfile(profileBetaName).toRepresentation()).toString();
        this.updatePolicies(json);
        String clientAlphaId = this.generateSuffixedName("Alpha-App");
        String clientAlphaSecret = "secretAlpha";
        try {
            this.createClientByAdmin(this.generateSuffixedName(CLIENT_NAME), clientRep -> {
                clientRep.setSecret(clientAlphaSecret);
                clientRep.setClientAuthenticatorType("client-secret-jwt");
            });
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        String cAlphaId = this.createClientByAdmin(clientAlphaId, clientRep -> {
            clientRep.setSecret(clientAlphaSecret);
            clientRep.setClientAuthenticatorType("client-secret");
        });
        RolesResource rolesResourceAlpha = this.adminClient.realm("test").clients().get(cAlphaId).roles();
        rolesResourceAlpha.create(RoleBuilder.create().name(roleAlphaName).build());
        rolesResourceAlpha.create(RoleBuilder.create().name(roleCommonName).build());
        String clientBetaId = this.generateSuffixedName("Beta-App");
        String cBetaId = this.createClientByAdmin(clientBetaId, clientRep -> clientRep.setSecret("secretBeta"));
        RolesResource rolesResourceBeta = this.adminClient.realm("test").clients().get(cBetaId).roles();
        rolesResourceBeta.create(RoleBuilder.create().name(roleBetaName).build());
        rolesResourceBeta.create(RoleBuilder.create().name(roleCommonName).build());
        Assert.assertEquals((Object)"client-secret", (Object)this.getClientByAdmin(cAlphaId).getClientAuthenticatorType());
        this.successfulLoginAndLogout(clientAlphaId, clientAlphaSecret);
        this.failLoginByNotFollowingPKCE(clientBetaId);
    }

    @Test
    public void testIntentionalExceptionOnCondition() throws Exception {
        String json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Fyrsta Stefnan", Boolean.TRUE).addCondition("test-raise-exception", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createTestRaiseExeptionConditionConfig()).toRepresentation()).toString();
        this.updatePolicies(json);
        try {
            this.createClientByAdmin(this.generateSuffixedName(CLIENT_NAME), clientRep -> {});
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"server_error", (Object)e.getMessage());
        }
    }

    @Test
    public void testAnyClientCondition() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Le Premier Profil").addExecutor("secure-session", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientAlphaId = this.generateSuffixedName("Alpha-App");
        String clientAlphaSecret = "secretAlpha";
        this.createClientByAdmin(clientAlphaId, clientRep -> {
            clientRep.setDefaultRoles(Arrays.asList("sample-client-role-alpha").toArray(new String[1]));
            clientRep.setSecret(clientAlphaSecret);
        });
        String clientBetaId = this.generateSuffixedName("Beta-App");
        this.createClientByAdmin(clientBetaId, clientRep -> clientRep.setSecret("secretBeta"));
        try {
            this.failLoginWithoutSecureSessionParameter(clientBetaId, "Missing parameter: nonce");
            this.oauth.nonce("yesitisnonce");
            this.successfulLoginAndLogout(clientAlphaId, clientAlphaSecret);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testConditionWithoutNoConfiguration() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Die Erste Politik").addExecutor("secure-client-authenticator", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy-ClientAccessTypeCondition", "Die Erste Politik", Boolean.TRUE).addCondition("client-access-type", null).addProfile("MyProfile").toRepresentation()).addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy-ClientUpdateSourceGroupsCondition", "Die Zweite Politik", Boolean.TRUE).addCondition("client-updater-source-groups", null).addProfile("MyProfile").toRepresentation()).addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy-ClientUpdateSourceRolesCondition", "Die Dritte Politik", Boolean.TRUE).addCondition("client-updater-source-roles", null).addProfile("MyProfile").toRepresentation()).addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy-ClientUpdateContextCondition", "Die Vierte Politik", Boolean.TRUE).addCondition("client-updater-context", null).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secret";
        this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setSecret(clientSecret);
            clientRep.setBearerOnly(Boolean.FALSE);
            clientRep.setPublicClient(Boolean.FALSE);
        });
        this.successfulLoginAndLogout(clientId, clientSecret);
    }

    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    @Test
    public void testClientUpdateSourceHostsCondition() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Prvni Profil").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-jwt", "client-secret-jwt", "client-x509"), null)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Prvni Politika", Boolean.TRUE).addCondition("client-updater-source-host", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateSourceHostsConditionConfig(Arrays.asList("localhost", "127.0.0.1"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secret";
        try {
            this.createClientByAdmin(clientId, clientRep -> clientRep.setSecret(clientSecret));
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Aktualizovana Prvni Politika", Boolean.TRUE).addCondition("client-updater-source-host", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateSourceHostsConditionConfig(Arrays.asList("example.com"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        try {
            this.createClientByAdmin(clientId, clientRep -> clientRep.setSecret(clientSecret));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testClientUpdateSourceGroupsCondition() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forste Profil").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-jwt"), null)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Den Forste Politik", Boolean.TRUE).addCondition("client-updater-source-groups", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateSourceGroupsConditionConfig(Arrays.asList("topGroup"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        try {
            this.authCreateClients();
            this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {});
            Assert.fail();
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((Object)"Failed to send request", (Object)e.getMessage());
        }
        this.authManageClients();
        try {
            this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testClientUpdateSourceRolesCondition() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Il Primo Profilo").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-secret-jwt"), null)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Prima Politica", Boolean.TRUE).addCondition("client-updater-source-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateSourceRolesConditionConfig(Arrays.asList("realm-management." + AdminRoles.CREATE_CLIENT))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        try {
            this.authCreateClients();
            this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {});
            Assert.fail();
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((Object)"Failed to send request", (Object)e.getMessage());
        }
        this.authManageClients();
        try {
            this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> {});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testClientScopesCondition() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Het Eerste Profiel").addExecutor("pkce-enforcer", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createPKCEEnforceExecutorConfig(Boolean.TRUE)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Het Eerste Beleid", Boolean.TRUE).addCondition("client-scopes", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientScopesConditionConfig("Optional", Arrays.asList("offline_access", "microprofile-jwt"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secret";
        this.createClientByAdmin(clientId, clientRep -> clientRep.setSecret(clientSecret));
        try {
            this.oauth.scope("address phone");
            this.successfulLoginAndLogout(clientId, clientSecret);
            this.oauth.scope("microprofile-jwt profile");
            this.failLoginByNotFollowingPKCE(clientId);
            this.oauth.scope("microprofile-jwt profile");
            this.failLoginByNotFollowingPKCE(clientId);
            this.successfulLoginAndLogoutWithPKCE(clientId, clientSecret, TEST_USER_NAME, TEST_USER_PASSWORD);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testClientAccessTypeCondition() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "El Primer Perfil").addExecutor("secure-session", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Primera Plitica", Boolean.TRUE).addCondition("client-access-type", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientAccessTypeConditionConfig(Arrays.asList("confidential"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientAlphaId = this.generateSuffixedName("Alpha-App");
        this.createClientByAdmin(clientAlphaId, clientRep -> {
            clientRep.setSecret("secretAlpha");
            clientRep.setBearerOnly(Boolean.FALSE);
            clientRep.setPublicClient(Boolean.FALSE);
        });
        String clientBetaId = this.generateSuffixedName("Beta-App");
        this.createClientByAdmin(clientBetaId, clientRep -> {
            clientRep.setBearerOnly(Boolean.FALSE);
            clientRep.setPublicClient(Boolean.TRUE);
        });
        this.successfulLoginAndLogout(clientBetaId, null);
        this.failLoginWithoutNonce(clientAlphaId);
    }

    @Test
    public void testSecureResponseTypeExecutor() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "O Primeiro Perfil").addExecutor("secure-response-type", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "A Primeira Politica", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList("sample-client-role"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secret";
        String cid = this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setSecret(clientSecret);
            clientRep.setStandardFlowEnabled(Boolean.TRUE);
            clientRep.setImplicitFlowEnabled(Boolean.TRUE);
            clientRep.setPublicClient(Boolean.FALSE);
        });
        this.adminClient.realm("test").clients().get(cid).roles().create(RoleBuilder.create().name("sample-client-role").build());
        this.oauth.clientId(clientId);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"invalid response_type", this.oauth.getCurrentQuery().get("error_description"));
        this.oauth.responseType("code id_token");
        this.oauth.nonce("vbwe566fsfffds");
        this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        EventRepresentation loginEvent = this.events.expectLogin().client(clientId).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = new OAuthClient.AuthorizationEndpointResponse(this.oauth).getCode();
        OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.events.expectCodeToToken(codeId, sessionId).client(clientId).assertEvent();
        this.oauth.doLogout(res.getRefreshToken(), clientSecret);
        this.events.expectLogout(sessionId).client(clientId).clearDetails().assertEvent();
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "O Primeiro Perfil").addExecutor("secure-response-type", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureResponseTypeExecutor(Boolean.FALSE, Boolean.TRUE)).toRepresentation()).toString();
        this.updateProfiles(json);
        this.oauth.responseType("code id_token token");
        this.oauth.nonce("cie8cjcwiw");
        this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        loginEvent = this.events.expectLogin().client(clientId).assertEvent();
        sessionId = loginEvent.getSessionId();
        codeId = (String)loginEvent.getDetails().get("code_id");
        code = new OAuthClient.AuthorizationEndpointResponse(this.oauth).getCode();
        res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.events.expectCodeToToken(codeId, sessionId).client(clientId).assertEvent();
        this.oauth.doLogout(res.getRefreshToken(), clientSecret);
        this.events.expectLogout(sessionId).client(clientId).clearDetails().assertEvent();
        this.oauth.responseType("code");
        this.oauth.responseMode("jwt");
        OAuthClient.AuthorizationEndpointResponse authzResponse = this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        String jwsResponse = authzResponse.getResponse();
        AuthorizationResponseToken responseObject = this.oauth.verifyAuthorizationResponseToken(jwsResponse);
        code = (String)responseObject.getOtherClaims().get("code");
        res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "O Primeiro Perfil").addExecutor("secure-response-type", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureResponseTypeExecutor(Boolean.FALSE, Boolean.FALSE)).toRepresentation()).toString();
        this.updateProfiles(json);
        this.oauth.openLogout();
        this.oauth.responseType("code id_token token");
        this.oauth.responseMode("jwt");
        this.oauth.openLoginForm();
        JWSInput errorJws = new JWSInput(new OAuthClient.AuthorizationEndpointResponse(this.oauth).getResponse());
        JsonNode errorClaims = (JsonNode)JsonSerialization.readValue((byte[])errorJws.getContent(), JsonNode.class);
        Assert.assertEquals((Object)"invalid_request", (Object)errorClaims.get("error").asText());
    }

    @Test
    public void testSecureResponseTypeExecutorAllowTokenResponseType() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "O Primeiro Perfil").addExecutor("secure-response-type", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureResponseTypeExecutor(null, Boolean.TRUE)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Den Forsta Policyn", Boolean.TRUE).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser", "ByInitialAccessToken", "ByRegistrationAccessToken"))).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList("sample-client-role"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        try {
            this.createClientByAdmin(this.generateSuffixedName("App-by-Admin"), clientRep -> clientRep.setSecret("secret"));
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getMessage());
        }
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "O Primeiro Perfil").addExecutor("secure-response-type", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureResponseTypeExecutor(Boolean.TRUE, null)).toRepresentation()).toString();
        this.updateProfiles(json);
        String cId = null;
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secret";
        try {
            cId = this.createClientByAdmin(clientId, clientRep -> {
                clientRep.setSecret(clientSecret);
                clientRep.setStandardFlowEnabled(Boolean.TRUE);
                clientRep.setImplicitFlowEnabled(Boolean.TRUE);
                clientRep.setPublicClient(Boolean.FALSE);
            });
        }
        catch (ClientPolicyException e) {
            Assert.fail();
        }
        ClientRepresentation cRep = this.getClientByAdmin(cId);
        Assert.assertEquals((Object)Boolean.TRUE.toString(), cRep.getAttributes().get("id.token.as.detached.signature"));
        this.adminClient.realm("test").clients().get(cId).roles().create(RoleBuilder.create().name("sample-client-role").build());
        this.oauth.clientId(clientId);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"invalid response_type", this.oauth.getCurrentQuery().get("error_description"));
        this.oauth.responseType("code id_token");
        this.oauth.nonce("LIVieviDie028f");
        this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        EventRepresentation loginEvent = this.events.expectLogin().client(clientId).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = new OAuthClient.AuthorizationEndpointResponse(this.oauth).getCode();
        IDToken idToken = this.oauth.verifyIDToken(new OAuthClient.AuthorizationEndpointResponse(this.oauth).getIdToken());
        Assert.assertNull((Object)idToken.getEmailVerified());
        Assert.assertNull((Object)idToken.getName());
        Assert.assertNull((Object)idToken.getPreferredUsername());
        Assert.assertNull((Object)idToken.getGivenName());
        Assert.assertNull((Object)idToken.getFamilyName());
        Assert.assertNull((Object)idToken.getEmail());
        Assert.assertEquals((Object)"LIVieviDie028f", (Object)idToken.getNonce());
        Assert.assertNull((Object)new OAuthClient.AuthorizationEndpointResponse(this.oauth).getAccessToken());
        OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.events.expectCodeToToken(codeId, sessionId).client(clientId).assertEvent();
        this.oauth.doLogout(res.getRefreshToken(), clientSecret);
        this.events.expectLogout(sessionId).client(clientId).clearDetails().assertEvent();
    }

    @Test
    public void testSecureRequestObjectExecutor() throws Exception {
        Integer availablePeriod = SecureRequestObjectExecutor.DEFAULT_AVAILABLE_PERIOD + 400;
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Prvy Profil").addExecutor("secure-request-object", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureRequestObjectExecutorConfig(availablePeriod, null)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Prva Politika", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList("sample-client-role"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secret";
        String cid = this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setSecret(clientSecret);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestUris(Arrays.asList(TestApplicationResourceUrls.clientRequestUri()));
        });
        this.adminClient.realm("test").clients().get(cid).roles().create(RoleBuilder.create().name("sample-client-role").build());
        this.oauth.clientId(clientId);
        this.oauth.request(null);
        this.oauth.requestUri(null);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Missing parameter: 'request' or 'request_uri'", this.oauth.getCurrentQuery().get("error_description"));
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.setScope(null);
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, true);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Invalid parameter. Parameters in 'request' object not matching with request parameters", this.oauth.getCurrentQuery().get("error_description"));
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, true);
        this.oauth.scope(null);
        this.oauth.openid(false);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Parameter 'scope' missing in the request parameters or in 'request' object", this.oauth.getCurrentQuery().get("error_description"));
        this.oauth.openid(true);
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.exp(null);
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_object", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Missing parameter in the 'request' object: exp", this.oauth.getCurrentQuery().get("error_description"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.exp(Long.valueOf(0L));
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, true);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_object", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Request Expired", this.oauth.getCurrentQuery().get("error_description"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.nbf(null);
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_object", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Missing parameter in the 'request' object: nbf", this.oauth.getCurrentQuery().get("error_description"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.nbf(Long.valueOf(requestObject.getNbf() + 600L));
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_object", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Request not yet being processed", this.oauth.getCurrentQuery().get("error_description"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.exp(Long.valueOf(requestObject.getNbf() + (long)availablePeriod.intValue() + 1L));
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_object", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Request's available period is long", this.oauth.getCurrentQuery().get("error_description"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.audience(new String[]{null});
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_object", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Missing parameter in the 'request' object: aud", this.oauth.getCurrentQuery().get("error_description"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.audience(new String[]{this.suiteContext.getAuthServerInfo().getContextRoot().toString()});
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, true);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_uri", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Invalid parameter in the 'request' object: aud", this.oauth.getCurrentQuery().get("error_description"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.setState("notmatchstate");
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Invalid parameter. Parameters in 'request' object not matching with request parameters", this.oauth.getCurrentQuery().get("error_description"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, true);
        this.successfulLoginAndLogout(clientId, clientSecret);
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Prvy Profil").addExecutor("secure-request-object", null).toRepresentation()).toString();
        this.updateProfiles(json);
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.nbf(null);
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_object", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Missing parameter in the 'request' object: nbf", this.oauth.getCurrentQuery().get("error_description"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.nbf(Long.valueOf(requestObject.getNbf() + 600L));
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_object", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Request not yet being processed", this.oauth.getCurrentQuery().get("error_description"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.exp(Long.valueOf(requestObject.getNbf() + (long)SecureRequestObjectExecutor.DEFAULT_AVAILABLE_PERIOD.intValue() + 1L));
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_object", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Request's available period is long", this.oauth.getCurrentQuery().get("error_description"));
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Prvy Profil").addExecutor("secure-request-object", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureRequestObjectExecutorConfig(null, Boolean.FALSE)).toRepresentation()).toString();
        this.updateProfiles(json);
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.nbf(null);
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.successfulLoginAndLogout(clientId, clientSecret);
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.nbf(Long.valueOf(requestObject.getNbf() + 600L));
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.successfulLoginAndLogout(clientId, clientSecret);
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.exp(Long.valueOf(requestObject.getNbf() + (long)SecureRequestObjectExecutor.DEFAULT_AVAILABLE_PERIOD.intValue() + 1L));
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.successfulLoginAndLogout(clientId, clientSecret);
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Prvy Profil").addExecutor("secure-request-object", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureRequestObjectExecutorConfig(null, null, true)).toRepresentation()).toString();
        this.updateProfiles(json);
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        this.registerRequestObject(requestObject, clientId, Algorithm.ES256, false);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_object", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Request object not encrypted", this.oauth.getCurrentQuery().get("error_description"));
    }

    @Test
    public void testParSecureRequestObjectExecutor() throws Exception {
        Integer availablePeriod = SecureRequestObjectExecutor.DEFAULT_AVAILABLE_PERIOD + 400;
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Prvy Profil").addExecutor("secure-request-object", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureRequestObjectExecutorConfig(availablePeriod, true)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Prva Politika", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList("sample-client-role"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secret";
        String cid = this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setSecret(clientSecret);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestUris(Arrays.asList(TestApplicationResourceUrls.clientRequestUri()));
        });
        this.oauth.realm("test");
        this.oauth.clientId(clientId);
        this.adminClient.realm("test").clients().get(cid).roles().create(RoleBuilder.create().name("sample-client-role").build());
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        this.oauth.request(this.signRequestObject(requestObject));
        OAuthClient.ParResponse pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((long)201L, (long)pResp.getStatusCode());
        String requestUri = pResp.getRequestUri();
        this.oauth.scope(null);
        this.oauth.responseType(null);
        this.oauth.request(null);
        this.oauth.requestUri(requestUri);
        OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        Assert.assertNotNull((Object)loginResponse.getCode());
        this.oauth.openLogout();
        requestObject.exp(null);
        this.oauth.requestUri(null);
        this.oauth.request(this.signRequestObject(requestObject));
        pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        requestUri = pResp.getRequestUri();
        this.oauth.request(null);
        this.oauth.requestUri(requestUri);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_uri", this.oauth.getCurrentQuery().get("error"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.nbf(null);
        this.oauth.requestUri(null);
        this.oauth.request(this.signRequestObject(requestObject));
        pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        requestUri = pResp.getRequestUri();
        this.oauth.request(null);
        this.oauth.requestUri(requestUri);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_uri", this.oauth.getCurrentQuery().get("error"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.audience(new String[]{"https://www.other1.example.com/"});
        this.oauth.request(this.signRequestObject(requestObject));
        this.oauth.requestUri(null);
        pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        requestUri = pResp.getRequestUri();
        this.oauth.request(null);
        this.oauth.requestUri(requestUri);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request_uri", this.oauth.getCurrentQuery().get("error"));
        requestObject = this.createValidRequestObjectForSecureRequestObjectExecutor(clientId);
        requestObject.setOtherClaims("request_uri", (Object)"foo");
        this.oauth.request(this.signRequestObject(requestObject));
        this.oauth.requestUri(null);
        pResp = this.oauth.doPushedAuthorizationRequest(clientId, clientSecret);
        Assert.assertEquals((Object)"invalid_request_object", (Object)pResp.getError());
    }

    private String signRequestObject(TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject) throws IOException {
        byte[] contentBytes = JsonSerialization.writeValueAsBytes((Object)requestObject);
        String encodedRequestObject = Base64Url.encode((byte[])contentBytes);
        TestOIDCEndpointsApplicationResource client = this.testingClient.testApp().oidcClientEndpoints();
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(this.oauth.getRealm()), (String)this.oauth.getClientId());
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(true);
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(TestApplicationResourceUrls.clientJwksUri());
        clientResource.update(clientRep);
        client.generateKeys("PS256");
        client.registerOIDCRequest(encodedRequestObject, "PS256");
        String oidcRequest = client.getOIDCRequest();
        return oidcRequest;
    }

    @Test
    public void testSecureSessionEnforceExecutor() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forste Profilen").addExecutor("secure-session", null).toRepresentation()).toString();
        this.updateProfiles(json);
        String roleAlphaName = "sample-client-role-alpha";
        String roleBetaName = "sample-client-role-beta";
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Den Forste Politikken", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList(roleBetaName))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientAlphaId = this.generateSuffixedName("Alpha-App");
        String clientAlphaSecret = "secretAlpha";
        String cAlphaId = this.createClientByAdmin(clientAlphaId, clientRep -> clientRep.setSecret(clientAlphaSecret));
        this.adminClient.realm("test").clients().get(cAlphaId).roles().create(RoleBuilder.create().name(roleAlphaName).build());
        String clientBetaId = this.generateSuffixedName("Beta-App");
        String clientBetaSecret = "secretBeta";
        String cBetaId = this.createClientByAdmin(clientBetaId, clientRep -> clientRep.setSecret(clientBetaSecret));
        this.adminClient.realm("test").clients().get(cBetaId).roles().create(RoleBuilder.create().name(roleBetaName).build());
        this.successfulLoginAndLogout(clientAlphaId, clientAlphaSecret);
        this.oauth.openid(false);
        this.successfulLoginAndLogout(clientAlphaId, clientAlphaSecret);
        this.oauth.openid(true);
        this.failLoginWithoutSecureSessionParameter(clientBetaId, "Missing parameter: nonce");
        this.oauth.nonce("yesitisnonce");
        this.successfulLoginAndLogout(clientBetaId, clientBetaSecret);
        this.oauth.openid(false);
        this.oauth.stateParamHardcoded(null);
        this.failLoginWithoutSecureSessionParameter(clientBetaId, "Missing parameter: state");
        this.oauth.stateParamRandom();
        this.successfulLoginAndLogout(clientBetaId, clientBetaSecret);
    }

    @Test
    public void testSecureSigningAlgorithmEnforceExecutor() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forsta Profilen").addExecutor("secure-signature-algorithm", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Den Forsta Policyn", Boolean.TRUE).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser", "ByInitialAccessToken", "ByRegistrationAccessToken"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        try {
            this.createClientByAdmin(this.generateSuffixedName("App-by-Admin"), clientRep -> {
                clientRep.setSecret("secret");
                clientRep.setAttributes(new HashMap());
                clientRep.getAttributes().put("user.info.response.signature.alg", Algorithm.none.name());
            });
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_request", (Object)e.getMessage());
        }
        String cAppAdminId = this.createClientByAdmin(this.generateSuffixedName("App-by-Admin"), clientRep -> {
            clientRep.setAttributes(new HashMap());
            clientRep.getAttributes().put("user.info.response.signature.alg", "PS256");
            clientRep.getAttributes().put("request.object.signature.alg", "ES256");
            clientRep.getAttributes().put("id.token.signed.response.alg", "ES256");
            clientRep.getAttributes().put("token.endpoint.auth.signing.alg", "ES256");
            clientRep.getAttributes().put("access.token.signed.response.alg", "ES256");
        });
        String cAppAdmin2Id = this.createClientByAdmin(this.generateSuffixedName("App-by-Admin2"), client2Rep -> {});
        ClientRepresentation cRep2 = this.getClientByAdmin(cAppAdmin2Id);
        Assert.assertEquals((Object)"PS256", cRep2.getAttributes().get("user.info.response.signature.alg"));
        Assert.assertEquals((Object)"PS256", cRep2.getAttributes().get("request.object.signature.alg"));
        Assert.assertEquals((Object)"PS256", cRep2.getAttributes().get("id.token.signed.response.alg"));
        Assert.assertEquals((Object)"PS256", cRep2.getAttributes().get("token.endpoint.auth.signing.alg"));
        Assert.assertEquals((Object)"PS256", cRep2.getAttributes().get("access.token.signed.response.alg"));
        try {
            this.updateClientByAdmin(cAppAdminId, clientRep -> {
                clientRep.setAttributes(new HashMap());
                clientRep.getAttributes().put("access.token.signed.response.alg", "RS512");
            });
        }
        catch (ClientPolicyException cpe) {
            Assert.assertEquals((Object)"invalid_request", (Object)cpe.getError());
        }
        ClientRepresentation cRep = this.getClientByAdmin(cAppAdminId);
        Assert.assertEquals((Object)"ES256", cRep.getAttributes().get("access.token.signed.response.alg"));
        this.updateClientByAdmin(cAppAdminId, clientRep -> {
            clientRep.setAttributes(new HashMap());
            clientRep.getAttributes().put("access.token.signed.response.alg", "PS384");
        });
        cRep = this.getClientByAdmin(cAppAdminId);
        Assert.assertEquals((Object)"PS384", cRep.getAttributes().get("access.token.signed.response.alg"));
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forsta Profilen").addExecutor("secure-signature-algorithm", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureSigningAlgorithmEnforceExecutorConfig("ES256")).toRepresentation()).toString();
        this.updateProfiles(json);
        this.updateClientByAdmin(cAppAdmin2Id, client2Rep -> {
            client2Rep.getAttributes().remove("user.info.response.signature.alg");
            client2Rep.getAttributes().remove("request.object.signature.alg");
            client2Rep.getAttributes().remove("id.token.signed.response.alg");
            client2Rep.getAttributes().remove("token.endpoint.auth.signing.alg");
            client2Rep.getAttributes().remove("access.token.signed.response.alg");
        });
        cRep2 = this.getClientByAdmin(cAppAdmin2Id);
        Assert.assertEquals((Object)"ES256", cRep2.getAttributes().get("user.info.response.signature.alg"));
        Assert.assertEquals((Object)"ES256", cRep2.getAttributes().get("request.object.signature.alg"));
        Assert.assertEquals((Object)"ES256", cRep2.getAttributes().get("id.token.signed.response.alg"));
        Assert.assertEquals((Object)"ES256", cRep2.getAttributes().get("token.endpoint.auth.signing.alg"));
        Assert.assertEquals((Object)"ES256", cRep2.getAttributes().get("access.token.signed.response.alg"));
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forsta Profilen").addExecutor("secure-signature-algorithm", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureSigningAlgorithmEnforceExecutorConfig("RS512")).toRepresentation()).toString();
        this.updateProfiles(json);
        try {
            this.createClientByAdmin(this.generateSuffixedName("App-in-Dynamic"), clientRep -> {
                clientRep.setSecret("secret");
                clientRep.setAttributes(new HashMap());
                clientRep.getAttributes().put("user.info.response.signature.alg", "RS384");
            });
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_request", (Object)e.getMessage());
        }
        String cAppDynamicClientId = this.createClientDynamically(this.generateSuffixedName("App-in-Dynamic"), clientRep -> {
            clientRep.setUserinfoSignedResponseAlg("ES256");
            clientRep.setRequestObjectSigningAlg("ES256");
            clientRep.setIdTokenSignedResponseAlg("PS256");
            clientRep.setTokenEndpointAuthSigningAlg("PS256");
        });
        this.events.expect(EventType.CLIENT_REGISTER).client(cAppDynamicClientId).user((Matcher<String>)Matchers.isEmptyOrNullString()).assertEvent();
        try {
            this.updateClientDynamically(cAppDynamicClientId, clientRep -> clientRep.setIdTokenSignedResponseAlg("RS256"));
            Assert.fail();
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((Object)"Failed to send request", (Object)e.getMessage());
        }
        Assert.assertEquals((Object)"PS256", (Object)this.getClientDynamically(cAppDynamicClientId).getIdTokenSignedResponseAlg());
        this.updateClientDynamically(cAppDynamicClientId, clientRep -> clientRep.setIdTokenSignedResponseAlg("ES384"));
        Assert.assertEquals((Object)"ES384", (Object)this.getClientDynamically(cAppDynamicClientId).getIdTokenSignedResponseAlg());
        this.restartAuthenticatedClientRegistrationSetting();
        String cAppDynamicClient2Id = this.createClientDynamically(this.generateSuffixedName("App-in-Dynamic"), client2Rep -> {});
        OIDCClientRepresentation cAppDynamicClient2Rep = this.getClientDynamically(cAppDynamicClient2Id);
        Assert.assertEquals((Object)"PS256", (Object)cAppDynamicClient2Rep.getUserinfoSignedResponseAlg());
        Assert.assertEquals((Object)"PS256", (Object)cAppDynamicClient2Rep.getRequestObjectSigningAlg());
        Assert.assertEquals((Object)"PS256", (Object)cAppDynamicClient2Rep.getIdTokenSignedResponseAlg());
        Assert.assertEquals((Object)"PS256", (Object)cAppDynamicClient2Rep.getTokenEndpointAuthSigningAlg());
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forsta Profilen").addExecutor("secure-signature-algorithm", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureSigningAlgorithmEnforceExecutorConfig("ES256")).toRepresentation()).toString();
        this.updateProfiles(json);
        this.updateClientDynamically(cAppDynamicClient2Id, client2Rep -> {
            client2Rep.setUserinfoSignedResponseAlg(null);
            client2Rep.setRequestObjectSigningAlg(null);
            client2Rep.setIdTokenSignedResponseAlg(null);
            client2Rep.setTokenEndpointAuthSigningAlg(null);
        });
        cAppDynamicClient2Rep = this.getClientDynamically(cAppDynamicClient2Id);
        Assert.assertEquals((Object)"ES256", (Object)cAppDynamicClient2Rep.getUserinfoSignedResponseAlg());
        Assert.assertEquals((Object)"ES256", (Object)cAppDynamicClient2Rep.getRequestObjectSigningAlg());
        Assert.assertEquals((Object)"ES256", (Object)cAppDynamicClient2Rep.getIdTokenSignedResponseAlg());
        Assert.assertEquals((Object)"ES256", (Object)cAppDynamicClient2Rep.getTokenEndpointAuthSigningAlg());
    }

    @Test
    public void testSecureClientRegisteringUriEnforceExecutor() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Ensimmainen Profiili").addExecutor("secure-client-uris", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Ensimmainen Politiikka", Boolean.TRUE).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser", "ByInitialAccessToken", "ByRegistrationAccessToken"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        try {
            this.createClientDynamically(this.generateSuffixedName(CLIENT_NAME), clientRep -> clientRep.setRedirectUris(Collections.singletonList("http://newredirect")));
            Assert.fail();
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((Object)"Failed to send request", (Object)e.getMessage());
        }
        String cid = null;
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        try {
            cid = this.createClientByAdmin(clientId, clientRep -> {
                clientRep.setServiceAccountsEnabled(Boolean.TRUE);
                clientRep.setRedirectUris(null);
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
        this.updateClientByAdmin(cid, clientRep -> {
            clientRep.setRedirectUris(null);
            clientRep.setServiceAccountsEnabled(Boolean.FALSE);
        });
        Assert.assertEquals((Object)false, (Object)this.getClientByAdmin(cid).isServiceAccountsEnabled());
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Paivitetyn Ensimmaisen Politiikka", Boolean.TRUE).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser", "ByRegistrationAccessToken"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        try {
            this.updateClientDynamically(clientId, clientRep -> clientRep.setRedirectUris(Collections.singletonList("https://newredirect/*")));
            Assert.fail();
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((Object)"Failed to send request", (Object)e.getMessage());
        }
        try {
            this.updateClientByAdmin(cid, clientRep -> {
                clientRep.setRootUrl("https://client.example.com/");
                clientRep.setAdminUrl("https://client.example.com/admin/");
                clientRep.setBaseUrl("https://client.example.com/base/");
                clientRep.setWebOrigins(Arrays.asList("https://valid.other.client.example.com/", "https://valid.another.client.example.com/"));
                Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
                attributes.put("backchannel.logout.url", "https://client.example.com/logout/");
                clientRep.setAttributes(attributes);
                clientRep.setRedirectUris(Arrays.asList("https://client.example.com/redirect/", "https://client.example.com/callback/"));
                attributes.put("jwks.url", "https://client.example.com/jwks/");
                clientRep.setAttributes(attributes);
                this.setAttributeMultivalued((ClientRepresentation)clientRep, "request.uris", Arrays.asList("https://client.example.com/request/", "https://client.example.com/reqobj/"));
                attributes.put("ciba.backchannel.client.notification.endpoint", "https://client.example.com/client-notification/");
                clientRep.setAttributes(attributes);
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            this.updateClientByAdmin(cid, clientRep -> clientRep.setRootUrl("http://client.example.com/*/"));
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getError());
            Assert.assertEquals((Object)"Invalid rootUrl", (Object)e.getErrorDetail());
        }
        try {
            this.updateClientByAdmin(cid, clientRep -> clientRep.setAdminUrl("http://client.example.com/admin/"));
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getError());
            Assert.assertEquals((Object)"Invalid adminUrl", (Object)e.getErrorDetail());
        }
        try {
            this.updateClientByAdmin(cid, clientRep -> clientRep.setBaseUrl("https://client.example.com/base/*"));
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getError());
            Assert.assertEquals((Object)"Invalid baseUrl", (Object)e.getErrorDetail());
        }
        try {
            this.updateClientByAdmin(cid, clientRep -> clientRep.setWebOrigins(Arrays.asList("http://valid.another.client.example.com/")));
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getError());
            Assert.assertEquals((Object)"Invalid webOrigins", (Object)e.getErrorDetail());
        }
        try {
            this.updateClientByAdmin(cid, clientRep -> {
                Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
                attributes.put("backchannel.logout.url", "httpss://client.example.com/logout/");
                clientRep.setAttributes(attributes);
            });
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getError());
            Assert.assertEquals((Object)"Invalid logoutUrl", (Object)e.getErrorDetail());
        }
        try {
            this.updateClientByAdmin(cid, clientRep -> clientRep.setRedirectUris(Arrays.asList("https://client.example.com/redirect/", "ftp://client.example.com/callback/")));
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getError());
            Assert.assertEquals((Object)"Invalid redirectUris", (Object)e.getErrorDetail());
        }
        try {
            this.updateClientByAdmin(cid, clientRep -> {
                Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
                attributes.put("jwks.url", "http s://client.example.com/jwks/");
                clientRep.setAttributes(attributes);
            });
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getError());
            Assert.assertEquals((Object)"Invalid jwksUri", (Object)e.getErrorDetail());
        }
        try {
            this.updateClientByAdmin(cid, clientRep -> this.setAttributeMultivalued((ClientRepresentation)clientRep, "request.uris", Arrays.asList("https://client.example.com/request/*", "https://client.example.com/reqobj/")));
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getError());
            Assert.assertEquals((Object)"Invalid requestUris", (Object)e.getErrorDetail());
        }
        try {
            this.updateClientByAdmin(cid, clientRep -> {
                Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
                attributes.put("ciba.backchannel.client.notification.endpoint", "http://client.example.com/client-notification/");
                clientRep.setAttributes(attributes);
            });
            Assert.fail();
        }
        catch (ClientPolicyException e) {
            Assert.assertEquals((Object)"invalid_client_metadata", (Object)e.getError());
            Assert.assertEquals((Object)"Invalid cibaClientNotificationEndpoint", (Object)e.getErrorDetail());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientPolicyTriggeredForServiceAccountRequest() throws Exception {
        String clientId = "service-account-app";
        String clientSecret = "app-secret";
        this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setSecret(clientSecret);
            clientRep.setStandardFlowEnabled(Boolean.FALSE);
            clientRep.setImplicitFlowEnabled(Boolean.FALSE);
            clientRep.setServiceAccountsEnabled(Boolean.TRUE);
            clientRep.setPublicClient(Boolean.FALSE);
            clientRep.setBearerOnly(Boolean.FALSE);
        });
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forste Profilen").addExecutor("test-raise-exception", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String origClientId = this.oauth.getClientId();
        this.oauth.clientId("service-account-app");
        try {
            OAuthClient.AccessTokenResponse response = this.oauth.doClientCredentialsGrantAccessTokenRequest("app-secret");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)ClientPolicyEvent.SERVICE_ACCOUNT_TOKEN_REQUEST.toString(), (Object)response.getError());
            Assert.assertEquals((Object)"Exception thrown intentionally", (Object)response.getErrorDescription());
        }
        finally {
            this.oauth.clientId(origClientId);
        }
    }

    private List<String> getAttributeMultivalued(ClientRepresentation clientRep, String attrKey) {
        String attrValue = (String)Optional.ofNullable(clientRep.getAttributes()).orElse(Collections.emptyMap()).get(attrKey);
        if (attrValue == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(Constants.CFG_DELIMITER_PATTERN.split(attrValue));
    }

    private void setAttributeMultivalued(ClientRepresentation clientRep, String attrKey, List<String> attrValues) {
        String attrValueFull = String.join((CharSequence)"##", attrValues);
        clientRep.getAttributes().put(attrKey, attrValueFull);
    }

    @Test
    public void testSecureSigningAlgorithmForSignedJwtEnforceExecutorWithSecureAlg() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Ensimmainen Profiili").addExecutor("secure-signature-algorithm-signed-jwt", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureSigningAlgorithmForSignedJwtEnforceExecutorConfig(Boolean.TRUE)).toRepresentation()).toString();
        this.updateProfiles(json);
        String roleAlphaName = "sample-client-role-alpha";
        String roleZetaName = "sample-client-role-zeta";
        String roleCommonName = "sample-client-role-common";
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Den Forste Politikken", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList(roleAlphaName, roleZetaName))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String cid = this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setSecret("secret");
            clientRep.setClientAuthenticatorType("client-jwt");
            clientRep.setAttributes(new HashMap());
            clientRep.getAttributes().put("token.endpoint.auth.signing.alg", "ES256");
        });
        this.adminClient.realm("test").clients().get(cid).roles().create(RoleBuilder.create().name(roleAlphaName).build());
        this.adminClient.realm("test").clients().get(cid).roles().create(RoleBuilder.create().name(roleCommonName).build());
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId);
        ClientRepresentation clientRep2 = clientResource.toRepresentation();
        KeyPair keyPair = this.setupJwksUrl("ES256", clientRep2, clientResource);
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        String signedJwt = this.createSignedRequestToken(clientId, privateKey, publicKey, "ES256");
        this.oauth.clientId(clientId);
        this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        EventRepresentation loginEvent = this.events.expectLogin().client(clientId).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.doAccessTokenRequestWithSignedJWT(code, signedJwt);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        Assert.assertEquals((Object)sessionId, (Object)refreshToken.getSessionState());
        Assert.assertEquals((Object)sessionId, (Object)refreshToken.getSessionState());
        this.events.expectCodeToToken((String)loginEvent.getDetails().get("code_id"), loginEvent.getSessionId()).client(clientId).detail("client_auth_method", "client-jwt").assertEvent();
        signedJwt = this.createSignedRequestToken(clientId, privateKey, publicKey, "ES256");
        OAuthClient.AccessTokenResponse refreshedResponse = this.doRefreshTokenRequestWithSignedJWT(response.getRefreshToken(), signedJwt);
        Assert.assertEquals((long)200L, (long)refreshedResponse.getStatusCode());
        signedJwt = this.createSignedRequestToken(clientId, privateKey, publicKey, "ES256");
        HttpResponse tokenIntrospectionResponse = this.doTokenIntrospectionWithSignedJWT("access_token", refreshedResponse.getAccessToken(), signedJwt);
        Assert.assertEquals((long)200L, (long)tokenIntrospectionResponse.getStatusLine().getStatusCode());
        signedJwt = this.createSignedRequestToken(clientId, privateKey, publicKey, "ES256");
        HttpResponse revokeTokenResponse = this.doTokenRevokeWithSignedJWT("refresh_toke", refreshedResponse.getRefreshToken(), signedJwt);
        Assert.assertEquals((long)200L, (long)revokeTokenResponse.getStatusLine().getStatusCode());
        signedJwt = this.createSignedRequestToken(clientId, privateKey, publicKey, "ES256");
        OAuthClient.AccessTokenResponse tokenRes = this.doRefreshTokenRequestWithSignedJWT(refreshedResponse.getRefreshToken(), signedJwt);
        Assert.assertEquals((long)400L, (long)tokenRes.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)tokenRes.getError());
        signedJwt = this.createSignedRequestToken(clientId, privateKey, publicKey, "ES256");
        HttpResponse logoutResponse = this.doLogoutWithSignedJWT(refreshedResponse.getRefreshToken(), signedJwt);
        Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
    }

    @Test
    public void testSecureSigningAlgorithmForSignedJwtEnforceExecutorWithNotSecureAlg() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Ensimmainen Profiili").addExecutor("secure-signature-algorithm-signed-jwt", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureSigningAlgorithmForSignedJwtEnforceExecutorConfig(Boolean.FALSE)).toRepresentation()).toString();
        this.updateProfiles(json);
        String roleAlphaName = "sample-client-role-alpha";
        String roleZetaName = "sample-client-role-zeta";
        String roleCommonName = "sample-client-role-common";
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Den Forste Politikken", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList(roleAlphaName, roleZetaName))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String cid = this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setSecret("secret");
            clientRep.setClientAuthenticatorType("client-jwt");
            clientRep.setAttributes(new HashMap());
            clientRep.getAttributes().put("token.endpoint.auth.signing.alg", "RS256");
        });
        this.adminClient.realm("test").clients().get(cid).roles().create(RoleBuilder.create().name(roleAlphaName).build());
        this.adminClient.realm("test").clients().get(cid).roles().create(RoleBuilder.create().name(roleCommonName).build());
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)clientId);
        ClientRepresentation clientRep2 = clientResource.toRepresentation();
        KeyPair keyPair = this.setupJwksUrl("RS256", clientRep2, clientResource);
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        String signedJwt = this.createSignedRequestToken(clientId, privateKey, publicKey, "RS256");
        this.oauth.clientId(clientId);
        this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        EventRepresentation loginEvent = this.events.expectLogin().client(clientId).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.doAccessTokenRequestWithSignedJWT(code, signedJwt);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"not allowed signature algorithm.", (Object)response.getErrorDescription());
    }

    @Test
    public void testHolderOfKeyEnforceExecutor() throws Exception {
        Assume.assumeTrue((String)"This test must be executed with enabled TLS.", (boolean)ServerURLs.AUTH_SERVER_SSL_REQUIRED);
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Az Elso Profil").addExecutor("holder-of-key-enforcer", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createHolderOfKeyEnforceExecutorConfig(Boolean.TRUE)).addExecutor("secure-signature-algorithm-signed-jwt", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureSigningAlgorithmForSignedJwtEnforceExecutorConfig(Boolean.FALSE)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Az Elso Politika", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        try (ClientAttributeUpdater cau = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"test", (String)"test-app");){
            ClientRepresentation clientRep = ((ClientResource)cau.getResource()).toRepresentation();
            Assert.assertNotNull((Object)clientRep);
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseMtlsHoKToken(true);
            cau.update();
            this.checkMtlsFlow();
        }
    }

    @Test
    public void testNegativeLogicCondition() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forste Profilen").addExecutor("secure-session", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secretBeta";
        this.createClientByAdmin(clientId, clientRep -> clientRep.setSecret(clientSecret));
        try {
            this.failLoginWithoutSecureSessionParameter(clientId, "Missing parameter: nonce");
            this.updatePolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig(Boolean.TRUE)).addProfile("MyProfile").toRepresentation());
            this.successfulLoginAndLogout(clientId, clientSecret);
            this.updatePolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig(Boolean.FALSE)).addProfile("MyProfile").toRepresentation());
            this.failLoginWithoutSecureSessionParameter(clientId, "Missing parameter: nonce");
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testExtendedClientPolicyIntefacesForClientRegistrationPolicyMigration() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forste Profilen").addExecutor("test-raise-exception", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientName = "ByAdmin-App" + KeycloakModelUtils.generateId().substring(0, 7);
        String clientId = null;
        try {
            this.createClientByAdmin(clientName, clientRep -> {});
            Assert.fail();
        }
        catch (ClientPolicyException cpe) {
            Assert.assertEquals((Object)ClientPolicyEvent.REGISTERED.toString(), (Object)cpe.getError());
        }
        clientId = this.getClientByAdminWithName(clientName).getId();
        Assert.assertEquals((Object)true, (Object)this.getClientByAdmin(clientId).isEnabled());
        try {
            this.updateClientByAdmin(clientId, clientRep -> clientRep.setEnabled(Boolean.valueOf(false)));
            Assert.fail();
        }
        catch (ClientPolicyException cpe) {
            Assert.assertEquals((Object)ClientPolicyEvent.UPDATED.toString(), (Object)cpe.getError());
        }
        Assert.assertEquals((Object)false, (Object)this.getClientByAdmin(clientId).isEnabled());
        try {
            this.deleteClientByAdmin(clientId);
            Assert.fail();
        }
        catch (ClientPolicyException cpe) {
            Assert.assertEquals((Object)ClientPolicyEvent.UNREGISTER.toString(), (Object)cpe.getError());
        }
    }

    @Test
    public void testUpdatePolicyWithoutNameNotAllowed() throws Exception {
        String json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy(null, "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        try {
            this.updatePolicies(json);
            Assert.fail();
        }
        catch (ClientPolicyException cpe) {
            Assert.assertEquals((Object)"update policies failed", (Object)cpe.getError());
        }
    }

    @Test
    public void testConfidentialClientAcceptExecutorExecutor() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Erstes Profil").addExecutor("confidential-client", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Erstes Politik", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList("sample-client-role"))).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientConfidentialId = this.generateSuffixedName("confidential-app");
        String clientConfidentialSecret = "app-secret";
        String cidConfidential = this.createClientByAdmin(clientConfidentialId, clientRep -> {
            clientRep.setSecret(clientConfidentialSecret);
            clientRep.setStandardFlowEnabled(Boolean.TRUE);
            clientRep.setImplicitFlowEnabled(Boolean.TRUE);
            clientRep.setPublicClient(Boolean.FALSE);
            clientRep.setBearerOnly(Boolean.FALSE);
        });
        this.adminClient.realm("test").clients().get(cidConfidential).roles().create(RoleBuilder.create().name("sample-client-role").build());
        this.successfulLoginAndLogout(clientConfidentialId, clientConfidentialSecret);
        String clientPublicId = this.generateSuffixedName("public-app");
        String cidPublic = this.createClientByAdmin(clientPublicId, clientRep -> {
            clientRep.setSecret(clientConfidentialSecret);
            clientRep.setStandardFlowEnabled(Boolean.TRUE);
            clientRep.setImplicitFlowEnabled(Boolean.TRUE);
            clientRep.setPublicClient(Boolean.TRUE);
            clientRep.setBearerOnly(Boolean.FALSE);
        });
        this.adminClient.realm("test").clients().get(cidPublic).roles().create(RoleBuilder.create().name("sample-client-role").build());
        this.oauth.clientId(clientPublicId);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_client", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"invalid client access type", this.oauth.getCurrentQuery().get("error_description"));
    }

    @Test
    public void testConsentRequiredExecutorExecutor() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Test Profile").addExecutor("consent-required", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createConsentRequiredExecutorConfig(true)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Test Policy", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName("aaa-app");
        String cid = this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setImplicitFlowEnabled(Boolean.FALSE);
            clientRep.setConsentRequired(Boolean.FALSE);
        });
        ClientRepresentation clientRep3 = this.getClientByAdmin(cid);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)clientRep3.isConsentRequired());
        this.updateClientByAdmin(cid, cRep -> cRep.setConsentRequired(Boolean.FALSE));
        clientRep3 = this.getClientByAdmin(cid);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)clientRep3.isConsentRequired());
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Test Profile").addExecutor("consent-required", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createConsentRequiredExecutorConfig(false)).toRepresentation()).toString();
        this.updateProfiles(json);
        try {
            this.createClientByAdmin(clientId, clientRep2 -> clientRep2.setConsentRequired(Boolean.FALSE));
            Assert.fail();
        }
        catch (ClientPolicyException cpe) {
            Assert.assertEquals((Object)"invalid_registration", (Object)cpe.getError());
        }
        try {
            this.updateClientByAdmin(cid, cRep -> cRep.setConsentRequired(Boolean.FALSE));
            Assert.fail();
        }
        catch (ClientPolicyException cpe) {
            Assert.assertEquals((Object)"invalid_registration", (Object)cpe.getError());
        }
        clientRep3 = this.getClientByAdmin(cid);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)clientRep3.isConsentRequired());
        try {
            this.updateClientByAdmin(cid, cRep -> cRep.setImplicitFlowEnabled(Boolean.TRUE));
            clientRep3 = this.getClientByAdmin(cid);
            Assert.assertEquals((Object)Boolean.TRUE, (Object)clientRep3.isImplicitFlowEnabled());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)clientRep3.isConsentRequired());
        }
        catch (ClientPolicyException cpe) {
            Assert.fail();
        }
    }

    @Test
    public void testFullScopeDisabledExecutor() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Test Profile").addExecutor("full-scope-disabled", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createFullScopeDisabledExecutorConfig(true)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Test Policy", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName("aaa-app");
        String cid = this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setImplicitFlowEnabled(Boolean.FALSE);
            clientRep.setFullScopeAllowed(Boolean.TRUE);
        });
        ClientRepresentation clientRep3 = this.getClientByAdmin(cid);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)clientRep3.isFullScopeAllowed());
        this.updateClientByAdmin(cid, cRep -> cRep.setFullScopeAllowed(Boolean.TRUE));
        clientRep3 = this.getClientByAdmin(cid);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)clientRep3.isFullScopeAllowed());
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Test Profile").addExecutor("full-scope-disabled", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createFullScopeDisabledExecutorConfig(false)).toRepresentation()).toString();
        this.updateProfiles(json);
        try {
            this.createClientByAdmin(clientId, clientRep2 -> clientRep2.setFullScopeAllowed(Boolean.TRUE));
            Assert.fail();
        }
        catch (ClientPolicyException cpe) {
            Assert.assertEquals((Object)"invalid_registration", (Object)cpe.getError());
        }
        try {
            this.updateClientByAdmin(cid, cRep -> cRep.setFullScopeAllowed(Boolean.TRUE));
            Assert.fail();
        }
        catch (ClientPolicyException cpe) {
            Assert.assertEquals((Object)"invalid_registration", (Object)cpe.getError());
        }
        clientRep3 = this.getClientByAdmin(cid);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)clientRep3.isFullScopeAllowed());
        try {
            this.updateClientByAdmin(cid, cRep -> cRep.setImplicitFlowEnabled(Boolean.TRUE));
            clientRep3 = this.getClientByAdmin(cid);
            Assert.assertEquals((Object)Boolean.TRUE, (Object)clientRep3.isImplicitFlowEnabled());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)clientRep3.isFullScopeAllowed());
        }
        catch (ClientPolicyException cpe) {
            Assert.fail();
        }
    }

    @Test
    public void testExtendedClientPolicyIntefacesForDeviceAuthorizationRequest() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forste Profilen").addExecutor("test-raise-exception", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        this.oauth.realm("test");
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)ClientPolicyEvent.DEVICE_AUTHORIZATION_REQUEST.toString(), (Object)response.getError());
        Assert.assertEquals((Object)"Exception thrown intentionally", (Object)response.getErrorDescription());
    }

    @Test
    public void testExtendedClientPolicyIntefacesForDeviceTokenRequest() throws Exception {
        this.oauth.realm("test");
        this.oauth.clientId(DEVICE_APP);
        OAuthClient.DeviceAuthorizationResponse response = this.oauth.doDeviceAuthorizationRequest(DEVICE_APP, "secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertNotNull((Object)response.getDeviceCode());
        Assert.assertNotNull((Object)response.getUserCode());
        Assert.assertNotNull((Object)response.getVerificationUri());
        Assert.assertNotNull((Object)response.getVerificationUriComplete());
        this.openVerificationPage(response.getVerificationUri());
        this.verificationPage.assertCurrent();
        this.verificationPage.submit(response.getUserCode());
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("device-login", TEST_USER_PASSWORD);
        this.grantPage.assertCurrent();
        this.grantPage.assertGrants(new String[]{"User profile", "Email address", "User roles"});
        this.grantPage.accept();
        this.verificationPage.assertApprovedPage();
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Den Forste Profilen").addExecutor("test-raise-exception", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "La Premiere Politique", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doDeviceTokenRequest(DEVICE_APP, "secret", response.getDeviceCode());
        Assert.assertEquals((long)400L, (long)tokenResponse.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)tokenResponse.getError());
        Assert.assertEquals((Object)"Exception thrown intentionally", (Object)tokenResponse.getErrorDescription());
    }

    @Test
    public void testSecureLogoutExecutor() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Logout Test").addExecutor("secure-logout", null).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Logout Policy", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secret";
        try {
            this.createClientByAdmin(clientId, clientRep -> {
                clientRep.setSecret(clientSecret);
                clientRep.setStandardFlowEnabled(Boolean.TRUE);
                clientRep.setImplicitFlowEnabled(Boolean.TRUE);
                clientRep.setPublicClient(Boolean.FALSE);
                clientRep.setFrontchannelLogout(Boolean.valueOf(true));
            });
        }
        catch (ClientPolicyException cpe) {
            Assert.assertEquals((Object)"Front-channel logout is not allowed for this client", (Object)cpe.getErrorDetail());
        }
        String cid = this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setSecret(clientSecret);
            clientRep.setStandardFlowEnabled(Boolean.TRUE);
            clientRep.setImplicitFlowEnabled(Boolean.TRUE);
            clientRep.setPublicClient(Boolean.FALSE);
        });
        ClientResource clientResource = this.adminClient.realm("test").clients().get(cid);
        ClientRepresentation clientRep2 = clientResource.toRepresentation();
        clientRep2.setFrontchannelLogout(Boolean.valueOf(true));
        try {
            clientResource.update(clientRep2);
        }
        catch (BadRequestException bre) {
            Assert.assertEquals((Object)"Front-channel logout is not allowed for this client", (Object)((OAuth2ErrorRepresentation)bre.getResponse().readEntity(OAuth2ErrorRepresentation.class)).getErrorDescription());
        }
        ClientPolicyExecutorConfigurationRepresentation config = new ClientPolicyExecutorConfigurationRepresentation();
        config.setConfigAsMap("allow-front-channel-logout", (Object)Boolean.TRUE);
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Logout Test").addExecutor("secure-logout", config).toRepresentation()).toString();
        this.updateProfiles(json);
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep2).setFrontChannelLogoutUrl(this.oauth.getRedirectUri());
        clientResource.update(clientRep2);
        config.setConfigAsMap("allow-front-channel-logout", (Object)Boolean.FALSE.toString());
        json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Logout Test").addExecutor("secure-logout", config).toRepresentation()).toString();
        this.updateProfiles(json);
        this.successfulLogin(clientId, clientSecret);
        this.oauth.openLogout();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Front-channel logout is not allowed for this client"));
    }

    @Test
    public void testRejectResourceOwnerCredentialsGrantExecutor() throws Exception {
        String clientId = this.generateSuffixedName(CLIENT_NAME);
        String clientSecret = "secret";
        this.createClientByAdmin(clientId, clientRep -> {
            clientRep.setSecret(clientSecret);
            clientRep.setStandardFlowEnabled(Boolean.TRUE);
            clientRep.setDirectAccessGrantsEnabled(Boolean.TRUE);
            clientRep.setPublicClient(Boolean.FALSE);
        });
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("MyProfile", "Purofairu desu").addExecutor("reject-ropc-grant", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createRejectisResourceOwnerPasswordCredentialsGrantExecutorConfig(Boolean.TRUE)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("MyPolicy", "Porisii desu", Boolean.TRUE).addCondition("any-client", ClientPoliciesUtil.createAnyClientConditionConfig()).addProfile("MyProfile").toRepresentation()).toString();
        this.updatePolicies(json);
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest(clientSecret, TEST_USER_NAME, TEST_USER_PASSWORD, null);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"resource owner password credentials grant is prohibited.", (Object)response.getErrorDescription());
    }

    private void openVerificationPage(String verificationUri) {
        this.driver.navigate().to(verificationUri);
    }

    private void checkMtlsFlow() throws IOException {
        CloseableHttpResponse logoutResponse;
        CloseableHttpClient client;
        CloseableHttpResponse tokenRevokeResponse;
        String tokenResponse;
        OAuthClient.AccessTokenResponse accessTokenResponseRefreshed;
        OAuthClient.AccessTokenResponse accessTokenResponse;
        OAuthClient.AuthorizationEndpointResponse loginResponse = this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        Assert.assertNull((Object)loginResponse.getError());
        String code = (String)this.oauth.getCurrentQuery().get("code");
        try (CloseableHttpClient client2 = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            accessTokenResponse = this.oauth.doAccessTokenRequest(code, TEST_USER_PASSWORD, client2);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)200L, (long)accessTokenResponse.getStatusCode());
        try (CloseableHttpClient client3 = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            accessTokenResponseRefreshed = this.oauth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken(), TEST_USER_PASSWORD, client3);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)200L, (long)accessTokenResponseRefreshed.getStatusCode());
        try (CloseableHttpClient client4 = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            tokenResponse = this.oauth.introspectTokenWithClientCredential("test-app", TEST_USER_PASSWORD, "access_token", accessTokenResponse.getAccessToken(), client4);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertNotNull((Object)tokenResponse);
        TokenMetadataRepresentation tokenMetadataRepresentation = (TokenMetadataRepresentation)JsonSerialization.readValue((String)tokenResponse, TokenMetadataRepresentation.class);
        Assert.assertTrue((boolean)tokenMetadataRepresentation.isActive());
        try (CloseableHttpClient client5 = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();){
            tokenRevokeResponse = this.oauth.doTokenRevoke(accessTokenResponse.getRefreshToken(), "refresh_token", TEST_USER_PASSWORD, client5);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)200L, (long)tokenRevokeResponse.getStatusLine().getStatusCode());
        try {
            client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();
            try {
                logoutResponse = this.oauth.doLogout(accessTokenResponse.getRefreshToken(), TEST_USER_PASSWORD, client);
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)204L, (long)logoutResponse.getStatusLine().getStatusCode());
        loginResponse = this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        Assert.assertNull((Object)loginResponse.getError());
        code = (String)this.oauth.getCurrentQuery().get("code");
        try {
            client = MutualTLSUtils.newCloseableHttpClientWithoutKeyStoreAndTrustStore();
            try {
                accessTokenResponse = this.oauth.doAccessTokenRequest(code, TEST_USER_PASSWORD, client);
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)400L, (long)accessTokenResponse.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)accessTokenResponse.getError());
        this.oauth.openLogout();
        loginResponse = this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        Assert.assertNull((Object)loginResponse.getError());
        code = (String)this.oauth.getCurrentQuery().get("code");
        try {
            client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();
            try {
                accessTokenResponse = this.oauth.doAccessTokenRequest(code, TEST_USER_PASSWORD, client);
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)200L, (long)accessTokenResponse.getStatusCode());
        try {
            client = MutualTLSUtils.newCloseableHttpClientWithOtherKeyStoreAndTrustStore();
            try {
                accessTokenResponseRefreshed = this.oauth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken(), TEST_USER_PASSWORD, client);
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)400L, (long)accessTokenResponseRefreshed.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)accessTokenResponseRefreshed.getError());
        try {
            client = MutualTLSUtils.newCloseableHttpClientWithOtherKeyStoreAndTrustStore();
            try {
                tokenRevokeResponse = this.oauth.doTokenRevoke(accessTokenResponse.getRefreshToken(), "refresh_token", TEST_USER_PASSWORD, client);
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)401L, (long)tokenRevokeResponse.getStatusLine().getStatusCode());
        try {
            client = MutualTLSUtils.newCloseableHttpClientWithoutKeyStoreAndTrustStore();
            try {
                logoutResponse = this.oauth.doLogout(accessTokenResponse.getRefreshToken(), TEST_USER_PASSWORD, client);
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Assert.assertEquals((long)401L, (long)logoutResponse.getStatusLine().getStatusCode());
        try {
            client = MutualTLSUtils.newCloseableHttpClientWithDefaultKeyStoreAndTrustStore();
            try {
                logoutResponse = this.oauth.doLogout(accessTokenResponse.getRefreshToken(), TEST_USER_PASSWORD, client);
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void setupPolicyClientIdAndSecretNotAcceptableAuthType(String policyName) throws Exception {
        String profileName = "MyProfile";
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile(profileName, "Primum Profile").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-jwt", "client-secret-jwt", "client-x509"), null)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy(policyName, "Primum Consilium", Boolean.TRUE).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser"))).addProfile(profileName).toRepresentation()).toString();
        this.updatePolicies(json);
    }

    private void setupPolicyAuthzCodeFlowUnderMultiPhasePolicy(String policyName) throws Exception {
        String profileName = "MyProfile";
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile(profileName, "Primul Profil").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-secret", "client-jwt"), "client-secret")).addExecutor("pkce-enforcer", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createPKCEEnforceExecutorConfig(Boolean.TRUE)).toRepresentation()).toString();
        this.updateProfiles(json);
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy(policyName, "Prima Politica", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList("sample-client-role"))).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByInitialAccessToken"))).addProfile(profileName).toRepresentation()).toString();
        this.updatePolicies(json);
    }

    private void successfulLoginAndLogout(String clientId, String clientSecret) {
        OAuthClient.AccessTokenResponse res = this.successfulLogin(clientId, clientSecret);
        this.oauth.doLogout(res.getRefreshToken(), clientSecret);
        this.events.expectLogout(res.getSessionState()).client(clientId).clearDetails().assertEvent();
    }

    private OAuthClient.AccessTokenResponse successfulLogin(String clientId, String clientSecret) {
        this.oauth.clientId(clientId);
        this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        EventRepresentation loginEvent = this.events.expectLogin().client(clientId).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.events.expectCodeToToken(codeId, sessionId).client(clientId).assertEvent();
        return res;
    }

    private void successfulLoginAndLogoutWithPKCE(String clientId, String clientSecret, String userName, String userPassword) throws Exception {
        this.oauth.clientId(clientId);
        String codeVerifier = "1a345A7890123456r8901c3456789012b45K7890l23";
        String codeChallenge = this.generateS256CodeChallenge(codeVerifier);
        this.oauth.codeChallenge(codeChallenge);
        this.oauth.codeChallengeMethod("S256");
        this.oauth.nonce("bjapewiziIE083d");
        this.oauth.doLogin(userName, userPassword);
        EventRepresentation loginEvent = this.events.expectLogin().client(clientId).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        this.oauth.codeVerifier(codeVerifier);
        OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.events.expectCodeToToken(codeId, sessionId).client(clientId).assertEvent();
        AccessToken token = this.oauth.verifyToken(res.getAccessToken());
        String userId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)userName).getId();
        Assert.assertEquals((Object)userId, (Object)token.getSubject());
        Assert.assertNotEquals((Object)userName, (Object)token.getSubject());
        Assert.assertEquals((Object)sessionId, (Object)token.getSessionState());
        Assert.assertEquals((Object)clientId, (Object)token.getIssuedFor());
        String refreshTokenString = res.getRefreshToken();
        RefreshToken refreshToken = this.oauth.parseRefreshToken(refreshTokenString);
        Assert.assertEquals((Object)sessionId, (Object)refreshToken.getSessionState());
        Assert.assertEquals((Object)clientId, (Object)refreshToken.getIssuedFor());
        OAuthClient.AccessTokenResponse refreshResponse = this.oauth.doRefreshTokenRequest(refreshTokenString, clientSecret);
        Assert.assertEquals((long)200L, (long)refreshResponse.getStatusCode());
        this.events.expectRefresh(refreshToken.getId(), sessionId).client(clientId).assertEvent();
        AccessToken refreshedToken = this.oauth.verifyToken(refreshResponse.getAccessToken());
        RefreshToken refreshedRefreshToken = this.oauth.parseRefreshToken(refreshResponse.getRefreshToken());
        Assert.assertEquals((Object)sessionId, (Object)refreshedToken.getSessionState());
        Assert.assertEquals((Object)sessionId, (Object)refreshedRefreshToken.getSessionState());
        Assert.assertEquals((Object)ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)userName).getId(), (Object)refreshedToken.getSubject());
        this.doIntrospectAccessToken(refreshResponse, userName, clientId, clientSecret);
        this.doTokenRevoke(refreshResponse.getRefreshToken(), clientId, clientSecret, userId, false);
    }

    private void failLoginByNotFollowingPKCE(String clientId) {
        this.oauth.clientId(clientId);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Missing parameter: code_challenge_method", this.oauth.getCurrentQuery().get("error_description"));
    }

    private void failTokenRequestByNotFollowingPKCE(String clientId, String clientSecret) {
        this.oauth.clientId(clientId);
        this.oauth.doLogin(TEST_USER_NAME, TEST_USER_PASSWORD);
        EventRepresentation loginEvent = this.events.expectLogin().client(clientId).assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse res = this.oauth.doAccessTokenRequest(code, clientSecret);
        Assert.assertEquals((Object)"invalid_grant", (Object)res.getError());
        Assert.assertEquals((Object)"PKCE code verifier not specified", (Object)res.getErrorDescription());
        this.events.expect(EventType.CODE_TO_TOKEN_ERROR).client(clientId).session(sessionId).clearDetails().error("code_verifier_missing").assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(sessionId).clearDetails().assertEvent();
    }

    private void failLoginWithoutSecureSessionParameter(String clientId, String errorDescription) {
        this.oauth.clientId(clientId);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)errorDescription, this.oauth.getCurrentQuery().get("error_description"));
    }

    private void failLoginWithoutNonce(String clientId) {
        this.oauth.clientId(clientId);
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)"invalid_request", this.oauth.getCurrentQuery().get("error"));
        Assert.assertEquals((Object)"Missing parameter: nonce", this.oauth.getCurrentQuery().get("error_description"));
    }
}

