/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientPoliciesRepresentation;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientPolicyRepresentation;
import org.keycloak.representations.idm.ClientProfileRepresentation;
import org.keycloak.representations.idm.ClientProfilesRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.clientpolicy.ClientPoliciesUtil;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.AbstractClientPoliciesTest;
import org.keycloak.testsuite.util.ClientPoliciesUtil;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ClientPoliciesLoadUpdateTest
extends AbstractClientPoliciesTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void testLoadBuiltinProfilesAndPolicies() throws Exception {
        ClientProfilesRepresentation actualProfilesRep = this.getProfilesWithGlobals();
        this.assertExpectedProfiles(actualProfilesRep, Arrays.asList("fapi-1-baseline", "fapi-1-advanced", "fapi-ciba"), Collections.emptyList());
        ClientProfileRepresentation actualProfileRep = this.getProfileRepresentation(actualProfilesRep, "fapi-1-baseline", true);
        this.assertExpectedProfile(actualProfileRep, "fapi-1-baseline", "Client profile, which enforce clients to conform 'Financial-grade API Security Profile 1.0 - Part 1: Baseline' specification.");
        this.assertExpectedExecutors(Arrays.asList("secure-session", "pkce-enforcer", "secure-client-authenticator", "secure-client-uris", "consent-required", "full-scope-disabled"), actualProfileRep);
        this.assertExpectedSecureSessionEnforceExecutor(actualProfileRep);
        actualProfilesRep = this.getProfilesWithoutGlobals();
        this.assertExpectedProfiles(actualProfilesRep, null, Collections.emptyList());
        ClientPoliciesRepresentation actualPoliciesRep = this.getPolicies();
        this.assertExpectedPolicies(Collections.emptyList(), actualPoliciesRep);
        ClientPolicyRepresentation actualPolicyRep = this.getPolicyRepresentation(actualPoliciesRep, "builtin-default-policy");
        Assert.assertNull((Object)actualPolicyRep);
    }

    @Test
    public void testUpdateValidProfilesAndPolicies() throws Exception {
        this.setupValidProfilesAndPolicies();
        this.assertExpectedLoadedProfiles(reps -> {
            ClientProfileRepresentation rep = this.getProfileRepresentation((ClientProfilesRepresentation)reps, "ordinal-test-profile", false);
            this.assertExpectedProfile(rep, "ordinal-test-profile", "The profile that can be loaded.");
        });
        this.assertExpectedLoadedPolicies(reps -> {
            ClientPolicyRepresentation rep = this.getPolicyRepresentation((ClientPoliciesRepresentation)reps, "new-policy");
            this.assertExpectedPolicy("new-policy", "duplicated profiles are ignored.", true, Arrays.asList("ordinal-test-profile", "lack-of-builtin-field-test-profile"), rep);
        });
        String modifiedProfileDescription = "The profile has been updated.";
        ClientProfilesRepresentation actualProfilesRep = this.getProfilesWithoutGlobals();
        ClientPoliciesUtil.ClientProfilesBuilder profilesBuilder = new ClientPoliciesUtil.ClientProfilesBuilder();
        actualProfilesRep.getProfiles().stream().forEach(i -> {
            if (i.getName().equals("ordinal-test-profile")) {
                i.setDescription(modifiedProfileDescription);
            }
            profilesBuilder.addProfile((ClientProfileRepresentation)i);
        });
        this.updateProfiles(profilesBuilder.toString());
        this.assertExpectedLoadedProfiles(reps -> {
            ClientProfileRepresentation rep = this.getProfileRepresentation((ClientProfilesRepresentation)reps, "ordinal-test-profile", false);
            this.assertExpectedProfile(rep, "ordinal-test-profile", modifiedProfileDescription);
        });
        String modifiedPolicyDescription = "The policy has also been updated.";
        ClientPoliciesRepresentation actualPoliciesRep = this.getPolicies();
        ClientPoliciesUtil.ClientPoliciesBuilder policiesBuilder = new ClientPoliciesUtil.ClientPoliciesBuilder();
        actualPoliciesRep.getPolicies().stream().forEach(i -> {
            if (i.getName().equals("new-policy")) {
                i.setDescription(modifiedPolicyDescription);
                i.setEnabled(null);
            }
            policiesBuilder.addPolicy((ClientPolicyRepresentation)i);
        });
        this.updatePolicies(policiesBuilder.toString());
        this.assertExpectedLoadedPolicies(reps -> {
            ClientPolicyRepresentation rep = this.getPolicyRepresentation((ClientPoliciesRepresentation)reps, "new-policy");
            this.assertExpectedPolicy("new-policy", modifiedPolicyDescription, false, Arrays.asList("ordinal-test-profile", "lack-of-builtin-field-test-profile"), rep);
        });
    }

    @Test
    public void testDuplicatedProfiles() throws Exception {
        String beforeUpdateProfilesJson = ClientPoliciesUtil.convertClientProfilesRepresentationToJson((ClientProfilesRepresentation)this.getProfilesWithGlobals());
        ClientProfileRepresentation duplicatedProfileRep = new ClientPoliciesUtil.ClientProfileBuilder().createProfile("builtin-basic-security", "Enforce basic security level").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)org.keycloak.testsuite.util.ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-secret", "client-jwt"), null)).addExecutor("pkce-enforcer", (ClientPolicyExecutorConfigurationRepresentation)org.keycloak.testsuite.util.ClientPoliciesUtil.createPKCEEnforceExecutorConfig(Boolean.FALSE)).addExecutor("no-such-executor", (ClientPolicyExecutorConfigurationRepresentation)org.keycloak.testsuite.util.ClientPoliciesUtil.createPKCEEnforceExecutorConfig(Boolean.TRUE)).toRepresentation();
        ClientProfileRepresentation loadedProfileRep = new ClientPoliciesUtil.ClientProfileBuilder().createProfile("ordinal-test-profile", "The profile that can be loaded.").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)org.keycloak.testsuite.util.ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Collections.singletonList("client-jwt"), "client-jwt")).toRepresentation();
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(duplicatedProfileRep).addProfile(loadedProfileRep).addProfile(duplicatedProfileRep).toString();
        try {
            this.updateProfiles(json);
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException cpe) {
            org.junit.Assert.assertEquals((Object)"Bad Request", (Object)cpe.getErrorDetail());
            String afterFailedUpdateProfilesJson = ClientPoliciesUtil.convertClientProfilesRepresentationToJson((ClientProfilesRepresentation)this.getProfilesWithGlobals());
            org.junit.Assert.assertEquals((Object)beforeUpdateProfilesJson, (Object)afterFailedUpdateProfilesJson);
        }
    }

    @Test
    public void testOverwriteBuiltinProfileNotAllowed() throws Exception {
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(new ClientPoliciesUtil.ClientProfileBuilder().createProfile("fapi-1-baseline", "Pershyy Profil").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)org.keycloak.testsuite.util.ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-jwt", "client-secret-jwt", "client-x509"), "client-x509")).toRepresentation()).toRepresentation().toString();
        try {
            this.updateProfiles(json);
            org.junit.Assert.fail();
        }
        catch (ClientPolicyException cpe) {
            org.junit.Assert.assertEquals((Object)"update profiles failed", (Object)cpe.getError());
        }
    }

    @Test
    public void testNullProfiles() throws Exception {
        String beforeUpdateProfilesJson = ClientPoliciesUtil.convertClientProfilesRepresentationToJson((ClientProfilesRepresentation)this.getProfilesWithGlobals());
        String json = null;
        try {
            this.updateProfiles(json);
        }
        catch (ClientPolicyException cpe) {
            org.junit.Assert.assertEquals((Object)"argument \"content\" is null", (Object)cpe.getErrorDetail());
            String afterFailedUpdateProfilesJson = ClientPoliciesUtil.convertClientProfilesRepresentationToJson((ClientProfilesRepresentation)this.getProfilesWithGlobals());
            org.junit.Assert.assertEquals((Object)beforeUpdateProfilesJson, (Object)afterFailedUpdateProfilesJson);
            return;
        }
        org.junit.Assert.fail();
    }

    @Test
    public void testInvalidFormattedJsonProfiles() throws Exception {
        String beforeUpdateProfilesJson = ClientPoliciesUtil.convertClientProfilesRepresentationToJson((ClientProfilesRepresentation)this.getProfilesWithGlobals());
        String json = "{\n    \"profiles\": [\n        {\n            \"name\" : \"ordinal-test-profile\",\n            \"description\" : \"invalid , added.\",\n            \"builtin\" : false,\n            \"executors\": [\n                {\n                    \"new-secure-client-authnenticator\": {\n                        \"client-authns\": [ \"private-key-jwt\" ],\n                        \"client-authns-augment\" : \"private-key-jwt\",\n                        \"is-augment\" : true\n                    }\n                }\n            ]\n        },\n    ]\n}";
        try {
            this.updateProfiles(json);
        }
        catch (ClientPolicyException cpe) {
            MatcherAssert.assertThat((Object)cpe.getErrorDetail(), (Matcher)Matchers.startsWith((String)"Unrecognized field"));
            String afterFailedUpdateProfilesJson = ClientPoliciesUtil.convertClientProfilesRepresentationToJson((ClientProfilesRepresentation)this.getProfilesWithGlobals());
            org.junit.Assert.assertEquals((Object)beforeUpdateProfilesJson, (Object)afterFailedUpdateProfilesJson);
            return;
        }
        org.junit.Assert.fail();
    }

    @Test
    public void testInvalidFieldTypeJsonProfiles() throws Exception {
        String beforeUpdateProfilesJson = ClientPoliciesUtil.convertClientProfilesRepresentationToJson((ClientProfilesRepresentation)this.getProfilesWithGlobals());
        String json = "{\n    \"profiles\": [\n        {\n            \"name\" : \"ordinal-test-profile\",\n            \"description\" : \"Not builtin profile that should be skipped.\",\n            \"builtin\" : \"no\",\n            \"executors\": {\n                    \"new-secure-client-authnenticator\": {\n                        \"client-authns\": [ \"private-key-jwt\" ],\n                        \"client-authns-augment\" : \"private-key-jwt\",\n                        \"is-augment\" : true\n                    }\n            ]\n        }\n    ]\n}";
        try {
            this.updateProfiles(json);
        }
        catch (ClientPolicyException cpe) {
            MatcherAssert.assertThat((Object)cpe.getErrorDetail(), (Matcher)Matchers.startsWith((String)"Unrecognized field "));
            String afterFailedUpdateProfilesJson = ClientPoliciesUtil.convertClientProfilesRepresentationToJson((ClientProfilesRepresentation)this.getProfilesWithGlobals());
            org.junit.Assert.assertEquals((Object)beforeUpdateProfilesJson, (Object)afterFailedUpdateProfilesJson);
            return;
        }
        org.junit.Assert.fail();
    }

    @Test
    public void testDuplicatedPolicies() throws Exception {
        String beforeUpdatePoliciesJson = ClientPoliciesUtil.convertClientPoliciesRepresentationToJson((ClientPoliciesRepresentation)this.getPolicies());
        ClientPolicyRepresentation duplicatedPoliciesRep = new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("builtin-duplicated-new-policy", "builtin duplicated new policy is ignored.", Boolean.TRUE).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)org.keycloak.testsuite.util.ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList("sample-client-role"))).addProfile("fapi-1-baseline").toRepresentation();
        ClientPolicyRepresentation loadedPolicyRep = new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("new-policy", "duplicated profiles are ignored.", Boolean.TRUE).addCondition("client-access-type", (ClientPolicyConditionConfigurationRepresentation)org.keycloak.testsuite.util.ClientPoliciesUtil.createClientAccessTypeConditionConfig(Arrays.asList("public", "bearer-only"))).addProfile("lack-of-builtin-field-test-profile").addProfile("ordinal-test-profile").toRepresentation();
        String json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(duplicatedPoliciesRep).addPolicy(loadedPolicyRep).addPolicy(duplicatedPoliciesRep).toString();
        try {
            this.updatePolicies(json);
        }
        catch (ClientPolicyException cpe) {
            org.junit.Assert.assertEquals((Object)"Bad Request", (Object)cpe.getErrorDetail());
            String afterFailedUpdatePoliciesJson = ClientPoliciesUtil.convertClientPoliciesRepresentationToJson((ClientPoliciesRepresentation)this.getPolicies());
            org.junit.Assert.assertEquals((Object)beforeUpdatePoliciesJson, (Object)afterFailedUpdatePoliciesJson);
            return;
        }
        org.junit.Assert.fail();
    }

    @Test
    public void testNullPolicies() throws Exception {
        String beforeUpdatePoliciesJson = ClientPoliciesUtil.convertClientPoliciesRepresentationToJson((ClientPoliciesRepresentation)this.getPolicies());
        String json = null;
        try {
            this.updatePolicies(json);
        }
        catch (ClientPolicyException cpe) {
            org.junit.Assert.assertEquals((Object)"Bad Request", (Object)cpe.getErrorDetail());
            String afterFailedUpdatePoliciesJson = ClientPoliciesUtil.convertClientPoliciesRepresentationToJson((ClientPoliciesRepresentation)this.getPolicies());
            org.junit.Assert.assertEquals((Object)beforeUpdatePoliciesJson, (Object)afterFailedUpdatePoliciesJson);
            return;
        }
        org.junit.Assert.fail();
    }

    @Test
    public void testInvalidFormattedJsonPolicies() throws Exception {
        String beforeUpdatePoliciesJson = ClientPoliciesUtil.convertClientPoliciesRepresentationToJson((ClientPoliciesRepresentation)this.getPolicies());
        String json = "{\n    \"policies\": [\n        {\n            \"name\": \"ordinal-test-policy\",\n            \"description\" : \"bracket not enclosed properly.\",\n            \"builtin\": false,\n            \"enable\": true,\n            \"conditions\": [\n                {\n                    \"new-client-updater-source-host\": {\n                        \"trusted-hosts\": [\"myuniversity\"],\n                        \"host-sending-request-must-match\" : [true]\n                    }\n                }\n            ],\n            \"profiles\": [ \"builtin-advanced-security\" ]\n        }\n}";
        try {
            this.updatePolicies(json);
        }
        catch (ClientPolicyException cpe) {
            MatcherAssert.assertThat((Object)cpe.getErrorDetail(), (Matcher)Matchers.startsWith((String)"Unrecognized field "));
            String afterFailedUpdatePoliciesJson = ClientPoliciesUtil.convertClientPoliciesRepresentationToJson((ClientPoliciesRepresentation)this.getPolicies());
            org.junit.Assert.assertEquals((Object)beforeUpdatePoliciesJson, (Object)afterFailedUpdatePoliciesJson);
            return;
        }
        org.junit.Assert.fail();
    }

    @Test
    public void testInvalidFieldTypeJsonPolicies() throws Exception {
        String beforeUpdatePoliciesJson = ClientPoliciesUtil.convertClientPoliciesRepresentationToJson((ClientPoliciesRepresentation)this.getPolicies());
        String json = "{    \n    \"policies\": [    \n        {    \n            \"name\": \"ordinal-test-policy\",    \n            \"description\" : \"Not builtin policy that should be skipped.\",    \n            \"builtin\": false,    \n            \"enable\": true,    \n            \"conditions\": true,    \n            \"profiles\": [ \"builtin-advanced-security\" ]    \n        }    \n    ]    \n}";
        try {
            this.updatePolicies(json);
        }
        catch (ClientPolicyException cpe) {
            MatcherAssert.assertThat((Object)cpe.getErrorDetail(), (Matcher)Matchers.startsWith((String)"Unrecognized field "));
            String afterFailedUpdatePoliciesJson = ClientPoliciesUtil.convertClientPoliciesRepresentationToJson((ClientPoliciesRepresentation)this.getPolicies());
            org.junit.Assert.assertEquals((Object)beforeUpdatePoliciesJson, (Object)afterFailedUpdatePoliciesJson);
            return;
        }
        org.junit.Assert.fail();
    }

    @Test
    public void testCRUDRealmRepresentation() throws Exception {
        this.setupValidProfilesAndPolicies();
        RealmResource testRealm = this.realmsResouce().realm("test");
        RealmRepresentation realmRep = testRealm.toRepresentation();
        this.assertExpectedProfiles(realmRep.getParsedClientProfiles(), null, Arrays.asList("ordinal-test-profile", "lack-of-builtin-field-test-profile"));
        this.assertExpectedPolicies(Arrays.asList("new-policy", "lack-of-builtin-field-test-policy"), realmRep.getParsedClientPolicies());
        testRealm.update(realmRep);
        realmRep = testRealm.toRepresentation();
        this.assertExpectedProfiles(realmRep.getParsedClientProfiles(), null, Arrays.asList("ordinal-test-profile", "lack-of-builtin-field-test-profile"));
        this.assertExpectedPolicies(Arrays.asList("new-policy", "lack-of-builtin-field-test-policy"), realmRep.getParsedClientPolicies());
    }
}

