/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.client.registration.HttpErrorException;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.client.AbstractClientRegistrationTest;
import org.keycloak.testsuite.util.ServerURLs;

public class AdapterInstallationConfigTest
extends AbstractClientRegistrationTest {
    private ClientRepresentation client;
    private ClientRepresentation client2;
    private ClientRepresentation clientPublic;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.client = new ClientRepresentation();
        this.client.setEnabled(Boolean.valueOf(true));
        this.client.setClientId("RegistrationAccessTokenTest");
        this.client.setSecret("RegistrationAccessTokenTestClientSecret");
        this.client.setPublicClient(Boolean.valueOf(false));
        this.client.setRegistrationAccessToken("RegistrationAccessTokenTestRegistrationAccessToken");
        this.client.setRootUrl("http://root");
        this.client = this.createClient(this.client);
        this.client.setSecret("RegistrationAccessTokenTestClientSecret");
        this.getCleanup().addClientUuid(this.client.getId());
        this.client2 = new ClientRepresentation();
        this.client2.setEnabled(Boolean.valueOf(true));
        this.client2.setClientId("RegistrationAccessTokenTest2");
        this.client2.setSecret("RegistrationAccessTokenTestClientSecret");
        this.client2.setPublicClient(Boolean.valueOf(false));
        this.client2.setRegistrationAccessToken("RegistrationAccessTokenTestRegistrationAccessToken");
        this.client2.setRootUrl("http://root");
        this.client2 = this.createClient(this.client2);
        this.getCleanup().addClientUuid(this.client2.getId());
        this.clientPublic = new ClientRepresentation();
        this.clientPublic.setEnabled(Boolean.valueOf(true));
        this.clientPublic.setClientId("RegistrationAccessTokenTestPublic");
        this.clientPublic.setPublicClient(Boolean.valueOf(true));
        this.clientPublic.setRegistrationAccessToken("RegistrationAccessTokenTestRegistrationAccessTokenPublic");
        this.clientPublic.setRootUrl("http://root");
        this.clientPublic = this.createClient(this.clientPublic);
        this.getCleanup().addClientUuid(this.clientPublic.getId());
    }

    @Test
    public void getConfigWithRegistrationAccessToken() throws ClientRegistrationException {
        this.reg.auth(Auth.token((String)this.client.getRegistrationAccessToken()));
        AdapterConfig config = this.reg.getAdapterConfig(this.client.getClientId());
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void getConfig() throws ClientRegistrationException {
        this.reg.auth(Auth.client((String)this.client.getClientId(), (String)"RegistrationAccessTokenTestClientSecret"));
        AdapterConfig config = this.reg.getAdapterConfig(this.client.getClientId());
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/"), (Object)config.getAuthServerUrl());
        Assert.assertEquals((Object)"test", (Object)config.getRealm());
        Assert.assertEquals((long)1L, (long)config.getCredentials().size());
        Assert.assertEquals((Object)"RegistrationAccessTokenTestClientSecret", config.getCredentials().get("secret"));
        Assert.assertEquals((Object)this.client.getClientId(), (Object)config.getResource());
        if (ServerURLs.AUTH_SERVER_SSL_REQUIRED) {
            Assert.assertEquals((Object)SslRequired.EXTERNAL.name().toLowerCase(), (Object)config.getSslRequired());
        }
    }

    @Test
    public void getConfigMissingSecret() throws ClientRegistrationException {
        this.reg.auth(null);
        try {
            this.reg.getAdapterConfig(this.client.getClientId());
            Assert.fail((String)"Expected 401");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void getConfigWrongClient() throws ClientRegistrationException {
        this.reg.auth(Auth.client((String)this.client.getClientId(), (String)this.client.getSecret()));
        try {
            this.reg.getAdapterConfig(this.client2.getClientId());
            Assert.fail((String)"Expected 401");
        }
        catch (ClientRegistrationException e) {
            Assert.assertEquals((long)401L, (long)((HttpErrorException)e.getCause()).getStatusLine().getStatusCode());
        }
    }

    @Test
    public void getConfigPublicClient() throws ClientRegistrationException {
        this.reg.auth(null);
        AdapterConfig config = this.reg.getAdapterConfig(this.clientPublic.getClientId());
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"test", (Object)config.getRealm());
        Assert.assertEquals((long)0L, (long)config.getCredentials().size());
        Assert.assertEquals((Object)this.clientPublic.getClientId(), (Object)config.getResource());
        if (ServerURLs.AUTH_SERVER_SSL_REQUIRED) {
            Assert.assertEquals((Object)SslRequired.EXTERNAL.name().toLowerCase(), (Object)config.getSslRequired());
        }
    }
}

