/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistration;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.BouncyIntegration;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.UriUtils;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientPoliciesRepresentation;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.representations.idm.ClientPolicyConditionRepresentation;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientPolicyExecutorRepresentation;
import org.keycloak.representations.idm.ClientPolicyRepresentation;
import org.keycloak.representations.idm.ClientProfileRepresentation;
import org.keycloak.representations.idm.ClientProfilesRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.representations.oidc.TokenMetadataRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.condition.ClientAccessTypeCondition;
import org.keycloak.services.clientpolicy.condition.ClientRolesCondition;
import org.keycloak.services.clientpolicy.condition.ClientScopesCondition;
import org.keycloak.services.clientpolicy.condition.ClientUpdaterContextCondition;
import org.keycloak.services.clientpolicy.condition.ClientUpdaterSourceGroupsCondition;
import org.keycloak.services.clientpolicy.condition.ClientUpdaterSourceHostsCondition;
import org.keycloak.services.clientpolicy.condition.ClientUpdaterSourceRolesCondition;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.client.resources.TestApplicationResourceUrls;
import org.keycloak.testsuite.client.resources.TestOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.rest.resource.TestingOIDCEndpointsApplicationResource;
import org.keycloak.testsuite.util.ClientPoliciesUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.util.JsonSerialization;

public abstract class AbstractClientPoliciesTest
extends AbstractKeycloakTest {
    protected static final Logger logger = Logger.getLogger(AbstractClientPoliciesTest.class);
    protected static final String REALM_NAME = "test";
    protected static final String TEST_CLIENT = "test-app";
    protected static final String TEST_CLIENT_SECRET = "password";
    protected static final String POLICY_NAME = "MyPolicy";
    protected static final String PROFILE_NAME = "MyProfile";
    protected static final String SAMPLE_CLIENT_ROLE = "sample-client-role";
    protected static final String FAPI1_BASELINE_PROFILE_NAME = "fapi-1-baseline";
    protected static final String FAPI1_ADVANCED_PROFILE_NAME = "fapi-1-advanced";
    protected static final String FAPI_CIBA_PROFILE_NAME = "fapi-ciba";
    protected static final String ERR_MSG_MISSING_NONCE = "Missing parameter: nonce";
    protected static final String ERR_MSG_MISSING_STATE = "Missing parameter: state";
    protected static final String ERR_MSG_CLIENT_REG_FAIL = "Failed to send request";
    protected ClientRegistration reg;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @BeforeClass
    public static void beforeClientPoliciesTest() {
        BouncyIntegration.init();
    }

    @Before
    public void before() throws Exception {
        this.setInitialAccessTokenForDynamicClientRegistration();
    }

    protected void setInitialAccessTokenForDynamicClientRegistration() {
        this.reg = ClientRegistration.create().url(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth", REALM_NAME).build();
        ClientInitialAccessPresentation token = this.adminClient.realm(REALM_NAME).clientInitialAccess().create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(10)));
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)token));
    }

    @After
    public void after() throws Exception {
        this.reg.close();
        this.revertToBuiltinProfiles();
        this.revertToBuiltinPolicies();
    }

    protected void setupValidProfilesAndPolicies() throws Exception {
        ClientProfileRepresentation loadedProfileRep = new ClientPoliciesUtil.ClientProfileBuilder().createProfile("ordinal-test-profile", "The profile that can be loaded.").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-jwt"), "client-jwt")).toRepresentation();
        ClientProfileRepresentation loadedProfileRepWithoutBuiltinField = new ClientPoliciesUtil.ClientProfileBuilder().createProfile("lack-of-builtin-field-test-profile", "Without builtin field that is treated as builtin=false.").addExecutor("secure-client-authenticator", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createSecureClientAuthenticatorExecutorConfig(Arrays.asList("client-jwt"), "client-jwt")).addExecutor("holder-of-key-enforcer", (ClientPolicyExecutorConfigurationRepresentation)ClientPoliciesUtil.createHolderOfKeyEnforceExecutorConfig(Boolean.TRUE)).addExecutor("secure-client-uris", null).addExecutor("secure-request-object", null).addExecutor("secure-response-type", null).addExecutor("secure-session", null).addExecutor("secure-signature-algorithm", null).addExecutor("secure-signature-algorithm-signed-jwt", null).toRepresentation();
        String json = new ClientPoliciesUtil.ClientProfilesBuilder().addProfile(loadedProfileRep).addProfile(loadedProfileRepWithoutBuiltinField).toString();
        this.updateProfiles(json);
        ClientPolicyRepresentation loadedPolicyRepNotExistAndDuplicatedProfile = new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("new-policy", "duplicated profiles are ignored.", Boolean.TRUE).addCondition("client-access-type", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientAccessTypeConditionConfig(Arrays.asList("public", "bearer-only"))).addCondition("client-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientRolesConditionConfig(Arrays.asList(SAMPLE_CLIENT_ROLE))).addCondition("client-scopes", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientScopesConditionConfig("Optional", Arrays.asList(SAMPLE_CLIENT_ROLE))).addProfile("ordinal-test-profile").addProfile("lack-of-builtin-field-test-profile").addProfile("ordinal-test-profile").toRepresentation();
        ClientPolicyRepresentation loadedPolicyRepWithoutBuiltinField = new ClientPoliciesUtil.ClientPolicyBuilder().createPolicy("lack-of-builtin-field-test-policy", "Without builtin field that is treated as builtin=false.", null).addCondition("client-updater-context", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateContextConditionConfig(Arrays.asList("ByAuthenticatedUser"))).addCondition("client-updater-source-groups", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateSourceGroupsConditionConfig(Arrays.asList("topGroup"))).addCondition("client-updater-source-host", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateSourceHostsConditionConfig(Arrays.asList("localhost", "127.0.0.1"))).addCondition("client-updater-source-roles", (ClientPolicyConditionConfigurationRepresentation)ClientPoliciesUtil.createClientUpdateSourceRolesConditionConfig(Arrays.asList(AdminRoles.CREATE_CLIENT))).addProfile("lack-of-builtin-field-test-profile").toRepresentation();
        json = new ClientPoliciesUtil.ClientPoliciesBuilder().addPolicy(loadedPolicyRepNotExistAndDuplicatedProfile).addPolicy(loadedPolicyRepWithoutBuiltinField).toString();
        this.updatePolicies(json);
    }

    protected void assertExpectedLoadedProfiles(Consumer<ClientProfilesRepresentation> modifiedAssertion) throws Exception {
        ClientProfilesRepresentation actualProfilesRep = this.getProfilesWithGlobals();
        this.assertExpectedProfiles(actualProfilesRep, Arrays.asList(FAPI1_BASELINE_PROFILE_NAME, FAPI1_ADVANCED_PROFILE_NAME, FAPI_CIBA_PROFILE_NAME), Arrays.asList("ordinal-test-profile", "lack-of-builtin-field-test-profile"));
        ClientProfileRepresentation actualProfileRep = this.getProfileRepresentation(actualProfilesRep, FAPI1_BASELINE_PROFILE_NAME, true);
        this.assertExpectedProfile(actualProfileRep, FAPI1_BASELINE_PROFILE_NAME, "Client profile, which enforce clients to conform 'Financial-grade API Security Profile 1.0 - Part 1: Baseline' specification.");
        this.assertExpectedExecutors(Arrays.asList("secure-session", "pkce-enforcer", "secure-client-authenticator", "secure-client-uris", "consent-required", "full-scope-disabled"), actualProfileRep);
        this.assertExpectedSecureSessionEnforceExecutor(actualProfileRep);
        actualProfileRep = this.getProfileRepresentation(actualProfilesRep, "ordinal-test-profile", false);
        modifiedAssertion.accept(actualProfilesRep);
        this.assertExpectedExecutors(Arrays.asList("secure-client-authenticator"), actualProfileRep);
        this.assertExpectedSecureClientAuthEnforceExecutor(Arrays.asList("client-jwt"), "client-jwt", actualProfileRep);
        actualProfileRep = this.getProfileRepresentation(actualProfilesRep, "lack-of-builtin-field-test-profile", false);
        this.assertExpectedProfile(actualProfileRep, "lack-of-builtin-field-test-profile", "Without builtin field that is treated as builtin=false.");
        this.assertExpectedExecutors(Arrays.asList("secure-client-authenticator", "holder-of-key-enforcer", "secure-client-uris", "secure-request-object", "secure-response-type", "secure-session", "secure-signature-algorithm", "secure-signature-algorithm-signed-jwt"), actualProfileRep);
        this.assertExpectedSecureClientAuthEnforceExecutor(Arrays.asList("client-jwt"), "client-jwt", actualProfileRep);
        this.assertExpectedHolderOfKeyEnforceExecutor(true, actualProfileRep);
        this.assertExpectedSecureRedirectUriEnforceExecutor(actualProfileRep);
        this.assertExpectedSecureRequestObjectExecutor(actualProfileRep);
        this.assertExpectedSecureResponseTypeExecutor(actualProfileRep);
        this.assertExpectedSecureSessionEnforceExecutor(actualProfileRep);
        this.assertExpectedSecureSigningAlgorithmEnforceExecutor(actualProfileRep);
        this.assertExpectedSecureSigningAlgorithmForSignedJwtEnforceExecutor(actualProfileRep);
    }

    protected void assertExpectedLoadedPolicies(Consumer<ClientPoliciesRepresentation> modifiedAssertion) {
        ClientPoliciesRepresentation actualPoliciesRep = this.getPolicies();
        this.assertExpectedPolicies(Arrays.asList("new-policy", "lack-of-builtin-field-test-policy"), actualPoliciesRep);
        ClientPolicyRepresentation actualPolicyRep = this.getPolicyRepresentation(actualPoliciesRep, "new-policy");
        modifiedAssertion.accept(actualPoliciesRep);
        this.assertExpectedConditions(Arrays.asList("client-access-type", "client-roles", "client-scopes"), actualPolicyRep);
        this.assertExpectedClientAccessTypeCondition(Arrays.asList("public", "bearer-only"), actualPolicyRep);
        this.assertExpectedClientRolesCondition(Arrays.asList(SAMPLE_CLIENT_ROLE), actualPolicyRep);
        this.assertExpectedClientScopesCondition("Optional", Arrays.asList(SAMPLE_CLIENT_ROLE), actualPolicyRep);
        actualPolicyRep = this.getPolicyRepresentation(actualPoliciesRep, "lack-of-builtin-field-test-policy");
        this.assertExpectedPolicy("lack-of-builtin-field-test-policy", "Without builtin field that is treated as builtin=false.", false, Arrays.asList("lack-of-builtin-field-test-profile"), actualPolicyRep);
        this.assertExpectedConditions(Arrays.asList("client-updater-context", "client-updater-source-groups", "client-updater-source-host", "client-updater-source-roles"), actualPolicyRep);
        this.assertExpectedClientUpdateContextCondition(Arrays.asList("ByAuthenticatedUser"), actualPolicyRep);
        this.assertExpectedClientUpdateSourceGroupsCondition(Arrays.asList("topGroup"), actualPolicyRep);
        this.assertExpectedClientUpdateSourceHostsCondition(Arrays.asList("localhost", "127.0.0.1"), actualPolicyRep);
        this.assertExpectedClientUpdateSourceRolesCondition(Arrays.asList(AdminRoles.CREATE_CLIENT), actualPolicyRep);
    }

    protected String generateSuffixedName(String name) {
        return name + "-" + UUID.randomUUID().toString().subSequence(0, 7);
    }

    protected KeyPair setupJwksUrl(String algorithm, ClientRepresentation clientRepresentation, ClientResource clientResource) throws Exception {
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.generateKeys(algorithm);
        Map generatedKeys = oidcClientEndpointsResource.getKeysAsBase64();
        KeyPair keyPair = this.getKeyPairFromGeneratedBase64(generatedKeys, algorithm);
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRepresentation).setUseJwksUrl(true);
        String jwksUrl = TestApplicationResourceUrls.clientJwksUri();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRepresentation).setJwksUrl(jwksUrl);
        clientResource.update(clientRepresentation);
        this.setTimeOffset(20);
        return keyPair;
    }

    protected KeyPair getKeyPairFromGeneratedBase64(Map<String, String> generatedKeys, String algorithm) throws Exception {
        String privateKeyBase64 = generatedKeys.get("privateKey");
        String publicKeyBase64 = generatedKeys.get("publicKey");
        PrivateKey privateKey = this.decodePrivateKey(Base64.decode((String)privateKeyBase64), algorithm);
        PublicKey publicKey = this.decodePublicKey(Base64.decode((String)publicKeyBase64), algorithm);
        return new KeyPair(publicKey, privateKey);
    }

    private PrivateKey decodePrivateKey(byte[] der, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(der);
        String keyAlg = this.getKeyAlgorithmFromJwaAlgorithm(algorithm);
        KeyFactory kf = KeyFactory.getInstance(keyAlg, "BC");
        return kf.generatePrivate(spec);
    }

    private PublicKey decodePublicKey(byte[] der, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(der);
        String keyAlg = this.getKeyAlgorithmFromJwaAlgorithm(algorithm);
        KeyFactory kf = KeyFactory.getInstance(keyAlg, "BC");
        return kf.generatePublic(spec);
    }

    private String getKeyAlgorithmFromJwaAlgorithm(String jwaAlgorithm) {
        String keyAlg = null;
        switch (jwaAlgorithm) {
            case "RS256": 
            case "RS384": 
            case "RS512": 
            case "PS256": 
            case "PS384": 
            case "PS512": {
                keyAlg = "RSA";
                break;
            }
            case "ES256": 
            case "ES384": 
            case "ES512": {
                keyAlg = "EC";
                break;
            }
            default: {
                throw new RuntimeException("Unsupported signature algorithm");
            }
        }
        return keyAlg;
    }

    protected String createSignedRequestToken(String clientId, PrivateKey privateKey, PublicKey publicKey, String algorithm) {
        JsonWebToken jwt = this.createRequestToken(clientId, this.getRealmInfoUrl());
        String kid = KeyUtils.createKeyId((Key)publicKey);
        SignatureSignerContext signer = this.oauth.createSigner(privateKey, kid, algorithm);
        return new JWSBuilder().kid(kid).jsonContent((Object)jwt).sign(signer);
    }

    private String getRealmInfoUrl() {
        String authServerBaseUrl = UriUtils.getOrigin((String)this.oauth.getRedirectUri()) + "/auth";
        return KeycloakUriBuilder.fromUri((String)authServerBaseUrl).path("/realms/{realm-name}").build(new Object[]{REALM_NAME}).toString();
    }

    private JsonWebToken createRequestToken(String clientId, String realmInfoUrl) {
        JsonWebToken reqToken = new JsonWebToken();
        reqToken.id(AdapterUtils.generateId());
        reqToken.issuer(clientId);
        reqToken.subject(clientId);
        reqToken.audience(new String[]{realmInfoUrl});
        int now = Time.currentTime();
        reqToken.iat(Long.valueOf(now));
        reqToken.exp(Long.valueOf(now + 10));
        reqToken.nbf(Long.valueOf(now));
        return reqToken;
    }

    protected OAuthClient.AccessTokenResponse doAccessTokenRequestWithSignedJWT(String code, String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        parameters.add((NameValuePair)new BasicNameValuePair("code", code));
        parameters.add((NameValuePair)new BasicNameValuePair("redirect_uri", this.oauth.getRedirectUri()));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        CloseableHttpResponse response = this.sendRequest(this.oauth.getAccessTokenUrl(), parameters);
        return new OAuthClient.AccessTokenResponse(response);
    }

    protected OAuthClient.AccessTokenResponse doRefreshTokenRequestWithSignedJWT(String refreshToken, String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "refresh_token"));
        parameters.add((NameValuePair)new BasicNameValuePair("refresh_token", refreshToken));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        CloseableHttpResponse response = this.sendRequest(this.oauth.getRefreshTokenUrl(), parameters);
        return new OAuthClient.AccessTokenResponse(response);
    }

    protected HttpResponse doTokenIntrospectionWithSignedJWT(String tokenType, String tokenToIntrospect, String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("token", tokenToIntrospect));
        parameters.add((NameValuePair)new BasicNameValuePair("token_type_hint", tokenType));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        return this.sendRequest(this.oauth.getTokenIntrospectionUrl(), parameters);
    }

    protected HttpResponse doTokenRevokeWithSignedJWT(String tokenType, String tokenToIntrospect, String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("token", tokenToIntrospect));
        parameters.add((NameValuePair)new BasicNameValuePair("token_type_hint", tokenType));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        return this.sendRequest(this.oauth.getTokenRevocationUrl(), parameters);
    }

    protected HttpResponse doLogoutWithSignedJWT(String refreshToken, String signedJwt) throws Exception {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", "refresh_token"));
        parameters.add((NameValuePair)new BasicNameValuePair("refresh_token", refreshToken));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        parameters.add((NameValuePair)new BasicNameValuePair("client_assertion", signedJwt));
        return this.sendRequest(this.oauth.getLogoutUrl().build(), parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpResponse sendRequest(String requestUrl, List<NameValuePair> parameters) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpPost post = new HttpPost(requestUrl);
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            post.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)post);
            return closeableHttpResponse;
        }
        finally {
            this.oauth.closeClient((CloseableHttpClient)client);
        }
    }

    protected TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject createValidRequestObjectForSecureRequestObjectExecutor(String clientId) throws URISyntaxException {
        TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject = new TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject();
        requestObject.id(KeycloakModelUtils.generateId());
        requestObject.iat(Long.valueOf(Time.currentTime()));
        requestObject.exp(Long.valueOf(requestObject.getIat() + Long.valueOf(300L)));
        requestObject.nbf(requestObject.getIat());
        requestObject.setClientId(clientId);
        requestObject.setResponseType("code");
        requestObject.setRedirectUriParam(this.oauth.getRedirectUri());
        requestObject.setScope("openid");
        String state = KeycloakModelUtils.generateId();
        this.oauth.stateParamHardcoded(state);
        requestObject.setState(state);
        requestObject.setMax_age(Integer.valueOf(600));
        requestObject.setOtherClaims("custom_claim_ein", (Object)"rot");
        requestObject.audience(new String[]{Urls.realmIssuer((URI)new URI(this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth"), (String)REALM_NAME), "https://example.com"});
        requestObject.setNonce(KeycloakModelUtils.generateId());
        return requestObject;
    }

    protected void registerRequestObject(TestingOIDCEndpointsApplicationResource.AuthorizationEndpointRequestObject requestObject, String clientId, Algorithm sigAlg, boolean isUseRequestUri) throws URISyntaxException, IOException {
        TestOIDCEndpointsApplicationResource oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        ClientResource clientResource = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm(REALM_NAME), (String)clientId);
        ClientRepresentation clientRep = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setRequestObjectSignatureAlg(sigAlg);
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setUseJwksUrl(true);
        String jwksUrl = TestApplicationResourceUrls.clientJwksUri();
        OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)clientRep).setJwksUrl(jwksUrl);
        clientResource.update(clientRep);
        oidcClientEndpointsResource = this.testingClient.testApp().oidcClientEndpoints();
        oidcClientEndpointsResource.generateKeys(sigAlg.name());
        byte[] contentBytes = JsonSerialization.writeValueAsBytes((Object)requestObject);
        String encodedRequestObject = Base64Url.encode((byte[])contentBytes);
        oidcClientEndpointsResource.registerOIDCRequest(encodedRequestObject, sigAlg.name());
        if (isUseRequestUri) {
            this.oauth.request(null);
            this.oauth.requestUri(TestApplicationResourceUrls.clientRequestUri());
        } else {
            this.oauth.requestUri(null);
            this.oauth.request(oidcClientEndpointsResource.getOIDCRequest());
        }
    }

    protected String generateS256CodeChallenge(String codeVerifier) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(codeVerifier.getBytes("ISO_8859_1"));
        byte[] digestBytes = md.digest();
        String codeChallenge = Base64Url.encode((byte[])digestBytes);
        return codeChallenge;
    }

    protected void doIntrospectAccessToken(OAuthClient.AccessTokenResponse tokenRes, String username, String clientId, String clientSecret) throws IOException {
        String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential(clientId, clientSecret, tokenRes.getAccessToken());
        JsonNode jsonNode = objectMapper.readTree(tokenResponse);
        org.junit.Assert.assertEquals((Object)true, (Object)jsonNode.get("active").asBoolean());
        org.junit.Assert.assertEquals((Object)username, (Object)jsonNode.get("username").asText());
        org.junit.Assert.assertEquals((Object)clientId, (Object)jsonNode.get("client_id").asText());
        TokenMetadataRepresentation rep = (TokenMetadataRepresentation)objectMapper.readValue(tokenResponse, TokenMetadataRepresentation.class);
        org.junit.Assert.assertEquals((Object)true, (Object)rep.isActive());
        org.junit.Assert.assertEquals((Object)clientId, (Object)rep.getClientId());
        org.junit.Assert.assertEquals((Object)clientId, (Object)rep.getIssuedFor());
        this.events.expect(EventType.INTROSPECT_TOKEN).client(clientId).user((String)null).clearDetails().assertEvent();
    }

    protected void doTokenRevoke(String refreshToken, String clientId, String clientSecret, String userId, boolean isOfflineAccess) throws IOException {
        this.oauth.clientId(clientId);
        this.oauth.doTokenRevoke(refreshToken, "refresh_token", clientSecret);
        OAuthClient.AccessTokenResponse tokenRes = this.oauth.doRefreshTokenRequest(refreshToken, clientSecret);
        org.junit.Assert.assertEquals((long)400L, (long)tokenRes.getStatusCode());
        org.junit.Assert.assertEquals((Object)"invalid_grant", (Object)tokenRes.getError());
        if (isOfflineAccess) {
            org.junit.Assert.assertEquals((Object)"Offline user session not found", (Object)tokenRes.getErrorDescription());
        } else {
            org.junit.Assert.assertEquals((Object)"Session not active", (Object)tokenRes.getErrorDescription());
        }
        this.events.expect(EventType.REVOKE_GRANT).clearDetails().client(clientId).user(userId).assertEvent();
    }

    protected String createClientByAdmin(String clientName, Consumer<ClientRepresentation> op) throws ClientPolicyException {
        ClientRepresentation clientRep = new ClientRepresentation();
        clientRep.setClientId(clientName);
        clientRep.setName(clientName);
        clientRep.setProtocol("openid-connect");
        clientRep.setBearerOnly(Boolean.FALSE);
        clientRep.setPublicClient(Boolean.FALSE);
        clientRep.setServiceAccountsEnabled(Boolean.TRUE);
        clientRep.setRedirectUris(Collections.singletonList(ServerURLs.getAuthServerContextRoot() + "/auth/realms/master/app/auth"));
        op.accept(clientRep);
        Response resp = this.adminClient.realm(REALM_NAME).clients().create(clientRep);
        if (resp.getStatus() == Response.Status.BAD_REQUEST.getStatusCode()) {
            String respBody = (String)resp.readEntity(String.class);
            Map responseJson = null;
            try {
                responseJson = (Map)JsonSerialization.readValue((String)respBody, Map.class);
            }
            catch (IOException e) {
                org.junit.Assert.fail();
            }
            throw new ClientPolicyException((String)responseJson.get("error"), (String)responseJson.get("error_description"));
        }
        resp.close();
        org.junit.Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)resp.getStatus());
        String cId = ApiUtil.getCreatedId((Response)resp);
        this.testContext.getOrCreateCleanup(REALM_NAME).addClientUuid(cId);
        return cId;
    }

    protected ClientRepresentation getClientByAdmin(String cId) throws ClientPolicyException {
        ClientResource clientResource = this.adminClient.realm(REALM_NAME).clients().get(cId);
        try {
            return clientResource.toRepresentation();
        }
        catch (BadRequestException bre) {
            this.processClientPolicyExceptionByAdmin(bre);
            return null;
        }
    }

    protected ClientRepresentation getClientByAdminWithName(String clientName) {
        return (ClientRepresentation)this.adminClient.realm(REALM_NAME).clients().findByClientId(clientName).get(0);
    }

    protected void updateClientByAdmin(String cId, Consumer<ClientRepresentation> op) throws ClientPolicyException {
        ClientResource clientResource = this.adminClient.realm(REALM_NAME).clients().get(cId);
        ClientRepresentation clientRep = clientResource.toRepresentation();
        op.accept(clientRep);
        try {
            clientResource.update(clientRep);
        }
        catch (BadRequestException bre) {
            this.processClientPolicyExceptionByAdmin(bre);
        }
    }

    protected void deleteClientByAdmin(String cId) throws ClientPolicyException {
        ClientResource clientResource = this.adminClient.realm(REALM_NAME).clients().get(cId);
        try {
            clientResource.remove();
        }
        catch (BadRequestException bre) {
            this.processClientPolicyExceptionByAdmin(bre);
        }
    }

    private void processClientPolicyExceptionByAdmin(BadRequestException bre) throws ClientPolicyException {
        Response resp = bre.getResponse();
        if (resp.getStatus() != Response.Status.BAD_REQUEST.getStatusCode()) {
            resp.close();
            return;
        }
        String respBody = (String)resp.readEntity(String.class);
        Map responseJson = null;
        try {
            responseJson = (Map)JsonSerialization.readValue((String)respBody, Map.class);
        }
        catch (IOException e) {
            org.junit.Assert.fail();
        }
        throw new ClientPolicyException((String)responseJson.get("error"), (String)responseJson.get("error_description"));
    }

    protected void restartAuthenticatedClientRegistrationSetting() throws ClientRegistrationException {
        this.reg.close();
        this.reg = ClientRegistration.create().url(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth", REALM_NAME).build();
        ClientInitialAccessPresentation token = this.adminClient.realm(REALM_NAME).clientInitialAccess().create(new ClientInitialAccessCreatePresentation(Integer.valueOf(0), Integer.valueOf(10)));
        this.reg.auth(Auth.token((ClientInitialAccessPresentation)token));
    }

    protected void authCreateClients() {
        this.reg.auth(Auth.token((String)this.getToken("create-clients", TEST_CLIENT_SECRET)));
    }

    protected void authManageClients() {
        this.reg.auth(Auth.token((String)this.getToken("manage-clients", TEST_CLIENT_SECRET)));
    }

    protected void authNoAccess() {
        this.reg.auth(Auth.token((String)this.getToken("no-access", TEST_CLIENT_SECRET)));
    }

    private String getToken(String username, String password) {
        try {
            return this.oauth.doGrantAccessTokenRequest(REALM_NAME, username, password, null, "admin-cli", null).getAccessToken();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String createClientDynamically(String clientName, Consumer<OIDCClientRepresentation> op) throws ClientRegistrationException {
        OIDCClientRepresentation clientRep = new OIDCClientRepresentation();
        clientRep.setClientName(clientName);
        clientRep.setClientUri(ServerURLs.getAuthServerContextRoot());
        clientRep.setRedirectUris(Collections.singletonList(ServerURLs.getAuthServerContextRoot() + "/auth/realms/master/app/auth"));
        op.accept(clientRep);
        OIDCClientRepresentation response = this.reg.oidc().create(clientRep);
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
        String clientId = response.getClientId();
        this.testContext.getOrCreateCleanup(REALM_NAME).addClientUuid(clientId);
        return clientId;
    }

    protected OIDCClientRepresentation getClientDynamically(String clientId) throws ClientRegistrationException {
        return this.reg.oidc().get(clientId);
    }

    protected void updateClientDynamically(String clientId, Consumer<OIDCClientRepresentation> op) throws ClientRegistrationException {
        OIDCClientRepresentation clientRep = this.reg.oidc().get(clientId);
        op.accept(clientRep);
        OIDCClientRepresentation response = this.reg.oidc().update(clientRep);
        this.reg.auth(Auth.token((OIDCClientRepresentation)response));
    }

    protected void deleteClientDynamically(String clientId) throws ClientRegistrationException {
        this.reg.oidc().delete(clientId);
    }

    protected String convertToProfilesJson(ClientProfilesRepresentation reps) {
        String json = null;
        try {
            json = objectMapper.writeValueAsString((Object)reps);
        }
        catch (JsonProcessingException e) {
            org.junit.Assert.fail();
        }
        return json;
    }

    protected void updateProfiles(String json) throws ClientPolicyException {
        try {
            ClientProfilesRepresentation clientProfiles = (ClientProfilesRepresentation)JsonSerialization.readValue((String)json, ClientProfilesRepresentation.class);
            this.adminClient.realm(REALM_NAME).clientPoliciesProfilesResource().updateProfiles(clientProfiles);
        }
        catch (BadRequestException e) {
            throw new ClientPolicyException("update profiles failed", e.getResponse().getStatusInfo().toString());
        }
        catch (Exception e) {
            throw new ClientPolicyException("update profiles failed", e.getMessage());
        }
    }

    protected void updateProfiles(ClientProfilesRepresentation reps) throws ClientPolicyException {
        this.updateProfiles(this.convertToProfilesJson(reps));
    }

    protected void revertToBuiltinProfiles() throws ClientPolicyException {
        this.updateProfiles("{}");
    }

    protected ClientProfilesRepresentation getProfilesWithGlobals() {
        return this.adminClient.realm(REALM_NAME).clientPoliciesProfilesResource().getProfiles(Boolean.valueOf(true));
    }

    protected ClientProfilesRepresentation getProfilesWithoutGlobals() {
        return this.adminClient.realm(REALM_NAME).clientPoliciesProfilesResource().getProfiles(Boolean.valueOf(false));
    }

    protected String convertToProfileJson(ClientProfileRepresentation rep) {
        String json = null;
        try {
            json = objectMapper.writeValueAsString((Object)rep);
        }
        catch (JsonProcessingException e) {
            org.junit.Assert.fail();
        }
        return json;
    }

    protected ClientProfileRepresentation convertToProfile(String json) {
        ClientProfileRepresentation rep = null;
        try {
            rep = (ClientProfileRepresentation)JsonSerialization.readValue((String)json, ClientProfileRepresentation.class);
        }
        catch (IOException e) {
            org.junit.Assert.fail();
        }
        return rep;
    }

    protected ClientProfileRepresentation getProfile(String name) {
        if (name == null) {
            return null;
        }
        ClientProfilesRepresentation reps = this.getProfilesWithGlobals();
        if (reps == null || reps.getProfiles() == null) {
            return null;
        }
        if (reps.getProfiles().stream().anyMatch(i -> name.equals(i.getName()))) {
            return (ClientProfileRepresentation)reps.getProfiles().stream().filter(i -> name.equals(i.getName())).collect(Collectors.toList()).get(0);
        }
        return null;
    }

    protected String getProfileJson(String name) {
        return this.convertToProfileJson(this.getProfile(name));
    }

    protected void addProfile(ClientProfileRepresentation profileRep) throws ClientPolicyException {
        ClientProfilesRepresentation reps = this.getProfilesWithoutGlobals();
        if (reps == null || reps.getProfiles() == null) {
            return;
        }
        reps.getProfiles().add(profileRep);
        this.updateProfiles(this.convertToProfilesJson(reps));
    }

    protected void updateProfile(ClientProfileRepresentation profileRep) throws ClientPolicyException {
        if (profileRep == null || profileRep.getName() == null) {
            return;
        }
        String profileName = profileRep.getName();
        ClientProfilesRepresentation reps = this.getProfilesWithoutGlobals();
        if (!reps.getProfiles().stream().anyMatch(i -> profileName.equals(i.getName()))) {
            return;
        }
        ClientProfileRepresentation rep = (ClientProfileRepresentation)reps.getProfiles().stream().filter(i -> profileName.equals(i.getName())).collect(Collectors.toList()).get(0);
        reps.getProfiles().remove(rep);
        reps.getProfiles().add(profileRep);
        this.updateProfiles(this.convertToProfilesJson(reps));
    }

    protected void deleteProfile(String profileName) throws ClientPolicyException {
        if (profileName == null) {
            return;
        }
        ClientProfilesRepresentation reps = this.getProfilesWithoutGlobals();
        if (!reps.getProfiles().stream().anyMatch(i -> profileName.equals(i.getName()))) {
            return;
        }
        ClientProfileRepresentation rep = (ClientProfileRepresentation)reps.getProfiles().stream().filter(i -> profileName.equals(i.getName())).collect(Collectors.toList()).get(0);
        reps.getProfiles().remove(rep);
        this.updateProfiles(this.convertToProfilesJson(reps));
    }

    protected String convertToPoliciesJson(ClientPoliciesRepresentation reps) {
        String json = null;
        try {
            json = objectMapper.writeValueAsString((Object)reps);
        }
        catch (JsonProcessingException e) {
            org.junit.Assert.fail();
        }
        return json;
    }

    protected void updatePolicies(String json) throws ClientPolicyException {
        try {
            ClientPoliciesRepresentation clientPolicies = json == null ? null : (ClientPoliciesRepresentation)JsonSerialization.readValue((String)json, ClientPoliciesRepresentation.class);
            this.adminClient.realm(REALM_NAME).clientPoliciesPoliciesResource().updatePolicies(clientPolicies);
        }
        catch (BadRequestException e) {
            throw new ClientPolicyException("update policies failed", e.getResponse().getStatusInfo().toString());
        }
        catch (IOException e) {
            throw new ClientPolicyException("update policies failed", e.getMessage());
        }
    }

    protected void revertToBuiltinPolicies() throws ClientPolicyException {
        this.updatePolicies("{}");
    }

    protected ClientPoliciesRepresentation getPolicies() {
        return this.adminClient.realm(REALM_NAME).clientPoliciesPoliciesResource().getPolicies();
    }

    protected String convertToPolicyJson(ClientPolicyRepresentation rep) {
        String json = null;
        try {
            json = objectMapper.writeValueAsString((Object)rep);
        }
        catch (JsonProcessingException e) {
            org.junit.Assert.fail();
        }
        return json;
    }

    protected ClientPolicyRepresentation convertToPolicy(String json) {
        ClientPolicyRepresentation rep = null;
        try {
            rep = (ClientPolicyRepresentation)JsonSerialization.readValue((String)json, ClientPolicyRepresentation.class);
        }
        catch (IOException e) {
            org.junit.Assert.fail();
        }
        return rep;
    }

    protected ClientPolicyRepresentation getPolicy(String name) {
        if (name == null) {
            return null;
        }
        ClientPoliciesRepresentation reps = this.getPolicies();
        if (reps == null || reps.getPolicies() == null) {
            return null;
        }
        if (reps.getPolicies().stream().anyMatch(i -> name.equals(i.getName()))) {
            return (ClientPolicyRepresentation)reps.getPolicies().stream().filter(i -> name.equals(i.getName())).collect(Collectors.toList()).get(0);
        }
        return null;
    }

    protected String getPolicyJson(String name) {
        return this.convertToPolicyJson(this.getPolicy(name));
    }

    protected void addPolicy(ClientPolicyRepresentation policyRep) throws ClientPolicyException {
        ClientPoliciesRepresentation reps = this.getPolicies();
        if (reps == null || reps.getPolicies() == null) {
            return;
        }
        reps.getPolicies().add(policyRep);
        this.updatePolicies(this.convertToPoliciesJson(reps));
    }

    protected void updatePolicy(ClientPolicyRepresentation policyRep) throws ClientPolicyException {
        if (policyRep == null || policyRep.getName() == null) {
            return;
        }
        String policyName = policyRep.getName();
        ClientPoliciesRepresentation reps = this.getPolicies();
        if (!reps.getPolicies().stream().anyMatch(i -> policyName.equals(i.getName()))) {
            return;
        }
        ClientPolicyRepresentation rep = (ClientPolicyRepresentation)reps.getPolicies().stream().filter(i -> policyName.equals(i.getName())).collect(Collectors.toList()).get(0);
        reps.getPolicies().remove(rep);
        reps.getPolicies().add(policyRep);
        this.updatePolicies(this.convertToPoliciesJson(reps));
    }

    protected void deletePolicy(String policyName) throws ClientPolicyException {
        if (policyName == null) {
            return;
        }
        ClientPoliciesRepresentation reps = this.getPolicies();
        if (!reps.getPolicies().stream().anyMatch(i -> policyName.equals(i.getName()))) {
            return;
        }
        ClientPolicyRepresentation rep = (ClientPolicyRepresentation)reps.getPolicies().stream().filter(i -> policyName.equals(i.getName())).collect(Collectors.toList()).get(0);
        reps.getPolicies().remove(rep);
        this.updatePolicies(this.convertToPoliciesJson(reps));
    }

    protected ClientProfilesRepresentation getProfilesRepresentation(String json) {
        return this.getCompoundsRepresentation(json, ClientProfilesRepresentation.class);
    }

    protected ClientProfileRepresentation getProfileRepresentation(ClientProfilesRepresentation profilesRep, String name, boolean global) {
        Function<ClientProfilesRepresentation, List> profilesListGetter = global ? ClientProfilesRepresentation::getGlobalProfiles : ClientProfilesRepresentation::getProfiles;
        return this.getCompoundRepresentation(profilesRep, name, profilesListGetter, i -> i.getName());
    }

    protected void assertExpectedProfiles(ClientProfilesRepresentation profilesRep, List<String> expectedGlobalProfiles, List<String> expectedRealmProfiles) {
        this.assertExpectedCompounds(expectedGlobalProfiles, profilesRep, i -> i.getGlobalProfiles(), i -> i.getName());
        this.assertExpectedCompounds(expectedRealmProfiles, profilesRep, i -> i.getProfiles(), i -> i.getName());
    }

    protected void assertExpectedProfile(ClientProfileRepresentation actualProfileRep, String name, String description) {
        org.junit.Assert.assertNotNull((Object)actualProfileRep);
        org.junit.Assert.assertEquals((Object)description, (Object)actualProfileRep.getDescription());
    }

    protected void assertExpectedExecutors(List<String> expectedExecutors, ClientProfileRepresentation profileRep) {
        List actualExecutorNames = profileRep.getExecutors().stream().map(ClientPolicyExecutorRepresentation::getExecutorProviderId).collect(Collectors.toList());
        MatcherAssert.assertThat(actualExecutorNames, (Matcher)Matchers.containsInAnyOrder((Object[])expectedExecutors.toArray()));
    }

    protected void assertExpectedHolderOfKeyEnforceExecutor(boolean autoConfigure, ClientProfileRepresentation profileRep) {
        this.assertExpectedAutoConfiguredExecutor(autoConfigure, "holder-of-key-enforcer", profileRep);
    }

    protected void assertExpectedPKCEEnforceExecutor(boolean autoConfigure, ClientProfileRepresentation profileRep) {
        this.assertExpectedAutoConfiguredExecutor(autoConfigure, "pkce-enforcer", profileRep);
    }

    protected void assertExpectedSecureClientAuthEnforceExecutor(List<String> expectedAllowedClientAuthenticators, String expectedAutoConfiguredClientAuthenticator, ClientProfileRepresentation profileRep) throws Exception {
        org.junit.Assert.assertNotNull((Object)profileRep);
        JsonNode actualExecutorConfig = this.getConfigOfExecutor("secure-client-authenticator", profileRep);
        org.junit.Assert.assertNotNull((Object)actualExecutorConfig);
        HashSet actualClientAuthns = new HashSet((Collection)JsonSerialization.readValue((String)actualExecutorConfig.get("allowed-client-authenticators").toString(), List.class));
        org.junit.Assert.assertEquals(new HashSet<String>(expectedAllowedClientAuthenticators), actualClientAuthns);
        String actualAutoConfiguredClientAuthenticator = actualExecutorConfig.get("default-client-authenticator").textValue();
        org.junit.Assert.assertEquals((Object)expectedAutoConfiguredClientAuthenticator, (Object)actualAutoConfiguredClientAuthenticator);
    }

    protected void assertExpectedSecureRedirectUriEnforceExecutor(ClientProfileRepresentation profileRep) {
        this.assertExpectedEmptyConfig("secure-client-uris", profileRep);
    }

    protected void assertExpectedSecureRequestObjectExecutor(ClientProfileRepresentation profileRep) {
        this.assertExpectedEmptyConfig("secure-request-object", profileRep);
    }

    protected void assertExpectedSecureResponseTypeExecutor(ClientProfileRepresentation profileRep) {
        this.assertExpectedEmptyConfig("secure-response-type", profileRep);
    }

    protected void assertExpectedSecureSessionEnforceExecutor(ClientProfileRepresentation profileRep) {
        this.assertExpectedEmptyConfig("secure-session", profileRep);
    }

    protected void assertExpectedSecureSigningAlgorithmEnforceExecutor(ClientProfileRepresentation profileRep) {
        this.assertExpectedEmptyConfig("secure-signature-algorithm", profileRep);
    }

    protected void assertExpectedSecureSigningAlgorithmForSignedJwtEnforceExecutor(ClientProfileRepresentation profileRep) {
        this.assertExpectedEmptyConfig("secure-signature-algorithm-signed-jwt", profileRep);
    }

    protected void assertExpectedAutoConfiguredExecutor(boolean expectedAutoConfigure, String providerId, ClientProfileRepresentation profileRep) {
        org.junit.Assert.assertNotNull((Object)profileRep);
        JsonNode actualExecutorConfig = this.getConfigOfExecutor(providerId, profileRep);
        org.junit.Assert.assertNotNull((Object)actualExecutorConfig);
        boolean actualAutoConfigure = actualExecutorConfig.get("auto-configure") == null ? false : actualExecutorConfig.get("auto-configure").asBoolean();
        org.junit.Assert.assertEquals((Object)expectedAutoConfigure, (Object)actualAutoConfigure);
    }

    private JsonNode getConfigOfExecutor(String providerId, ClientProfileRepresentation profileRep) {
        ClientPolicyExecutorRepresentation executorRep = profileRep.getExecutors().stream().filter(profileRepp -> providerId.equals(profileRepp.getExecutorProviderId())).findFirst().orElse(null);
        return executorRep == null ? null : executorRep.getConfiguration();
    }

    protected ClientPoliciesRepresentation getPoliciesRepresentation(String json) {
        return this.getCompoundsRepresentation(json, ClientPoliciesRepresentation.class);
    }

    protected ClientPolicyRepresentation getPolicyRepresentation(ClientPoliciesRepresentation policiesRep, String name) {
        return this.getCompoundRepresentation(policiesRep, name, i -> i.getPolicies(), i -> i.getName());
    }

    protected void assertExpectedPolicies(List<String> expectedPolicies, ClientPoliciesRepresentation policiesRep) {
        org.junit.Assert.assertNotNull((Object)policiesRep);
        List reps = policiesRep.getPolicies();
        if (reps == null) {
            org.junit.Assert.assertNull(expectedPolicies);
            return;
        }
        Set actualPolicies = reps.stream().map(i -> i.getName()).collect(Collectors.toSet());
        org.junit.Assert.assertEquals(new HashSet<String>(expectedPolicies), actualPolicies);
    }

    protected void assertExpectedPolicy(String name, String description, boolean isEnabled, List<String> profiles, ClientPolicyRepresentation actualPolicyRep) {
        org.junit.Assert.assertNotNull((Object)actualPolicyRep);
        org.junit.Assert.assertEquals((Object)description, (Object)actualPolicyRep.getDescription());
        org.junit.Assert.assertEquals((Object)isEnabled, (Object)actualPolicyRep.isEnabled());
        org.junit.Assert.assertEquals(new HashSet<String>(profiles), new HashSet(actualPolicyRep.getProfiles()));
    }

    protected void assertExpectedConditions(List<String> expectedConditions, ClientPolicyRepresentation policyRep) {
        List actualConditionNames = policyRep.getConditions().stream().map(ClientPolicyConditionRepresentation::getConditionProviderId).collect(Collectors.toList());
        MatcherAssert.assertThat(actualConditionNames, (Matcher)Matchers.containsInAnyOrder((Object[])expectedConditions.toArray()));
    }

    protected void assertExpectedAnyClientCondition(ClientPolicyRepresentation policyRep) {
        ClientPolicyConditionConfigurationRepresentation config = this.getConfigAsExpectedType(policyRep, "any-client", ClientPolicyConditionConfigurationRepresentation.class);
        Assert.assertTrue((String)"Expected empty configuration for provider any-client", (boolean)config.getConfigAsMap().isEmpty());
    }

    protected void assertExpectedClientAccessTypeCondition(List<String> type, ClientPolicyRepresentation policyRep) {
        ClientAccessTypeCondition.Configuration cfg = this.getConfigAsExpectedType(policyRep, "client-access-type", ClientAccessTypeCondition.Configuration.class);
        Assert.assertEquals((Object)cfg.getType(), type);
    }

    protected void assertExpectedClientRolesCondition(List<String> roles, ClientPolicyRepresentation policyRep) {
        ClientRolesCondition.Configuration cfg = this.getConfigAsExpectedType(policyRep, "client-roles", ClientRolesCondition.Configuration.class);
        Assert.assertEquals((Object)cfg.getRoles(), roles);
    }

    protected void assertExpectedClientScopesCondition(String type, List<String> scopes, ClientPolicyRepresentation policyRep) {
        ClientScopesCondition.Configuration cfg = this.getConfigAsExpectedType(policyRep, "client-scopes", ClientScopesCondition.Configuration.class);
        Assert.assertEquals((Object)cfg.getType(), (Object)type);
        Assert.assertEquals((Object)cfg.getScope(), scopes);
    }

    protected void assertExpectedClientUpdateContextCondition(List<String> updateClientSources, ClientPolicyRepresentation policyRep) {
        ClientUpdaterContextCondition.Configuration cfg = this.getConfigAsExpectedType(policyRep, "client-updater-context", ClientUpdaterContextCondition.Configuration.class);
        Assert.assertEquals((Object)cfg.getUpdateClientSource(), updateClientSources);
    }

    protected void assertExpectedClientUpdateSourceGroupsCondition(List<String> groups, ClientPolicyRepresentation policyRep) {
        ClientUpdaterSourceGroupsCondition.Configuration cfg = this.getConfigAsExpectedType(policyRep, "client-updater-source-groups", ClientUpdaterSourceGroupsCondition.Configuration.class);
        Assert.assertEquals((Object)cfg.getGroups(), groups);
    }

    protected void assertExpectedClientUpdateSourceHostsCondition(List<String> trustedHosts, ClientPolicyRepresentation policyRep) {
        ClientUpdaterSourceHostsCondition.Configuration cfg = this.getConfigAsExpectedType(policyRep, "client-updater-source-host", ClientUpdaterSourceHostsCondition.Configuration.class);
        Assert.assertEquals((Object)cfg.getTrustedHosts(), trustedHosts);
    }

    protected void assertExpectedClientUpdateSourceRolesCondition(List<String> roles, ClientPolicyRepresentation policyRep) {
        ClientUpdaterSourceRolesCondition.Configuration cfg = this.getConfigAsExpectedType(policyRep, "client-updater-source-roles", ClientUpdaterSourceRolesCondition.Configuration.class);
        Assert.assertEquals((Object)cfg.getRoles(), roles);
    }

    private <CFG extends ClientPolicyConditionConfigurationRepresentation> CFG getConfigAsExpectedType(ClientPolicyRepresentation policyRep, String conditionProviderId, Class<CFG> configClass) {
        ClientPolicyConditionRepresentation conditionRep = policyRep.getConditions().stream().filter(condition -> conditionProviderId.equals(condition.getConditionProviderId())).findFirst().orElseThrow(() -> new AssertionError((Object)("Expected to contain configuration for condition " + conditionProviderId)));
        return (CFG)((ClientPolicyConditionConfigurationRepresentation)JsonSerialization.mapper.convertValue((Object)conditionRep.getConfiguration(), configClass));
    }

    private <T> T getCompoundsRepresentation(String json, Class<T> clazz) {
        Object rep = null;
        try {
            rep = JsonSerialization.readValue((String)json, clazz);
        }
        catch (IOException ioe) {
            org.junit.Assert.fail();
        }
        return (T)rep;
    }

    private <T, R> void assertExpectedCompounds(List<String> expected, R rep, Function<R, List<T>> f, Function<T, String> g) {
        org.junit.Assert.assertNotNull(rep);
        List<T> reps = f.apply(rep);
        if (reps == null) {
            org.junit.Assert.assertNull(expected);
            return;
        }
        Set actual = reps.stream().map(i -> (String)g.apply(i)).collect(Collectors.toSet());
        org.junit.Assert.assertEquals(new HashSet<String>(expected), actual);
    }

    private <T, R> T getCompoundRepresentation(R rep, String name, Function<R, List<T>> f, Function<T, String> g) {
        org.junit.Assert.assertNotNull(rep);
        if (f.apply(rep) == null) {
            return null;
        }
        List reps = f.apply(rep).stream().filter(i -> ((String)g.apply(i)).equals(name)).collect(Collectors.toList());
        if (reps == null) {
            return null;
        }
        if (reps.size() != 1) {
            return null;
        }
        return reps.get(0);
    }

    private void assertExpectedEmptyConfig(String executorProviderId, ClientProfileRepresentation profileRep) {
        JsonNode config = this.getConfigOfExecutor(executorProviderId, profileRep);
        Assert.assertTrue((String)("Expected empty configuration for provider " + executorProviderId), (boolean)config.isEmpty());
    }
}

