/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.registration;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.config.ConfigHandler;
import org.keycloak.client.registration.cli.config.FileConfigHandler;
import org.keycloak.client.registration.cli.config.RealmConfigData;
import org.keycloak.client.registration.cli.util.ConfigUtil;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.cli.KcRegExec;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.cli.registration.AbstractRegCliTest;
import org.keycloak.testsuite.util.TempFileResource;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class KcRegUpdateTokenTest
extends AbstractRegCliTest {
    @Test
    public void testUpdateToken() throws IOException {
        FileConfigHandler handler = this.initCustomConfigFile();
        ConfigUtil.setHandler((ConfigHandler)handler);
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            KcRegExec exe = KcRegExec.execute((String)("config credentials --config '" + configFile.getName() + "' --server " + this.serverUrl + " --realm master --user admin --password admin"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            ConfigData data = ConfigUtil.loadConfig();
            RealmConfigData rdata = data.getRealmConfigData(this.serverUrl, "test");
            Assert.assertNull((String)"realm info set", (Object)rdata);
            exe = KcRegExec.execute((String)("update-token --config '" + configFile.getName() + "' reg-cli-secret-direct  --server " + this.serverUrl + " --realm test --user user1 --password userpass"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            data = ConfigUtil.loadConfig();
            rdata = data.getRealmConfigData(this.serverUrl, "test");
            Assert.assertEquals((String)"current session realm unchanged", (Object)"master", (Object)data.getRealm());
            Assert.assertNotNull((String)"realm info set", (Object)rdata);
            Assert.assertNull((String)"on the fly login was transient", (Object)rdata.getToken());
            Assert.assertNotNull((String)"client info has registration access token", rdata.getClients().get("reg-cli-secret-direct"));
            exe = KcRegExec.execute((String)("update-token reg-cli-secret-direct --no-config --server " + this.serverUrl + " --realm test --user user1 --password userpass"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 1);
            String token = (String)exe.stdoutLines().get(0);
            exe = KcRegExec.execute((String)("get reg-cli-secret-direct --no-config --server " + this.serverUrl + " --realm test -t " + token));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            ClientRepresentation client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertEquals((String)"client representation returned", (Object)"reg-cli-secret-direct", (Object)client.getClientId());
        }
    }
}

