/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.registration;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.client.registration.cli.config.FileConfigHandler;
import org.keycloak.client.registration.cli.util.OsUtil;
import org.keycloak.testsuite.cli.KcRegExec;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.cli.registration.AbstractRegCliTest;
import org.keycloak.testsuite.util.TempFileResource;

public class KcRegConfigTest
extends AbstractRegCliTest {
    @Test
    public void testRegistrationToken() throws IOException {
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            KcRegExec exe = KcRegExec.execute((String)("config registration-token --config '" + configFile.getName() + "' "));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
            Assert.assertEquals((String)"error message", (Object)"Required option not specified: --server", exe.stderrLines().get(0));
            Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config registration-token' for more information"), exe.stderrLines().get(1));
            exe = KcRegExec.execute((String)("config registration-token --config '" + configFile.getName() + "' --server http://localhost:8080/auth"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
            Assert.assertEquals((String)"error message", (Object)"Required option not specified: --realm", exe.stderrLines().get(0));
            Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config registration-token' for more information"), exe.stderrLines().get(1));
            exe = KcRegExec.execute((String)("config registration-token --config '" + configFile.getName() + "' --server http://localhost:8080/auth --realm test"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
            Assert.assertEquals((String)"error message", (Object)"Required option not specified: --client", exe.stderrLines().get(0));
            Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config registration-token' for more information"), exe.stderrLines().get(1));
            exe = KcRegExec.execute((String)("config registration-token --config '" + configFile.getName() + "' --server http://localhost:8080/auth --realm test --client my_client NEWTOKEN"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            if (KcRegConfigTest.runIntermittentlyFailingTests()) {
                exe = (KcRegExec)KcRegExec.newBuilder().argsLine("config registration-token --config '" + configFile.getName() + "' --server http://localhost:8080/auth --realm test --client my_client").executeAsync();
                exe.waitForStdout("Enter Registration Access Token:");
                exe.sendToStdin("NEWTOKEN" + OsUtil.EOL);
                exe.waitCompletion();
                this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 0);
            } else {
                System.out.println("TEST SKIPPED PARTIALLY - This test currently suffers from intermittent failures. Use -Dtest.intermittent=true to run it in full.");
            }
            exe = KcRegExec.execute((String)("config registration-token --config '" + configFile.getName() + "' --server http://localhost:8080/auth --realm test --client nonexistent --delete"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
            exe = KcRegExec.execute((String)("config registration-token --config '" + configFile.getName() + "' --server http://localhost:8080/auth --realm test --client my_client --delete"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 0);
        }
    }

    @Test
    public void testNoConfigOption() throws IOException {
        KcRegExec exe = KcRegExec.execute((String)"config registration-token --no-config --server http://localhost:8080/auth --realm test --client my_client --delete");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Unsupported option: --no-config", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config registration-token' for more information"), exe.stderrLines().get(1));
        exe = KcRegExec.execute((String)"config initial-token --no-config --server http://localhost:8080/auth --realm test --delete");
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"stderr first line", (Object)"Unsupported option: --no-config", exe.stderrLines().get(0));
        Assert.assertEquals((String)"try help", (Object)("Try '" + OsUtil.CMD + " help config initial-token' for more information"), exe.stderrLines().get(1));
    }
}

