/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.registration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.keycloak.admin.client.resource.ClientInitialAccessResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.config.FileConfigHandler;
import org.keycloak.client.registration.cli.config.RealmConfigData;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyManager;
import org.keycloak.services.clientregistration.policy.RegistrationAuth;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.cli.AbstractCliTest;
import org.keycloak.testsuite.cli.KcRegExec;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;

public abstract class AbstractRegCliTest
extends AbstractCliTest {
    @Before
    public void deleteDefaultConfig() {
        AbstractRegCliTest.getDefaultConfigFilePath().delete();
    }

    static boolean runIntermittentlyFailingTests() {
        return "true".equals(System.getProperty("test.intermittent"));
    }

    static File getDefaultConfigFilePath() {
        return new File(System.getProperty("user.home") + "/.keycloak/kcreg.config");
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realmRepresentation);
        UserRepresentation admin = UserBuilder.create().username("user1").password("userpass").enabled(true).build();
        HashMap<String, List<String>> clientRoles = new HashMap<String, List<String>>();
        clientRoles.put("realm-management", Arrays.asList("manage-clients"));
        admin.setClientRoles(clientRoles);
        realmRepresentation.getUsers().add(admin);
        ClientRepresentation regClient = ClientBuilder.create().clientId("reg-cli-jwt").attribute("jwt.credential.certificate", "MIICnTCCAYUCBgFXUhpRTTANBgkqhkiG9w0BAQsFADASMRAwDgYDVQQDDAdyZWctY2xpMB4XDTE2MDkyMjEzMzIxOFoXDTI2MDkyMjEzMzM1OFowEjEQMA4GA1UEAwwHcmVnLWNsaTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMHZn/0Bk1M9oKcTHxzn2cGvBWwO1m6OVLQ8LSVwNIf4ixfGkVIkhI5iEGYND+uD8ame54ZPClTVxMra3JldClLIG+L+ymnbT2vKIhEsVvCROs9PnYxbFALt1dXneLIio2uzF+d7/zQWlmeaWfNunSJT1aHNJDkGgDeUuQa25b0IMqsFjsN8Dg4ATkA97r3wKn4Tp3SE7sTM/B2pmra4atNxGeShVrgihqUiQ/PwDiDGwry64AsexkZnQsCR3bJWBAVUiHef3JWzTfWWN5bfCBG6Mnq1xw7YN+YpV1nR3CGmcKJuLe6aTe7Ps8hYejYiQA7Mp7ZQsoImsVFV5HDOlb0CAwEAATANBgkqhkiG9w0BAQsFAAOCAQEAZl8XvLfKXTPYvq/QyHOg7EDlAdlV3HkmHP9SBAV4BccmHmorMkm5I6I21UA5mfju+0nhbEd0bm0kvJFxIfNU6lJyyVvQx3Gns37KYUOzIV/ocWZuOTBLp5tfIBYbBwfE/s1J4PhpA/3WhBY9JKiLvdJfxECGIgaLs2M0UsylW/7o04+18Od8j/m7crQc7fpe5gJB5m/+hxUDowIjG5CumffX9OHYGDvHBpaUl7QNSGgjP8Bn9ogmIMUBJ7XSYUcohKuk2Cnj6p+GlLuqHbOISUXLVjf0DxhCu6diVxvacKbgAZmyCIO1tGL/UVRxg9GOYdCiC9vHfPuZ8US+ZB0P9g==").authenticatorType("client-jwt").serviceAccount().build();
        realmRepresentation.getClients().add(regClient);
        this.addServiceAccount(realmRepresentation, "reg-cli-jwt");
        regClient = ClientBuilder.create().clientId("reg-cli-jwt-direct").attribute("jwt.credential.certificate", "MIICnTCCAYUCBgFXUhpRTTANBgkqhkiG9w0BAQsFADASMRAwDgYDVQQDDAdyZWctY2xpMB4XDTE2MDkyMjEzMzIxOFoXDTI2MDkyMjEzMzM1OFowEjEQMA4GA1UEAwwHcmVnLWNsaTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMHZn/0Bk1M9oKcTHxzn2cGvBWwO1m6OVLQ8LSVwNIf4ixfGkVIkhI5iEGYND+uD8ame54ZPClTVxMra3JldClLIG+L+ymnbT2vKIhEsVvCROs9PnYxbFALt1dXneLIio2uzF+d7/zQWlmeaWfNunSJT1aHNJDkGgDeUuQa25b0IMqsFjsN8Dg4ATkA97r3wKn4Tp3SE7sTM/B2pmra4atNxGeShVrgihqUiQ/PwDiDGwry64AsexkZnQsCR3bJWBAVUiHef3JWzTfWWN5bfCBG6Mnq1xw7YN+YpV1nR3CGmcKJuLe6aTe7Ps8hYejYiQA7Mp7ZQsoImsVFV5HDOlb0CAwEAATANBgkqhkiG9w0BAQsFAAOCAQEAZl8XvLfKXTPYvq/QyHOg7EDlAdlV3HkmHP9SBAV4BccmHmorMkm5I6I21UA5mfju+0nhbEd0bm0kvJFxIfNU6lJyyVvQx3Gns37KYUOzIV/ocWZuOTBLp5tfIBYbBwfE/s1J4PhpA/3WhBY9JKiLvdJfxECGIgaLs2M0UsylW/7o04+18Od8j/m7crQc7fpe5gJB5m/+hxUDowIjG5CumffX9OHYGDvHBpaUl7QNSGgjP8Bn9ogmIMUBJ7XSYUcohKuk2Cnj6p+GlLuqHbOISUXLVjf0DxhCu6diVxvacKbgAZmyCIO1tGL/UVRxg9GOYdCiC9vHfPuZ8US+ZB0P9g==").authenticatorType("client-jwt").directAccessGrants().build();
        realmRepresentation.getClients().add(regClient);
        regClient = ClientBuilder.create().clientId("reg-cli-secret").secret("password").authenticatorType("client-secret").serviceAccount().build();
        realmRepresentation.getClients().add(regClient);
        this.addServiceAccount(realmRepresentation, "reg-cli-secret");
        regClient = ClientBuilder.create().clientId("reg-cli-secret-direct").secret("password").authenticatorType("client-secret").directAccessGrants().build();
        realmRepresentation.getClients().add(regClient);
    }

    void loginAsUser(File configFile, String server, String realm, String user, String password) {
        KcRegExec exe = KcRegExec.execute((String)("config credentials --server " + server + " --realm " + realm + " --user " + user + " --password " + password + " --config " + configFile.getAbsolutePath()));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
    }

    void assertFieldsEqualWithExclusions(ConfigData config1, ConfigData config2, String ... excluded) {
        HashSet<String> exclusions = new HashSet<String>(Arrays.asList(excluded));
        if (!exclusions.contains("serverUrl")) {
            Assert.assertEquals((String)"serverUrl", (Object)config1.getServerUrl(), (Object)config2.getServerUrl());
        }
        if (!exclusions.contains("realm")) {
            Assert.assertEquals((String)"realm", (Object)config1.getRealm(), (Object)config2.getRealm());
        }
        if (!exclusions.contains("truststore")) {
            Assert.assertEquals((String)"truststore", (Object)config1.getTruststore(), (Object)config2.getTruststore());
        }
        if (!exclusions.contains("endpoints")) {
            Map endp1 = config1.getEndpoints();
            Map endp2 = config2.getEndpoints();
            Iterator it1 = endp1.entrySet().iterator();
            Iterator it2 = endp2.entrySet().iterator();
            while (it1.hasNext()) {
                Map.Entry ent1 = it1.next();
                Map.Entry ent2 = it2.next();
                String serverUrl = (String)ent1.getKey();
                String endpskey = "endpoints." + serverUrl;
                if (exclusions.contains(endpskey)) continue;
                Assert.assertEquals((String)endpskey, ent1.getKey(), ent2.getKey());
                Map realms1 = (Map)ent1.getValue();
                Map realms2 = (Map)ent2.getValue();
                Iterator rit1 = realms1.entrySet().iterator();
                Iterator rit2 = realms2.entrySet().iterator();
                while (rit1.hasNext()) {
                    Map.Entry rent1 = rit1.next();
                    Map.Entry rent2 = rit2.next();
                    String realm = (String)rent1.getKey();
                    String rkey = endpskey + "." + realm;
                    if (exclusions.contains(endpskey)) continue;
                    Assert.assertEquals((String)rkey, rent1.getKey(), rent2.getKey());
                    RealmConfigData rdata1 = (RealmConfigData)rent1.getValue();
                    RealmConfigData rdata2 = (RealmConfigData)rent2.getValue();
                    this.assertFieldsEqualWithExclusions(serverUrl, realm, rdata1, rdata2, excluded);
                }
            }
        }
    }

    void assertFieldsEqualWithExclusions(RealmConfigData data1, RealmConfigData data2, String ... excluded) {
        this.assertFieldsEqualWithExclusions(null, null, data1, data2, excluded);
    }

    void assertFieldsEqualWithExclusions(String server, String realm, RealmConfigData data1, RealmConfigData data2, String ... excluded) {
        String ekey;
        HashSet<String> exclusions = new HashSet<String>(Arrays.asList(excluded));
        String pfix = "";
        if (server != null || realm != null) {
            pfix = "endpoints." + server + "." + realm + ".";
        }
        if (!exclusions.contains(ekey = pfix + "serverUrl")) {
            Assert.assertEquals((String)ekey, (Object)data1.serverUrl(), (Object)data2.serverUrl());
        }
        if (!exclusions.contains(ekey = pfix + "realm")) {
            Assert.assertEquals((String)ekey, (Object)data1.realm(), (Object)data2.realm());
        }
        if (!exclusions.contains(ekey = pfix + "clientId")) {
            Assert.assertEquals((String)ekey, (Object)data1.getClientId(), (Object)data2.getClientId());
        }
        if (!exclusions.contains(ekey = pfix + "initialToken")) {
            Assert.assertEquals((String)ekey, (Object)data1.getInitialToken(), (Object)data2.getInitialToken());
        }
        if (!exclusions.contains(ekey = pfix + "token")) {
            Assert.assertEquals((String)ekey, (Object)data1.getToken(), (Object)data2.getToken());
        }
        if (!exclusions.contains(ekey = pfix + "refreshToken")) {
            Assert.assertEquals((String)ekey, (Object)data1.getRefreshToken(), (Object)data2.getRefreshToken());
        }
        if (!exclusions.contains(ekey = pfix + "expiresAt")) {
            Assert.assertEquals((String)ekey, (Object)data1.getExpiresAt(), (Object)data2.getExpiresAt());
        }
        if (!exclusions.contains(ekey = pfix + "refreshExpiresAt")) {
            Assert.assertEquals((String)ekey, (Object)data1.getRefreshExpiresAt(), (Object)data2.getRefreshExpiresAt());
        }
        if (!exclusions.contains(ekey = pfix + "secret")) {
            Assert.assertEquals((String)ekey, (Object)data1.getSecret(), (Object)data2.getSecret());
        }
        if (!exclusions.contains(ekey = pfix + "signingToken")) {
            Assert.assertEquals((String)ekey, (Object)data1.getSigningToken(), (Object)data2.getSigningToken());
        }
        if (!exclusions.contains(ekey = pfix + "sigExpiresAt")) {
            Assert.assertEquals((String)ekey, (Object)data1.getSigExpiresAt(), (Object)data2.getSigExpiresAt());
        }
        if (!exclusions.contains(ekey = pfix + "clients")) {
            Map clients1 = data1.getClients();
            Map clients2 = data2.getClients();
            Iterator cit1 = clients1.entrySet().iterator();
            Iterator cit2 = clients2.entrySet().iterator();
            while (cit1.hasNext() || cit2.hasNext()) {
                Map.Entry ckey1 = cit1.hasNext() ? cit1.next() : null;
                Map.Entry ckey2 = cit2.hasNext() ? cit2.next() : null;
                String ckey = ekey + "." + (ckey1 != null ? (String)ckey1.getKey() : (String)ckey2.getKey());
                if (exclusions.contains(ckey)) continue;
                Assert.assertNotNull((String)(ckey + " left not null"), ckey1);
                Assert.assertNotNull((String)(ckey + " right not null"), ckey2);
                Assert.assertEquals((String)ckey, ckey1.getKey(), ckey2.getKey());
                Assert.assertEquals((String)(ckey + " value"), ckey1.getValue(), ckey2.getValue());
            }
        }
    }

    void addServiceAccount(RealmRepresentation realm, String clientId) {
        UserRepresentation account = UserBuilder.create().username("service-account-" + clientId).enabled(true).serviceAccountId(clientId).build();
        HashMap<String, List<String>> clientRoles = new HashMap<String, List<String>>();
        clientRoles.put("realm-management", Arrays.asList("manage-clients"));
        account.setClientRoles(clientRoles);
        realm.getUsers().add(account);
    }

    void waitFor(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted");
        }
    }

    FileConfigHandler initCustomConfigFile() {
        String filename = UUID.randomUUID().toString() + ".config";
        File cfgFile = new File(KcRegExec.WORK_DIR + "/" + filename);
        FileConfigHandler handler = new FileConfigHandler();
        FileConfigHandler.setConfigFile((String)cfgFile.getAbsolutePath());
        return handler;
    }

    File initTempFile(String extension) throws IOException {
        return this.initTempFile(extension, null);
    }

    File initTempFile(String extension, String content) throws IOException {
        String filename = UUID.randomUUID().toString() + extension;
        File file = new File(KcRegExec.WORK_DIR + "/" + filename);
        if (content != null) {
            FileOutputStream os = new FileOutputStream(file);
            ((OutputStream)os).write(content.getBytes(Charset.forName("iso_8859_1")));
            ((OutputStream)os).close();
        }
        return file;
    }

    String issueInitialAccessToken(String realm) {
        ClientInitialAccessResource resource = this.adminClient.realm(realm).clientInitialAccess();
        ClientInitialAccessCreatePresentation rep = new ClientInitialAccessCreatePresentation();
        rep.setCount(Integer.valueOf(10));
        rep.setExpiration(Integer.valueOf(100));
        ClientInitialAccessPresentation response = resource.create(rep);
        String token = response.getToken();
        Assert.assertNotNull((String)"Issued initial access token not null", (Object)token);
        return token;
    }

    private ComponentRepresentation findPolicyByProviderAndAuth(String realm, String providerId, String authType) {
        List reps = this.adminClient.realm(realm).components().query(realm, ClientRegistrationPolicy.class.getName());
        for (ComponentRepresentation rep : reps) {
            if (!rep.getSubType().equals(authType) || !rep.getProviderId().equals(providerId)) continue;
            return rep;
        }
        return null;
    }

    void addLocalhostToAllowedHosts(String realm) {
        RealmResource realmResource = this.adminClient.realm(realm);
        String anonPolicy = ClientRegistrationPolicyManager.getComponentTypeKey((RegistrationAuth)RegistrationAuth.ANONYMOUS);
        ComponentRepresentation trustedHostRep = this.findPolicyByProviderAndAuth(realm, "trusted-hosts", anonPolicy);
        trustedHostRep.getConfig().putSingle((Object)"trusted-hosts", (Object)"localhost");
        realmResource.components().component(trustedHostRep.getId()).update(trustedHostRep);
    }

    void testCRUDWithOnTheFlyAuth(String serverUrl, String credentials, String extraOptions, String loginMessage) throws IOException {
        File configFile = AbstractRegCliTest.getDefaultConfigFilePath();
        long lastModified = configFile.exists() ? configFile.lastModified() : 0L;
        KcRegExec exe = KcRegExec.execute((String)("create --no-config --server " + serverUrl + " --realm test " + credentials + " " + extraOptions + " -s clientId=test-client -o"));
        Assert.assertEquals((String)"exitCode == 0", (long)0L, (long)exe.exitCode());
        Assert.assertEquals((String)"login message", (Object)loginMessage, exe.stderrLines().get(0));
        ClientRepresentation client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
        Assert.assertEquals((String)"clientId", (Object)"test-client", (Object)client.getClientId());
        Assert.assertNotNull((String)"registrationAccessToken not null", (Object)client.getRegistrationAccessToken());
        long lastModified2 = configFile.exists() ? configFile.lastModified() : 0L;
        Assert.assertEquals((String)"config file not modified", (long)lastModified, (long)lastModified2);
        exe = KcRegExec.execute((String)("get test-client --no-config --server " + serverUrl + " --realm test " + credentials + " " + extraOptions));
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 1);
        ClientRepresentation client2 = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
        Assert.assertEquals((String)"clientId", (Object)"test-client", (Object)client2.getClientId());
        Assert.assertNull((String)"registrationAccessToken is null", (Object)client2.getRegistrationAccessToken());
        lastModified2 = configFile.exists() ? configFile.lastModified() : 0L;
        Assert.assertEquals((String)"config file not modified", (long)lastModified, (long)lastModified2);
        exe = KcRegExec.execute((String)("get test-client --no-config --server " + serverUrl + " --realm test " + extraOptions + " -t " + client.getRegistrationAccessToken()));
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        ClientRepresentation client3 = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
        Assert.assertEquals((String)"clientId", (Object)"test-client", (Object)client3.getClientId());
        Assert.assertEquals((String)"registrationAccessToken in returned json is different than one returned by create", (Object)client.getRegistrationAccessToken(), (Object)client3.getRegistrationAccessToken());
        lastModified2 = configFile.exists() ? configFile.lastModified() : 0L;
        Assert.assertEquals((String)"config file not modified", (long)lastModified, (long)lastModified2);
        exe = KcRegExec.execute((String)("update test-client --no-config --server " + serverUrl + " --realm test " + credentials + " " + extraOptions + " -s enabled=false -o"));
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 1);
        ClientRepresentation client4 = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
        Assert.assertEquals((String)"clientId", (Object)"test-client", (Object)client4.getClientId());
        Assert.assertFalse((String)"enabled", (boolean)client4.isEnabled());
        Assert.assertNull((String)"registrationAccessToken in null", (Object)client4.getRegistrationAccessToken());
        lastModified2 = configFile.exists() ? configFile.lastModified() : 0L;
        Assert.assertEquals((String)"config file not modified", (long)lastModified, (long)lastModified2);
        exe = KcRegExec.execute((String)("update test-client --no-config --server " + serverUrl + " --realm test " + extraOptions + " -s enabled=true -o -t " + client3.getRegistrationAccessToken()));
        this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
        ClientRepresentation client5 = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
        Assert.assertEquals((String)"clientId", (Object)"test-client", (Object)client5.getClientId());
        Assert.assertTrue((String)"enabled", (boolean)client5.isEnabled());
        Assert.assertNotEquals((String)"registrationAccessToken in returned json is different than one returned by get", (Object)client3.getRegistrationAccessToken(), (Object)client5.getRegistrationAccessToken());
        lastModified2 = configFile.exists() ? configFile.lastModified() : 0L;
        Assert.assertEquals((String)"config file not modified", (long)lastModified, (long)lastModified2);
        exe = KcRegExec.execute((String)("delete test-client --no-config --server " + serverUrl + " --realm test " + credentials + " " + extraOptions));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
        lastModified2 = configFile.exists() ? configFile.lastModified() : 0L;
        Assert.assertEquals((String)"config file not modified", (long)lastModified, (long)lastModified2);
        exe = KcRegExec.execute((String)("delete test-client --no-config --server " + serverUrl + " --realm test " + credentials + " " + extraOptions));
        this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
        Assert.assertEquals((String)"error message", (Object)"Client not found [invalid_request]", exe.stderrLines().get(1));
        lastModified2 = configFile.exists() ? configFile.lastModified() : 0L;
        Assert.assertEquals((String)"config file not modified", (long)lastModified, (long)lastModified2);
    }
}

