/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.admin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.client.admin.cli.config.FileConfigHandler;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.cli.KcAdmExec;
import org.keycloak.testsuite.cli.admin.AbstractAdmCliTest;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.updaters.IdentityProviderCreator;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.TempFileResource;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class KcAdmUpdateTest
extends AbstractAdmCliTest {
    @Test
    public void testUpdateIDPWithoutInternalId() throws IOException {
        String realm = "test";
        RealmResource realmResource = this.adminClient.realm("test");
        IdentityProviderRepresentation identityProvider = IdentityProviderBuilder.create().providerId("saml").alias("idpAlias").displayName("SAML").setAttribute("singleSignOnServiceUrl", "https://saml.idp/saml").setAttribute("singleLogoutServiceUrl", "https://saml.idp/saml").setAttribute("nameIDPolicyFormat", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress").setAttribute("postBindingResponse", "false").setAttribute("postBindingAuthnRequest", "false").setAttribute("backchannelSupported", "false").build();
        try (IdentityProviderCreator ipc = new IdentityProviderCreator(realmResource, identityProvider);){
            FileConfigHandler handler = this.initCustomConfigFile();
            try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
                this.loginAsUser(configFile.getFile(), this.serverUrl, "test", "user1", "userpass");
                KcAdmExec exe = KcAdmExec.execute((String)("get identity-provider/instances/idpAlias -r test --config " + configFile.getFile()));
                this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
                File idpJson = new File("target/test-classes/cli/idp-keycloak-9167.json");
                exe = KcAdmExec.execute((String)("update identity-provider/instances/idpAlias -r test -f " + idpJson.getAbsolutePath() + " --config " + configFile.getFile()));
                this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            }
            Assert.assertThat((Object)realmResource.identityProviders().get("idpAlias").toRepresentation().getDisplayName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"SAML_UPDATED")));
        }
    }

    @Test
    public void testUpdateThoroughly() throws IOException {
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            String realm = "test";
            this.loginAsUser(configFile.getFile(), this.serverUrl, "test", "user1", "userpass");
            KcAdmExec exe = KcAdmExec.execute((String)("create clients --config '" + configFile.getName() + "' -o -s clientId=my_client"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            ClientRepresentation client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertTrue((String)"enabled", (boolean)client.isEnabled());
            Assert.assertFalse((String)"publicClient", (boolean)client.isPublicClient());
            Assert.assertFalse((String)"bearerOnly", (boolean)client.isBearerOnly());
            Assert.assertTrue((String)"redirectUris is empty", (boolean)client.getRedirectUris().isEmpty());
            exe = KcAdmExec.execute((String)("update clients/" + client.getId() + " --config '" + configFile.getName() + "' -o  -s enabled=false -s 'redirectUris=[\"http://localhost:8980/myapp/*\"]'"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertFalse((String)"enabled", (boolean)client.isEnabled());
            Assert.assertEquals((String)"redirectUris", Arrays.asList("http://localhost:8980/myapp/*"), (Object)client.getRedirectUris());
            exe = KcAdmExec.execute((String)("update clients/" + client.getId() + " --config '" + configFile.getName() + "' -o -d redirectUris[0] -s webOrigins+=http://localhost:8980/myapp -s webOrigins+=http://localhost:8981/myapp -d webOrigins[0]"));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertTrue((String)"redirectUris is empty", (boolean)client.getRedirectUris().isEmpty());
            Assert.assertEquals((String)"webOrigins", Arrays.asList("http://localhost:8981/myapp"), (Object)client.getWebOrigins());
            exe = KcAdmExec.execute((String)("update clients/" + client.getId() + " --nonexisting --config '" + configFile.getName() + "'"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 1, 0, 2);
            Assert.assertEquals((String)"error message", (Object)"Invalid option: --nonexisting", exe.stderrLines().get(0));
            Assert.assertEquals((String)"try help", (Object)("Try '" + KcAdmExec.CMD + " help update' for more information"), exe.stderrLines().get(1));
            exe = (KcAdmExec)KcAdmExec.newBuilder().argsLine("update clients/" + client.getId() + " --config '" + configFile.getName() + "' -o  -s clientId=my_client -s 'redirectUris=[\"http://localhost:8980/myapp/*\"]' -f -").stdin((InputStream)new ByteArrayInputStream("{ \"enabled\": false }".getBytes())).execute();
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertEquals((String)"webOrigins", Arrays.asList("http://localhost:8981/myapp"), (Object)client.getWebOrigins());
            Assert.assertFalse((String)"enabled is false", (boolean)client.isEnabled());
            Assert.assertEquals((String)"redirectUris", Arrays.asList("http://localhost:8980/myapp/*"), (Object)client.getRedirectUris());
            exe = (KcAdmExec)KcAdmExec.newBuilder().argsLine("update clients/" + client.getId() + " --config '" + configFile.getName() + "' -o -s enabled=true -m -f -").stdin((InputStream)new ByteArrayInputStream("{ \"webOrigins\": [\"http://localhost:8980/myapp\"] }".getBytes())).execute();
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
            client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
            Assert.assertEquals((String)"webOrigins", Arrays.asList("http://localhost:8980/myapp"), (Object)client.getWebOrigins());
            Assert.assertTrue((String)"enabled is true", (boolean)client.isEnabled());
            Assert.assertEquals((String)"redirectUris", Arrays.asList("http://localhost:8980/myapp/*"), (Object)client.getRedirectUris());
        }
    }
}

