/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.cli.admin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.client.admin.cli.config.FileConfigHandler;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.cli.KcAdmExec;
import org.keycloak.testsuite.cli.admin.AbstractAdmCliTest;
import org.keycloak.testsuite.cli.exec.AbstractExec;
import org.keycloak.testsuite.util.TempFileResource;
import org.keycloak.util.JsonSerialization;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class KcAdmCreateTest
extends AbstractAdmCliTest {
    @Test
    public void testCreateWithRealmOverride() throws IOException {
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            KcAdmExec exe = KcAdmExec.execute((String)("config credentials -x --config '" + configFile.getName() + "' --server " + this.serverUrl + " --realm master --user admin --password admin"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            exe = KcAdmExec.execute((String)("create clients --config '" + configFile.getName() + "' --server " + this.serverUrl + " -r test -s clientId=my_first_client"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
        }
    }

    @Test
    public void testCreateIDPWithoutSyncMode() throws IOException {
        String realm = "test";
        RealmResource realmResource = this.adminClient.realm("test");
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            this.loginAsUser(configFile.getFile(), this.serverUrl, "test", "user1", "userpass");
            File idpJson = new File("target/test-classes/cli/idp-keycloak-without-sync-mode.json");
            KcAdmExec exe = KcAdmExec.execute((String)("create identity-provider/instances/ -r test -f " + idpJson.getAbsolutePath() + " --config " + configFile.getFile()));
            this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 1);
        }
        Assert.assertNull(realmResource.identityProviders().get("idpAlias").toRepresentation().getConfig().get("syncMode"));
    }

    @Test
    public void testCreateThoroughly() throws IOException {
        FileConfigHandler handler = this.initCustomConfigFile();
        try (TempFileResource configFile = new TempFileResource(handler.getConfigFile());){
            String realm = "test";
            KcAdmExec exe = KcAdmExec.execute((String)("config credentials -x --config '" + configFile.getName() + "' --server " + this.serverUrl + " --realm master --user admin --password admin"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            String content = "{\n        \"clientId\": \"my_client\",\n        \"enabled\": true,\n        \"redirectUris\": [\"http://localhost:8980/myapp/*\"],\n        \"serviceAccountsEnabled\": true,\n        \"name\": \"My Client App\",\n        \"implicitFlowEnabled\": false,\n        \"publicClient\": true,\n        \"webOrigins\": [\"http://localhost:8980/myapp\"],\n        \"consentRequired\": false,\n        \"baseUrl\": \"http://localhost:8980/myapp\",\n        \"bearerOnly\": true,\n        \"standardFlowEnabled\": true\n}";
            try (TempFileResource tmpFile = new TempFileResource(this.initTempFile(".json", content));){
                exe = KcAdmExec.execute((String)("create clients --config '" + configFile.getName() + "' -o -f - < '" + tmpFile.getName() + "'"));
                this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
                ClientRepresentation client = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
                Assert.assertNotNull((String)"id", (Object)client.getId());
                Assert.assertEquals((String)"clientId", (Object)"my_client", (Object)client.getClientId());
                Assert.assertEquals((String)"enabled", (Object)true, (Object)client.isEnabled());
                Assert.assertEquals((String)"redirectUris", Arrays.asList("http://localhost:8980/myapp/*"), (Object)client.getRedirectUris());
                Assert.assertEquals((String)"serviceAccountsEnabled", (Object)true, (Object)client.isServiceAccountsEnabled());
                Assert.assertEquals((String)"name", (Object)"My Client App", (Object)client.getName());
                Assert.assertEquals((String)"implicitFlowEnabled", (Object)false, (Object)client.isImplicitFlowEnabled());
                Assert.assertEquals((String)"publicClient", (Object)true, (Object)client.isPublicClient());
                Assert.assertEquals((String)"webOrigins", Arrays.asList("http://localhost:8980/myapp"), (Object)client.getWebOrigins());
                Assert.assertEquals((String)"consentRequired", (Object)false, (Object)client.isConsentRequired());
                Assert.assertEquals((String)"baseUrl", (Object)"http://localhost:8980/myapp", (Object)client.getBaseUrl());
                Assert.assertEquals((String)"bearerOnly", (Object)true, (Object)client.isStandardFlowEnabled());
                Assert.assertFalse((String)"mappers not empty", (boolean)client.getProtocolMappers().isEmpty());
                exe = KcAdmExec.execute((String)("create clients --config '" + configFile.getName() + "' -o -f '" + tmpFile.getName() + "' -s clientId=my_client2 -s enabled=false -s 'redirectUris=[\"http://localhost:8980/myapp2/*\"]' -s 'name=My Client App II' -s 'webOrigins=[\"http://localhost:8980/myapp2\"]' -s baseUrl=http://localhost:8980/myapp2 -s rootUrl=http://localhost:8980/myapp2"));
                this.assertExitCodeAndStdErrSize((AbstractExec)exe, 0, 0);
                ClientRepresentation client2 = (ClientRepresentation)JsonSerialization.readValue((InputStream)exe.stdout(), ClientRepresentation.class);
                Assert.assertNotNull((String)"id", (Object)client2.getId());
                Assert.assertEquals((String)"clientId", (Object)"my_client2", (Object)client2.getClientId());
                Assert.assertEquals((String)"enabled", (Object)false, (Object)client2.isEnabled());
                Assert.assertEquals((String)"redirectUris", Arrays.asList("http://localhost:8980/myapp2/*"), (Object)client2.getRedirectUris());
                Assert.assertEquals((String)"serviceAccountsEnabled", (Object)true, (Object)client2.isServiceAccountsEnabled());
                Assert.assertEquals((String)"name", (Object)"My Client App II", (Object)client2.getName());
                Assert.assertEquals((String)"implicitFlowEnabled", (Object)false, (Object)client2.isImplicitFlowEnabled());
                Assert.assertEquals((String)"publicClient", (Object)true, (Object)client2.isPublicClient());
                Assert.assertEquals((String)"webOrigins", Arrays.asList("http://localhost:8980/myapp2"), (Object)client2.getWebOrigins());
                Assert.assertEquals((String)"consentRequired", (Object)false, (Object)client2.isConsentRequired());
                Assert.assertEquals((String)"baseUrl", (Object)"http://localhost:8980/myapp2", (Object)client2.getBaseUrl());
                Assert.assertEquals((String)"rootUrl", (Object)"http://localhost:8980/myapp2", (Object)client2.getRootUrl());
                Assert.assertEquals((String)"bearerOnly", (Object)true, (Object)client2.isStandardFlowEnabled());
                Assert.assertFalse((String)"mappers not empty", (boolean)client2.getProtocolMappers().isEmpty());
            }
            exe = KcAdmExec.execute((String)("create clients --config '" + configFile.getName() + "' -i -s clientId=my_client3"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 1, 0);
            exe = KcAdmExec.execute((String)("create clients --config '" + configFile.getName() + "' -s clientId=my_client4"));
            this.assertExitCodeAndStreamSizes((AbstractExec)exe, 0, 0, 1);
            Assert.assertTrue((String)"only id returned", (boolean)((String)exe.stderrLines().get(0)).startsWith("Created new client with id '"));
        }
    }
}

