/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractRoleMapperTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class OidcUserInfoClaimToRoleMapperTest
extends AbstractRoleMapperTest {
    protected static final String ATTRIBUTE_TO_MAP_USER_INFO = "user-attribute-info";
    private static final String USER_INFO_CLAIM = "user-attribute-info";
    private static final String USER_INFO_CLAIM_VALUE = "value 1";
    private String claimOnSecondLogin = "";

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfigurationUserInfoOnlyMappers();
    }

    @Test
    public void singleClaimValueInUserInfoMatches() {
        this.createClaimToRoleMapper(USER_INFO_CLAIM_VALUE);
        this.createUserInProviderRealm((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute-info", (Object)ImmutableList.builder().add((Object)USER_INFO_CLAIM_VALUE).build()).build());
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void noRoleAddedIfUserInfoDisabledAndOnlyClaimIsInUserInfo() {
        this.createClaimToRoleMapperWithUserInfoDisabledInIdP(USER_INFO_CLAIM_VALUE);
        this.createUserInProviderRealm((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute-info", (Object)ImmutableList.builder().add((Object)USER_INFO_CLAIM_VALUE).build()).build());
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    private void createClaimToRoleMapper(String claimValue) {
        IdentityProviderRepresentation idp = this.setupIdentityProvider();
        this.createClaimToRoleMapper(idp, claimValue, IdentityProviderMapperSyncMode.IMPORT);
    }

    private void createClaimToRoleMapperWithUserInfoDisabledInIdP(String claimValue) {
        IdentityProviderRepresentation idp = this.setupIdentityProviderDisableUserInfo();
        this.createClaimToRoleMapper(idp, claimValue, IdentityProviderMapperSyncMode.IMPORT);
    }

    @Override
    protected void createMapperInIdp(IdentityProviderRepresentation idp, IdentityProviderMapperSyncMode syncMode) {
        this.createClaimToRoleMapper(idp, USER_INFO_CLAIM_VALUE, syncMode);
    }

    @Override
    protected void updateUser() {
        UserRepresentation user = this.findUser(this.bc.providerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        ImmutableMap mismatchingAttributes = ImmutableMap.builder().put((Object)"user-attribute-info", (Object)ImmutableList.builder().add((Object)this.claimOnSecondLogin).build()).build();
        user.setAttributes((Map)mismatchingAttributes);
        this.adminClient.realm(this.bc.providerRealmName()).users().get(user.getId()).update(user);
    }

    private void createClaimToRoleMapper(IdentityProviderRepresentation idp, String claimValue, IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation claimToRoleMapper = new IdentityProviderMapperRepresentation();
        claimToRoleMapper.setName("userinfo-claim-to-role-mapper");
        claimToRoleMapper.setIdentityProviderMapper("oidc-role-idp-mapper");
        claimToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"claim", (Object)"user-attribute-info").put((Object)"claim.value", (Object)claimValue).put((Object)"role", (Object)"realm-management.view-realm").build());
        IdentityProviderResource idpResource = this.realm.identityProviders().get(idp.getAlias());
        claimToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(claimToRoleMapper).close();
    }

    private class KcOidcBrokerConfigurationUserInfoOnlyMappers
    extends KcOidcBrokerConfiguration {
        private KcOidcBrokerConfigurationUserInfoOnlyMappers() {
        }

        @Override
        public List<ClientRepresentation> createProviderClients() {
            List<ClientRepresentation> clientsRepList = super.createProviderClients();
            OidcUserInfoClaimToRoleMapperTest.this.log.info((Object)"Update provider clients to disable attributes in Access & ID token");
            ProtocolMapperRepresentation userAttrMapper = new ProtocolMapperRepresentation();
            userAttrMapper.setName("attribute - name");
            userAttrMapper.setProtocol("openid-connect");
            userAttrMapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
            Map userAttrMapperConfig = userAttrMapper.getConfig();
            userAttrMapperConfig.put("user.attribute", "user-attribute-info");
            userAttrMapperConfig.put("claim.name", "user-attribute-info");
            userAttrMapperConfig.put("jsonType.label", "String");
            userAttrMapperConfig.put("access.token.claim", "false");
            userAttrMapperConfig.put("id.token.claim", "false");
            userAttrMapperConfig.put("userinfo.token.claim", "true");
            for (ClientRepresentation client : clientsRepList) {
                client.setProtocolMappers(Arrays.asList(userAttrMapper));
            }
            return clientsRepList;
        }

        @Override
        protected void applyDefaultConfiguration(Map<String, String> config, IdentityProviderSyncMode syncMode) {
            super.applyDefaultConfiguration(config, syncMode);
            config.put("disableUserInfo", "false");
        }
    }
}

