/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractRoleMapperTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class OidcClaimToRoleMapperTest
extends AbstractRoleMapperTest {
    protected static final String CLAIM = "user-attribute";
    protected static final String CLAIM_VALUE = "value 1";
    private String claimOnSecondLogin = "";

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration();
    }

    @Test
    public void allClaimValuesMatch() {
        this.createClaimToRoleMapper(CLAIM_VALUE);
        this.createUserInProviderRealm((Map<String, List<String>>)ImmutableMap.builder().put((Object)CLAIM, (Object)ImmutableList.builder().add((Object)CLAIM_VALUE).build()).build());
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void claimValuesMismatch() {
        this.createClaimToRoleMapper("other value");
        this.createUserInProviderRealm((Map<String, List<String>>)ImmutableMap.builder().put((Object)CLAIM, (Object)ImmutableList.builder().add((Object)CLAIM_VALUE).build()).build());
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserMismatchDeletesRoleInForceMode() {
        UserRepresentation user = this.loginWithClaimThenChangeClaimToValue("value mismatch", IdentityProviderMapperSyncMode.FORCE, false);
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserMismatchDeletesRoleInLegacyMode() {
        UserRepresentation user = this.createMapperThenLoginWithStandardClaimThenChangeClaimToValue("value mismatch", IdentityProviderMapperSyncMode.LEGACY);
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserNewMatchGrantsRoleAfterFirstLoginInForceMode() {
        UserRepresentation user = this.loginWithStandardClaimThenAddMapperAndLoginAgain(IdentityProviderMapperSyncMode.FORCE);
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserNewMatchDoesNotGrantRoleAfterFirstLoginInLegacyMode() {
        UserRepresentation user = this.loginWithStandardClaimThenAddMapperAndLoginAgain(IdentityProviderMapperSyncMode.LEGACY);
        this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
    }

    @Test
    public void updateBrokeredUserDoesNotDeleteRoleIfClaimStillMatches() {
        UserRepresentation user = this.createMapperThenLoginWithStandardClaimThenChangeClaimToValue(CLAIM_VALUE, IdentityProviderMapperSyncMode.FORCE);
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }

    private UserRepresentation loginWithStandardClaimThenAddMapperAndLoginAgain(IdentityProviderMapperSyncMode syncMode) {
        return this.loginWithClaimThenChangeClaimToValue(CLAIM_VALUE, syncMode, true);
    }

    private UserRepresentation createMapperThenLoginWithStandardClaimThenChangeClaimToValue(String claimOnSecondLogin, IdentityProviderMapperSyncMode syncMode) {
        return this.loginWithClaimThenChangeClaimToValue(claimOnSecondLogin, syncMode, false);
    }

    @NotNull
    private UserRepresentation loginWithClaimThenChangeClaimToValue(String claimOnSecondLogin, IdentityProviderMapperSyncMode syncMode, boolean createAfterFirstLogin) {
        this.claimOnSecondLogin = claimOnSecondLogin;
        return this.loginAsUserTwiceWithMapper(syncMode, createAfterFirstLogin, (Map<String, List<String>>)ImmutableMap.builder().put((Object)CLAIM, (Object)ImmutableList.builder().add((Object)CLAIM_VALUE).build()).build());
    }

    private void createClaimToRoleMapper(String claimValue) {
        IdentityProviderRepresentation idp = this.setupIdentityProvider();
        this.createClaimToRoleMapper(idp, claimValue, IdentityProviderMapperSyncMode.IMPORT);
    }

    @Override
    protected void createMapperInIdp(IdentityProviderRepresentation idp, IdentityProviderMapperSyncMode syncMode) {
        this.createClaimToRoleMapper(idp, CLAIM_VALUE, syncMode);
    }

    @Override
    protected void updateUser() {
        UserRepresentation user = this.findUser(this.bc.providerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        ImmutableMap mismatchingAttributes = ImmutableMap.builder().put((Object)CLAIM, (Object)ImmutableList.builder().add((Object)this.claimOnSecondLogin).build()).build();
        user.setAttributes((Map)mismatchingAttributes);
        this.adminClient.realm(this.bc.providerRealmName()).users().get(user.getId()).update(user);
    }

    protected void createClaimToRoleMapper(IdentityProviderRepresentation idp, String claimValue, IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation claimToRoleMapper = new IdentityProviderMapperRepresentation();
        claimToRoleMapper.setName("claim-to-role-mapper");
        claimToRoleMapper.setIdentityProviderMapper("oidc-role-idp-mapper");
        claimToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"claim", (Object)CLAIM).put((Object)"claim.value", (Object)claimValue).put((Object)"role", (Object)"realm-management.view-realm").build());
        IdentityProviderResource idpResource = this.realm.identityProviders().get(idp.getAlias());
        claimToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(claimToRoleMapper).close();
    }
}

