/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testsuite.broker.AbstractAdvancedRoleMapperTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class OidcAdvancedClaimToRoleMapperTest
extends AbstractAdvancedRoleMapperTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration();
    }

    @Override
    protected void createMapperInIdp(IdentityProviderRepresentation idp, String claimsOrAttributeRepresentation, boolean areClaimsOrAttributeValuesRegexes, IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation advancedClaimToRoleMapper = new IdentityProviderMapperRepresentation();
        advancedClaimToRoleMapper.setName("advanced-claim-to-role-mapper");
        advancedClaimToRoleMapper.setIdentityProviderMapper("oidc-advanced-role-idp-mapper");
        advancedClaimToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"claims", (Object)claimsOrAttributeRepresentation).put((Object)"are.claim.values.regex", (Object)(areClaimsOrAttributeValuesRegexes ? "true" : "false")).put((Object)"role", (Object)"realm-management.view-realm").build());
        IdentityProviderResource idpResource = this.realm.identityProviders().get(idp.getAlias());
        advancedClaimToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(advancedClaimToRoleMapper).close();
    }
}

