/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionQNames;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.IdentityProviderAttributeUpdater;
import org.keycloak.testsuite.updaters.RealmAttributeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.KeyUtils;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.keycloak.testsuite.util.saml.SamlDocumentStepBuilder;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KcSamlSignedBrokerTest
extends AbstractBrokerTest {
    private static final String PRIVATE_KEY = "MIIBVQIBADANBgkqhkiG9w0BAQEFAASCAT8wggE7AgEAAkEAs46ICYPRIkmr8diECmyT59cChTWIEiXYBY3T6OLlZrF8ofVCzbEeoUOmhrtHijxxuKSoqLWP4nNOt3rINtQNBQIDAQABAkBL2nyxuFQTLhhLdPJjDPd2y6gu6ixvrjkSL5ZEHgZXWRHzhTzBT0eRxg/5rJA2NDRMBzTTegaEGkWUt7lF5wDJAiEA5pC+h9NEgqDJSw42I52BOml3II35Z6NlNwl6OMfnD1sCIQDHXUiOIJy4ZcSgv5WGue1KbdNVOT2gop1XzfuyWgtjHwIhAOCjLb9QC3PqC7Tgx8azcnDiyHojWVesTrTsuvQPcAP5AiAkX5OeQrr1NbQTNAEe7IsrmjAFi4T/6stUOsOiPaV4NwIhAJIeyh4foIXIVQ+M4To2koaDFRssxKI9/O72vnZSJ+uA";
    private static final String PUBLIC_KEY = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBALOOiAmD0SJJq/HYhApsk+fXAoU1iBIl2AWN0+ji5WaxfKH1Qs2xHqFDpoa7R4o8cbikqKi1j+JzTrd6yDbUDQUCAwEAAQ==";

    public void withSignedEncryptedAssertions(Runnable testBody, boolean signedDocument, boolean signedAssertion, boolean encryptedAssertion) throws Exception {
        String providerCert = KeyUtils.getActiveSigningKey((KeysMetadataRepresentation)this.adminClient.realm(this.bc.providerRealmName()).keys().getKeyMetadata(), (String)"RS256").getCertificate();
        Assert.assertThat((Object)providerCert, (Matcher)org.hamcrest.Matchers.notNullValue());
        String consumerCert = KeyUtils.getActiveSigningKey((KeysMetadataRepresentation)this.adminClient.realm(this.bc.consumerRealmName()).keys().getKeyMetadata(), (String)"RS256").getCertificate();
        Assert.assertThat((Object)consumerCert, (Matcher)org.hamcrest.Matchers.notNullValue());
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("validateSignature", Boolean.toString(signedAssertion || signedDocument)).setAttribute("wantAssertionsSigned", Boolean.toString(signedAssertion)).setAttribute("wantAssertionsEncrypted", Boolean.toString(encryptedAssertion)).setAttribute("wantAuthnRequestsSigned", "false").setAttribute("encryptionPublicKey", PUBLIC_KEY).setAttribute("signingCertificate", providerCert).update();
             ServerResourceUpdater clientUpdater = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)this.bc.providerRealmName(), (String)this.bc.getIDPClientIdInProviderRealm()).setAttribute("saml.encrypt", Boolean.toString(encryptedAssertion)).setAttribute("saml.encryption.certificate", consumerCert).setAttribute("saml.server.signature", Boolean.toString(signedDocument)).setAttribute("saml.assertion.signature", Boolean.toString(signedAssertion)).setAttribute("saml.encryption.private.key", PRIVATE_KEY).setAttribute("saml.client.signature", "false").update();){
            testBody.run();
        }
    }

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcSamlSignedBrokerConfiguration();
    }

    @Test
    public void testWithExpiredBrokerCertificate() throws Exception {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("validateSignature", Boolean.toString(true)).setAttribute("wantAssertionsSigned", Boolean.toString(true)).setAttribute("wantAssertionsEncrypted", Boolean.toString(false)).setAttribute("wantAuthnRequestsSigned", "true").setAttribute("signingCertificate", "MIICMTCCAZqgAwIBAgIJAPlizW20Nhe6MA0GCSqGSIb3DQEBCwUAMDAxLjAsBgNVBAMMJWh0dHA6Ly9sb2NhbGhvc3Q6ODA4MC9zYWxlcy1wb3N0LXNpZy8wHhcNMTYwODI5MDg1MjMzWhcNMTYwODMwMDg1MjMzWjAwMS4wLAYDVQQDDCVodHRwOi8vbG9jYWxob3N0OjgwODAvc2FsZXMtcG9zdC1zaWcvMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDKxs0adx1X+k4u+a5eZjwD17mvADwgiwDYpMznfNlSNEfDJdFAHIZH0VAbwXnaGySJ/a/MMMTHly5irDMp1udkmHgv2ceW+SumsjEtxliSIKi6af59aYlHiOLGyV5VI/VLVvkE6Roax7fZ+7O858KDahg1JI5smYnpBLKY3X885QIDAQABo1MwUTAdBgNVHQ4EFgQUE9C6Ck0jsdY+sjN064ZYwYkZJr4wHwYDVR0jBBgwFoAUE9C6Ck0jsdY+sjN064ZYwYkZJr4wDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQsFAAOBgQBuypHw5DMDBgfI6LcXBiCjpiQP3DLRLdwthh/RfCnZT7PrhXRJV8RMm8EqxqtEgfg2SKqMyA02uxMKH0p277U2iQveSDAaICTJRxtyFm6FERtgLNlsekusC2I14gZpLe84oHDf6L1w3dKFzzLEC9+bHg/XCg/KthWxW8iuVct5qg==").update();
             ServerResourceUpdater clientUpdater = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)this.bc.providerRealmName(), (String)this.bc.getIDPClientIdInProviderRealm()).setAttribute("saml.encrypt", Boolean.toString(false)).setAttribute("saml.server.signature", "true").setAttribute("saml.assertion.signature", Boolean.toString(true)).setAttribute("saml.client.signature", "false").update();
             ServerResourceUpdater realmUpdater = new RealmAttributeUpdater(this.adminClient.realm(this.bc.providerRealmName())).setPublicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDKxs0adx1X+k4u+a5eZjwD17mvADwgiwDYpMznfNlSNEfDJdFAHIZH0VAbwXnaGySJ/a/MMMTHly5irDMp1udkmHgv2ceW+SumsjEtxliSIKi6af59aYlHiOLGyV5VI/VLVvkE6Roax7fZ+7O858KDahg1JI5smYnpBLKY3X885QIDAQAB").setPrivateKey("MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAMrGzRp3HVf6Ti75rl5mPAPXua8APCCLANikzOd82VI0R8Ml0UAchkfRUBvBedobJIn9r8wwxMeXLmKsMynW52SYeC/Zx5b5K6ayMS3GWJIgqLpp/n1piUeI4sbJXlUj9UtW+QTpGhrHt9n7s7znwoNqGDUkjmyZiekEspjdfzzlAgMBAAECgYBJvPFo5lftXkCAJJucCGFapGAJm3RCAUpVfdhldakxk4FlHaNyRO0vwJX5AeplvekTpQUAo9trGTbs+uHAHT4XWOnwhHHyBRkWdiwXX9bzNdHnIwf/0SLIBBYUk0hoWEDvpklBPqllM215a0sEnB2ykYSsMDBSkFB7Ah+RK7zTAQJBAOw9v7SsfIhOXci9vnkQPuQpL8T4kwj7nWi+YtRGrXbF/bJGwjsgXN5i7otwBV/W+TNzI5H7s2opPUXdIxfP9C0CQQDbvIcxXjwjO1hjXXY4axiT1sxU8Oq1bds033atMoN9pib7IxkWh6ouOQZT8bxwQ2ElH0rswZ0/2CusrIUIekaZAkEAk9UUSQiDKXz4vSzXq8SZxodriDQRNtbVqv0wtSvBUwkU9+HFm+BlnRiFtCYWhuHsseCESs8ad/10hWqbkkQkxQJAZOvN2+rADB5xlhGS/o6RlzUMW+bapcFy8HHB/AI7SjZJqQaRuztL+jbOpTddqOIJeBdLPjoekvgh9wi1gRNH4QJBAMjfB1xYxmztfbUcUuOsATz3s7StprOAukd+hhBiMukxcKhi1IQp7tFhfFe/+xUY3fSh1a3KlyItFKxp68EdDRk=").update();){
            AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
            Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
            new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().assertResponse(Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST));
        }
    }

    @Test
    public void testSignedEncryptedAssertions() throws Exception {
        this.withSignedEncryptedAssertions(this::testAssertionSignatureRespected, false, true, true);
    }

    @Test
    public void testSignedAssertion() throws Exception {
        this.withSignedEncryptedAssertions(this::testAssertionSignatureRespected, false, true, false);
    }

    private void testAssertionSignatureRespected() {
        this.loginUser();
        String redirectUri = this.getAccountUrl(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        String logoutUri = this.oauth.realm(this.bc.providerRealmName()).getLogoutUrl().redirectUri(redirectUri).build();
        this.driver.navigate().to(logoutUri);
        this.errorPage.assertCurrent();
    }

    private Document extractNamespacesToTopLevelElement(Document original) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        this.enumerateAndRemoveNamespaces(original.getDocumentElement(), namespaces);
        this.log.infof("Namespaces: %s", namespaces);
        this.log.infof("Document: %s", (Object)DocumentUtil.asString((Document)original));
        Element rootNode = original.getDocumentElement();
        for (Map.Entry<String, String> me : namespaces.entrySet()) {
            rootNode.setAttribute(me.getKey(), me.getValue());
        }
        this.log.infof("Updated document: %s", (Object)DocumentUtil.asString((Document)original));
        return original;
    }

    private void enumerateAndRemoveNamespaces(Element documentElement, HashMap<String, String> namespaces) {
        int i;
        NamedNodeMap attrs = documentElement.getAttributes();
        if (attrs != null) {
            HashSet<String> found = new HashSet<String>();
            for (i = attrs.getLength() - 1; i >= 0; --i) {
                Node item = attrs.item(i);
                String nodeName = item.getNodeName();
                if (nodeName == null || !nodeName.startsWith("xmlns:")) continue;
                namespaces.put(nodeName, item.getNodeValue());
                found.add(nodeName);
            }
            found.forEach(documentElement::removeAttribute);
        }
        NodeList childNodes = documentElement.getChildNodes();
        for (i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            this.enumerateAndRemoveNamespaces((Element)childNode, namespaces);
        }
    }

    @Test
    public void loginUserAllNamespacesInTopElement() {
        Document doc;
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
        try {
            doc = this.extractNamespacesToTopLevelElement(SAML2Request.convert((RequestAbstractType)loginRep));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().transformDocument(this::extractNamespacesToTopLevelElement)).build().login().user(this.bc.getUserLogin(), this.bc.getUserPassword()).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(this::extractNamespacesToTopLevelElement)).build().updateProfile().firstName("a").lastName("b").email(this.bc.getUserEmail()).username(this.bc.getUserLogin()).build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)samlResponse, (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
    }

    @Test
    public void loginUserAllNamespacesInTopElementSignedEncryptedAssertion() throws Exception {
        this.withSignedEncryptedAssertions(this::loginUserAllNamespacesInTopElement, false, true, true);
    }

    @Test
    public void loginUserAllNamespacesInTopElementSignedAssertion() throws Exception {
        this.withSignedEncryptedAssertions(this::loginUserAllNamespacesInTopElement, false, true, false);
    }

    @Test
    public void loginUserAllNamespacesInTopElementEncryptedAssertion() throws Exception {
        this.withSignedEncryptedAssertions(this::loginUserAllNamespacesInTopElement, false, false, true);
    }

    @Test
    public void testSignatureTampering_NOsignDoc_NOsignAssert_NOencAssert() throws Exception {
        this.loginAttackChangeSignature(false, false, false);
    }

    @Test
    public void testSignatureTampering_NOsignDoc_NOsignAssert_encAssert() throws Exception {
        this.loginAttackChangeSignature(false, false, true);
    }

    @Test
    public void testSignatureTampering_NOsignDoc_signAssert_NOencAssert() throws Exception {
        this.loginAttackChangeSignature(false, true, false);
    }

    @Test
    public void testSignatureTampering_NOsignDoc_signAssert_encAssert() throws Exception {
        this.loginAttackChangeSignature(false, true, true);
    }

    @Test
    public void testSignatureTampering_signDoc_NOsignAssert_NOencAssert() throws Exception {
        this.loginAttackChangeSignature(true, false, false);
    }

    @Test
    public void testSignatureTampering_signDoc_NOsignAssert_encAssert() throws Exception {
        this.loginAttackChangeSignature(true, false, true);
    }

    @Test
    public void testSignatureTampering_signDoc_signAssert_NOencAssert() throws Exception {
        this.loginAttackChangeSignature(true, true, false);
    }

    @Test
    public void testSignatureTampering_signDoc_signAssert_encAssert() throws Exception {
        this.loginAttackChangeSignature(true, true, true);
    }

    private Document removeDocumentSignature(Document orig) {
        return this.removeSignatureTag(orig, Collections.singleton(SAMLProtocolQNames.RESPONSE.getQName()));
    }

    private Document removeAssertionSignature(Document orig) {
        return this.removeSignatureTag(orig, Collections.singleton(SAMLAssertionQNames.ASSERTION.getQName()));
    }

    private Document removeDocumentAndAssertionSignature(Document orig) {
        return this.removeSignatureTag(orig, new HashSet<QName>(Arrays.asList(SAMLProtocolQNames.RESPONSE.getQName(), SAMLAssertionQNames.ASSERTION.getQName())));
    }

    private Document removeSignatureTag(Document orig, Set<QName> qNames) throws DOMException {
        NodeList sigElements = orig.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        LinkedList<Node> nodesToRemove = new LinkedList<Node>();
        for (int i = 0; i < sigElements.getLength(); ++i) {
            Node n2 = sigElements.item(i);
            Node p = n2.getParentNode();
            QName q = new QName(p.getNamespaceURI(), p.getLocalName());
            if (!qNames.contains(q)) continue;
            nodesToRemove.add(n2);
        }
        nodesToRemove.forEach(n -> n.getParentNode().removeChild((Node)n));
        return orig;
    }

    private void loginAttackChangeSignature(boolean producerSignDocument, boolean producerSignAssertions, boolean producerEncryptAssertions) throws Exception {
        this.log.debug((Object)"");
        this.loginAttackChangeSignature("No changes to SAML document", producerSignDocument, producerSignAssertions, producerEncryptAssertions, t -> t, true);
        boolean validAfterTamperingWithDocumentSignature = !producerSignDocument || producerSignAssertions;
        this.loginAttackChangeSignature("Remove document signature", producerSignDocument, producerSignAssertions, producerEncryptAssertions, this::removeDocumentSignature, validAfterTamperingWithDocumentSignature);
        if (producerEncryptAssertions) {
            return;
        }
        boolean validAfterTamperingWithAssertionSignature = !producerSignAssertions;
        boolean validAfterTamperingWithBothDocumentAndAssertionSignature = !producerSignDocument && !producerSignAssertions;
        this.loginAttackChangeSignature("Remove assertion signature", producerSignDocument, producerSignAssertions, producerEncryptAssertions, this::removeAssertionSignature, validAfterTamperingWithAssertionSignature);
        this.loginAttackChangeSignature("Remove both document and assertion signature", producerSignDocument, producerSignAssertions, producerEncryptAssertions, this::removeDocumentAndAssertionSignature, validAfterTamperingWithBothDocumentAndAssertionSignature);
    }

    private void loginAttackChangeSignature(String description, boolean producerSignDocument, boolean producerSignAssertions, boolean producerEncryptAssertions, SamlDocumentStepBuilder.Saml2DocumentTransformer tr, boolean shouldSucceed) throws Exception {
        this.log.infof("producerSignDocument: %s, producerSignAssertions: %s, producerEncryptAssertions: %s", (Object)producerSignDocument, (Object)producerSignAssertions, (Object)producerEncryptAssertions);
        Matcher responseFromConsumerMatcher = shouldSucceed ? Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"Update Account Information")) : org.hamcrest.Matchers.not((Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"Update Account Information")));
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        this.withSignedEncryptedAssertions(() -> ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).build().login().user(this.bc.getUserLogin(), this.bc.getUserPassword()).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(tr)).build().execute(currentResponse -> Assert.assertThat((String)description, (Object)currentResponse, (Matcher)responseFromConsumerMatcher)), producerSignDocument, producerSignAssertions, producerEncryptAssertions);
    }

    @Test
    public void testSignatureDataWhenWantsRequestsSigned() throws Exception {
        String providerCert = KeyUtils.getActiveSigningKey((KeysMetadataRepresentation)this.adminClient.realm(this.bc.providerRealmName()).keys().getKeyMetadata(), (String)"RS256").getCertificate();
        Assert.assertThat((Object)providerCert, (Matcher)org.hamcrest.Matchers.notNullValue());
        String consumerCert = KeyUtils.getActiveSigningKey((KeysMetadataRepresentation)this.adminClient.realm(this.bc.consumerRealmName()).keys().getKeyMetadata(), (String)"RS256").getCertificate();
        Assert.assertThat((Object)consumerCert, (Matcher)org.hamcrest.Matchers.notNullValue());
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("validateSignature", Boolean.toString(true)).setAttribute("wantAssertionsSigned", Boolean.toString(true)).setAttribute("wantAssertionsEncrypted", Boolean.toString(false)).setAttribute("wantAuthnRequestsSigned", "true").setAttribute("signingCertificate", "MIICMTCCAZqgAwIBAgIJAPlizW20Nhe6MA0GCSqGSIb3DQEBCwUAMDAxLjAsBgNVBAMMJWh0dHA6Ly9sb2NhbGhvc3Q6ODA4MC9zYWxlcy1wb3N0LXNpZy8wHhcNMTYwODI5MDg1MjMzWhcNMTYwODMwMDg1MjMzWjAwMS4wLAYDVQQDDCVodHRwOi8vbG9jYWxob3N0OjgwODAvc2FsZXMtcG9zdC1zaWcvMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDKxs0adx1X+k4u+a5eZjwD17mvADwgiwDYpMznfNlSNEfDJdFAHIZH0VAbwXnaGySJ/a/MMMTHly5irDMp1udkmHgv2ceW+SumsjEtxliSIKi6af59aYlHiOLGyV5VI/VLVvkE6Roax7fZ+7O858KDahg1JI5smYnpBLKY3X885QIDAQABo1MwUTAdBgNVHQ4EFgQUE9C6Ck0jsdY+sjN064ZYwYkZJr4wHwYDVR0jBBgwFoAUE9C6Ck0jsdY+sjN064ZYwYkZJr4wDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQsFAAOBgQBuypHw5DMDBgfI6LcXBiCjpiQP3DLRLdwthh/RfCnZT7PrhXRJV8RMm8EqxqtEgfg2SKqMyA02uxMKH0p277U2iQveSDAaICTJRxtyFm6FERtgLNlsekusC2I14gZpLe84oHDf6L1w3dKFzzLEC9+bHg/XCg/KthWxW8iuVct5qg==").update();
             ServerResourceUpdater clientUpdater = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)this.bc.providerRealmName(), (String)this.bc.getIDPClientIdInProviderRealm()).setAttribute("saml.encrypt", Boolean.toString(false)).setAttribute("saml.server.signature", "true").setAttribute("saml.assertion.signature", Boolean.toString(true)).setAttribute("saml.client.signature", "false").update();){
            AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
            Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
            ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().transformDocument(this::extractNamespacesToTopLevelElement)).transformDocument(document -> {
                try {
                    Element signatureElement = DocumentUtil.getDirectChildElement((Element)document.getDocumentElement(), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
                    Assert.assertThat((String)"Signature element not found in request document", (Object)signatureElement, (Matcher)org.hamcrest.Matchers.notNullValue());
                    Element keyInfoElement = DocumentUtil.getDirectChildElement((Element)signatureElement, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"KeyInfo");
                    Assert.assertThat((String)"KeyInfo element not found in request Signature element", (Object)keyInfoElement, (Matcher)org.hamcrest.Matchers.notNullValue());
                    Element x509DataElement = DocumentUtil.getDirectChildElement((Element)keyInfoElement, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"X509Data");
                    Assert.assertThat((String)"X509Data element not found in request Signature/KeyInfo element", (Object)x509DataElement, (Matcher)org.hamcrest.Matchers.notNullValue());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            })).build().execute();
        }
    }

    public class KcSamlSignedBrokerConfiguration
    extends KcSamlBrokerConfiguration {
        @Override
        public RealmRepresentation createProviderRealm() {
            RealmRepresentation realm = super.createProviderRealm();
            realm.setPublicKey("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAgj8r0029eL0jJKXv6XbNj+QqsZO25HhZ0IjTEtb8mfh0tju/X8c6dXgILh5wU7OF00U+0mSYSE/+rrYKmY5g4oCleTe1+abavATP1tamtXGAUYqdutaXPrVn9yMsCWEPchSPZlEGq5iBJdA+xh9ejUmZJYXmln26HUVWq71/jC9GpjbRmFQ37f0X7WJoGyiqyttfKkKfUeBmRbX/0P0Zm6DVze8HjCDVPBllZE0a3HCgSF0rp0+s1xn7o91qdWKVattAVsGNjjDPz/sgwHOyyhDtSyajwXU+K/QUZ9pV4moGtwC9uIEymTylP7bu7qnxXIhfouEa+fEjAzTs0HJ5JQIDAQAB");
            realm.setPrivateKey("MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCCPyvTTb14vSMkpe/pds2P5Cqxk7bkeFnQiNMS1vyZ+HS2O79fxzp1eAguHnBTs4XTRT7SZJhIT/6utgqZjmDigKV5N7X5ptq8BM/W1qa1cYBRip261pc+tWf3IywJYQ9yFI9mUQarmIEl0D7GH16NSZklheaWfbodRVarvX+ML0amNtGYVDft/RftYmgbKKrK218qQp9R4GZFtf/Q/RmboNXN7weMINU8GWVkTRrccKBIXSunT6zXGfuj3Wp1YpVq20BWwY2OMM/P+yDAc7LKEO1LJqPBdT4r9BRn2lXiaga3AL24gTKZPKU/tu7uqfFciF+i4Rr58SMDNOzQcnklAgMBAAECggEAc0eibJYEO5d8QXW1kPgcHV2gBChv2mxDYnWYDLbIQSdNdfYP/qABt/MTmm5KkWr16fcCEYoD1w0mqFBrtVn1msSusUmEAYGTXJMNumOmjjX1kzaTQMmqeFBrwqwYz/xehWR5P+A7fSmwNV3KEeW19GvN5w5K96w0TLAQdFV3TQVPSytusDunwuR1yltMe1voaEDZ9z0Pi08YiEk2f6xhj5CMkoiw3mNImzfruphHullxU4FD05fH6tDeJ381527ILpAzDsgYZh4aFLKjUHem96bX4EL7FIzBJ6okgN78AZnUC/EaVfgFTw0qfhoWvZV4ruVXXiMhCg4CMMRDq/k9iQKBgQDBNWsJMT84OnnWmQoJmZogkFV+tsGrSK6Re+aJxLWpishh7dwAnT2OcagZvVdUb0FwNWu1D0B9/SKDDMRnnHBhOGDpH57m/eQdRU0oX1BD27xvffk0lLcfD4BTxnR5e9jss8K4twc9jf0P1rxC/loGJ2NtCH0BrPHgz54Ea+96ewKBgQCsk3JDaaPnFwzVYm2BXlhxOxLPsF4wvD2rIRAswZV4C5xebjand8nwiMmVpNd0PRLkEnkI+waURGv2EY/P3JsssoiY8Xqe8f/1G+SQKre7lbqOas8rFoALepC0BYDiZDFy0Z9ZnRAFzRI5sgIt7jpoMRD4xDNlmiV8X+yBxc3Y3wKBgQChDQsU1YUyNKQ8+sLAL9anEEkD4Ald4q8JPHN2IY+gLLxNzT0XEfsu0pTiJ8805axxgUYv3e/PVYNAJBNPnrqaf6lgiegl+jr9Hzhqz9CTUAYqFaL2boSakoxQyNtsLI0s+cb1vDN/3uy0GDZDzcty18BsMagqDmRtFgNNAj/UIwKBgQCahbeFBv0cOPZjxisY8Bou4N8aGehsqNBq/0LVYExuXa8YmoTTdJ3bgw9Er4G/ccQNdUDsuqAMeCtW/CiRzQ0ge4d1sprB4Rv3I4+HSsiS7SFKzfZLtWzXWlpg5qCdlWr1TR7qhYjIOPO9t1beO3YOvwhcRoliyyAPenBxTmTfbwKBgDtm2WJ5VlQgNpIdOs1CCiqd0DFmWOmvBPspPC1kySiy+Ndr9jNohRZkR7pEjgqA5E8rdzc88LirUN7bY5HFHRWN9KXrs5/o3O1K3GFCp64N6nvnPEYZ2zSJalcMC2fjSsJg26z8Dg1H+gfTIDUMoGiEAAnJXuqk+WayPU+fZMLn");
            return realm;
        }

        @Override
        public RealmRepresentation createConsumerRealm() {
            RealmRepresentation realm = super.createConsumerRealm();
            realm.setPublicKey("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAgj8r0029eL0jJKXv6XbNj+QqsZO25HhZ0IjTEtb8mfh0tju/X8c6dXgILh5wU7OF00U+0mSYSE/+rrYKmY5g4oCleTe1+abavATP1tamtXGAUYqdutaXPrVn9yMsCWEPchSPZlEGq5iBJdA+xh9ejUmZJYXmln26HUVWq71/jC9GpjbRmFQ37f0X7WJoGyiqyttfKkKfUeBmRbX/0P0Zm6DVze8HjCDVPBllZE0a3HCgSF0rp0+s1xn7o91qdWKVattAVsGNjjDPz/sgwHOyyhDtSyajwXU+K/QUZ9pV4moGtwC9uIEymTylP7bu7qnxXIhfouEa+fEjAzTs0HJ5JQIDAQAB");
            realm.setPrivateKey("MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCCPyvTTb14vSMkpe/pds2P5Cqxk7bkeFnQiNMS1vyZ+HS2O79fxzp1eAguHnBTs4XTRT7SZJhIT/6utgqZjmDigKV5N7X5ptq8BM/W1qa1cYBRip261pc+tWf3IywJYQ9yFI9mUQarmIEl0D7GH16NSZklheaWfbodRVarvX+ML0amNtGYVDft/RftYmgbKKrK218qQp9R4GZFtf/Q/RmboNXN7weMINU8GWVkTRrccKBIXSunT6zXGfuj3Wp1YpVq20BWwY2OMM/P+yDAc7LKEO1LJqPBdT4r9BRn2lXiaga3AL24gTKZPKU/tu7uqfFciF+i4Rr58SMDNOzQcnklAgMBAAECggEAc0eibJYEO5d8QXW1kPgcHV2gBChv2mxDYnWYDLbIQSdNdfYP/qABt/MTmm5KkWr16fcCEYoD1w0mqFBrtVn1msSusUmEAYGTXJMNumOmjjX1kzaTQMmqeFBrwqwYz/xehWR5P+A7fSmwNV3KEeW19GvN5w5K96w0TLAQdFV3TQVPSytusDunwuR1yltMe1voaEDZ9z0Pi08YiEk2f6xhj5CMkoiw3mNImzfruphHullxU4FD05fH6tDeJ381527ILpAzDsgYZh4aFLKjUHem96bX4EL7FIzBJ6okgN78AZnUC/EaVfgFTw0qfhoWvZV4ruVXXiMhCg4CMMRDq/k9iQKBgQDBNWsJMT84OnnWmQoJmZogkFV+tsGrSK6Re+aJxLWpishh7dwAnT2OcagZvVdUb0FwNWu1D0B9/SKDDMRnnHBhOGDpH57m/eQdRU0oX1BD27xvffk0lLcfD4BTxnR5e9jss8K4twc9jf0P1rxC/loGJ2NtCH0BrPHgz54Ea+96ewKBgQCsk3JDaaPnFwzVYm2BXlhxOxLPsF4wvD2rIRAswZV4C5xebjand8nwiMmVpNd0PRLkEnkI+waURGv2EY/P3JsssoiY8Xqe8f/1G+SQKre7lbqOas8rFoALepC0BYDiZDFy0Z9ZnRAFzRI5sgIt7jpoMRD4xDNlmiV8X+yBxc3Y3wKBgQChDQsU1YUyNKQ8+sLAL9anEEkD4Ald4q8JPHN2IY+gLLxNzT0XEfsu0pTiJ8805axxgUYv3e/PVYNAJBNPnrqaf6lgiegl+jr9Hzhqz9CTUAYqFaL2boSakoxQyNtsLI0s+cb1vDN/3uy0GDZDzcty18BsMagqDmRtFgNNAj/UIwKBgQCahbeFBv0cOPZjxisY8Bou4N8aGehsqNBq/0LVYExuXa8YmoTTdJ3bgw9Er4G/ccQNdUDsuqAMeCtW/CiRzQ0ge4d1sprB4Rv3I4+HSsiS7SFKzfZLtWzXWlpg5qCdlWr1TR7qhYjIOPO9t1beO3YOvwhcRoliyyAPenBxTmTfbwKBgDtm2WJ5VlQgNpIdOs1CCiqd0DFmWOmvBPspPC1kySiy+Ndr9jNohRZkR7pEjgqA5E8rdzc88LirUN7bY5HFHRWN9KXrs5/o3O1K3GFCp64N6nvnPEYZ2zSJalcMC2fjSsJg26z8Dg1H+gfTIDUMoGiEAAnJXuqk+WayPU+fZMLn");
            return realm;
        }

        @Override
        public List<ClientRepresentation> createProviderClients() {
            List<ClientRepresentation> clientRepresentationList = super.createProviderClients();
            String consumerCert = KeyUtils.getActiveSigningKey((KeysMetadataRepresentation)KcSamlSignedBrokerTest.this.adminClient.realm(this.consumerRealmName()).keys().getKeyMetadata(), (String)"RS256").getCertificate();
            Assert.assertThat((Object)consumerCert, (Matcher)org.hamcrest.Matchers.notNullValue());
            for (ClientRepresentation client : clientRepresentationList) {
                client.setClientAuthenticatorType("client-secret");
                client.setSurrogateAuthRequired(Boolean.valueOf(false));
                HashMap<String, String> attributes = client.getAttributes();
                if (attributes == null) {
                    attributes = new HashMap<String, String>();
                    client.setAttributes(attributes);
                }
                attributes.put("saml.assertion.signature", "true");
                attributes.put("saml.server.signature", "true");
                attributes.put("saml.client.signature", "true");
                attributes.put("saml.signature.algorithm", "RSA_SHA256");
                attributes.put("saml.signing.certificate", consumerCert);
            }
            return clientRepresentationList;
        }

        @Override
        public IdentityProviderRepresentation setUpIdentityProvider(IdentityProviderSyncMode syncMode) {
            IdentityProviderRepresentation result = super.setUpIdentityProvider(syncMode);
            String providerCert = KeyUtils.getActiveSigningKey((KeysMetadataRepresentation)KcSamlSignedBrokerTest.this.adminClient.realm(this.providerRealmName()).keys().getKeyMetadata(), (String)"RS256").getCertificate();
            Assert.assertThat((Object)providerCert, (Matcher)org.hamcrest.Matchers.notNullValue());
            Map config = result.getConfig();
            config.put("validateSignature", "true");
            config.put("wantAssertionsSigned", "true");
            config.put("wantAuthnRequestsSigned", "true");
            config.put("signingCertificate", providerCert);
            return result;
        }
    }
}

