/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.io.Closeable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.dom.saml.v2.protocol.AuthnContextComparisonType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.updaters.IdentityProviderAttributeUpdater;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class KcSamlRequestedAuthnContextBrokerTest
extends AbstractBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcSamlBrokerConfiguration.INSTANCE;
    }

    @Test
    public void testNoComparisonTypeNoClassRefsAndNoDeclRefs() throws Exception {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).update();){
            AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
            Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().transformDocument(document -> {
                try {
                    this.log.infof("Document: %s", (Object)DocumentUtil.asString((Document)document));
                    Element requestedAuthnContextElement = DocumentUtil.getDirectChildElement((Element)document.getDocumentElement(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get(), (String)"RequestedAuthnContext");
                    Assert.assertThat((String)"RequestedAuthnContext element found in request document, but was not necessary as ClassRef/DeclRefs were not specified", (Object)requestedAuthnContextElement, (Matcher)Matchers.nullValue());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            })).build().execute();
        }
    }

    @Test
    public void testComparisonTypeSetNoClassRefsAndNoDeclRefs() throws Exception {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("authnContextComparisonType", AuthnContextComparisonType.MINIMUM.value()).update();){
            AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
            Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().transformDocument(document -> {
                try {
                    this.log.infof("Document: %s", (Object)DocumentUtil.asString((Document)document));
                    Element requestedAuthnContextElement = DocumentUtil.getDirectChildElement((Element)document.getDocumentElement(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get(), (String)"RequestedAuthnContext");
                    Assert.assertThat((String)"RequestedAuthnContext element found in request document, but was not necessary as ClassRef/DeclRefs were not specified", (Object)requestedAuthnContextElement, (Matcher)Matchers.nullValue());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            })).build().execute();
        }
    }

    @Test
    public void testComparisonTypeSetClassRefsSetNoDeclRefs() throws Exception {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("authnContextComparisonType", AuthnContextComparisonType.EXACT.value()).setAttribute("authnContextClassRefs", "[\"" + JBossSAMLURIConstants.AC_PASSWORD_PROTECTED_TRANSPORT.get() + "\"]").update();){
            AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
            Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().transformDocument(document -> {
                try {
                    this.log.infof("Document: %s", (Object)DocumentUtil.asString((Document)document));
                    Element requestedAuthnContextElement = DocumentUtil.getDirectChildElement((Element)document.getDocumentElement(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get(), (String)"RequestedAuthnContext");
                    Assert.assertThat((String)"RequestedAuthnContext element not found in request document", (Object)requestedAuthnContextElement, (Matcher)Matchers.notNullValue());
                    Assert.assertThat((String)"RequestedAuthnContext element not found in request document", (Object)requestedAuthnContextElement.getAttribute("Comparison"), (Matcher)Matchers.is((Object)AuthnContextComparisonType.EXACT.value()));
                    Element requestedAuthnContextClassRefElement = DocumentUtil.getDirectChildElement((Element)requestedAuthnContextElement, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get(), (String)"AuthnContextClassRef");
                    Assert.assertThat((String)"RequestedAuthnContext/AuthnContextClassRef element not found in request document", (Object)requestedAuthnContextClassRefElement, (Matcher)Matchers.notNullValue());
                    Assert.assertThat((String)"RequestedAuthnContext/AuthnContextClassRef element does not have the expected value", (Object)requestedAuthnContextClassRefElement.getTextContent(), (Matcher)Matchers.is((Object)JBossSAMLURIConstants.AC_PASSWORD_PROTECTED_TRANSPORT.get()));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            })).build().execute();
        }
    }

    @Test
    public void testComparisonTypeSetNoClassRefsDeclRefsSet() throws Exception {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("authnContextComparisonType", AuthnContextComparisonType.MINIMUM.value()).setAttribute("authnContextDeclRefs", "[\"secure/name/password/icmaolr/uri\"]").update();){
            AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
            Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().transformDocument(document -> {
                try {
                    this.log.infof("Document: %s", (Object)DocumentUtil.asString((Document)document));
                    Element requestedAuthnContextElement = DocumentUtil.getDirectChildElement((Element)document.getDocumentElement(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get(), (String)"RequestedAuthnContext");
                    Assert.assertThat((String)"RequestedAuthnContext element not found in request document", (Object)requestedAuthnContextElement, (Matcher)Matchers.notNullValue());
                    Assert.assertThat((String)"RequestedAuthnContext element not found in request document", (Object)requestedAuthnContextElement.getAttribute("Comparison"), (Matcher)Matchers.is((Object)AuthnContextComparisonType.MINIMUM.value()));
                    Element requestedAuthnContextDeclRefElement = DocumentUtil.getDirectChildElement((Element)requestedAuthnContextElement, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get(), (String)"AuthnContextDeclRef");
                    Assert.assertThat((String)"RequestedAuthnContext/AuthnContextDeclRef element not found in request document", (Object)requestedAuthnContextDeclRefElement, (Matcher)Matchers.notNullValue());
                    Assert.assertThat((String)"RequestedAuthnContext/AuthnContextDeclRef element does not have the expected value", (Object)requestedAuthnContextDeclRefElement.getTextContent(), (Matcher)Matchers.is((Object)"secure/name/password/icmaolr/uri"));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            })).build().execute();
        }
    }

    @Test
    public void testNoComparisonTypeClassRefsSetNoDeclRefs() throws Exception {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("authnContextClassRefs", "[\"" + JBossSAMLURIConstants.AC_PASSWORD_PROTECTED_TRANSPORT.get() + "\"]").update();){
            AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
            Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
            ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().transformDocument(document -> {
                try {
                    this.log.infof("Document: %s", (Object)DocumentUtil.asString((Document)document));
                    Element requestedAuthnContextElement = DocumentUtil.getDirectChildElement((Element)document.getDocumentElement(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get(), (String)"RequestedAuthnContext");
                    Assert.assertThat((String)"RequestedAuthnContext element not found in request document", (Object)requestedAuthnContextElement, (Matcher)Matchers.notNullValue());
                    Assert.assertThat((String)"RequestedAuthnContext element not found in request document", (Object)requestedAuthnContextElement.getAttribute("Comparison"), (Matcher)Matchers.is((Object)AuthnContextComparisonType.EXACT.value()));
                    Element requestedAuthnContextClassRefElement = DocumentUtil.getDirectChildElement((Element)requestedAuthnContextElement, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get(), (String)"AuthnContextClassRef");
                    Assert.assertThat((String)"RequestedAuthnContext/AuthnContextClassRef element not found in request document", (Object)requestedAuthnContextClassRefElement, (Matcher)Matchers.notNullValue());
                    Assert.assertThat((String)"RequestedAuthnContext/AuthnContextClassRef element does not have the expected value", (Object)requestedAuthnContextClassRefElement.getTextContent(), (Matcher)Matchers.is((Object)JBossSAMLURIConstants.AC_PASSWORD_PROTECTED_TRANSPORT.get()));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            })).build().execute();
        }
    }
}

