/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.protocol.saml.SamlPrincipalType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.IdentityProviderAttributeUpdater;
import org.keycloak.testsuite.updaters.UserAttributeUpdater;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.keycloak.testsuite.util.saml.SamlMessageReceiver;
import org.w3c.dom.Document;

public class KcSamlLogoutTest
extends AbstractInitializedBaseBrokerTest {
    private static final String PROVIDER_SAML_CLIENT_ID = BrokerTestTools.getProviderRoot() + "/sales-post/";

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcSamlBrokerConfiguration(false){

            @Override
            public List<ClientRepresentation> createProviderClients() {
                List<ClientRepresentation> superClients = super.createProviderClients();
                ClientRepresentation providerSamlClient = ClientBuilder.create().clientId(PROVIDER_SAML_CLIENT_ID).enabled(true).fullScopeEnabled(true).protocol("saml").baseUrl(BrokerTestTools.getProviderRoot() + "/sales-post").addRedirectUri(BrokerTestTools.getProviderRoot() + "/sales-post/*").attribute("saml.authnstatement", "true").attribute("saml.client.signature", "false").frontchannelLogout(true).build();
                superClients.add(providerSamlClient);
                return superClients;
            }
        };
    }

    @Test
    public void testProviderInitiatedLogoutCorrectlyLogsOutConsumerClients() throws Exception {
        try (SamlMessageReceiver logoutReceiver = new SamlMessageReceiver(8082);
             ClientAttributeUpdater cauConsumer = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)this.bc.consumerRealmName(), (String)"http://localhost:8280/sales-post/").setFrontchannelLogout(Boolean.valueOf(false)).setAttribute("saml_single_logout_service_url_post", logoutReceiver.getUrl()).update();
             ClientAttributeUpdater cauProvider = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)this.bc.providerRealmName(), (String)this.bc.getIDPClientIdInProviderRealm()).setFrontchannelLogout(Boolean.valueOf(true)).update();){
            AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
            Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
            AtomicReference nameIdRef = new AtomicReference();
            AtomicReference sessionIndexRef = new AtomicReference();
            ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user(this.bc.getUserLogin(), this.bc.getUserPassword()).build().processSamlResponse(SamlClient.Binding.POST).build().updateProfile().firstName("a").lastName("b").email(this.bc.getUserEmail()).username(this.bc.getUserLogin()).build().followOneRedirect().processSamlResponse(SamlClient.Binding.POST).transformObject(saml2Object -> {
                MatcherAssert.assertThat((Object)saml2Object, (Matcher)org.hamcrest.Matchers.notNullValue());
                MatcherAssert.assertThat((Object)saml2Object, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
                return null;
            })).build().authnRequest(this.getProviderSamlEndpoint(this.bc.providerRealmName()), PROVIDER_SAML_CLIENT_ID, PROVIDER_SAML_CLIENT_ID + "saml", SamlClient.Binding.POST).build().followOneRedirect().processSamlResponse(SamlClient.Binding.POST).transformObject(saml2Object -> {
                MatcherAssert.assertThat((Object)saml2Object, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
                ResponseType loginResp1 = (ResponseType)saml2Object;
                AssertionType firstAssertion = ((ResponseType.RTChoiceType)loginResp1.getAssertions().get(0)).getAssertion();
                MatcherAssert.assertThat((Object)firstAssertion, (Matcher)org.hamcrest.Matchers.notNullValue());
                MatcherAssert.assertThat((Object)firstAssertion.getSubject().getSubType().getBaseID(), (Matcher)CoreMatchers.instanceOf(NameIDType.class));
                NameIDType nameId = (NameIDType)firstAssertion.getSubject().getSubType().getBaseID();
                AuthnStatementType firstAssertionStatement = (AuthnStatementType)firstAssertion.getStatements().iterator().next();
                nameIdRef.set(nameId);
                sessionIndexRef.set(firstAssertionStatement.getSessionIndex());
                return null;
            })).build().logoutRequest(this.getProviderSamlEndpoint(this.bc.providerRealmName()), PROVIDER_SAML_CLIENT_ID, SamlClient.Binding.POST).nameId(nameIdRef::get).sessionIndex(sessionIndexRef::get).build().processSamlResponse(SamlClient.Binding.POST).transformObject(saml2Object -> {
                MatcherAssert.assertThat((Object)saml2Object, (Matcher)Matchers.isSamlLogoutRequest((String)(BrokerTestTools.getConsumerRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-saml-idp" + "/endpoint")));
                return saml2Object;
            })).build().executeAndTransform(response -> {
                SAMLDocumentHolder saml2ObjectHolder = SamlClient.Binding.POST.extractResponse(response);
                MatcherAssert.assertThat((Object)saml2ObjectHolder.getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
                return null;
            });
            MatcherAssert.assertThat((Object)logoutReceiver.isMessageReceived(), (Matcher)CoreMatchers.is((Object)true));
            SAMLDocumentHolder message = logoutReceiver.getSamlDocumentHolder();
            MatcherAssert.assertThat((Object)message.getSamlObject(), (Matcher)Matchers.isSamlLogoutRequest((String)logoutReceiver.getUrl()));
        }
    }

    @Test
    public void testProviderInitiatedLogoutCorrectlyLogsOutConsumerClientsWhenPrincipalTypeAttribute() throws Exception {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("principalType", SamlPrincipalType.ATTRIBUTE.name()).setAttribute("principalAttribute", "user-attribute").update();
             UserAttributeUpdater uau = (UserAttributeUpdater)UserAttributeUpdater.forUserByUsername((Keycloak)this.adminClient, (String)this.bc.providerRealmName(), (String)this.bc.getUserLogin()).setAttribute("user-attribute", new String[]{"masked_principal_for_consumer_idp"}).update();){
            this.testProviderInitiatedLogoutCorrectlyLogsOutConsumerClients();
        }
    }
}

