/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.security.PublicKey;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.PemUtils;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.RandomSecret;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.util.XMLEncryptionUtil;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KcSamlEncryptedIdTest
extends AbstractBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcSamlBrokerConfiguration.INSTANCE;
    }

    @Test
    public void testEncryptedIdIsReadable() throws ConfigurationException, ParsingException, ProcessingException {
        this.createRolesForRealm(this.bc.consumerRealmName());
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/.dot/ted", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        AtomicReference username = new AtomicReference();
        MatcherAssert.assertThat((Object)this.adminClient.realm(this.bc.consumerRealmName()).users().search((String)username.get()), (Matcher)org.hamcrest.Matchers.hasSize((int)0));
        SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user(this.bc.getUserLogin(), this.bc.getUserPassword()).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(document -> {
            Node assertionElement = document.getDocumentElement().getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get()).item(0);
            if (assertionElement == null) {
                throw new IllegalStateException("Unable to find assertion in saml response document");
            }
            String samlNSPrefix = assertionElement.getPrefix();
            try {
                QName encryptedIdElementQName = new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ENCRYPTED_ID.get(), samlNSPrefix);
                QName nameIdQName = new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.NAMEID.get(), samlNSPrefix);
                Element nameIdElement = DocumentUtil.getElement((Document)document, (QName)nameIdQName);
                if (nameIdElement == null) {
                    throw new RuntimeException("Assertion doesn't contain NameId " + DocumentUtil.asString((Document)document));
                }
                nameIdElement.setAttribute("xmlns:" + samlNSPrefix, JBossSAMLURIConstants.ASSERTION_NSURI.get());
                username.set(nameIdElement.getTextContent());
                byte[] secret = RandomSecret.createRandomSecret((int)16);
                SecretKeySpec secretKey = new SecretKeySpec(secret, "AES");
                XMLEncryptionUtil.encryptElement((QName)nameIdQName, (Document)document, (PublicKey)PemUtils.decodePublicKey((String)ApiUtil.findActiveSigningKey((RealmResource)this.adminClient.realm(this.bc.consumerRealmName())).getPublicKey()), (SecretKey)secretKey, (int)128, (QName)encryptedIdElementQName, (boolean)true);
            }
            catch (Exception e) {
                throw new ProcessingException("failed to encrypt", (Throwable)e);
            }
            MatcherAssert.assertThat((Object)DocumentUtil.asString((Document)document), (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.containsString((String)((String)username.get()))));
            return document;
        })).build().updateProfile().firstName("a").lastName("b").email(this.bc.getUserEmail()).build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
        MatcherAssert.assertThat((Object)samlResponse, (Matcher)org.hamcrest.Matchers.notNullValue());
        MatcherAssert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        MatcherAssert.assertThat((Object)this.adminClient.realm(this.bc.consumerRealmName()).users().search((String)username.get()), (Matcher)org.hamcrest.Matchers.hasSize((int)1));
    }
}

