/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import org.junit.Test;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.broker.AbstractSamlLoginHintTest;
import org.keycloak.testsuite.broker.BrokerTestTools;

public class KcSamlBrokerLoginHintWithOptionEnabledTest
extends AbstractSamlLoginHintTest {
    @Test
    public void testPassLoginHintWithXmlCharShouldEncodeIt() {
        String username = "all-info-set@localhost.com";
        this.createUser(this.bc.providerRealmName(), username, "password", "FirstName");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        String fishyLoginHint = "<an-xml-tag>";
        this.addLoginHintOnSocialButton(fishyLoginHint);
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        org.junit.Assert.assertEquals((String)"Username input should contain the SAML subject", (Object)this.loginPage.getUsername(), (Object)fishyLoginHint);
    }

    @Override
    boolean isLoginHintOptionEnabled() {
        return true;
    }
}

