/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.ws.rs.core.Response;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.ReverseProxy;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;

public final class KcSamlBrokerFrontendUrlTest
extends AbstractBrokerTest {
    @Rule
    public ReverseProxy proxy = new ReverseProxy();
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcSamlBrokerConfiguration(){

            @Override
            public RealmRepresentation createConsumerRealm() {
                RealmRepresentation realm = super.createConsumerRealm();
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("frontendUrl", KcSamlBrokerFrontendUrlTest.this.proxy.getUrl());
                realm.setAttributes(attributes);
                return realm;
            }

            @Override
            public List<ClientRepresentation> createProviderClients() {
                List<ClientRepresentation> clients = super.createProviderClients();
                ArrayList<String> redirectUris = new ArrayList<String>();
                redirectUris.add(KcSamlBrokerFrontendUrlTest.this.proxy.getUrl() + "/realms/" + "consumer" + "/broker/" + "kc-saml-idp" + "/endpoint/*");
                clients.get(0).setRedirectUris(redirectUris);
                return clients;
            }

            @Override
            public String getIDPClientIdInProviderRealm() {
                return KcSamlBrokerFrontendUrlTest.this.proxy.getUrl() + "/realms/" + this.consumerRealmName();
            }
        };
    }

    private SamlClientBuilder clientBuilderTrustingAllCertificates() {
        return new SamlClientBuilder(){

            protected SamlClient createSamlClient() {
                return new SamlClient(){

                    protected HttpClientBuilder createHttpClientBuilderInstance() {
                        try {
                            return super.createHttpClientBuilderInstance().setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build()).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                        }
                        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    @Override
    @Test
    public void testLogInAsUserInIDP() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.createUser(this.bc.consumerRealmName(), "consumer", "password", "FirstName", "LastName", "consumer@localhost.com");
        this.driver.navigate().to(this.proxy.getUrl() + "/realms/consumer/account");
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        this.log.debug((Object)"Logging in");
        try {
            MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)CoreMatchers.containsString((String)("client_id=" + URLEncoder.encode(this.proxy.getUrl(), "UTF-8"))));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        BrokerTestTools.waitForPage(this.driver, "account management", true);
        this.accountUpdateProfilePage.assertCurrent();
    }

    @Test
    public void testFrontendUrlInDestinationExpected() throws URISyntaxException {
        SAMLDocumentHolder samlResponse = ((ModifySamlResponseStepBuilder)this.clientBuilderTrustingAllCertificates().idpInitiatedLogin(new URI(this.proxy.getUrl() + "/realms/" + this.bc.consumerRealmName() + "/protocol/saml"), "sales-post").build().login().idp("kc-saml-idp").build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user("testuser", "password").build().processSamlResponse(SamlClient.Binding.POST).transformObject(saml2Object -> {
            MatcherAssert.assertThat((Object)saml2Object, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType response = (ResponseType)saml2Object;
            MatcherAssert.assertThat((Object)response.getDestination(), (Matcher)CoreMatchers.startsWith((String)this.proxy.getUrl()));
            return saml2Object;
        })).build().updateProfile().username("testuser").email("user@localhost.com").firstName("Firstname").lastName("Lastname").build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
        MatcherAssert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
    }

    @Test
    public void testKeycloakRejectsRealUrlWhenFrontendUrlConfigured() throws URISyntaxException {
        ((ModifySamlResponseStepBuilder)this.clientBuilderTrustingAllCertificates().idpInitiatedLogin(new URI(this.proxy.getUrl() + "/realms/" + this.bc.consumerRealmName() + "/protocol/saml"), "sales-post").build().login().idp("kc-saml-idp").build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user("testuser", "password").build().processSamlResponse(SamlClient.Binding.POST).transformObject(saml2Object -> {
            MatcherAssert.assertThat((Object)saml2Object, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType response = (ResponseType)saml2Object;
            MatcherAssert.assertThat((Object)response.getDestination(), (Matcher)CoreMatchers.startsWith((String)this.proxy.getUrl()));
            response.setDestination(BrokerTestTools.getConsumerRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-saml-idp" + "/endpoint");
            return saml2Object;
        })).build().execute(response -> {
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST));
            String consumerRealmId = this.realmsResouce().realm(this.bc.consumerRealmName()).toRepresentation().getId();
            this.events.expect(EventType.IDENTITY_PROVIDER_RESPONSE_ERROR).clearDetails().session((String)null).realm(consumerRealmId).user((String)null).client((String)null).error("invalid_saml_response").detail("reason", "invalid_destination").assertEvent();
            this.events.assertEmpty();
        });
    }

    @Override
    @Ignore
    @Test
    public void loginWithExistingUser() {
    }
}

