/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.util.ClientBuilder;

public class KcSamlBrokerConfiguration
implements BrokerConfiguration {
    public static final KcSamlBrokerConfiguration INSTANCE = new KcSamlBrokerConfiguration();
    public static final String ATTRIBUTE_TO_MAP_FRIENDLY_NAME = "user-attribute-friendly";
    private final boolean loginHint;

    public KcSamlBrokerConfiguration() {
        this(false);
    }

    public KcSamlBrokerConfiguration(boolean loginHint) {
        this.loginHint = loginHint;
    }

    @Override
    public RealmRepresentation createProviderRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setEnabled(Boolean.valueOf(true));
        realm.setRealm("provider");
        return realm;
    }

    @Override
    public RealmRepresentation createConsumerRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setEnabled(Boolean.valueOf(true));
        realm.setRealm("consumer");
        realm.setResetPasswordAllowed(Boolean.valueOf(true));
        realm.setEventsListeners(Arrays.asList("jboss-logging", "event-queue"));
        return realm;
    }

    @Override
    public List<ClientRepresentation> createProviderClients() {
        String clientId = this.getIDPClientIdInProviderRealm();
        return new LinkedList<ClientRepresentation>(Collections.singleton(this.createProviderClient(clientId)));
    }

    private ClientRepresentation createProviderClient(String clientId) {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientId);
        client.setEnabled(Boolean.valueOf(true));
        client.setProtocol("saml");
        client.setRedirectUris(Collections.singletonList(BrokerTestTools.getConsumerRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-saml-idp" + "/endpoint"));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("saml.authnstatement", "true");
        attributes.put("saml_single_logout_service_url_post", BrokerTestTools.getConsumerRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-saml-idp" + "/endpoint");
        attributes.put("saml_assertion_consumer_url_post", BrokerTestTools.getConsumerRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-saml-idp" + "/endpoint");
        attributes.put("saml_force_name_id_format", "true");
        attributes.put("saml_name_id_format", "username");
        attributes.put("saml.assertion.signature", "false");
        attributes.put("saml.server.signature", "false");
        attributes.put("saml.client.signature", "false");
        attributes.put("saml.encrypt", "false");
        attributes.put("loginHint", String.valueOf(this.loginHint));
        client.setAttributes(attributes);
        ProtocolMapperRepresentation emailMapper = new ProtocolMapperRepresentation();
        emailMapper.setName("email");
        emailMapper.setProtocol("saml");
        emailMapper.setProtocolMapper("saml-user-property-mapper");
        Map emailMapperConfig = emailMapper.getConfig();
        emailMapperConfig.put("user.attribute", "email");
        emailMapperConfig.put("attribute.name", "urn:oid:1.2.840.113549.1.9.1");
        emailMapperConfig.put("attribute.nameformat", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        emailMapperConfig.put("friendly.name", "email");
        ProtocolMapperRepresentation dottedAttrMapper = new ProtocolMapperRepresentation();
        dottedAttrMapper.setName("email - dotted");
        dottedAttrMapper.setProtocol("saml");
        dottedAttrMapper.setProtocolMapper("saml-user-attribute-mapper");
        Map dottedEmailMapperConfig = dottedAttrMapper.getConfig();
        dottedEmailMapperConfig.put("user.attribute", "dotted.email");
        dottedEmailMapperConfig.put("attribute.name", "dotted.email");
        dottedEmailMapperConfig.put("attribute.nameformat", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        ProtocolMapperRepresentation nestedAttrMapper = new ProtocolMapperRepresentation();
        nestedAttrMapper.setName("email - nested");
        nestedAttrMapper.setProtocol("saml");
        nestedAttrMapper.setProtocolMapper("saml-user-attribute-mapper");
        Map nestedEmailMapperConfig = nestedAttrMapper.getConfig();
        nestedEmailMapperConfig.put("user.attribute", "nested.email");
        nestedEmailMapperConfig.put("attribute.name", "nested.email");
        nestedEmailMapperConfig.put("attribute.nameformat", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        ProtocolMapperRepresentation userAttrMapper = new ProtocolMapperRepresentation();
        userAttrMapper.setName("attribute - name");
        userAttrMapper.setProtocol("saml");
        userAttrMapper.setProtocolMapper("saml-user-attribute-mapper");
        Map userAttrMapperConfig = userAttrMapper.getConfig();
        userAttrMapperConfig.put("user.attribute", "user-attribute");
        userAttrMapperConfig.put("attribute.name", "user-attribute");
        userAttrMapperConfig.put("attribute.nameformat", "Basic");
        userAttrMapperConfig.put("friendly.name", "");
        ProtocolMapperRepresentation userAttrMapper2 = new ProtocolMapperRepresentation();
        userAttrMapper2.setName("attribute - name 2");
        userAttrMapper2.setProtocol("saml");
        userAttrMapper2.setProtocolMapper("saml-user-attribute-mapper");
        Map userAttrMapper2Config = userAttrMapper2.getConfig();
        userAttrMapper2Config.put("user.attribute", "user-attribute-2");
        userAttrMapper2Config.put("attribute.name", "user-attribute-2");
        userAttrMapper2Config.put("attribute.nameformat", "Basic");
        userAttrMapper2Config.put("friendly.name", "");
        ProtocolMapperRepresentation userFriendlyAttrMapper = new ProtocolMapperRepresentation();
        userFriendlyAttrMapper.setName("attribute - friendly name");
        userFriendlyAttrMapper.setProtocol("saml");
        userFriendlyAttrMapper.setProtocolMapper("saml-user-attribute-mapper");
        Map userFriendlyAttrMapperConfig = userFriendlyAttrMapper.getConfig();
        userFriendlyAttrMapperConfig.put("user.attribute", ATTRIBUTE_TO_MAP_FRIENDLY_NAME);
        userFriendlyAttrMapperConfig.put("attribute.name", "urn:oid:1.2.3.4.5.6.7");
        userFriendlyAttrMapperConfig.put("attribute.nameformat", "Basic");
        userFriendlyAttrMapperConfig.put("friendly.name", ATTRIBUTE_TO_MAP_FRIENDLY_NAME);
        client.setProtocolMappers(Arrays.asList(emailMapper, dottedAttrMapper, nestedAttrMapper, userAttrMapper, userAttrMapper2, userFriendlyAttrMapper));
        return client;
    }

    @Override
    public List<ClientRepresentation> createConsumerClients() {
        return Arrays.asList(ClientBuilder.create().clientId("http://localhost:8280/sales-post/").enabled(true).fullScopeEnabled(true).protocol("saml").baseUrl(BrokerTestTools.getConsumerRoot() + "/sales-post").addRedirectUri(BrokerTestTools.getConsumerRoot() + "/sales-post/*").attribute("saml.authnstatement", "true").attribute("saml.client.signature", "false").build(), ClientBuilder.create().clientId("http://localhost:8280/sales-post/.dot/ted").enabled(true).fullScopeEnabled(true).protocol("saml").baseUrl(BrokerTestTools.getConsumerRoot() + "/sales-post").addRedirectUri(BrokerTestTools.getConsumerRoot() + "/sales-post/*").attribute("saml.authnstatement", "true").attribute("saml.client.signature", "false").attribute("saml_idp_initiated_sso_url_name", "sales-post").attribute("saml_assertion_consumer_url_post", BrokerTestTools.getConsumerRoot() + "/sales-post/saml").build(), ClientBuilder.create().clientId("broker-app").name("broker-app").secret("broker-app-secret").enabled(true).directAccessGrants().addRedirectUri(BrokerTestTools.getConsumerRoot() + "/auth/*").baseUrl(BrokerTestTools.getConsumerRoot() + "/auth/realms/" + "consumer" + "/app").build());
    }

    @Override
    public IdentityProviderRepresentation setUpIdentityProvider(IdentityProviderSyncMode syncMode) {
        IdentityProviderRepresentation idp = BrokerTestTools.createIdentityProvider("kc-saml-idp", "saml");
        idp.setTrustEmail(true);
        idp.setAddReadTokenRoleOnCreate(true);
        idp.setStoreToken(true);
        Map config = idp.getConfig();
        config.put("syncMode", syncMode.toString());
        config.put("singleSignOnServiceUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + "provider" + "/protocol/saml");
        config.put("singleLogoutServiceUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + "provider" + "/protocol/saml");
        config.put("nameIDPolicyFormat", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        config.put("forceAuthn", "false");
        config.put("loginHint", String.valueOf(this.loginHint));
        config.put("postBindingResponse", "true");
        config.put("postBindingAuthnRequest", "true");
        config.put("validateSignature", "false");
        config.put("wantAuthnRequestsSigned", "false");
        config.put("backchannelSupported", "false");
        return idp;
    }

    @Override
    public String providerRealmName() {
        return "provider";
    }

    @Override
    public String consumerRealmName() {
        return "consumer";
    }

    @Override
    public String getIDPClientIdInProviderRealm() {
        return BrokerTestTools.getConsumerRoot() + "/auth/realms/" + this.consumerRealmName();
    }

    @Override
    public String getUserLogin() {
        return "testuser";
    }

    @Override
    public String getUserPassword() {
        return "password";
    }

    @Override
    public String getUserEmail() {
        return "user@localhost.com";
    }

    @Override
    public String getIDPAlias() {
        return "kc-saml-idp";
    }
}

