/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.io.Closeable;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.updaters.IdentityProviderAttributeUpdater;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.w3c.dom.Document;

public class KcSamlBrokerAllowedClockSkewTest
extends AbstractInitializedBaseBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcSamlBrokerConfiguration.INSTANCE;
    }

    @Test
    public void loginClientExpiredResponseFromIdP() throws Exception {
        AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
        Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
        new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user(this.bc.getUserLogin(), this.bc.getUserPassword()).build().addStep(() -> this.setTimeOffset(-30)).processSamlResponse(SamlClient.Binding.POST).build().execute(hr -> Assert.assertThat((Object)hr, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST)));
    }

    @Test
    public void loginClientExpiredResponseFromIdPWithClockSkew() throws Exception {
        try (Closeable idpUpdater = new IdentityProviderAttributeUpdater(this.identityProviderResource).setAttribute("allowedClockSkew", "60").update();){
            AuthnRequestType loginRep = SamlClient.createLoginRequestDocument((String)"http://localhost:8280/sales-post/", (String)(BrokerTestTools.getConsumerRoot() + "/sales-post/saml"), null);
            Document doc = SAML2Request.convert((RequestAbstractType)loginRep);
            SAMLDocumentHolder samlResponse = new SamlClientBuilder().authnRequest(this.getConsumerSamlEndpoint(this.bc.consumerRealmName()), doc, SamlClient.Binding.POST).build().login().idp(this.bc.getIDPAlias()).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlRequest().build().login().user(this.bc.getUserLogin(), this.bc.getUserPassword()).build().addStep(() -> this.setTimeOffset(-30)).processSamlResponse(SamlClient.Binding.POST).build().updateProfile().firstName("a").lastName("b").email(this.bc.getUserEmail()).username(this.bc.getUserLogin()).build().followOneRedirect().getSamlResponse(SamlClient.Binding.POST);
            Assert.assertThat((Object)samlResponse, (Matcher)org.hamcrest.Matchers.notNullValue());
            Assert.assertThat((Object)samlResponse.getSamlObject(), (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        }
    }
}

