/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractAdvancedRoleMapperTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;

public class KcSamlAdvancedAttributeToRoleMapperTest
extends AbstractAdvancedRoleMapperTest {
    private static final String ATTRIBUTES = "[\n  {\n    \"key\": \"user-attribute-friendly\",\n    \"value\": \"value 1\"\n  },\n  {\n    \"key\": \"user-attribute-2\",\n    \"value\": \"value 2\"\n  }\n]";

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcSamlBrokerConfiguration();
    }

    @Override
    protected void createMapperInIdp(IdentityProviderRepresentation idp, String claimsOrAttributeRepresentation, boolean areClaimsOrAttributeValuesRegexes, IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation advancedAttributeToRoleMapper = new IdentityProviderMapperRepresentation();
        advancedAttributeToRoleMapper.setName("advanced-attribute-to-role-mapper");
        advancedAttributeToRoleMapper.setIdentityProviderMapper("saml-advanced-role-idp-mapper");
        advancedAttributeToRoleMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"attributes", (Object)claimsOrAttributeRepresentation).put((Object)"are.attribute.values.regex", (Object)(areClaimsOrAttributeValuesRegexes ? "true" : "false")).put((Object)"role", (Object)"realm-management.view-realm").build());
        IdentityProviderResource idpResource = this.realm.identityProviders().get(idp.getAlias());
        advancedAttributeToRoleMapper.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(advancedAttributeToRoleMapper).close();
    }

    @Test
    public void attributeFriendlyNameGetsConsideredAndMatchedToRole() {
        this.createAdvancedRoleMapper(ATTRIBUTES, false);
        this.createUserInProviderRealm((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute-friendly", (Object)ImmutableList.builder().add((Object)"value 1").build()).put((Object)"user-attribute-2", (Object)ImmutableList.builder().add((Object)"value 2").build()).build());
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
    }
}

