/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcFirstBrokerLoginTest;
import org.keycloak.testsuite.forms.RegisterWithUserProfileTest;
import org.keycloak.testsuite.forms.VerifyProfileTest;
import org.keycloak.testsuite.util.ClientScopeBuilder;
import org.openqa.selenium.By;

@EnableFeature(value=Profile.Feature.DECLARATIVE_USER_PROFILE)
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class KcOidcFirstBrokerLoginWithUserProfileTest
extends KcOidcFirstBrokerLoginTest {
    @Override
    @Before
    public void beforeBrokerTest() {
        super.beforeBrokerTest();
        this.enableDynamicUserProfile();
    }

    @Test
    public void testDisplayName() {
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"displayName\":\"${firstName}\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"displayName\" : \"Department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}}]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        Assert.assertEquals((Object)"First name", (Object)this.updateAccountInformationPage.getLabelForField("firstName"));
        Assert.assertEquals((Object)"lastName", (Object)this.updateAccountInformationPage.getLabelForField("lastName"));
        Assert.assertEquals((Object)"Department", (Object)this.updateAccountInformationPage.getLabelForField("department"));
    }

    @Test
    public void testAttributeGrouping() {
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"group\": \"company\"},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"group\": \"contact\"}], \"groups\": [{\"name\": \"company\", \"displayDescription\": \"Company field desc\" },{\"name\": \"contact\" }]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        String htmlFormId = "kc-idp-review-profile-form";
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(1) > div:nth-child(2) > input#lastName"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(2) > div:nth-child(2) > input#username"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(3) > div:nth-child(2) > input#firstName"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(4) > div:nth-child(1) > label#header-company"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(4) > div:nth-child(2) > label#description-company"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(5) > div:nth-child(2) > input#department"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(6) > div:nth-child(1) > label#header-contact"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(7) > div:nth-child(2) > input#email"))).isDisplayed());
    }

    @Test
    public void testAttributeGuiOrder() {
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}},{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        String htmlFormId = "kc-idp-review-profile-form";
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(1) > div:nth-child(2) > input#lastName"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(2) > div:nth-child(2) > input#department"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(3) > div:nth-child(2) > input#username"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(4) > div:nth-child(2) > input#firstName"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(5) > div:nth-child(2) > input#email"))).isDisplayed());
    }

    @Test
    public void testAttributeInputTypes() {
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"defaultType\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"placeholderAttribute\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputTypePlaceholder\":\"Example.\"}},{\"name\": \"helperTexts\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputHelperTextBefore\":\"Example <b>bold text</b> before.\",\"inputHelperTextAfter\":\"Example <i>i text</i> after.\"}},{\"name\": \"textWithBasicAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputTypeSize\":\"35\",\"inputTypeMinlength\":\"1\",\"inputTypeMaxlength\":\"10\",\"inputTypePattern\":\".*\"}},{\"name\": \"html5NumberWithAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"html5-number\",\"inputTypeMin\":\"10\",\"inputTypeMax\":\"20\",\"inputTypeStep\":1}},{\"name\": \"textareaWithAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"textarea\",\"inputTypeCols\":\"35\",\"inputTypeRows\":\"7\",\"inputTypeMaxlength\":\"10\"}},{\"name\": \"selectWithoutOptions\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"select\",\"inputTypeSize\":\"5\"}},{\"name\": \"selectWithOptionsWithoutLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{\"options\":[ \"opt1\",\"opt2\"]}}, \"annotations\":{\"inputType\":\"select\"}},{\"name\": \"multiselectWithOptionsAndSimpleI18nLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{ \"options\":[\"totp\",\"opt2\"]}}, \"annotations\":{\"inputType\":\"multiselect\",\"inputOptionLabelsI18nPrefix\": \"loginTotp\"}},{\"name\": \"multiselectWithOptionsAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{ \"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"multiselect\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}},{\"name\": \"selectWithOptionsFromCustomValidatorAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"dummyOptions\":{\"options\" : [\"vopt1\",\"vopt2\",\"vopt3\"]}} ,\"annotations\":{\"inputType\":\"select\",\"inputOptionsFromValidation\":\"dummyOptions\",\"inputOptionLabels\":{\"vopt1\": \"Option 1\",\"vopt2\":\"${username}\"}}},{\"name\": \"selectRadiobuttons\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\" : {\"options\" : {\"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"select-radiobuttons\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}},{\"name\": \"selectRadiobuttonsWithOptionsFromCustomValidatorAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\" : {\"dummyOptions\" : {\"options\" : [\"vopt1\",\"vopt2\",\"vopt3\"]}} ,\"annotations\":{\"inputType\":\"select-radiobuttons\",\"inputOptionsFromValidation\":\"dummyOptions\",\"inputOptionLabels\":{\"vopt1\": \"Option 1\",\"vopt2\":\"${username}\"}}},{\"name\": \"multiselectCheckboxes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\": {\"options\":{\"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"multiselect-checkboxes\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}}]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        RegisterWithUserProfileTest.assertFieldTypes(this.driver);
    }

    @Test
    public void testDynamicUserProfileReviewWhenMissing_requiredReadOnlyAttributeDoesnotForceUpdate() {
        this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\"]}, \"required\":{}}]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
    }

    @Test
    public void testDynamicUserProfileReviewWhenMissing_requiredButNotSelectedByScopeAttributeDoesnotForceUpdate() {
        this.addDepartmentScopeIntoRealm();
        this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
    }

    @Test
    public void testDynamicUserProfileReviewWhenMissing_requiredAndSelectedByScopeAttributeForcesUpdate() {
        this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"selector\":{\"scopes\":[\"profile\"]}}]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
    }

    @Test
    public void testDynamicUserProfileReview_requiredReadOnlyAttributeNotRenderedAndNotBlockingProcess() {
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\"]}, \"required\":{}}]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        Assert.assertFalse((boolean)this.updateAccountInformationPage.isDepartmentPresent());
        this.updateAccountInformationPage.updateAccountInformation("requiredReadOnlyAttributeNotRenderedAndNotBlockingRegistration", "requiredReadOnlyAttributeNotRenderedAndNotBlockingRegistration@email", "FirstAA", "LastAA");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
    }

    @Test
    public void testDynamicUserProfileReview_attributeRequiredAndSelectedByScopeMustBeSet() {
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"selector\":{\"scopes\":[\"profile\"]}}]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("attributeRequiredAndSelectedByScopeMustBeSet", "attributeRequiredAndSelectedByScopeMustBeSet@email", "FirstAA", "LastAA", "");
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("attributeRequiredAndSelectedByScopeMustBeSet", "attributeRequiredAndSelectedByScopeMustBeSet@email", "FirstAA", "LastAA", "DepartmentAA");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        UserRepresentation user = VerifyProfileTest.getUserByUsername(this.testRealm(), "attributeRequiredAndSelectedByScopeMustBeSet");
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentAA", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testDynamicUserProfileReview_attributeNotRequiredAndSelectedByScopeCanBeIgnored() {
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"selector\":{\"scopes\":[\"profile\"]}}]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isDepartmentPresent());
        this.updateAccountInformationPage.updateAccountInformation("attributeNotRequiredAndSelectedByScopeCanBeIgnored", "attributeNotRequiredAndSelectedByScopeCanBeIgnored@email", "FirstAA", "LastAA");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        UserRepresentation user = VerifyProfileTest.getUserByUsername(this.testRealm(), "attributeNotRequiredAndSelectedByScopeCanBeIgnored");
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        MatcherAssert.assertThat((Object)StringUtils.isEmpty((CharSequence)user.firstAttribute("department")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDynamicUserProfileReview_attributeNotRequiredAndSelectedByScopeCanBeSet() {
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"selector\":{\"scopes\":[\"profile\"]}}]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isDepartmentPresent());
        this.updateAccountInformationPage.updateAccountInformation("attributeNotRequiredAndSelectedByScopeCanBeSet", "attributeNotRequiredAndSelectedByScopeCanBeSet@email", "FirstAA", "LastAA", "Department AA");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        UserRepresentation user = VerifyProfileTest.getUserByUsername(this.testRealm(), "attributeNotRequiredAndSelectedByScopeCanBeSet");
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        Assert.assertEquals((Object)"Department AA", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testDynamicUserProfileReview_attributeRequiredButNotSelectedByScopeIsNotRenderedAndNotBlockingProcess() {
        this.addDepartmentScopeIntoRealm();
        this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        Assert.assertFalse((boolean)this.updateAccountInformationPage.isDepartmentPresent());
        this.updateAccountInformationPage.updateAccountInformation("attributeRequiredButNotSelectedByScopeIsNotRenderedAndNotBlockingRegistration", "attributeRequiredButNotSelectedByScopeIsNotRenderedAndNotBlockingRegistration@email", "FirstAA", "LastAA");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        UserRepresentation user = VerifyProfileTest.getUserByUsername(this.testRealm(), "attributeRequiredButNotSelectedByScopeIsNotRenderedAndNotBlockingRegistration");
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        Assert.assertEquals(null, (Object)user.firstAttribute("department"));
    }

    public void addDepartmentScopeIntoRealm() {
        this.testRealm().clientScopes().create(ClientScopeBuilder.create().name("department").protocol("openid-connect").build());
    }

    protected void setUserProfileConfiguration(String configuration) {
        VerifyProfileTest.setUserProfileConfiguration(this.testRealm(), configuration);
    }

    private RealmResource testRealm() {
        return this.adminClient.realm(this.bc.consumerRealmName());
    }
}

