/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.AbstractFirstBrokerLoginTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.pages.LoginUpdateProfilePage;
import org.openqa.selenium.NoSuchElementException;

public class KcOidcFirstBrokerLoginTest
extends AbstractFirstBrokerLoginTest {
    @Page
    protected LoginUpdateProfilePage loginUpdateProfilePage;

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcOidcBrokerConfiguration.INSTANCE;
    }

    @Test
    public void loginWithFirstnameLastnamePopulatedFromClaims() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        String firstname = "Firstname";
        String lastname = "Lastname";
        String username = "firstandlastname";
        this.createUser(this.bc.providerRealmName(), username, "password", firstname, lastname, "firstnamelastname@example.org");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithIdp(this.bc.getIDPAlias(), username, "password");
        this.accountUpdateProfilePage.assertCurrent();
        org.junit.Assert.assertEquals((Object)username, (Object)this.accountUpdateProfilePage.getUsername());
        org.junit.Assert.assertEquals((Object)firstname, (Object)this.accountUpdateProfilePage.getFirstName());
        org.junit.Assert.assertEquals((Object)lastname, (Object)this.accountUpdateProfilePage.getLastName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLinkAccountByReauthenticationWithDifferentBroker() {
        KcSamlBrokerConfiguration samlBrokerConfig = KcSamlBrokerConfiguration.INSTANCE;
        ClientRepresentation samlClient = samlBrokerConfig.createProviderClients().get(0);
        IdentityProviderRepresentation samlBroker = samlBrokerConfig.setUpIdentityProvider();
        RealmResource consumerRealm = this.adminClient.realm(this.bc.consumerRealmName());
        try {
            this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
            this.adminClient.realm(this.bc.providerRealmName()).clients().create(samlClient);
            consumerRealm.identityProviders().create(samlBroker);
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.logInWithBroker(samlBrokerConfig);
            this.waitForAccountManagementTitle();
            this.accountUpdateProfilePage.assertCurrent();
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
            this.logInWithBroker(this.bc);
            BrokerTestTools.waitForPage(this.driver, "account already exists", false);
            org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
            org.junit.Assert.assertEquals((Object)"User with email user@localhost.com already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
            this.idpConfirmLinkPage.clickLinkAccount();
            org.junit.Assert.assertEquals((Object)("Authenticate to link your account with " + this.bc.getIDPAlias()), (Object)this.loginPage.getInfoMessage());
            try {
                this.loginPage.findSocialButton(this.bc.getIDPAlias());
                org.junit.Assert.fail((String)("Not expected to see social button with " + samlBrokerConfig.getIDPAlias()));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.log.debug((Object)("Clicking social " + samlBrokerConfig.getIDPAlias()));
            this.loginPage.clickSocial(samlBrokerConfig.getIDPAlias());
            this.waitForAccountManagementTitle();
            this.accountUpdateProfilePage.assertCurrent();
            this.assertNumFederatedIdentities(((UserRepresentation)consumerRealm.users().search(samlBrokerConfig.getUserLogin()).get(0)).getId(), 2);
        }
        finally {
            this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
            ApiUtil.removeUserByUsername((RealmResource)consumerRealm, (String)"consumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterMultipleBrokerWhenReauthenticating() {
        KcSamlBrokerConfiguration samlBrokerConfig = KcSamlBrokerConfiguration.INSTANCE;
        ClientRepresentation samlClient = samlBrokerConfig.createProviderClients().get(0);
        IdentityProviderRepresentation samlBroker = samlBrokerConfig.setUpIdentityProvider();
        RealmResource consumerRealm = this.adminClient.realm(this.bc.consumerRealmName());
        KcOidcBrokerConfiguration oidcBrokerConfig = KcOidcBrokerConfiguration.INSTANCE;
        ClientRepresentation oidcClient = oidcBrokerConfig.createProviderClients().get(0);
        IdentityProviderRepresentation oidcBroker = oidcBrokerConfig.setUpIdentityProvider();
        oidcBroker.setAlias("kc-oidc-idp2");
        oidcBroker.setDisplayName("kc-oidc-idp2");
        try {
            this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
            this.adminClient.realm(this.bc.providerRealmName()).clients().create(samlClient);
            this.adminClient.realm(this.bc.providerRealmName()).clients().create(oidcClient);
            consumerRealm.identityProviders().create(samlBroker);
            consumerRealm.identityProviders().create(oidcBroker);
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.logInWithBroker(samlBrokerConfig);
            this.waitForAccountManagementTitle();
            this.accountUpdateProfilePage.assertCurrent();
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
            this.logInWithBroker(this.bc);
            BrokerTestTools.waitForPage(this.driver, "account already exists", false);
            org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
            org.junit.Assert.assertEquals((Object)"User with email user@localhost.com already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
            this.idpConfirmLinkPage.clickLinkAccount();
            org.junit.Assert.assertEquals((Object)("Authenticate to link your account with " + this.bc.getIDPAlias()), (Object)this.loginPage.getInfoMessage());
            this.loginPage.findSocialButton(samlBroker.getAlias());
            this.loginPage.findSocialButton(oidcBroker.getAlias());
            try {
                this.loginPage.findSocialButton(this.bc.getIDPAlias());
                org.junit.Assert.fail((String)("Not expected to see social button with " + this.bc.getIDPAlias()));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.log.debug((Object)("Clicking social " + samlBrokerConfig.getIDPAlias()));
            this.loginPage.clickSocial(samlBrokerConfig.getIDPAlias());
            this.waitForAccountManagementTitle();
            this.accountUpdateProfilePage.assertCurrent();
            this.assertNumFederatedIdentities(((UserRepresentation)consumerRealm.users().search(samlBrokerConfig.getUserLogin()).get(0)).getId(), 2);
        }
        finally {
            this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
            ApiUtil.removeUserByUsername((RealmResource)consumerRealm, (String)"consumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedFirstBrokerFlow() {
        KcSamlBrokerConfiguration samlBrokerConfig = KcSamlBrokerConfiguration.INSTANCE;
        ClientRepresentation samlClient = samlBrokerConfig.createProviderClients().get(0);
        IdentityProviderRepresentation samlBroker = samlBrokerConfig.setUpIdentityProvider();
        RealmResource consumerRealm = this.adminClient.realm(this.bc.consumerRealmName());
        try {
            this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
            this.adminClient.realm(this.bc.providerRealmName()).clients().create(samlClient);
            consumerRealm.identityProviders().create(samlBroker);
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.createUser(this.bc.getUserLogin());
            this.logInWithBroker(this.bc);
            BrokerTestTools.waitForPage(this.driver, "account already exists", false);
            org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
            org.junit.Assert.assertEquals((Object)"User with email user@localhost.com already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
            this.idpConfirmLinkPage.clickLinkAccount();
            org.junit.Assert.assertEquals((Object)("Authenticate to link your account with " + this.bc.getIDPAlias()), (Object)this.loginPage.getInfoMessage());
            try {
                this.loginPage.findSocialButton(this.bc.getIDPAlias());
                org.junit.Assert.fail((String)("Not expected to see social button with " + samlBrokerConfig.getIDPAlias()));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.log.debug((Object)("Clicking social " + samlBrokerConfig.getIDPAlias()));
            this.loginPage.clickSocial(samlBrokerConfig.getIDPAlias());
            org.junit.Assert.assertEquals((Object)String.format("The %s user %s is not linked to any known user.", samlBrokerConfig.getIDPAlias(), samlBrokerConfig.getUserLogin()), (Object)this.loginPage.getError());
            this.assertNumFederatedIdentities(((UserRepresentation)consumerRealm.users().search(samlBrokerConfig.getUserLogin()).get(0)).getId(), 0);
        }
        finally {
            this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
            ApiUtil.removeUserByUsername((RealmResource)consumerRealm, (String)"consumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoginWithDifferentBrokerWhenUpdatingProfile() {
        KcSamlBrokerConfiguration samlBrokerConfig = KcSamlBrokerConfiguration.INSTANCE;
        ClientRepresentation samlClient = samlBrokerConfig.createProviderClients().get(0);
        IdentityProviderRepresentation samlBroker = samlBrokerConfig.setUpIdentityProvider();
        RealmResource consumerRealm = this.adminClient.realm(this.bc.consumerRealmName());
        try {
            this.updateExecutions(AbstractBrokerTest::enableUpdateProfileOnFirstLogin);
            this.adminClient.realm(this.bc.providerRealmName()).clients().create(samlClient);
            consumerRealm.identityProviders().create(samlBroker);
            this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
            this.logInWithBroker(samlBrokerConfig);
            BrokerTestTools.waitForPage(this.driver, "update account information", false);
            this.updateAccountInformationPage.updateAccountInformation("FirstName", "LastName");
            this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
            this.logInWithBroker(this.bc);
            this.driver.navigate().back();
            this.driver.navigate().back();
            this.log.debug((Object)("Clicking social " + samlBrokerConfig.getIDPAlias()));
            this.loginPage.clickSocial(samlBrokerConfig.getIDPAlias());
            this.waitForAccountManagementTitle();
            this.accountUpdateProfilePage.assertCurrent();
            this.assertNumFederatedIdentities(((UserRepresentation)consumerRealm.users().search(samlBrokerConfig.getUserLogin()).get(0)).getId(), 1);
        }
        finally {
            this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
            ApiUtil.removeUserByUsername((RealmResource)consumerRealm, (String)"consumer");
        }
    }

    @Test
    public void testEditUsername() {
        this.updateExecutions(AbstractBrokerTest::setUpMissingUpdateProfileOnFirstLogin);
        this.createUser(this.bc.providerRealmName(), "no-first-name", "password", (String)null, "LastName", "no-first-name@localhost.com");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.loginPage.login("no-first-name", "password");
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        this.updateAccountInformationPage.updateAccountInformation("", "no-first-name@localhost.com", "FirstName", "LastName");
        this.updateAccountInformationPage.assertCurrent();
        org.junit.Assert.assertEquals((Object)"Please specify username.", (Object)this.loginUpdateProfilePage.getInputErrors().getUsernameError());
        this.updateAccountInformationPage.updateAccountInformation("new-username", "no-first-name@localhost.com", "First Name", "Last Name");
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"First Name", (Object)this.accountUpdateProfilePage.getFirstName());
        Assert.assertEquals((Object)"Last Name", (Object)this.accountUpdateProfilePage.getLastName());
        Assert.assertEquals((Object)"no-first-name@localhost.com", (Object)this.accountUpdateProfilePage.getEmail());
        Assert.assertEquals((Object)"new-username", (Object)this.accountUpdateProfilePage.getUsername());
    }
}

