/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerRunOnServerUtil;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.pages.PasswordPage;
import org.keycloak.testsuite.pages.SelectAuthenticatorPage;
import org.keycloak.testsuite.util.UserBuilder;

public class KcOidcFirstBrokerLoginNewAuthTest
extends AbstractInitializedBaseBrokerTest {
    @Page
    PasswordPage passwordPage;
    @Page
    protected SelectAuthenticatorPage selectAuthenticatorPage;

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcOidcBrokerConfiguration.INSTANCE;
    }

    @Before
    public void disableReviewProfileBeforeTest() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
    }

    @Test
    public void testReAuthenticateWithPasswordAndConditionalOTP_otpNotRequested() {
        this.configureBrokerFlowToReAuthenticationWithPasswordForm(this.bc.getIDPAlias(), "first broker login with password form");
        String consumerRealmUserId = this.createUser("consumer");
        this.loginWithBrokerAndConfirmLinkAccount();
        Assert.assertTrue((boolean)this.passwordPage.isCurrent("consumer"));
        this.passwordPage.login("bad-password");
        Assert.assertEquals((Object)"Invalid password.", (Object)this.passwordPage.getPasswordError());
        this.passwordPage.login("password");
        this.assertUserAuthenticatedInConsumer(consumerRealmUserId);
    }

    @Test
    public void testReAuthenticateWithPasswordAndConditionalOTP_otpRequested() {
        this.configureBrokerFlowToReAuthenticationWithPasswordForm(this.bc.getIDPAlias(), "first broker login with password form");
        String consumerRealmUserId = this.createUser("consumer");
        String totpSecret = this.addTOTPToUser("consumer");
        this.loginWithBrokerAndConfirmLinkAccount();
        Assert.assertTrue((boolean)this.passwordPage.isCurrent("consumer"));
        this.passwordPage.login("password");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
        this.assertUserAuthenticatedInConsumer(consumerRealmUserId);
    }

    @Test
    public void testReAuthenticateWithPasswordOrOTP_otpNotConfigured_passwordUsed() {
        this.configureBrokerFlowToReAuthenticationWithPasswordOrTotp(this.bc.getIDPAlias(), "first broker login with password or totp");
        String consumerRealmUserId = this.createUser("consumer");
        this.loginWithBrokerAndConfirmLinkAccount();
        Assert.assertTrue((boolean)this.passwordPage.isCurrent("consumer"));
        this.passwordPage.assertTryAnotherWayLinkAvailability(false);
        Assert.assertTrue((boolean)this.passwordPage.isCurrent("consumer"));
        this.passwordPage.login("password");
        this.assertUserAuthenticatedInConsumer(consumerRealmUserId);
    }

    @Test
    public void testReAuthenticateWithPasswordOrOTP_otpConfigured_passwordUsed() {
        this.configureBrokerFlowToReAuthenticationWithPasswordOrTotp(this.bc.getIDPAlias(), "first broker login with password or totp");
        String consumerRealmUserId = this.createUser("consumer");
        this.addTOTPToUser("consumer");
        this.loginWithBrokerAndConfirmLinkAccount();
        Assert.assertTrue((boolean)this.passwordPage.isCurrent("consumer"));
        this.passwordPage.assertTryAnotherWayLinkAvailability(true);
        this.passwordPage.clickTryAnotherWayLink();
        this.selectAuthenticatorPage.assertCurrent();
        Assert.assertNames(this.selectAuthenticatorPage.getAvailableLoginMethods(), "Password", "Authenticator Application");
        this.selectAuthenticatorPage.selectLoginMethod("Password");
        Assert.assertTrue((boolean)this.passwordPage.isCurrent("consumer"));
        this.passwordPage.login("password");
        this.assertUserAuthenticatedInConsumer(consumerRealmUserId);
    }

    @Test
    public void testReAuthenticateWithPasswordOrOTP_otpConfigured_otpUsed() {
        this.configureBrokerFlowToReAuthenticationWithPasswordOrTotp(this.bc.getIDPAlias(), "first broker login with password or totp");
        String consumerRealmUserId = this.createUser("consumer");
        String totpSecret = this.addTOTPToUser("consumer");
        this.loginWithBrokerAndConfirmLinkAccount();
        Assert.assertTrue((boolean)this.passwordPage.isCurrent("consumer"));
        this.passwordPage.assertTryAnotherWayLinkAvailability(true);
        this.passwordPage.clickTryAnotherWayLink();
        this.selectAuthenticatorPage.assertCurrent();
        this.selectAuthenticatorPage.selectLoginMethod("Authenticator Application");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
        this.assertUserAuthenticatedInConsumer(consumerRealmUserId);
    }

    private String addTOTPToUser(String username) {
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)realm, (String)username);
        UserRepresentation userRep = UserBuilder.edit(user.toRepresentation()).requiredAction(UserModel.RequiredAction.CONFIGURE_TOTP.toString()).build();
        user.update(userRep);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.loginPage.login(username, "password");
        this.totpPage.assertCurrent();
        String totpSecret = this.totpPage.getTotpSecret();
        this.totpPage.configure(this.totp.generateTOTP(totpSecret));
        user.logout();
        return totpSecret;
    }

    private void loginWithBrokerAndConfirmLinkAccount() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "account already exists", false);
        org.junit.Assert.assertTrue((boolean)this.idpConfirmLinkPage.isCurrent());
        org.junit.Assert.assertEquals((Object)"User with email user@localhost.com already exists. How do you want to continue?", (Object)this.idpConfirmLinkPage.getMessage());
        this.idpConfirmLinkPage.clickLinkAccount();
    }

    private void assertUserAuthenticatedInConsumer(String consumerRealmUserId) {
        this.waitForAccountManagementTitle();
        this.accountUpdateProfilePage.assertCurrent();
        this.assertNumFederatedIdentities(consumerRealmUserId, 1);
    }

    private void configureBrokerFlowToReAuthenticationWithPasswordForm(String idpAlias, String newFlowAlias) {
        BrokerRunOnServerUtil.configureBrokerFlowToReAuthenticationWithPasswordForm(this.testingClient, this.bc.consumerRealmName(), idpAlias, newFlowAlias);
    }

    private void configureBrokerFlowToReAuthenticationWithPasswordOrTotp(String idpAlias, String newFlowAlias) {
        BrokerRunOnServerUtil.configureBrokerFlowToReAuthenticationWithPasswordOrTotp(this.testingClient, this.bc.consumerRealmName(), idpAlias, newFlowAlias);
    }
}

