/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerRunOnServerUtil;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class KcOidcBrokerWithConsentTest
extends AbstractInitializedBaseBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcOidcBrokerConfiguration.INSTANCE;
    }

    @Override
    public void beforeBrokerTest() {
        super.beforeBrokerTest();
        RealmResource brokeredRealm = this.adminClient.realm(this.bc.providerRealmName());
        List clients = brokeredRealm.clients().findByClientId("brokerapp");
        Assert.assertEquals((long)1L, (long)clients.size());
        ClientRepresentation brokerApp = (ClientRepresentation)clients.get(0);
        brokerApp.setConsentRequired(Boolean.valueOf(true));
        brokeredRealm.clients().get(brokerApp.getId()).update(brokerApp);
        RealmResource realmWithBroker = this.adminClient.realm(this.bc.consumerRealmName());
        RealmRepresentation realmRep = realmWithBroker.toRepresentation();
        realmRep.setAccessCodeLifespanLogin(Integer.valueOf(30));
        realmRep.setAccessCodeLifespan(Integer.valueOf(30));
        realmRep.setAccessCodeLifespanUserAction(Integer.valueOf(30));
        realmWithBroker.update(realmRep);
    }

    @Test
    public void testConsentDeniedWithExpiredClientSession() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        this.log.debug((Object)"Logging in");
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        this.invokeTimeOffset(60);
        try {
            this.grantPage.assertCurrent();
            this.grantPage.cancel();
            Assert.assertEquals((Object)"Your login attempt timed out. Login will start from the beginning.", (Object)this.loginPage.getError());
        }
        finally {
            this.invokeTimeOffset(0);
        }
    }

    @Test
    public void testConsentDeniedWithExpiredAndClearedClientSession() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        this.invokeTimeOffset(60);
        try {
            this.testingClient.server(this.bc.providerRealmName()).run(BrokerRunOnServerUtil.removeBrokerExpiredSessions());
            this.grantPage.assertCurrent();
            this.grantPage.cancel();
            Assert.assertEquals((Object)"Your login attempt timed out. Login will start from the beginning.", (Object)this.loginPage.getError());
        }
        finally {
            this.invokeTimeOffset(0);
        }
    }

    @Test
    public void testAccountManagementLinkingAndExpiredClientSession() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.createUser(this.bc.consumerRealmName(), "consumer", "password", "FirstName", "LastName", "consumer@localhost.com");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.loginPage.login("consumer", "password");
        this.accountPage.federatedIdentity();
        this.accountFederatedIdentityPage.clickAddProvider(this.bc.getIDPAlias());
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        this.invokeTimeOffset(60);
        try {
            this.grantPage.assertCurrent();
            this.grantPage.cancel();
            this.accountFederatedIdentityPage.assertCurrent();
            Assert.assertEquals((Object)"The page expired. Please try one more time.", (Object)this.accountFederatedIdentityPage.getError());
            this.accountFederatedIdentityPage.clickAddProvider(this.bc.getIDPAlias());
            this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
            this.invokeTimeOffset(120);
            this.grantPage.assertCurrent();
            this.grantPage.accept();
            this.accountFederatedIdentityPage.assertCurrent();
            Assert.assertEquals((Object)"The page expired. Please try one more time.", (Object)this.accountFederatedIdentityPage.getError());
        }
        finally {
            this.invokeTimeOffset(0);
        }
    }

    @Test
    public void testLoginCancelConsent() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        this.grantPage.assertCurrent();
        this.grantPage.cancel();
        Assert.assertEquals((Object)("Sign in to " + this.bc.consumerRealmName()), (Object)this.driver.getTitle());
    }

    @Test
    public void testAccountManagementLinkingCancelConsent() throws Exception {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.createUser(this.bc.consumerRealmName(), "consumer", "password", "FirstName", "LastName", "consumer@localhost.com");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.loginPage.login("consumer", "password");
        this.accountPage.federatedIdentity();
        this.accountFederatedIdentityPage.clickAddProvider(this.bc.getIDPAlias());
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        this.grantPage.assertCurrent();
        this.grantPage.cancel();
        this.accountFederatedIdentityPage.assertCurrent();
        Assert.assertEquals((Object)"Consent denied.", (Object)this.accountFederatedIdentityPage.getError());
    }
}

