/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.ArrayList;
import java.util.List;
import org.junit.Ignore;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ProtocolMapperUtil;

public class KcOidcBrokerSubMatchIntrospectionTest
extends AbstractBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration(){

            @Override
            public List<ClientRepresentation> createConsumerClients() {
                ArrayList<ClientRepresentation> clients = new ArrayList<ClientRepresentation>(super.createConsumerClients());
                clients.add(ClientBuilder.create().clientId("consumer-client").publicClient().redirectUris(BrokerTestTools.getConsumerRoot() + "/auth/realms/master/app/auth/*").publicClient().build());
                return clients;
            }

            @Override
            public List<ClientRepresentation> createProviderClients() {
                List<ClientRepresentation> clients = super.createProviderClients();
                ArrayList<ProtocolMapperRepresentation> mappers = new ArrayList<ProtocolMapperRepresentation>();
                ProtocolMapperRepresentation hardcodedClaim = ProtocolMapperUtil.createHardcodedClaim("sub-override", "sub", "overriden", "String", false, false);
                hardcodedClaim.getConfig().put("userinfo.token.claim", Boolean.TRUE.toString());
                mappers.add(hardcodedClaim);
                clients.get(0).setProtocolMappers(mappers);
                return clients;
            }
        };
    }

    @Override
    public void testLogInAsUserInIDP() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.oauth.realm(this.bc.consumerRealmName());
        this.oauth.clientId("consumer-client");
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        this.log.debug((Object)"Logging in");
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        this.errorPage.assertCurrent();
    }

    @Override
    @Ignore
    public void loginWithExistingUser() {
    }
}

