/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.UriUtils;
import org.keycloak.events.EventType;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginExpiredPage;
import org.keycloak.testsuite.util.OAuthClient;

public class KcOidcBrokerStateParameterTest
extends AbstractInitializedBaseBrokerTest {
    @Page
    protected AppPage appPage;
    @Page
    protected LoginExpiredPage loginExpiredPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcOidcBrokerConfiguration.INSTANCE;
    }

    @Test
    public void testMissingStateParameter() {
        String consumerEndpointUrl = this.getURLOfOIDCIdpEndpointOnConsumerSide() + "?code=foo123";
        this.events.clear();
        this.driver.navigate().to(consumerEndpointUrl);
        BrokerTestTools.waitForPage(this.driver, "sign in to consumer", true);
        this.errorPage.assertCurrent();
        Assert.assertThat((Object)this.errorPage.getError(), (Matcher)Matchers.is((Object)"Missing state parameter in response from identity provider."));
        String consumerRealmId = this.realmsResouce().realm(this.bc.consumerRealmName()).toRepresentation().getId();
        this.events.expect(EventType.IDENTITY_PROVIDER_LOGIN_ERROR).clearDetails().session((String)null).realm(consumerRealmId).user((String)null).client((String)null).error("identity_provider_login_failure").assertEvent();
        this.events.assertEmpty();
    }

    @Test
    public void testIncorrectStateParameter() throws Exception {
        String consumerEndpointUrl = KeycloakUriBuilder.fromUri((String)this.getURLOfOIDCIdpEndpointOnConsumerSide()).queryParam("code", new Object[]{"foo456"}).queryParam("state", new Object[]{"someIncorrectState"}).build(new Object[0]).toString();
        this.events.clear();
        String consumerRealmId = this.realmsResouce().realm(this.bc.consumerRealmName()).toRepresentation().getId();
        this.driver.navigate().to(consumerEndpointUrl);
        this.events.expect(EventType.IDENTITY_PROVIDER_LOGIN_ERROR).clearDetails().session((String)null).realm(consumerRealmId).user((String)null).client((String)null).error("invalidRequestMessage").assertEvent();
        this.events.assertEmpty();
    }

    @Test
    public void testCorrectStateParameterButIncorrectCode() throws Exception {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        String url = this.driver.getCurrentUrl();
        String stateParamValue = (String)UriUtils.decodeQueryString((String)url).getFirst((Object)"state");
        String consumerEndpointUrl = KeycloakUriBuilder.fromUri((String)this.getURLOfOIDCIdpEndpointOnConsumerSide()).queryParam("code", new Object[]{"foo123"}).queryParam("state", new Object[]{stateParamValue}).build(new Object[0]).toString();
        this.events.clear();
        String providerRealmId = this.realmsResouce().realm(this.bc.providerRealmName()).toRepresentation().getId();
        String consumerRealmId = this.realmsResouce().realm(this.bc.consumerRealmName()).toRepresentation().getId();
        this.driver.navigate().to(consumerEndpointUrl);
        this.events.expect(EventType.CODE_TO_TOKEN_ERROR).clearDetails().session((String)null).realm(providerRealmId).user((String)null).client("brokerapp").error("invalid_code").assertEvent();
        this.events.expect(EventType.IDENTITY_PROVIDER_LOGIN_ERROR).clearDetails().session((String)null).realm(consumerRealmId).user((String)null).client("account").error("identity_provider_login_failure").assertEvent();
        this.driver.navigate().to(consumerEndpointUrl);
        this.loginExpiredPage.assertCurrent();
        this.events.assertEmpty();
    }

    private String getURLOfOIDCIdpEndpointOnConsumerSide() {
        BrokerConfiguration brokerConfig = this.getBrokerConfiguration();
        return OAuthClient.AUTH_SERVER_ROOT + "/realms/" + brokerConfig.consumerRealmName() + "/broker/" + brokerConfig.getIDPAlias() + "/endpoint";
    }
}

