/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.util.KeyUtils;

public class KcOidcBrokerPrivateKeyJwtTest
extends AbstractBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfigurationWithJWTAuthentication();
    }

    private class KcOidcBrokerConfigurationWithJWTAuthentication
    extends KcOidcBrokerConfiguration {
        private KcOidcBrokerConfigurationWithJWTAuthentication() {
        }

        @Override
        public List<ClientRepresentation> createProviderClients() {
            List<ClientRepresentation> clientsRepList = super.createProviderClients();
            KcOidcBrokerPrivateKeyJwtTest.this.log.info((Object)"Update provider clients to accept JWT authentication");
            KeysMetadataRepresentation.KeyMetadataRepresentation keyRep = KeyUtils.getActiveSigningKey((KeysMetadataRepresentation)KcOidcBrokerPrivateKeyJwtTest.this.adminClient.realm(this.consumerRealmName()).keys().getKeyMetadata(), (String)"RS256");
            for (ClientRepresentation client : clientsRepList) {
                client.setClientAuthenticatorType("client-jwt");
                if (client.getAttributes() == null) {
                    client.setAttributes(new HashMap());
                }
                client.getAttributes().put("jwt.credential.certificate", keyRep.getCertificate());
            }
            return clientsRepList;
        }

        @Override
        public IdentityProviderRepresentation setUpIdentityProvider(IdentityProviderSyncMode syncMode) {
            IdentityProviderRepresentation idp = BrokerTestTools.createIdentityProvider("kc-oidc-idp", "keycloak-oidc");
            Map config = idp.getConfig();
            this.applyDefaultConfiguration(config, syncMode);
            config.put("clientSecret", null);
            config.put("clientAuthMethod", "private_key_jwt");
            return idp;
        }
    }
}

