/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.util.TokenSignatureUtil;

public class KcOidcBrokerPrivateKeyJwtCustomSignAlgTest
extends AbstractBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfigurationWithJWTAuthentication();
    }

    private class KcOidcBrokerConfigurationWithJWTAuthentication
    extends KcOidcBrokerConfiguration {
        String signAlg = "ES256";

        private KcOidcBrokerConfigurationWithJWTAuthentication() {
        }

        @Override
        public List<ClientRepresentation> createProviderClients() {
            List<ClientRepresentation> clientsRepList = super.createProviderClients();
            KcOidcBrokerPrivateKeyJwtCustomSignAlgTest.this.log.info((Object)"Update provider clients to accept JWT authentication");
            for (ClientRepresentation client : clientsRepList) {
                client.setClientAuthenticatorType("client-jwt");
                if (client.getAttributes() == null) {
                    client.setAttributes(new HashMap());
                }
                client.getAttributes().put("token.endpoint.auth.signing.alg", this.signAlg);
                client.getAttributes().put("use.jwks.url", "true");
                client.getAttributes().put("jwks.url", BrokerTestTools.getConsumerRoot() + "/auth/realms/" + "consumer" + "/protocol/openid-connect/certs");
            }
            return clientsRepList;
        }

        @Override
        public IdentityProviderRepresentation setUpIdentityProvider(IdentityProviderSyncMode syncMode) {
            this.generateEcdsaKeyProvider("valid", this.signAlg, "consumer", KcOidcBrokerPrivateKeyJwtCustomSignAlgTest.this.adminClient);
            IdentityProviderRepresentation idp = BrokerTestTools.createIdentityProvider("kc-oidc-idp", "keycloak-oidc");
            Map config = idp.getConfig();
            this.applyDefaultConfiguration(config, syncMode);
            config.put("clientSecret", null);
            config.put("clientAuthMethod", "private_key_jwt");
            config.put("clientAssertionSigningAlg", this.signAlg);
            return idp;
        }

        private void generateEcdsaKeyProvider(String name, String alg, String realmName, Keycloak adminClient) {
            ComponentRepresentation rep = this.createRep(name, adminClient.realm(realmName).toRepresentation().getId(), "ecdsa-generated");
            long priority = System.currentTimeMillis();
            rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
            rep.getConfig().putSingle((Object)"active", (Object)"true");
            rep.getConfig().putSingle((Object)"enabled", (Object)"true");
            rep.getConfig().putSingle((Object)"ecdsaEllipticCurveKey", (Object)TokenSignatureUtil.convertAlgorithmToECDomainParamNistRep((String)alg));
            Response response = adminClient.realm(realmName).components().add(rep);
            response.close();
        }

        protected ComponentRepresentation createRep(String name, String realmId, String providerId) {
            ComponentRepresentation rep = new ComponentRepresentation();
            rep.setName(name);
            rep.setParentId(realmId);
            rep.setProviderId(providerId);
            rep.setProviderType(KeyProvider.class.getName());
            rep.setConfig(new MultivaluedHashMap());
            return rep;
        }
    }
}

