/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.OAuthClient;

public class KcOidcBrokerNonceParameterTest
extends AbstractBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration(){

            @Override
            public List<ClientRepresentation> createConsumerClients() {
                ArrayList<ClientRepresentation> clients = new ArrayList<ClientRepresentation>(super.createConsumerClients());
                clients.add(ClientBuilder.create().clientId("consumer-client").publicClient().redirectUris(BrokerTestTools.getConsumerRoot() + "/auth/realms/master/app/auth/*").publicClient().build());
                return clients;
            }
        };
    }

    @Override
    protected void loginUser() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.oauth.realm(this.bc.consumerRealmName());
        this.oauth.clientId("consumer-client");
        this.oauth.nonce("123456");
        OAuthClient.AuthorizationEndpointResponse authzResponse = this.oauth.doLoginSocial(this.bc.getIDPAlias(), this.bc.getUserLogin(), this.bc.getUserPassword());
        String code = authzResponse.getCode();
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        IDToken idToken = this.toIdToken(response.getIdToken());
        Assert.assertEquals((Object)"123456", (Object)idToken.getNonce());
    }

    @Test
    public void testNonceNotSet() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.oauth.realm(this.bc.consumerRealmName());
        this.oauth.clientId("consumer-client");
        this.oauth.nonce(null);
        OAuthClient.AuthorizationEndpointResponse authzResponse = this.oauth.doLoginSocial(this.bc.getIDPAlias(), this.bc.getUserLogin(), this.bc.getUserPassword());
        String code = authzResponse.getCode();
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest(code, null);
        IDToken idToken = this.toIdToken(response.getIdToken());
        Assert.assertNull((Object)idToken.getNonce());
    }

    protected IDToken toIdToken(String encoded) {
        IDToken idToken;
        try {
            idToken = (IDToken)new JWSInput(encoded).readJsonContent(IDToken.class);
        }
        catch (JWSInputException cause) {
            throw new RuntimeException("Failed to deserialize RPT", cause);
        }
        return idToken;
    }
}

