/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.util.OAuthClient;

public class KcOidcBrokerLogoutTest
extends AbstractBaseBrokerTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcOidcBrokerConfiguration.INSTANCE;
    }

    @Before
    public void createUser() {
        this.log.debug((Object)("creating user for realm " + this.bc.providerRealmName()));
        UserRepresentation user = new UserRepresentation();
        user.setUsername(this.bc.getUserLogin());
        user.setEmail(this.bc.getUserEmail());
        user.setEmailVerified(Boolean.valueOf(true));
        user.setEnabled(Boolean.valueOf(true));
        RealmResource realmResource = this.adminClient.realm(this.bc.providerRealmName());
        String userId = ApiUtil.createUserWithAdminClient((RealmResource)realmResource, (UserRepresentation)user);
        ApiUtil.resetUserPassword((UserResource)realmResource.users().get(userId), (String)this.bc.getUserPassword(), (boolean)false);
    }

    @Before
    public void addIdentityProviderToProviderRealm() {
        this.log.debug((Object)("adding identity provider to realm " + this.bc.consumerRealmName()));
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        realm.identityProviders().create(this.bc.setUpIdentityProvider()).close();
    }

    @Before
    public void addClients() {
        this.addClientsToProviderAndConsumer();
    }

    @Test
    public void logoutWithoutInitiatingIdpLogsOutOfIdp() {
        this.logInAsUserInIDPForFirstTime();
        this.assertLoggedInAccountManagement();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getProviderRoot(), "provider"));
        BrokerTestTools.waitForPage(this.driver, "sign in to provider", true);
    }

    @Test
    public void logoutWithActualIdpAsInitiatingIdpDoesNotLogOutOfIdp() {
        this.logInAsUserInIDPForFirstTime();
        this.assertLoggedInAccountManagement();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName(), "kc-oidc-idp");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getProviderRoot(), "provider"));
        this.waitForAccountManagementTitle();
    }

    @Test
    public void logoutWithOtherIdpAsInitiatinIdpLogsOutOfIdp() {
        this.logInAsUserInIDPForFirstTime();
        this.assertLoggedInAccountManagement();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName(), "something-else");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getProviderRoot(), "provider"));
        BrokerTestTools.waitForPage(this.driver, "sign in to provider", true);
    }

    @Test
    public void logoutAfterBrowserRestart() {
        this.driver.navigate().to(this.getLoginUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName(), "broker-app"));
        this.logInWithBroker(this.bc);
        this.updateAccountInformation();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse response = this.oauth.realm(this.bc.consumerRealmName()).clientId("broker-app").redirectUri(BrokerTestTools.getConsumerRoot() + "/auth/realms/" + "consumer" + "/app").doAccessTokenRequest(code, "broker-app-secret");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        String idToken = response.getIdToken();
        this.log.debugf("Deleting %s and %s cookies", (Object)"KEYCLOAK_IDENTITY", (Object)"KEYCLOAK_IDENTITY_LEGACY");
        this.driver.manage().deleteCookieNamed("KEYCLOAK_IDENTITY");
        this.driver.manage().deleteCookieNamed("KEYCLOAK_IDENTITY_LEGACY");
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName(), null, idToken);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getProviderRoot(), "provider"));
        BrokerTestTools.waitForPage(this.driver, "sign in to provider", true);
    }
}

