/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.util.ReverseProxy;

public final class KcOidcBrokerFrontendUrlTest
extends AbstractBrokerTest {
    @Rule
    public ReverseProxy proxy = new ReverseProxy();

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration(){

            @Override
            public RealmRepresentation createConsumerRealm() {
                RealmRepresentation realm = super.createConsumerRealm();
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("frontendUrl", KcOidcBrokerFrontendUrlTest.this.proxy.getUrl());
                realm.setAttributes(attributes);
                return realm;
            }

            @Override
            public List<ClientRepresentation> createProviderClients() {
                List<ClientRepresentation> clients = super.createProviderClients();
                ArrayList<String> redirectUris = new ArrayList<String>();
                redirectUris.add(KcOidcBrokerFrontendUrlTest.this.proxy.getUrl() + "/realms/" + "consumer" + "/broker/" + "kc-oidc-idp" + "/endpoint/*");
                clients.get(0).setRedirectUris(redirectUris);
                return clients;
            }
        };
    }

    @Override
    @Test
    public void testLogInAsUserInIDP() {
        this.updateExecutions(AbstractBrokerTest::disableUpdateProfileOnFirstLogin);
        this.createUser(this.bc.consumerRealmName(), "consumer", "password", "FirstName", "LastName", "consumer@localhost.com");
        this.driver.navigate().to(this.proxy.getUrl() + "/realms/consumer/account");
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        this.log.debug((Object)"Logging in");
        try {
            Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("redirect_uri=" + URLEncoder.encode(this.proxy.getUrl(), "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.loginPage.login(this.bc.getUserLogin(), this.bc.getUserPassword());
        BrokerTestTools.waitForPage(this.driver, "account management", true);
        this.accountUpdateProfilePage.assertCurrent();
    }

    @Override
    @Ignore
    @Test
    public void loginWithExistingUser() {
    }
}

