/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;

public class KcOidcBrokerConfiguration
implements BrokerConfiguration {
    public static final KcOidcBrokerConfiguration INSTANCE = new KcOidcBrokerConfiguration();
    protected static final String ATTRIBUTE_TO_MAP_NAME = "user-attribute";
    protected static final String ATTRIBUTE_TO_MAP_NAME_2 = "user-attribute-2";
    public static final String USER_INFO_CLAIM = "user-claim";
    public static final String HARDOCDED_CLAIM = "test";
    public static final String HARDOCDED_VALUE = "value";

    @Override
    public RealmRepresentation createProviderRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm("provider");
        realm.setEnabled(Boolean.valueOf(true));
        realm.setEventsListeners(Arrays.asList("jboss-logging", "event-queue"));
        realm.setEventsEnabled(true);
        return realm;
    }

    @Override
    public RealmRepresentation createConsumerRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm("consumer");
        realm.setEnabled(Boolean.valueOf(true));
        realm.setResetPasswordAllowed(Boolean.valueOf(true));
        realm.setEventsListeners(Arrays.asList("jboss-logging", "event-queue"));
        realm.setEventsEnabled(true);
        return realm;
    }

    @Override
    public List<ClientRepresentation> createProviderClients() {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(this.getIDPClientIdInProviderRealm());
        client.setName("brokerapp");
        client.setSecret("secret");
        client.setRedirectUris(Collections.singletonList(BrokerTestTools.getConsumerRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-oidc-idp" + "/endpoint/*"));
        client.setAdminUrl(BrokerTestTools.getConsumerRoot() + "/auth/realms/" + "consumer" + "/broker/" + "kc-oidc-idp" + "/endpoint");
        ProtocolMapperRepresentation emailMapper = new ProtocolMapperRepresentation();
        emailMapper.setName("email");
        emailMapper.setProtocol("openid-connect");
        emailMapper.setProtocolMapper("oidc-usermodel-property-mapper");
        Map emailMapperConfig = emailMapper.getConfig();
        emailMapperConfig.put("user.attribute", "email");
        emailMapperConfig.put("claim.name", "email");
        emailMapperConfig.put("jsonType.label", "String");
        emailMapperConfig.put("access.token.claim", "true");
        emailMapperConfig.put("id.token.claim", "true");
        emailMapperConfig.put("userinfo.token.claim", "true");
        ProtocolMapperRepresentation nestedAttrMapper = new ProtocolMapperRepresentation();
        nestedAttrMapper.setName("attribute - nested claim");
        nestedAttrMapper.setProtocol("openid-connect");
        nestedAttrMapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
        Map nestedEmailMapperConfig = nestedAttrMapper.getConfig();
        nestedEmailMapperConfig.put("user.attribute", "nested.email");
        nestedEmailMapperConfig.put("claim.name", "nested.email");
        nestedEmailMapperConfig.put("jsonType.label", "String");
        nestedEmailMapperConfig.put("access.token.claim", "true");
        nestedEmailMapperConfig.put("id.token.claim", "true");
        nestedEmailMapperConfig.put("userinfo.token.claim", "true");
        ProtocolMapperRepresentation dottedAttrMapper = new ProtocolMapperRepresentation();
        dottedAttrMapper.setName("attribute - claim with dot in name");
        dottedAttrMapper.setProtocol("openid-connect");
        dottedAttrMapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
        Map dottedEmailMapperConfig = dottedAttrMapper.getConfig();
        dottedEmailMapperConfig.put("user.attribute", "dotted.email");
        dottedEmailMapperConfig.put("claim.name", "dotted\\.email");
        dottedEmailMapperConfig.put("jsonType.label", "String");
        dottedEmailMapperConfig.put("access.token.claim", "true");
        dottedEmailMapperConfig.put("id.token.claim", "true");
        dottedEmailMapperConfig.put("userinfo.token.claim", "true");
        ProtocolMapperRepresentation userAttrMapper = new ProtocolMapperRepresentation();
        userAttrMapper.setName("attribute - name");
        userAttrMapper.setProtocol("openid-connect");
        userAttrMapper.setProtocolMapper("oidc-usermodel-attribute-mapper");
        Map userAttrMapperConfig = userAttrMapper.getConfig();
        userAttrMapperConfig.put("user.attribute", ATTRIBUTE_TO_MAP_NAME);
        userAttrMapperConfig.put("claim.name", ATTRIBUTE_TO_MAP_NAME);
        userAttrMapperConfig.put("jsonType.label", "String");
        userAttrMapperConfig.put("access.token.claim", "true");
        userAttrMapperConfig.put("id.token.claim", "true");
        userAttrMapperConfig.put("userinfo.token.claim", "true");
        userAttrMapperConfig.put("multivalued", "true");
        ProtocolMapperRepresentation userAttrMapper2 = new ProtocolMapperRepresentation();
        userAttrMapper2.setName("attribute - name - 2");
        userAttrMapper2.setProtocol("openid-connect");
        userAttrMapper2.setProtocolMapper("oidc-usermodel-attribute-mapper");
        Map userAttrMapperConfig2 = userAttrMapper2.getConfig();
        userAttrMapperConfig2.put("user.attribute", ATTRIBUTE_TO_MAP_NAME_2);
        userAttrMapperConfig2.put("claim.name", ATTRIBUTE_TO_MAP_NAME_2);
        userAttrMapperConfig2.put("jsonType.label", "String");
        userAttrMapperConfig2.put("access.token.claim", "true");
        userAttrMapperConfig2.put("id.token.claim", "true");
        userAttrMapperConfig2.put("userinfo.token.claim", "true");
        userAttrMapperConfig2.put("multivalued", "true");
        ProtocolMapperRepresentation hardcodedJsonClaim = new ProtocolMapperRepresentation();
        hardcodedJsonClaim.setName("json-mapper");
        hardcodedJsonClaim.setProtocol("openid-connect");
        hardcodedJsonClaim.setProtocolMapper("oidc-hardcoded-claim-mapper");
        Map hardcodedJsonClaimMapperConfig = hardcodedJsonClaim.getConfig();
        hardcodedJsonClaimMapperConfig.put("claim.name", USER_INFO_CLAIM);
        hardcodedJsonClaimMapperConfig.put("jsonType.label", "JSON");
        hardcodedJsonClaimMapperConfig.put("id.token.claim", "true");
        hardcodedJsonClaimMapperConfig.put("claim.value", "{\"test\": \"value\"}");
        client.setProtocolMappers(Arrays.asList(emailMapper, userAttrMapper, userAttrMapper2, nestedAttrMapper, dottedAttrMapper, hardcodedJsonClaim));
        return Collections.singletonList(client);
    }

    @Override
    public List<ClientRepresentation> createConsumerClients() {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("broker-app");
        client.setName("broker-app");
        client.setSecret("broker-app-secret");
        client.setEnabled(Boolean.valueOf(true));
        client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        client.setRedirectUris(Collections.singletonList(BrokerTestTools.getConsumerRoot() + "/auth/*"));
        client.setBaseUrl(BrokerTestTools.getConsumerRoot() + "/auth/realms/" + "consumer" + "/app");
        return Collections.singletonList(client);
    }

    @Override
    public IdentityProviderRepresentation setUpIdentityProvider(IdentityProviderSyncMode syncMode) {
        IdentityProviderRepresentation idp = BrokerTestTools.createIdentityProvider("kc-oidc-idp", "keycloak-oidc");
        Map config = idp.getConfig();
        this.applyDefaultConfiguration(config, syncMode);
        return idp;
    }

    protected void applyDefaultConfiguration(Map<String, String> config, IdentityProviderSyncMode syncMode) {
        config.put("syncMode", syncMode.toString());
        config.put("clientId", "brokerapp");
        config.put("clientSecret", "secret");
        config.put("prompt", "login");
        config.put("authorizationUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + "provider" + "/protocol/openid-connect/auth");
        config.put("tokenUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + "provider" + "/protocol/openid-connect/token");
        config.put("logoutUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + "provider" + "/protocol/openid-connect/logout");
        config.put("userInfoUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + "provider" + "/protocol/openid-connect/userinfo");
        config.put("defaultScope", "email profile");
        config.put("backchannelSupported", "true");
        config.put("jwksUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + "provider" + "/protocol/openid-connect/certs");
        config.put("useJwksUrl", "true");
        config.put("validateSignature", "true");
    }

    @Override
    public String getUserLogin() {
        return "testuser";
    }

    @Override
    public String getIDPClientIdInProviderRealm() {
        return "brokerapp";
    }

    @Override
    public String getUserPassword() {
        return "password";
    }

    @Override
    public String getUserEmail() {
        return "user@localhost.com";
    }

    @Override
    public String providerRealmName() {
        return "provider";
    }

    @Override
    public String consumerRealmName() {
        return "consumer";
    }

    @Override
    public String getIDPAlias() {
        return "kc-oidc-idp";
    }
}

