/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testsuite.broker.AbstractBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class KcOidcBrokerClientSecretJwtCustomSignAlgTest
extends AbstractBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfigurationWithJWTAuthentication();
    }

    private class KcOidcBrokerConfigurationWithJWTAuthentication
    extends KcOidcBrokerConfiguration {
        String clientSecret = UUID.randomUUID().toString();
        String signAlg = "HS384";

        private KcOidcBrokerConfigurationWithJWTAuthentication() {
        }

        @Override
        public List<ClientRepresentation> createProviderClients() {
            List<ClientRepresentation> clientsRepList = super.createProviderClients();
            KcOidcBrokerClientSecretJwtCustomSignAlgTest.this.log.info((Object)"Update provider clients to accept JWT authentication");
            for (ClientRepresentation client : clientsRepList) {
                if (client.getAttributes() == null) {
                    client.setAttributes(new HashMap());
                }
                client.setClientAuthenticatorType("client-secret-jwt");
                client.setSecret(this.clientSecret);
                client.getAttributes().put("token.endpoint.auth.signing.alg", this.signAlg);
            }
            return clientsRepList;
        }

        @Override
        public IdentityProviderRepresentation setUpIdentityProvider(IdentityProviderSyncMode syncMode) {
            IdentityProviderRepresentation idp = BrokerTestTools.createIdentityProvider("kc-oidc-idp", "keycloak-oidc");
            Map config = idp.getConfig();
            this.applyDefaultConfiguration(config, syncMode);
            config.put("clientAuthMethod", "client_secret_jwt");
            config.put("clientSecret", this.clientSecret);
            config.put("clientAssertionSigningAlg", this.signAlg);
            return idp;
        }
    }
}

