/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.security.Key;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.PemUtils;
import org.keycloak.keys.KeyProvider;
import org.keycloak.keys.PublicKeyStorageUtils;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.broker.OIDCIdentityProviderConfigRep;
import org.keycloak.testsuite.client.resources.TestingCacheResource;
import org.keycloak.testsuite.util.OAuthClient;

public class KcOIDCBrokerWithSignatureTest
extends AbstractBaseBrokerTest {
    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return KcOidcBrokerConfiguration.INSTANCE;
    }

    @Before
    public void createUser() {
        this.log.debug((Object)("creating user for realm " + this.bc.providerRealmName()));
        UserRepresentation user = new UserRepresentation();
        user.setUsername(this.bc.getUserLogin());
        user.setEmail(this.bc.getUserEmail());
        user.setEmailVerified(Boolean.valueOf(true));
        user.setEnabled(Boolean.valueOf(true));
        RealmResource realmResource = this.adminClient.realm(this.bc.providerRealmName());
        String userId = ApiUtil.createUserWithAdminClient((RealmResource)realmResource, (UserRepresentation)user);
        ApiUtil.resetUserPassword((UserResource)realmResource.users().get(userId), (String)this.bc.getUserPassword(), (boolean)false);
    }

    @Before
    public void addIdentityProviderToProviderRealm() {
        this.log.debug((Object)("adding identity provider to realm " + this.bc.consumerRealmName()));
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        Response resp = realm.identityProviders().create(this.bc.setUpIdentityProvider());
        resp.close();
    }

    @Before
    public void addClients() {
        this.addClientsToProviderAndConsumer();
    }

    @Test
    public void testSignatureVerificationJwksUrl() throws Exception {
        this.updateIdentityProviderWithJwksUrl();
        this.logInAsUserInIDPForFirstTime();
        this.assertLoggedInAccountManagement();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.rotateKeys();
        this.logInAsUserInIDP();
        this.assertErrorPage("Unexpected error when authenticating with identity provider");
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.setTimeOffset(20);
        this.logInAsUserInIDP();
        this.assertLoggedInAccountManagement();
    }

    private void updateIdentityProviderWithJwksUrl() {
        IdentityProviderRepresentation idpRep = this.getIdentityProvider();
        OIDCIdentityProviderConfigRep cfg = new OIDCIdentityProviderConfigRep(idpRep);
        cfg.setValidateSignature(true);
        cfg.setUseJwksUrl(true);
        UriBuilder b = OIDCLoginProtocolService.certsUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.AUTH_SERVER_ROOT));
        String jwksUrl = b.build(new Object[]{this.bc.providerRealmName()}).toString();
        cfg.setJwksUrl(jwksUrl);
        this.updateIdentityProvider(idpRep);
    }

    @Test
    public void testSignatureVerificationHardcodedPublicKey() throws Exception {
        IdentityProviderRepresentation idpRep = this.getIdentityProvider();
        OIDCIdentityProviderConfigRep cfg = new OIDCIdentityProviderConfigRep(idpRep);
        cfg.setValidateSignature(true);
        cfg.setUseJwksUrl(false);
        KeysMetadataRepresentation.KeyMetadataRepresentation key = ApiUtil.findActiveSigningKey((RealmResource)this.providerRealm());
        cfg.setPublicKeySignatureVerifier(key.getPublicKey());
        this.updateIdentityProvider(idpRep);
        this.logInAsUserInIDPForFirstTime();
        this.assertLoggedInAccountManagement();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.rotateKeys();
        this.logInAsUserInIDP();
        this.assertErrorPage("Unexpected error when authenticating with identity provider");
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.setTimeOffset(20);
        this.logInAsUserInIDP();
        this.assertErrorPage("Unexpected error when authenticating with identity provider");
    }

    @Test
    public void testSignatureVerificationHardcodedPublicKeyWithKeyIdSetExplicitly() throws Exception {
        IdentityProviderRepresentation idpRep = this.getIdentityProvider();
        OIDCIdentityProviderConfigRep cfg = new OIDCIdentityProviderConfigRep(idpRep);
        cfg.setValidateSignature(true);
        cfg.setUseJwksUrl(false);
        KeysMetadataRepresentation.KeyMetadataRepresentation key = ApiUtil.findActiveSigningKey((RealmResource)this.providerRealm());
        String pemData = key.getPublicKey();
        cfg.setPublicKeySignatureVerifier(pemData);
        String expectedKeyId = KeyUtils.createKeyId((Key)PemUtils.decodePublicKey((String)pemData));
        this.updateIdentityProvider(idpRep);
        this.logInAsUserInIDPForFirstTime();
        this.assertLoggedInAccountManagement();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        cfg.setPublicKeySignatureVerifierKeyId("invalid-key-id");
        this.updateIdentityProvider(idpRep);
        this.logInAsUserInIDP();
        this.assertErrorPage("Unexpected error when authenticating with identity provider");
        cfg.setPublicKeySignatureVerifierKeyId(expectedKeyId);
        this.updateIdentityProvider(idpRep);
        this.logInAsUserInIDP();
        this.assertLoggedInAccountManagement();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        cfg.setPublicKeySignatureVerifierKeyId("");
        this.updateIdentityProvider(idpRep);
        this.logInAsUserInIDP();
        this.assertLoggedInAccountManagement();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        cfg.setPublicKeySignatureVerifierKeyId(null);
        this.updateIdentityProvider(idpRep);
        this.logInAsUserInIDP();
        this.assertLoggedInAccountManagement();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
    }

    @Test
    public void testClearKeysCache() throws Exception {
        this.updateIdentityProviderWithJwksUrl();
        this.logInAsUserInIDPForFirstTime();
        this.assertLoggedInAccountManagement();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        IdentityProviderRepresentation idpRep = this.getIdentityProvider();
        String expectedCacheKey = PublicKeyStorageUtils.getIdpModelCacheKey((String)this.consumerRealm().toRepresentation().getId(), (String)idpRep.getInternalId());
        TestingCacheResource cache = this.testingClient.testing(this.bc.consumerRealmName()).cache("keys");
        Assert.assertTrue((boolean)cache.contains(expectedCacheKey));
        this.consumerRealm().clearKeysCache();
        Assert.assertFalse((boolean)cache.contains(expectedCacheKey));
        Assert.assertEquals((long)cache.size(), (long)0L);
    }

    @Test
    public void testPublicKeyCacheInvalidatedWhenProviderUpdated() throws Exception {
        this.updateIdentityProviderWithJwksUrl();
        this.logInAsUserInIDPForFirstTime();
        this.assertLoggedInAccountManagement();
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        IdentityProviderRepresentation idpRep = this.getIdentityProvider();
        String expectedCacheKey = PublicKeyStorageUtils.getIdpModelCacheKey((String)this.consumerRealm().toRepresentation().getId(), (String)idpRep.getInternalId());
        TestingCacheResource cache = this.testingClient.testing(this.bc.consumerRealmName()).cache("keys");
        Assert.assertTrue((boolean)cache.contains(expectedCacheKey));
        OIDCIdentityProviderConfigRep cfg = new OIDCIdentityProviderConfigRep(idpRep);
        cfg.setJwksUrl("https://localhost:43214/non-existent");
        this.updateIdentityProvider(idpRep);
        Assert.assertFalse((boolean)cache.contains(expectedCacheKey));
        this.setTimeOffset(20);
        this.logInAsUserInIDP();
        this.assertErrorPage("Unexpected error when authenticating with identity provider");
    }

    private void rotateKeys() {
        String activeKid = (String)this.providerRealm().keys().getKeyMetadata().getActive().get("RS256");
        String realmId = this.providerRealm().toRepresentation().getId();
        ComponentRepresentation keys = new ComponentRepresentation();
        keys.setName("generated");
        keys.setProviderType(KeyProvider.class.getName());
        keys.setProviderId("rsa-generated");
        keys.setParentId(realmId);
        keys.setConfig(new MultivaluedHashMap());
        keys.getConfig().putSingle((Object)"priority", (Object)Long.toString(System.currentTimeMillis()));
        Response response = this.providerRealm().components().add(keys);
        org.junit.Assert.assertEquals((long)201L, (long)response.getStatus());
        response.close();
        String updatedActiveKid = (String)this.providerRealm().keys().getKeyMetadata().getActive().get("RS256");
        org.junit.Assert.assertNotEquals((Object)activeKid, (Object)updatedActiveKid);
    }

    private RealmResource providerRealm() {
        return this.adminClient.realm(this.bc.providerRealmName());
    }

    private IdentityProviderRepresentation getIdentityProvider() {
        return this.consumerRealm().identityProviders().get("kc-oidc-idp").toRepresentation();
    }

    private void updateIdentityProvider(IdentityProviderRepresentation rep) {
        this.consumerRealm().identityProviders().get("kc-oidc-idp").update(rep);
    }

    private RealmResource consumerRealm() {
        return this.adminClient.realm(this.bc.consumerRealmName());
    }
}

