/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractIdentityProviderMapperTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;

public class JsonUserAttributeMapperTest
extends AbstractIdentityProviderMapperTest {
    public static final String USER_ATTRIBUTE = "user-attribute";

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration();
    }

    @Test
    public void loginWithIdentityProviderMapsJsonAttributeToUserAttributeButDoesNotModify() {
        UserRepresentation user = this.createMapperThenModifyAttribute(IdentityProviderMapperSyncMode.IMPORT, "new-value");
        this.assertUserAttribute("value", user);
    }

    @Test
    public void loginWithIdentityProviderDeletesAttributeInForceMode() {
        UserRepresentation user = this.createMapperThenDeleteAttribute(IdentityProviderMapperSyncMode.FORCE);
        this.assertAbsentUserAttribute(user);
    }

    @Test
    public void loginWithIdentityProviderDoesNotDeleteAttributeInLegacyMode() {
        UserRepresentation user = this.createMapperThenDeleteAttribute(IdentityProviderMapperSyncMode.LEGACY);
        this.assertUserAttribute("value", user);
    }

    @Test
    public void loginWithIdentityProviderModifiesAttributeInForceMode() {
        UserRepresentation user = this.createMapperThenModifyAttribute(IdentityProviderMapperSyncMode.FORCE, "new-value");
        this.assertUserAttribute("new-value", user);
    }

    @Test
    public void loginWithIdentityProviderAddsUserAttributeInForceNameWhenMapperIsCreatedLater() {
        UserRepresentation user = this.loginAndThenCreateMapperThenLoginAgain(IdentityProviderMapperSyncMode.FORCE);
        this.assertUserAttribute("value", user);
    }

    @Test
    public void loginWithIdentityProviderDoesNotAddUserAttributeInImportNameWhenMapperIsCreatedLater() {
        UserRepresentation user = this.loginAndThenCreateMapperThenLoginAgain(IdentityProviderMapperSyncMode.IMPORT);
        this.assertAbsentUserAttribute(user);
    }

    private UserRepresentation loginAndThenCreateMapperThenLoginAgain(IdentityProviderMapperSyncMode syncMode) {
        return this.loginAsUserTwiceWithMapper(syncMode, true, "test", "value");
    }

    private UserRepresentation createMapperThenDeleteAttribute(IdentityProviderMapperSyncMode syncMode) {
        return this.loginAsUserTwiceWithMapper(syncMode, false, "deleted", "deleted");
    }

    private UserRepresentation createMapperThenModifyAttribute(IdentityProviderMapperSyncMode syncMode, String updatedValue) {
        return this.loginAsUserTwiceWithMapper(syncMode, false, "test", updatedValue);
    }

    private UserRepresentation loginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode syncMode, boolean createAfterFirstLogin, String claim, String updatedValue) {
        IdentityProviderRepresentation idp = this.setupIdentityProvider();
        if (!createAfterFirstLogin) {
            this.createGithubProviderMapper(idp, syncMode);
        }
        this.createUserInProviderRealm(new HashMap<String, List<String>>());
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        if (!createAfterFirstLogin) {
            this.assertUserAttribute("value", user);
        } else {
            this.assertAbsentUserAttribute(user);
        }
        if (createAfterFirstLogin) {
            this.createGithubProviderMapper(idp, syncMode);
        }
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        if (!createAfterFirstLogin) {
            this.updateClaimSentToIDP(claim, updatedValue);
        }
        this.logInAsUserInIDP();
        return this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
    }

    private void updateClaimSentToIDP(String claim, String updatedValue) {
        ProtocolMapperRepresentation claimMapper = null;
        ClientRepresentation brokerClient = (ClientRepresentation)this.adminClient.realm(this.bc.providerRealmName()).clients().findByClientId("brokerapp").get(0);
        ProtocolMappersResource protocolMappers = this.adminClient.realm(this.bc.providerRealmName()).clients().get(brokerClient.getId()).getProtocolMappers();
        for (ProtocolMapperRepresentation representation : protocolMappers.getMappers()) {
            if (!representation.getProtocolMapper().equals("oidc-hardcoded-claim-mapper")) continue;
            claimMapper = representation;
        }
        Assert.assertThat(claimMapper, (Matcher)Matchers.notNullValue());
        claimMapper.getConfig().put("claim.value", "{\"" + claim + "\": \"" + updatedValue + "\"}");
        this.adminClient.realm(this.bc.providerRealmName()).clients().get(brokerClient.getId()).getProtocolMappers().update(claimMapper.getId(), claimMapper);
    }

    private void assertUserAttribute(String value, UserRepresentation userRep) {
        Assert.assertThat((Object)userRep.getAttributes(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)((List)userRep.getAttributes().get(USER_ATTRIBUTE)), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{value}));
    }

    private void assertAbsentUserAttribute(UserRepresentation userRep) {
        Assert.assertThat((Object)userRep.getAttributes(), (Matcher)Matchers.nullValue());
    }

    private void createGithubProviderMapper(IdentityProviderRepresentation idp, IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderMapperRepresentation githubProvider = new IdentityProviderMapperRepresentation();
        githubProvider.setName("json-attribute-mapper");
        githubProvider.setIdentityProviderMapper("github-user-attribute-mapper");
        githubProvider.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)syncMode.toString()).put((Object)"jsonField", (Object)"user-claim.test").put((Object)"userAttribute", (Object)USER_ATTRIBUTE).build());
        IdentityProviderResource idpResource = this.realm.identityProviders().get(idp.getAlias());
        githubProvider.setIdentityProviderAlias(this.bc.getIDPAlias());
        idpResource.addMapper(githubProvider).close();
    }
}

