/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcOidcBrokerConfiguration;
import org.keycloak.testsuite.util.FederatedIdentityBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class BrokerWithLegacyIdTest
extends AbstractInitializedBaseBrokerTest {
    private static final UserRepresentation consumerUser = UserBuilder.create().username("anakin").firstName("Darth").lastName("Vader").email("anakin@skywalker.tatooine").password("Come to the Dark Side. We have cookies").build();
    private UserResource consumerUserResource;

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcOidcBrokerConfiguration(){

            @Override
            public IdentityProviderRepresentation setUpIdentityProvider(IdentityProviderSyncMode syncMode) {
                IdentityProviderRepresentation idp = super.setUpIdentityProvider(syncMode);
                idp.setProviderId("legacy-id-idp");
                return idp;
            }
        };
    }

    @Override
    public void beforeBrokerTest() {
        super.beforeBrokerTest();
        RealmResource consumerRealm = this.realmsResouce().realm(this.bc.consumerRealmName());
        String consumerUserId = ApiUtil.createUserWithAdminClient((RealmResource)consumerRealm, (UserRepresentation)consumerUser);
        FederatedIdentityRepresentation identity = FederatedIdentityBuilder.create().userId("3.14159265359").userName(this.bc.getUserLogin()).identityProvider("kc-oidc-idp").build();
        this.consumerUserResource = consumerRealm.users().get(consumerUserId);
        this.consumerUserResource.addFederatedIdentity("kc-oidc-idp", identity);
    }

    @Test
    public void loginWithLegacyId() {
        Assert.assertEquals((Object)"3.14159265359", (Object)this.getFederatedIdentity().getUserId());
        this.logInAsUserInIDP();
        Assert.assertEquals((Object)this.userId, (Object)this.getFederatedIdentity().getUserId());
        this.assertLoggedInAccountManagement(consumerUser.getUsername(), consumerUser.getEmail());
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.logInAsUserInIDP();
        Assert.assertEquals((Object)this.userId, (Object)this.getFederatedIdentity().getUserId());
        this.assertLoggedInAccountManagement(consumerUser.getUsername(), consumerUser.getEmail());
    }

    private FederatedIdentityRepresentation getFederatedIdentity() {
        List identities = this.consumerUserResource.getFederatedIdentity();
        Assert.assertEquals((long)1L, (long)identities.size());
        return (FederatedIdentityRepresentation)identities.get(0);
    }
}

