/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.http.client.utils.URIBuilder;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class BrokerTestTools {
    private static String providerRoot;
    private static String consumerRoot;

    public static String getProviderRoot() {
        if (providerRoot == null) {
            providerRoot = new URIBuilder(URI.create(BrokerTestTools.getConsumerRoot())).setHost(ServerURLs.AUTH_SERVER_HOST2).toString();
        }
        return providerRoot;
    }

    public static String getConsumerRoot() {
        if (consumerRoot == null) {
            consumerRoot = ServerURLs.getAuthServerContextRoot();
        }
        return consumerRoot;
    }

    public static IdentityProviderRepresentation createIdentityProvider(String alias, String providerId) {
        IdentityProviderRepresentation identityProviderRepresentation = new IdentityProviderRepresentation();
        identityProviderRepresentation.setAlias(alias);
        identityProviderRepresentation.setDisplayName(alias);
        identityProviderRepresentation.setProviderId(providerId);
        identityProviderRepresentation.setEnabled(true);
        return identityProviderRepresentation;
    }

    public static void waitForPage(WebDriver driver, String title, boolean isHtmlTitle) {
        WaitUtils.waitForPageToLoad();
        WebDriverWait wait = new WebDriverWait(driver, 5L);
        ExpectedCondition condition = input -> isHtmlTitle ? input.getTitle().toLowerCase().contains(title) : PageUtils.getPageTitle((WebDriver)input).toLowerCase().contains(title);
        wait.until((Function)condition);
    }

    public static void waitForElementEnabled(WebDriver driver, String elementName) {
        WebDriverWait wait = new WebDriverWait(driver, 5L);
        ExpectedCondition condition = input -> {
            List elements = input.findElements(By.name((String)elementName));
            return !elements.isEmpty() && ((WebElement)elements.get(0)).isEnabled();
        };
        wait.until((Function)condition);
    }

    public static String encodeUrl(String url) {
        String result;
        try {
            result = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            result = url;
        }
        return result;
    }

    public static void createKcOidcBroker(Keycloak adminClient, String childRealm, String idpRealm) {
        BrokerTestTools.createKcOidcBroker(adminClient, childRealm, idpRealm, idpRealm, false);
    }

    public static void createKcOidcBroker(Keycloak adminClient, String childRealm, String idpRealm, String alias, boolean linkOnly) {
        IdentityProviderRepresentation idp = BrokerTestTools.createIdentityProvider(alias, "keycloak-oidc");
        idp.setLinkOnly(linkOnly);
        idp.setStoreToken(true);
        Map config = idp.getConfig();
        config.put("clientId", childRealm);
        config.put("clientSecret", childRealm);
        config.put("authorizationUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + idpRealm + "/protocol/openid-connect/auth");
        config.put("tokenUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + idpRealm + "/protocol/openid-connect/token");
        config.put("logoutUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + idpRealm + "/protocol/openid-connect/logout");
        config.put("userInfoUrl", BrokerTestTools.getProviderRoot() + "/auth/realms/" + idpRealm + "/protocol/openid-connect/userinfo");
        config.put("backchannelSupported", "true");
        adminClient.realm(childRealm).identityProviders().create(idp);
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(childRealm);
        client.setName(childRealm);
        client.setSecret(childRealm);
        client.setEnabled(Boolean.valueOf(true));
        client.setRedirectUris(Collections.singletonList(BrokerTestTools.getConsumerRoot() + "/auth/realms/" + childRealm + "/broker/" + idpRealm + "/endpoint/*"));
        client.setAdminUrl(BrokerTestTools.getConsumerRoot() + "/auth/realms/" + childRealm + "/broker/" + idpRealm + "/endpoint");
        adminClient.realm(idpRealm).clients().create(client);
    }
}

