/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.pages.AccountFederatedIdentityPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.UpdateAccountInformationPage;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class AccountLinkTest
extends AbstractKeycloakTest {
    public static final String CHILD_IDP = "child";
    public static final String PARENT_IDP = "parent-idp";
    public static final String PARENT_USERNAME = "parent";
    @Page
    protected AccountFederatedIdentityPage accountFederatedIdentityPage;
    @Page
    protected UpdateAccountInformationPage profilePage;
    @Page
    protected LoginPage loginPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(CHILD_IDP);
        realm.setEnabled(Boolean.valueOf(true));
        testRealms.add(realm);
        realm = new RealmRepresentation();
        realm.setRealm(PARENT_IDP);
        realm.setEnabled(Boolean.valueOf(true));
        testRealms.add(realm);
    }

    @Before
    public void beforeBrokerTest() {
        if (this.testContext.isInitialized()) {
            return;
        }
        RealmResource realmParent = this.adminClient.realms().realm(PARENT_IDP);
        UserRepresentation user = new UserRepresentation();
        user.setUsername(PARENT_USERNAME);
        user.setEnabled(Boolean.valueOf(true));
        String userId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)realmParent, (UserRepresentation)user, (String)"password");
        RealmResource realmChild = this.adminClient.realms().realm(CHILD_IDP);
        user = new UserRepresentation();
        user.setUsername(CHILD_IDP);
        user.setEnabled(Boolean.valueOf(true));
        userId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)realmChild, (UserRepresentation)user, (String)"password");
        ComponentRepresentation provider = new ComponentRepresentation();
        provider.setName("passthrough");
        provider.setProviderId("pass-through-federated");
        provider.setProviderType(UserStorageProvider.class.getName());
        provider.setConfig(new MultivaluedHashMap());
        provider.getConfig().putSingle((Object)"priority", (Object)Integer.toString(1));
        realmChild.components().add(provider);
        this.createParentChild();
        this.testContext.setInitialized(true);
    }

    public void createParentChild() {
        BrokerTestTools.createKcOidcBroker(this.adminClient, CHILD_IDP, PARENT_IDP);
    }

    @Test
    public void testAccountLink() {
        String childUsername = CHILD_IDP;
        String childPassword = "password";
        String childIdp = CHILD_IDP;
        this.testAccountLink(childUsername, childPassword, childIdp);
    }

    @Test
    public void testAccountLinkWithUserStorageProvider() {
        String childUsername = "passthrough";
        String childPassword = "secret";
        String childIdp = CHILD_IDP;
        this.testAccountLink(childUsername, childPassword, childIdp);
    }

    @Test
    public void testDeleteIdentityOnProviderRemoval() {
        String childUsername = CHILD_IDP;
        String childPassword = "password";
        String childIdp = CHILD_IDP;
        this.assertFederatedIdentity(childUsername, childPassword, childIdp);
        RealmResource realm = this.adminClient.realm(CHILD_IDP);
        UsersResource users = realm.users();
        List search = users.search(childUsername);
        Assert.assertFalse((boolean)search.isEmpty());
        String userId = ((UserRepresentation)search.get(0)).getId();
        List identities = users.get(userId).getFederatedIdentity();
        Assert.assertFalse((boolean)identities.isEmpty());
        realm.identityProviders().get(PARENT_IDP).remove();
        identities = users.get(userId).getFederatedIdentity();
        Assert.assertTrue((boolean)identities.isEmpty());
        this.getTestingClient().server(CHILD_IDP).run(AccountLinkTest::checkEmptyFederatedIdentities);
    }

    private static void checkEmptyFederatedIdentities(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        UserModel user = session.users().getUserByUsername(realm, CHILD_IDP);
        Assert.assertEquals((long)0L, (long)session.users().getFederatedIdentitiesStream(realm, user).count());
        Assert.assertNull((Object)session.users().getFederatedIdentity(realm, user, PARENT_IDP));
    }

    protected void testAccountLink(String childUsername, String childPassword, String childIdp) {
        this.assertFederatedIdentity(childUsername, childPassword, childIdp);
        this.assertRemoveFederatedIdentity();
    }

    private void assertFederatedIdentity(String childUsername, String childPassword, String childIdp) {
        this.accountFederatedIdentityPage.realm(childIdp);
        this.accountFederatedIdentityPage.open();
        this.loginPage.isCurrent();
        this.loginPage.login(childUsername, childPassword);
        Assert.assertTrue((boolean)this.accountFederatedIdentityPage.isCurrent());
        this.accountFederatedIdentityPage.clickAddProvider(PARENT_IDP);
        this.loginPage.isCurrent();
        this.loginPage.login(PARENT_USERNAME, "password");
        Assert.assertTrue((boolean)this.accountFederatedIdentityPage.isCurrent());
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("id=\"remove-link-parent-idp\""));
        this.accountFederatedIdentityPage.logout();
        this.loginPage.isCurrent();
        this.loginPage.clickSocial(PARENT_IDP);
        this.loginPage.login(PARENT_USERNAME, "password");
        System.out.println(this.driver.getCurrentUrl());
        System.out.println("--------------------------------");
        System.out.println(this.driver.getPageSource());
        Assert.assertTrue((boolean)this.accountFederatedIdentityPage.isCurrent());
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("id=\"remove-link-parent-idp\""));
    }

    private void assertRemoveFederatedIdentity() {
        this.accountFederatedIdentityPage.clickRemoveProvider(PARENT_IDP);
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("id=\"add-link-parent-idp\""));
        this.accountFederatedIdentityPage.logout();
        this.loginPage.clickSocial(PARENT_IDP);
        this.loginPage.login(PARENT_USERNAME, "password");
        this.profilePage.assertCurrent();
    }
}

