/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.broker.AbstractIdentityProviderMapperTest;
import org.keycloak.testsuite.broker.BrokerTestTools;

public abstract class AbstractUsernameTemplateMapperTest
extends AbstractIdentityProviderMapperTest {
    protected abstract String getMapperTemplate();

    protected abstract void createMapperInIdp(IdentityProviderRepresentation var1, IdentityProviderMapperSyncMode var2);

    @Test
    public void testUsernameGetsInsertedFromClaim() {
        this.loginAsUserTwiceWithMapperWillNotUpdateUsername(IdentityProviderMapperSyncMode.IMPORT);
    }

    @Test
    public void testUsernameGetsUpdatedFromClaimInForceMode() {
        this.loginAsUserTwiceWithMapperUpdatesUsername(IdentityProviderMapperSyncMode.FORCE);
    }

    @Test
    public void testUsernameDoesNotGetUpdatedInLegacyMode() {
        this.loginAsUserTwiceWithMapperWillNotUpdateUsername(IdentityProviderMapperSyncMode.LEGACY);
    }

    private void loginAsUserTwiceWithMapperUpdatesUsername(IdentityProviderMapperSyncMode syncMode) {
        this.loginAsUserTwiceWithMapper(syncMode, "customusername", "newname", true);
    }

    private void loginAsUserTwiceWithMapperWillNotUpdateUsername(IdentityProviderMapperSyncMode syncMode) {
        this.loginAsUserTwiceWithMapper(syncMode, "customusername", "newname", false);
    }

    private void loginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode syncMode, String userName, String updatedUserName, boolean updatingUserName) {
        IdentityProviderRepresentation idp = this.setupIdentityProvider();
        this.createMapperInIdp(idp, syncMode);
        this.createUserInProviderRealm((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)userName).build()).build());
        this.logInAsUserInIDPForFirstTime();
        String mappedUserName = String.format(this.getMapperTemplate(), userName);
        this.findUser(this.bc.consumerRealmName(), mappedUserName, this.bc.getUserEmail());
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.updateUser(updatedUserName);
        this.logInAsUserInIDP();
        String updatedMappedUserName = String.format(this.getMapperTemplate(), updatedUserName);
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), updatingUserName ? updatedMappedUserName : mappedUserName, this.bc.getUserEmail());
        if (updatingUserName) {
            org.junit.Assert.assertThat((Object)user.getUsername(), (Matcher)Matchers.is((Object)updatedMappedUserName));
        } else {
            org.junit.Assert.assertThat((Object)user.getUsername(), (Matcher)Matchers.is((Object)mappedUserName));
        }
    }

    @Override
    protected void logInAsUserInIDPForFirstTime() {
        this.logInAsUserInIDP();
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        Assert.assertTrue((boolean)this.updateAccountInformationPage.isCurrent());
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation(this.bc.getUserEmail(), "FirstName", "LastName");
    }

    private void updateUser(String updatedUserName) {
        UserRepresentation user = this.findUser(this.bc.providerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        ImmutableMap matchingAttributes = ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)updatedUserName).build()).build();
        user.setAttributes((Map)matchingAttributes);
        this.adminClient.realm(this.bc.providerRealmName()).users().get(user.getId()).update(user);
    }
}

