/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractIdentityProviderMapperTest;
import org.keycloak.testsuite.broker.BrokerTestTools;

public abstract class AbstractUserAttributeMapperTest
extends AbstractIdentityProviderMapperTest {
    protected static final String MAPPED_ATTRIBUTE_NAME = "mapped-user-attribute";
    protected static final String MAPPED_ATTRIBUTE_FRIENDLY_NAME = "mapped-user-attribute-friendly";
    private static final Set<String> PROTECTED_NAMES = ImmutableSet.builder().add((Object)"email").add((Object)"lastName").add((Object)"firstName").build();
    private static final Map<String, String> ATTRIBUTE_NAME_TRANSLATION = ImmutableMap.builder().put((Object)"dotted.email", (Object)"dotted.email").put((Object)"nested.email", (Object)"nested.email").put((Object)"user-attribute-friendly", (Object)"mapped-user-attribute-friendly").put((Object)"user-attribute", (Object)"mapped-user-attribute").build();

    protected abstract Iterable<IdentityProviderMapperRepresentation> createIdentityProviderMappers(IdentityProviderMapperSyncMode var1);

    public void addIdentityProviderToConsumerRealm(IdentityProviderMapperSyncMode syncMode) {
        IdentityProviderRepresentation idp = this.setupIdentityProvider();
        IdentityProviderResource idpResource = this.realm.identityProviders().get(idp.getAlias());
        for (IdentityProviderMapperRepresentation mapper : this.createIdentityProviderMappers(syncMode)) {
            mapper.setIdentityProviderAlias(this.bc.getIDPAlias());
            idpResource.addMapper(mapper).close();
        }
    }

    private void assertUserAttributes(Map<String, List<String>> attrs, UserRepresentation userRep) {
        Set mappedAttrNames = attrs.entrySet().stream().filter(me -> me.getValue() != null && !((List)me.getValue()).isEmpty()).map(me -> (String)me.getKey()).filter(a -> !PROTECTED_NAMES.contains(a)).map(ATTRIBUTE_NAME_TRANSLATION::get).collect(Collectors.toSet());
        if (mappedAttrNames.isEmpty()) {
            Assert.assertThat((String)"No attributes are expected to be present", (Object)userRep.getAttributes(), (Matcher)Matchers.nullValue());
        } else {
            Assert.assertThat((Object)userRep.getAttributes(), (Matcher)Matchers.notNullValue());
            Assert.assertThat(userRep.getAttributes().keySet(), (Matcher)Matchers.equalTo(mappedAttrNames));
            for (Map.Entry<String, List<String>> me2 : attrs.entrySet()) {
                String mappedAttrName = ATTRIBUTE_NAME_TRANSLATION.get(me2.getKey());
                if (!mappedAttrNames.contains(mappedAttrName)) continue;
                Assert.assertThat((Object)((List)userRep.getAttributes().get(mappedAttrName)), (Matcher)Matchers.containsInAnyOrder((Object[])me2.getValue().toArray()));
            }
        }
        if (attrs.containsKey("email")) {
            Assert.assertThat((Object)userRep.getEmail(), (Matcher)Matchers.equalTo((Object)attrs.get("email").get(0)));
        }
        if (attrs.containsKey("firstName")) {
            Assert.assertThat((Object)userRep.getFirstName(), (Matcher)Matchers.equalTo((Object)attrs.get("firstName").get(0)));
        }
        if (attrs.containsKey("lastName")) {
            Assert.assertThat((Object)userRep.getLastName(), (Matcher)Matchers.equalTo((Object)attrs.get("lastName").get(0)));
        }
    }

    private void testValueMappingForImportSyncMode(Map<String, List<String>> initialUserAttributes, Map<String, List<String>> modifiedUserAttributes) {
        this.addIdentityProviderToConsumerRealm(IdentityProviderMapperSyncMode.IMPORT);
        this.testValueMapping(initialUserAttributes, modifiedUserAttributes, initialUserAttributes);
    }

    private void testValueMappingForForceSyncMode(Map<String, List<String>> initialUserAttributes, Map<String, List<String>> modifiedUserAttributes) {
        this.addIdentityProviderToConsumerRealm(IdentityProviderMapperSyncMode.FORCE);
        this.testValueMapping(initialUserAttributes, modifiedUserAttributes, modifiedUserAttributes);
    }

    private void testValueMappingForLegacySyncMode(Map<String, List<String>> initialUserAttributes, Map<String, List<String>> modifiedUserAttributes) {
        this.addIdentityProviderToConsumerRealm(IdentityProviderMapperSyncMode.LEGACY);
        this.testValueMapping(initialUserAttributes, modifiedUserAttributes, modifiedUserAttributes);
    }

    private void testValueMapping(Map<String, List<String>> initialUserAttributes, Map<String, List<String>> modifiedUserAttributes, Map<String, List<String>> assertedModifiedAttributes) {
        String email = this.bc.getUserEmail();
        this.createUserInProviderRealm(initialUserAttributes);
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation userRep = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), email);
        this.assertUserAttributes(initialUserAttributes, userRep);
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        UserRepresentation userRepProvider = this.findUser(this.bc.providerRealmName(), this.bc.getUserLogin(), email);
        Map<String, List> modifiedWithoutSpecialKeys = modifiedUserAttributes.entrySet().stream().filter(a -> !PROTECTED_NAMES.contains(a.getKey())).filter(a -> a.getValue() != null).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (List)p.getValue()));
        userRepProvider.setAttributes(modifiedWithoutSpecialKeys);
        if (modifiedUserAttributes.containsKey("email")) {
            userRepProvider.setEmail(modifiedUserAttributes.get("email").get(0));
            email = modifiedUserAttributes.get("email").get(0);
        }
        if (modifiedUserAttributes.containsKey("firstName")) {
            userRepProvider.setFirstName(modifiedUserAttributes.get("firstName").get(0));
        }
        if (modifiedUserAttributes.containsKey("lastName")) {
            userRepProvider.setLastName(modifiedUserAttributes.get("lastName").get(0));
        }
        this.adminClient.realm(this.bc.providerRealmName()).users().get(userRepProvider.getId()).update(userRepProvider);
        this.logInAsUserInIDP();
        userRep = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), email);
        this.assertUserAttributes(assertedModifiedAttributes, userRep);
    }

    @Test
    public void testBasicMappingSingleValueForce() {
        this.testValueMappingForForceSyncMode((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").build()).build(), (Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"second value").build()).build());
    }

    @Test
    public void testBasicMappingSingleValueImport() {
        this.testValueMappingForImportSyncMode((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").build()).build(), (Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"second value").build()).build());
    }

    @Test
    public void testBasicMappingEmail() {
        this.testValueMappingForForceSyncMode((Map<String, List<String>>)ImmutableMap.builder().put((Object)"email", (Object)ImmutableList.builder().add((Object)this.bc.getUserEmail()).build()).put((Object)"nested.email", (Object)ImmutableList.builder().add((Object)this.bc.getUserEmail()).build()).put((Object)"dotted.email", (Object)ImmutableList.builder().add((Object)this.bc.getUserEmail()).build()).build(), (Map<String, List<String>>)ImmutableMap.builder().put((Object)"email", (Object)ImmutableList.builder().add((Object)"other_email@redhat.com").build()).put((Object)"nested.email", (Object)ImmutableList.builder().add((Object)"other_email@redhat.com").build()).put((Object)"dotted.email", (Object)ImmutableList.builder().add((Object)"other_email@redhat.com").build()).build());
    }

    @Test
    public void testBasicMappingAttributeGetsModifiedInSyncModeForce() {
        this.testValueMappingForForceSyncMode((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").build()).build(), (Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().build()).build());
    }

    @Test
    public void testBasicMappingAttributeGetsRemovedInSyncModeForce() {
        this.testValueMappingForForceSyncMode((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").build()).build(), (Map<String, List<String>>)ImmutableMap.builder().build());
    }

    @Test
    public void testBasicMappingAttributeWithMultipleValuesIsModifiedInSyncModeForce() {
        this.testValueMappingForForceSyncMode((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").add((Object)"value 2").build()).build(), (Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"second value").add((Object)"second value 2").build()).build());
    }

    @Test
    public void testBasicMappingAttributeWithMultipleValuesIsModifiedInSyncModeLegacy() {
        this.testValueMappingForLegacySyncMode((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").add((Object)"value 2").build()).build(), (Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"second value").add((Object)"second value 2").build()).build());
    }

    @Test
    public void testBasicMappingAttributeWithMultipleValuesDoesNotGetModifiedInSyncModeImport() {
        this.testValueMappingForImportSyncMode((Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"value 1").add((Object)"value 2").build()).build(), (Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"second value").add((Object)"second value 2").build()).build());
    }

    @Test
    public void testBasicMappingAttributeWithMultipleValuesGetsAddedInSyncModeForce() {
        this.testValueMappingForForceSyncMode((Map<String, List<String>>)ImmutableMap.builder().build(), (Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"second value").add((Object)"second value 2").build()).build());
    }

    @Test
    public void testBasicMappingAttributeWithMultipleValuesDoesNotGetAddedInSyncModeImport() {
        this.testValueMappingForImportSyncMode((Map<String, List<String>>)ImmutableMap.builder().build(), (Map<String, List<String>>)ImmutableMap.builder().put((Object)"user-attribute", (Object)ImmutableList.builder().add((Object)"second value").add((Object)"second value 2").build()).build());
    }
}

