/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import org.junit.Test;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerConfiguration;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

public abstract class AbstractSamlLoginHintTest
extends AbstractInitializedBaseBrokerTest {
    @Test
    public void testPassLoginHintShouldSendSubjectAndPrefillUsername() {
        String username = "all-info-set@localhost.com";
        this.createUser(this.bc.providerRealmName(), username, "password", new String[0]);
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.addLoginHintOnSocialButton(username);
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        if (this.isLoginHintOptionEnabled()) {
            org.junit.Assert.assertEquals((String)"Username input should contain the SAML subject", (Object)this.loginPage.getUsername(), (Object)username);
        } else {
            org.junit.Assert.assertEquals((String)"Username input should the SAML subject", (Object)this.loginPage.getUsername(), (Object)"");
        }
    }

    @Test
    public void testPassEmptyLoginHintShouldNotSendSubjectAndShouldNotPrefillUsername() {
        String username = "all-info-set@localhost.com";
        this.createUser(this.bc.providerRealmName(), username, "password", "FirstName");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.bc.getIDPAlias()));
        this.addLoginHintOnSocialButton("");
        this.loginPage.clickSocial(this.bc.getIDPAlias());
        BrokerTestTools.waitForPage(this.driver, "sign in to", true);
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        org.junit.Assert.assertEquals((String)"Username input should not contain any username", (Object)this.loginPage.getUsername(), (Object)"");
    }

    abstract boolean isLoginHintOptionEnabled();

    protected void addLoginHintOnSocialButton(String hint) {
        JavascriptExecutor executor = (JavascriptExecutor)this.driver;
        WebElement button = this.loginPage.findSocialButton(this.bc.getIDPAlias());
        String url = button.getAttribute("href") + "&" + "login_hint" + "=" + hint;
        executor.executeScript("document.getElementById('" + button.getAttribute("id") + "').setAttribute('href', '" + url + "')", new Object[0]);
    }

    @Override
    protected BrokerConfiguration getBrokerConfiguration() {
        return new KcSamlBrokerConfiguration(this.isLoginHintOptionEnabled());
    }
}

