/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractIdentityProviderMapperTest;
import org.keycloak.testsuite.broker.BrokerTestTools;

public abstract class AbstractRoleMapperTest
extends AbstractIdentityProviderMapperTest {
    private static final String CLIENT = "realm-management";
    private static final String CLIENT_ROLE = "view-realm";
    public static final String ROLE_USER = "user";
    public static final String CLIENT_ROLE_MAPPER_REPRESENTATION = "realm-management.view-realm";

    protected abstract void createMapperInIdp(IdentityProviderRepresentation var1, IdentityProviderMapperSyncMode var2);

    protected void updateUser() {
    }

    protected UserRepresentation loginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode syncMode, boolean createAfterFirstLogin, Map<String, List<String>> userConfig) {
        IdentityProviderRepresentation idp = this.setupIdentityProvider();
        if (!createAfterFirstLogin) {
            this.createMapperInIdp(idp, syncMode);
        }
        this.createUserInProviderRealm(userConfig);
        this.createUserRoleAndGrantToUserInProviderRealm();
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        if (!createAfterFirstLogin) {
            this.assertThatRoleHasBeenAssignedInConsumerRealmTo(user);
        } else {
            this.assertThatRoleHasNotBeenAssignedInConsumerRealmTo(user);
        }
        if (createAfterFirstLogin) {
            this.createMapperInIdp(idp, syncMode);
        }
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.updateUser();
        this.logInAsUserInIDP();
        user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        return user;
    }

    protected void createUserRoleAndGrantToUserInProviderRealm() {
        RoleRepresentation userRole = new RoleRepresentation(ROLE_USER, null, false);
        this.adminClient.realm(this.bc.providerRealmName()).roles().create(userRole);
        RoleRepresentation role = this.adminClient.realm(this.bc.providerRealmName()).roles().get(ROLE_USER).toRepresentation();
        UserResource userResource = this.adminClient.realm(this.bc.providerRealmName()).users().get(this.userId);
        userResource.roles().realmLevel().add(Collections.singletonList(role));
    }

    protected void assertThatRoleHasBeenAssignedInConsumerRealmTo(UserRepresentation user) {
        Assert.assertThat((Object)((List)user.getClientRoles().get(CLIENT)), (Matcher)Matchers.contains((Object[])new String[]{CLIENT_ROLE}));
    }

    protected void assertThatRoleHasNotBeenAssignedInConsumerRealmTo(UserRepresentation user) {
        Assert.assertThat((Object)((List)user.getClientRoles().get(CLIENT)), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{CLIENT_ROLE})));
    }
}

