/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.function.BiConsumer;
import org.junit.Before;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractBaseBrokerTest;

public abstract class AbstractInitializedBaseBrokerTest
extends AbstractBaseBrokerTest {
    protected IdentityProviderResource identityProviderResource;

    @Override
    @Before
    public void beforeBrokerTest() {
        super.beforeBrokerTest();
        this.log.debug((Object)("creating user for realm " + this.bc.providerRealmName()));
        UserRepresentation user = new UserRepresentation();
        user.setUsername(this.bc.getUserLogin());
        user.setEmail(this.bc.getUserEmail());
        user.setEmailVerified(Boolean.valueOf(true));
        user.setEnabled(Boolean.valueOf(true));
        RealmResource realmResource = this.adminClient.realm(this.bc.providerRealmName());
        this.userId = ApiUtil.createUserWithAdminClient((RealmResource)realmResource, (UserRepresentation)user);
        ApiUtil.resetUserPassword((UserResource)realmResource.users().get(this.userId), (String)this.bc.getUserPassword(), (boolean)false);
        this.log.debug((Object)("adding identity provider to realm " + this.bc.consumerRealmName()));
        RealmResource realm = this.adminClient.realm(this.bc.consumerRealmName());
        realm.identityProviders().create(this.bc.setUpIdentityProvider()).close();
        this.identityProviderResource = realm.identityProviders().get(this.bc.getIDPAlias());
        this.addClientsToProviderAndConsumer();
        this.testContext.setInitialized(true);
    }

    protected void updateExecutions(BiConsumer<AuthenticationExecutionInfoRepresentation, AuthenticationManagementResource> action) {
        AuthenticationManagementResource flows = this.adminClient.realm(this.bc.consumerRealmName()).flows();
        for (AuthenticationExecutionInfoRepresentation execution : flows.getExecutions("first broker login")) {
            action.accept(execution, flows);
        }
    }
}

