/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.broker.AbstractBaseBrokerTest;
import org.keycloak.testsuite.util.UserBuilder;

public abstract class AbstractIdentityProviderMapperTest
extends AbstractBaseBrokerTest {
    protected RealmResource realm;

    @Before
    public void addClients() {
        this.addClientsToProviderAndConsumer();
        this.realm = this.adminClient.realm(this.bc.consumerRealmName());
    }

    protected IdentityProviderRepresentation setupIdentityProvider() {
        this.log.debug((Object)("adding identity provider to realm " + this.bc.consumerRealmName()));
        IdentityProviderRepresentation idp = this.bc.setUpIdentityProvider();
        this.realm.identityProviders().create(idp).close();
        return idp;
    }

    protected IdentityProviderRepresentation setupIdentityProviderDisableUserInfo() {
        this.log.debug((Object)("adding identity provider to realm " + this.bc.consumerRealmName()));
        IdentityProviderRepresentation idp = this.bc.setUpIdentityProvider();
        idp.getConfig().put("disableUserInfo", "true");
        this.realm.identityProviders().create(idp).close();
        return idp;
    }

    protected void createUserInProviderRealm(Map<String, List<String>> attributes) {
        this.log.debug((Object)("Creating user in realm " + this.bc.providerRealmName()));
        UserRepresentation user = UserBuilder.create().username(this.bc.getUserLogin()).email(this.bc.getUserEmail()).build();
        user.setEmailVerified(Boolean.valueOf(true));
        user.setAttributes(attributes);
        this.userId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.adminClient.realm(this.bc.providerRealmName()), (UserRepresentation)user, (String)this.bc.getUserPassword());
    }

    protected UserRepresentation findUser(String realm, String userName, String email) {
        UsersResource consumerUsers = this.adminClient.realm(realm).users();
        List users = consumerUsers.list();
        Assert.assertThat((String)"There must be exactly one user", (Object)users, (Matcher)Matchers.hasSize((int)1));
        UserRepresentation user = (UserRepresentation)users.get(0);
        Assert.assertThat((String)"Username has to match", (Object)user.getUsername(), (Matcher)Matchers.equalTo((Object)userName));
        Assert.assertThat((String)"Email has to match", (Object)user.getEmail(), (Matcher)Matchers.equalTo((Object)email));
        MappingsRepresentation roles = consumerUsers.get(user.getId()).roles().getAll();
        List realmRoles = roles.getRealmMappings().stream().map(RoleRepresentation::getName).collect(Collectors.toList());
        user.setRealmRoles(realmRoles);
        HashMap clientRoles = new HashMap();
        if (roles.getClientMappings() != null) {
            roles.getClientMappings().forEach((key, value) -> clientRoles.put(key, value.getMappings().stream().map(RoleRepresentation::getName).collect(Collectors.toList())));
        }
        user.setClientRoles(clientRoles);
        return user;
    }
}

