/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.broker.AbstractIdentityProviderMapperTest;
import org.keycloak.testsuite.broker.BrokerTestTools;

public abstract class AbstractGroupMapperTest
extends AbstractIdentityProviderMapperTest {
    public static final String MAPPER_TEST_GROUP_NAME = "mapper-test";
    public static final String MAPPER_TEST_GROUP_PATH = "/mapper-test";

    protected abstract void createMapperInIdp(IdentityProviderRepresentation var1, IdentityProviderMapperSyncMode var2);

    protected void updateUser() {
    }

    protected UserRepresentation loginAsUserTwiceWithMapper(IdentityProviderMapperSyncMode syncMode, boolean createAfterFirstLogin, Map<String, List<String>> userConfig) {
        IdentityProviderRepresentation idp = this.setupIdentityProvider();
        if (!createAfterFirstLogin) {
            this.createMapperInIdp(idp, syncMode);
        }
        this.createUserInProviderRealm(userConfig);
        this.logInAsUserInIDPForFirstTime();
        UserRepresentation user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        if (!createAfterFirstLogin) {
            this.assertThatUserHasBeenAssignedToGroup(user);
        } else {
            this.assertThatUserHasNotBeenAssignedToGroup(user);
        }
        if (createAfterFirstLogin) {
            this.createMapperInIdp(idp, syncMode);
        }
        this.logoutFromRealm(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName());
        this.updateUser();
        this.logInAsUserInIDP();
        user = this.findUser(this.bc.consumerRealmName(), this.bc.getUserLogin(), this.bc.getUserEmail());
        return user;
    }

    protected void assertThatUserHasBeenAssignedToGroup(UserRepresentation user) {
        ArrayList groupNames = new ArrayList();
        this.realm.users().get(user.getId()).groups().forEach(group -> groupNames.add(group.getName()));
        Assert.assertTrue((boolean)groupNames.contains(MAPPER_TEST_GROUP_NAME));
    }

    protected void assertThatUserHasNotBeenAssignedToGroup(UserRepresentation user) {
        ArrayList groupNames = new ArrayList();
        this.realm.users().get(user.getId()).groups().forEach(group -> groupNames.add(group.getName()));
        Assert.assertFalse((boolean)groupNames.contains(MAPPER_TEST_GROUP_NAME));
    }
}

