/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.broker;

import java.util.List;
import java.util.Map;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.broker.AbstractInitializedBaseBrokerTest;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.pages.ConsentPage;

public abstract class AbstractBrokerTest
extends AbstractInitializedBaseBrokerTest {
    public static final String ROLE_USER = "user";
    public static final String ROLE_MANAGER = "manager";
    public static final String ROLE_FRIENDLY_MANAGER = "friendly-manager";
    public static final String ROLE_USER_DOT_GUIDE = "user.guide";
    public static final String EMPTY_ATTRIBUTE_ROLE = "empty.attribute.role";
    @Page
    ConsentPage consentPage;

    @Test
    public void testLogInAsUserInIDP() {
        this.loginUser();
        this.testSingleLogout();
    }

    protected void loginUser() {
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        BrokerTestTools.waitForPage(this.driver, "update account information", false);
        this.updateAccountInformationPage.assertCurrent();
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/"));
        this.log.debug((Object)"Updating info on updateAccount page");
        this.updateAccountInformationPage.updateAccountInformation(this.bc.getUserLogin(), this.bc.getUserEmail(), "Firstname", "Lastname");
        UsersResource consumerUsers = this.adminClient.realm(this.bc.consumerRealmName()).users();
        int userCount = consumerUsers.count();
        Assert.assertTrue((String)"There must be at least one user", (userCount > 0 ? 1 : 0) != 0);
        List users = consumerUsers.search("", Integer.valueOf(0), Integer.valueOf(userCount));
        boolean isUserFound = false;
        for (UserRepresentation user : users) {
            if (!user.getUsername().equals(this.bc.getUserLogin()) || !user.getEmail().equals(this.bc.getUserEmail())) continue;
            isUserFound = true;
            break;
        }
        Assert.assertTrue((String)("There must be user " + this.bc.getUserLogin() + " in realm " + this.bc.consumerRealmName()), (boolean)isUserFound);
    }

    @Test
    public void loginWithExistingUser() {
        this.testLogInAsUserInIDP();
        Integer userCount = this.adminClient.realm(this.bc.consumerRealmName()).users().count();
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        this.logInWithBroker(this.bc);
        org.junit.Assert.assertEquals((Object)(this.accountPage.buildUri().toASCIIString().replace("master", "consumer") + "/"), (Object)this.driver.getCurrentUrl());
        org.junit.Assert.assertEquals((Object)userCount, (Object)this.adminClient.realm(this.bc.consumerRealmName()).users().count());
    }

    protected void testSingleLogout() {
        this.log.debug((Object)"Testing single log out");
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName()));
        Assert.assertTrue((String)"Should be logged in the account page", (boolean)this.driver.getTitle().endsWith("Account Management"));
        this.logoutFromRealm(BrokerTestTools.getProviderRoot(), this.bc.providerRealmName());
        Assert.assertTrue((String)("Should be on " + this.bc.providerRealmName() + " realm"), (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.providerRealmName()));
        this.driver.navigate().to(this.getAccountUrl(BrokerTestTools.getConsumerRoot(), this.bc.consumerRealmName()));
        Assert.assertTrue((String)("Should be on " + this.bc.consumerRealmName() + " realm on login page"), (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.bc.consumerRealmName() + "/protocol/openid-connect/"));
    }

    protected void createRolesForRealm(String realm) {
        RoleRepresentation managerRole = new RoleRepresentation(ROLE_MANAGER, null, false);
        RoleRepresentation friendlyManagerRole = new RoleRepresentation(ROLE_FRIENDLY_MANAGER, null, false);
        RoleRepresentation userRole = new RoleRepresentation(ROLE_USER, null, false);
        RoleRepresentation userGuideRole = new RoleRepresentation(ROLE_USER_DOT_GUIDE, null, false);
        RoleRepresentation emptyAttributeRole = new RoleRepresentation(EMPTY_ATTRIBUTE_ROLE, null, false);
        this.adminClient.realm(realm).roles().create(managerRole);
        this.adminClient.realm(realm).roles().create(friendlyManagerRole);
        this.adminClient.realm(realm).roles().create(userRole);
        this.adminClient.realm(realm).roles().create(userGuideRole);
        this.adminClient.realm(realm).roles().create(emptyAttributeRole);
    }

    static void enableUpdateProfileOnFirstLogin(AuthenticationExecutionInfoRepresentation execution, AuthenticationManagementResource flows) {
        if (execution.getProviderId() != null && execution.getProviderId().equals("idp-create-user-if-unique")) {
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.name());
            flows.updateExecutions("first broker login", execution);
        } else if (execution.getAlias() != null && execution.getAlias().equals("review profile config")) {
            AuthenticatorConfigRepresentation config = flows.getAuthenticatorConfig(execution.getAuthenticationConfig());
            config.getConfig().put("update.profile.on.first.login", "on");
            flows.updateAuthenticatorConfig(config.getId(), config);
        }
    }

    static void setUpMissingUpdateProfileOnFirstLogin(AuthenticationExecutionInfoRepresentation execution, AuthenticationManagementResource flows) {
        if (execution.getProviderId() != null && execution.getProviderId().equals("idp-create-user-if-unique")) {
            execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE.name());
            flows.updateExecutions("first broker login", execution);
        } else if (execution.getAlias() != null && execution.getAlias().equals("review profile config")) {
            AuthenticatorConfigRepresentation config = flows.getAuthenticatorConfig(execution.getAuthenticationConfig());
            config.getConfig().put("update.profile.on.first.login", "missing");
            flows.updateAuthenticatorConfig(config.getId(), config);
        }
    }

    static void enableRequirePassword(AuthenticationExecutionInfoRepresentation execution, AuthenticationManagementResource flows) {
        AuthenticatorConfigRepresentation authenticatorConfig;
        String id = execution.getAuthenticationConfig();
        if (id != null && (authenticatorConfig = flows.getAuthenticatorConfig(id)) != null) {
            Map config = authenticatorConfig.getConfig();
            if (config != null && config.containsKey("require.password.update.after.registration")) {
                config.put("require.password.update.after.registration", Boolean.TRUE.toString());
            }
            flows.updateAuthenticatorConfig(authenticatorConfig.getId(), authenticatorConfig);
        }
    }

    static void disableUpdateProfileOnFirstLogin(AuthenticationExecutionInfoRepresentation execution, AuthenticationManagementResource flows) {
        if (execution.getProviderId() != null && execution.getProviderId().equals("idp-create-user-if-unique")) {
            execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE.name());
            flows.updateExecutions("first broker login", execution);
        } else if (execution.getAlias() != null && execution.getAlias().equals("review profile config")) {
            AuthenticatorConfigRepresentation config = flows.getAuthenticatorConfig(execution.getAuthenticationConfig());
            config.getConfig().put("update.profile.on.first.login", "off");
            flows.updateAuthenticatorConfig(config.getId(), config);
        }
    }

    static void disableExistingUser(AuthenticationExecutionInfoRepresentation execution, AuthenticationManagementResource flows) {
        if (execution.getProviderId() != null && (execution.getProviderId().equals("idp-create-user-if-unique") || execution.getProviderId().equals("idp-confirm-link"))) {
            execution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED.name());
            flows.updateExecutions("first broker login", execution);
        }
    }
}

