/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.NotFoundException;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.resource.AuthorizationResource;
import org.keycloak.authorization.client.resource.PolicyResource;
import org.keycloak.authorization.client.resource.ProtectionResource;
import org.keycloak.authorization.client.util.HttpResponseException;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.PermissionResponse;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.UmaPermissionRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.authz.AbstractResourceServerTest;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.GroupBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UserManagedPermissionServiceTest
extends AbstractResourceServerTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name("authz-test").roles(RolesBuilder.create().realmRole(RoleBuilder.create().name("uma_authorization").build()).realmRole(RoleBuilder.create().name("uma_protection").build()).realmRole(RoleBuilder.create().name("role_a").build()).realmRole(RoleBuilder.create().name("role_b").build()).realmRole(RoleBuilder.create().name("role_c").build()).realmRole(RoleBuilder.create().name("role_d").build())).group(GroupBuilder.create().name("group_a").subGroups(Arrays.asList(GroupBuilder.create().name("group_b").build())).build()).group(GroupBuilder.create().name("group_c").build()).group(GroupBuilder.create().name("group_remove").build()).user(UserBuilder.create().username("marta").password("password").addRoles("uma_authorization", "uma_protection").role("resource-server-test", "uma_protection")).user(UserBuilder.create().username("alice").password("password").addRoles("uma_authorization", "uma_protection").role("resource-server-test", "uma_protection")).user(UserBuilder.create().username("kolo").password("password").addRoles("role_a").addGroups("group_a")).client(ClientBuilder.create().clientId("resource-server-test").secret("secret").authorizationServicesEnabled(true).redirectUris("http://localhost/resource-server-test").defaultRoles("uma_protection").directAccessGrants().serviceAccountsEnabled(true)).client(ClientBuilder.create().clientId("client-a").redirectUris("http://localhost/resource-server-test").publicClient()).client(ClientBuilder.create().clientId("client-remove").redirectUris("http://localhost/resource-server-test").publicClient()).build());
    }

    private void testCreate() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Resource A");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        resource = this.getAuthzClient().protection().resource().create(resource);
        UmaPermissionRepresentation newPermission = new UmaPermissionRepresentation();
        newPermission.setName("Custom User-Managed Permission");
        newPermission.setDescription("Users from specific roles are allowed to access");
        newPermission.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        newPermission.addRole(new String[]{"role_a", "role_b", "role_c", "role_d"});
        newPermission.addGroup(new String[]{"/group_a", "/group_a/group_b", "/group_c"});
        newPermission.addClient(new String[]{"client-a", "resource-server-test"});
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPLOAD_SCRIPTS)) {
            newPermission.setCondition("$evaluation.grant()");
        }
        newPermission.addUser(new String[]{"kolo"});
        ProtectionResource protection = this.getAuthzClient().protection("marta", "password");
        UmaPermissionRepresentation permission = protection.policy(resource.getId()).create(newPermission);
        Assert.assertEquals((Object)newPermission.getName(), (Object)permission.getName());
        Assert.assertEquals((Object)newPermission.getDescription(), (Object)permission.getDescription());
        Assert.assertNotNull((Object)permission.getScopes());
        Assert.assertTrue((boolean)permission.getScopes().containsAll(newPermission.getScopes()));
        Assert.assertNotNull((Object)permission.getRoles());
        Assert.assertTrue((boolean)permission.getRoles().containsAll(newPermission.getRoles()));
        Assert.assertNotNull((Object)permission.getGroups());
        Assert.assertTrue((boolean)permission.getGroups().containsAll(newPermission.getGroups()));
        Assert.assertNotNull((Object)permission.getClients());
        Assert.assertTrue((boolean)permission.getClients().containsAll(newPermission.getClients()));
        Assert.assertEquals((Object)newPermission.getCondition(), (Object)permission.getCondition());
        Assert.assertNotNull((Object)permission.getUsers());
        Assert.assertTrue((boolean)permission.getUsers().containsAll(newPermission.getUsers()));
    }

    @Test
    public void testCreateDeprecatedFeaturesEnabled() {
        this.testCreate();
    }

    @Test
    @DisableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    public void testCreateDeprecatedFeaturesDisabled() {
        this.testCreate();
    }

    private void testUpdate() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Resource A");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        resource = this.getAuthzClient().protection().resource().create(resource);
        UmaPermissionRepresentation permission = new UmaPermissionRepresentation();
        permission.setName("Custom User-Managed Permission");
        permission.setDescription("Users from specific roles are allowed to access");
        permission.addScope(new String[]{"Scope A"});
        permission.addRole(new String[]{"role_a"});
        ProtectionResource protection = this.getAuthzClient().protection("marta", "password");
        permission = protection.policy(resource.getId()).create(permission);
        Assert.assertEquals((long)1L, (long)this.getAssociatedPolicies(permission).size());
        permission.setName("Changed");
        permission.setDescription("Changed");
        protection.policy(resource.getId()).update(permission);
        UmaPermissionRepresentation updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertEquals((Object)permission.getName(), (Object)updated.getName());
        Assert.assertEquals((Object)permission.getDescription(), (Object)updated.getDescription());
        permission.removeRole("role_a");
        permission.addRole(new String[]{"role_b", "role_c"});
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)1L, (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertTrue((boolean)permission.getRoles().containsAll(updated.getRoles()));
        permission.addRole(new String[]{"role_d"});
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)1L, (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertTrue((boolean)permission.getRoles().containsAll(updated.getRoles()));
        permission.addGroup(new String[]{"/group_a/group_b"});
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)2L, (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertTrue((boolean)permission.getGroups().containsAll(updated.getGroups()));
        permission.addGroup(new String[]{"/group_a"});
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)2L, (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertTrue((boolean)permission.getGroups().containsAll(updated.getGroups()));
        permission.removeGroup("/group_a/group_b");
        permission.addGroup(new String[]{"/group_c"});
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)2L, (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertTrue((boolean)permission.getGroups().containsAll(updated.getGroups()));
        permission.addClient(new String[]{"client-a"});
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)3L, (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertTrue((boolean)permission.getClients().containsAll(updated.getClients()));
        permission.addClient(new String[]{"resource-server-test"});
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)3L, (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertTrue((boolean)permission.getClients().containsAll(updated.getClients()));
        permission.removeClient("client-a");
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)3L, (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertTrue((boolean)permission.getClients().containsAll(updated.getClients()));
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPLOAD_SCRIPTS)) {
            permission.setCondition("$evaluation.grant()");
            protection.policy(resource.getId()).update(permission);
            Assert.assertEquals((long)4L, (long)this.getAssociatedPolicies(permission).size());
            updated = protection.policy(resource.getId()).findById(permission.getId());
            Assert.assertEquals((Object)permission.getCondition(), (Object)updated.getCondition());
        }
        permission.addUser(new String[]{"alice"});
        protection.policy(resource.getId()).update(permission);
        int expectedPolicies = Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPLOAD_SCRIPTS) ? 5 : 4;
        Assert.assertEquals((long)expectedPolicies, (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertEquals((long)1L, (long)updated.getUsers().size());
        Assert.assertEquals((Object)permission.getUsers(), (Object)updated.getUsers());
        permission.addUser(new String[]{"kolo"});
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)expectedPolicies, (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertEquals((long)2L, (long)updated.getUsers().size());
        Assert.assertEquals((Object)permission.getUsers(), (Object)updated.getUsers());
        permission.removeUser("alice");
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)expectedPolicies, (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertEquals((long)1L, (long)updated.getUsers().size());
        Assert.assertEquals((Object)permission.getUsers(), (Object)updated.getUsers());
        permission.setUsers(null);
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)(--expectedPolicies), (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertEquals((Object)permission.getUsers(), (Object)updated.getUsers());
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPLOAD_SCRIPTS)) {
            permission.setCondition(null);
            protection.policy(resource.getId()).update(permission);
            Assert.assertEquals((long)(--expectedPolicies), (long)this.getAssociatedPolicies(permission).size());
            updated = protection.policy(resource.getId()).findById(permission.getId());
            Assert.assertEquals((Object)permission.getCondition(), (Object)updated.getCondition());
        }
        permission.setRoles(null);
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)(--expectedPolicies), (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertEquals((Object)permission.getRoles(), (Object)updated.getRoles());
        permission.setClients(null);
        protection.policy(resource.getId()).update(permission);
        Assert.assertEquals((long)(--expectedPolicies), (long)this.getAssociatedPolicies(permission).size());
        updated = protection.policy(resource.getId()).findById(permission.getId());
        Assert.assertEquals((Object)permission.getClients(), (Object)updated.getClients());
        permission.setGroups(null);
        try {
            protection.policy(resource.getId()).update(permission);
            Assert.assertEquals((long)1L, (long)this.getAssociatedPolicies(permission).size());
            Assert.fail((String)"Permission must be removed because the last associated policy was removed");
        }
        catch (NotFoundException notFoundException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Expected not found");
        }
    }

    @Test
    public void testUpdateDeprecatedFeaturesEnabled() {
        this.testUpdate();
    }

    @Test
    @DisableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    public void testUpdateDeprecatedFeaturesDisabled() {
        this.testUpdate();
    }

    @Test
    @DisableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
    public void testUploadScriptDisabled() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Resource A");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        resource = this.getAuthzClient().protection().resource().create(resource);
        UmaPermissionRepresentation newPermission = new UmaPermissionRepresentation();
        newPermission.setName("Custom User-Managed Permission");
        newPermission.setDescription("Users from specific roles are allowed to access");
        newPermission.setCondition("$evaluation.grant()");
        ProtectionResource protection = this.getAuthzClient().protection("marta", "password");
        try {
            protection.policy(resource.getId()).create(newPermission);
            Assert.fail((String)"Should fail because upload scripts is disabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        newPermission.setCondition(null);
        UmaPermissionRepresentation representation = protection.policy(resource.getId()).create(newPermission);
        representation.setCondition("$evaluation.grant();");
        try {
            protection.policy(resource.getId()).update(newPermission);
            Assert.fail((String)"Should fail because upload scripts is disabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUserManagedPermission() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Resource A");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        resource = this.getAuthzClient().protection().resource().create(resource);
        UmaPermissionRepresentation permission = new UmaPermissionRepresentation();
        permission.setName("Custom User-Managed Permission");
        permission.setDescription("Users from specific roles are allowed to access");
        permission.addScope(new String[]{"Scope A"});
        permission.addRole(new String[]{"role_a"});
        ProtectionResource protection = this.getAuthzClient().protection("marta", "password");
        permission = protection.policy(resource.getId()).create(permission);
        AuthorizationResource authorization = this.getAuthzClient().authorization("kolo", "password");
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[]{"Scope A"});
        AuthorizationResponse authzResponse = authorization.authorize(request);
        Assert.assertNotNull((Object)authzResponse);
        permission.removeRole("role_a");
        permission.addRole(new String[]{"role_b"});
        protection.policy(resource.getId()).update(permission);
        try {
            authorization.authorize(request);
            Assert.fail((String)"User should not have permission");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
        }
        try {
            this.getAuthzClient().authorization("alice", "password").authorize(request);
            Assert.fail((String)"User should not have permission");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
        }
        permission.addRole(new String[]{"role_a"});
        protection.policy(resource.getId()).update(permission);
        authzResponse = authorization.authorize(request);
        Assert.assertNotNull((Object)authzResponse);
        protection.policy(resource.getId()).delete(permission.getId());
        try {
            authorization.authorize(request);
            Assert.fail((String)"User should not have permission");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
        }
        try {
            this.getAuthzClient().protection("marta", "password").policy(resource.getId()).findById(permission.getId());
            Assert.fail((String)"Permission must not exist");
        }
        catch (Exception e) {
            Assert.assertEquals((long)404L, (long)((HttpResponseException)HttpResponseException.class.cast(e.getCause())).getStatusCode());
        }
        permission = new UmaPermissionRepresentation();
        permission.setName("Custom User-Managed Permission");
        permission.setDescription("Specific users are allowed access to the resource");
        permission.addScope(new String[]{"Scope A"});
        permission.addUser(new String[]{"alice"});
        protection.policy(resource.getId()).create(permission);
        authzResponse = this.getAuthzClient().authorization("alice", "password").authorize(request);
        Assert.assertNotNull((Object)authzResponse);
        try {
            authorization.authorize(request);
            Assert.fail((String)"User should not have permission to access the protected resource");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
        }
    }

    @Test
    public void testPermissionInAdditionToUserGrantedPermission() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Resource A");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        resource = this.getAuthzClient().protection().resource().create(resource);
        PermissionResponse ticketResponse = this.getAuthzClient().protection().permission().create(new PermissionRequest(resource.getId(), new String[]{"Scope A"}));
        AuthorizationRequest request = new AuthorizationRequest();
        request.setTicket(ticketResponse.getTicket());
        try {
            this.getAuthzClient().authorization("kolo", "password").authorize(request);
            Assert.fail((String)"User should not have permission");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
            Assert.assertTrue((boolean)e.getMessage().contains("request_submitted"));
        }
        List tickets = this.getAuthzClient().protection().permission().findByResource(resource.getId());
        Assert.assertEquals((long)1L, (long)tickets.size());
        PermissionTicketRepresentation ticket = (PermissionTicketRepresentation)tickets.get(0);
        ticket.setGranted(true);
        this.getAuthzClient().protection().permission().update(ticket);
        AuthorizationResponse authzResponse = this.getAuthzClient().authorization("kolo", "password").authorize(request);
        Assert.assertNotNull((Object)authzResponse);
        UmaPermissionRepresentation permission = new UmaPermissionRepresentation();
        permission.setName("Custom User-Managed Permission");
        permission.addScope(new String[]{"Scope A"});
        permission.addRole(new String[]{"role_a"});
        ProtectionResource protection = this.getAuthzClient().protection("marta", "password");
        permission = protection.policy(resource.getId()).create(permission);
        this.getAuthzClient().authorization("kolo", "password").authorize(request);
        ticket.setGranted(false);
        this.getAuthzClient().protection().permission().update(ticket);
        this.getAuthzClient().authorization("kolo", "password").authorize(request);
        permission = this.getAuthzClient().protection("marta", "password").policy(resource.getId()).findById(permission.getId());
        Assert.assertNotNull((Object)permission);
        permission.removeRole("role_a");
        permission.addRole(new String[]{"role_b"});
        this.getAuthzClient().protection("marta", "password").policy(resource.getId()).update(permission);
        try {
            this.getAuthzClient().authorization("kolo", "password").authorize(request);
            Assert.fail((String)"User should not have permission");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
        }
        request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[0]);
        try {
            this.getAuthzClient().authorization("kolo", "password").authorize(request);
            Assert.fail((String)"User should not have permission");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
        }
        this.getAuthzClient().protection("marta", "password").policy(resource.getId()).delete(permission.getId());
        try {
            this.getAuthzClient().authorization("kolo", "password").authorize(request);
            Assert.fail((String)"User should not have permission");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
        }
    }

    @Test
    public void testPermissionWithoutScopes() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(UUID.randomUUID().toString());
        resource.setOwner("marta");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        ProtectionResource protection = this.getAuthzClient().protection();
        resource = protection.resource().create(resource);
        UmaPermissionRepresentation permission = new UmaPermissionRepresentation();
        permission.setName("Custom User-Managed Policy");
        permission.addRole(new String[]{"role_a"});
        PolicyResource policy = this.getAuthzClient().protection("marta", "password").policy(resource.getId());
        permission = policy.create(permission);
        Assert.assertEquals((long)3L, (long)permission.getScopes().size());
        Assert.assertTrue((boolean)Arrays.asList("Scope A", "Scope B", "Scope C").containsAll(permission.getScopes()));
        permission = policy.findById(permission.getId());
        Assert.assertTrue((boolean)Arrays.asList("Scope A", "Scope B", "Scope C").containsAll(permission.getScopes()));
        Assert.assertEquals((long)3L, (long)permission.getScopes().size());
        permission.removeScope("Scope B");
        policy.update(permission);
        permission = policy.findById(permission.getId());
        Assert.assertEquals((long)2L, (long)permission.getScopes().size());
        Assert.assertTrue((boolean)Arrays.asList("Scope A", "Scope C").containsAll(permission.getScopes()));
    }

    @Test
    public void testOnlyResourceOwnerCanManagePolicies() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(UUID.randomUUID().toString());
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        ProtectionResource protection = this.getAuthzClient().protection();
        resource = protection.resource().create(resource);
        try {
            this.getAuthzClient().protection("alice", "password").policy(resource.getId()).create(new UmaPermissionRepresentation());
            Assert.fail((String)"Error expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(e.getCause())).toString().contains("Only resource owner can access policies for resource"));
        }
    }

    @Test
    public void testOnlyResourcesWithOwnerManagedAccess() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(UUID.randomUUID().toString());
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        ProtectionResource protection = this.getAuthzClient().protection();
        resource = protection.resource().create(resource);
        try {
            this.getAuthzClient().protection("marta", "password").policy(resource.getId()).create(new UmaPermissionRepresentation());
            Assert.fail((String)"Error expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(e.getCause())).toString().contains("Only resources with owner managed accessed can have policies"));
        }
    }

    @Test
    public void testOwnerAccess() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(UUID.randomUUID().toString());
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        ProtectionResource protection = this.getAuthzClient().protection();
        resource = protection.resource().create(resource);
        UmaPermissionRepresentation rep = null;
        try {
            rep = new UmaPermissionRepresentation();
            rep.setName("test");
            rep.addRole(new String[]{"role_b"});
            rep = this.getAuthzClient().protection("marta", "password").policy(resource.getId()).create(rep);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)((HttpResponseException)HttpResponseException.class.cast(e.getCause())).toString().contains("Only resources with owner managed accessed can have policies"));
        }
        AuthorizationResource authorization = this.getAuthzClient().authorization("marta", "password");
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[]{"Scope A"});
        AuthorizationResponse authorize = authorization.authorize(request);
        Assert.assertNotNull((Object)authorize);
        try {
            this.getAuthzClient().authorization("kolo", "password").authorize(request);
            Assert.fail((String)"User should not have permission");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
        }
        rep.addRole(new String[]{"role_a"});
        this.getAuthzClient().protection("marta", "password").policy(resource.getId()).update(rep);
        authorization = this.getAuthzClient().authorization("kolo", "password");
        Assert.assertNotNull((Object)authorization.authorize(request));
    }

    @Test
    public void testFindPermission() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(UUID.randomUUID().toString());
        resource.setOwner("marta");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        ProtectionResource protection = this.getAuthzClient().protection();
        resource = protection.resource().create(resource);
        PolicyResource policy = this.getAuthzClient().protection("marta", "password").policy(resource.getId());
        for (int i = 0; i < 10; ++i) {
            UmaPermissionRepresentation permission = new UmaPermissionRepresentation();
            permission.setName("Custom User-Managed Policy " + i);
            permission.addRole(new String[]{"role_a"});
            policy.create(permission);
        }
        Assert.assertEquals((long)10L, (long)policy.find(null, null, null, null).size());
        List byId = policy.find("Custom User-Managed Policy 8", null, null, null);
        Assert.assertEquals((long)1L, (long)byId.size());
        Assert.assertEquals((Object)((UmaPermissionRepresentation)byId.get(0)).getId(), (Object)policy.findById(((UmaPermissionRepresentation)byId.get(0)).getId()).getId());
        Assert.assertEquals((long)10L, (long)policy.find(null, "Scope A", null, null).size());
        Assert.assertEquals((long)5L, (long)policy.find(null, null, Integer.valueOf(-1), Integer.valueOf(5)).size());
        Assert.assertEquals((long)2L, (long)policy.find(null, null, Integer.valueOf(-1), Integer.valueOf(2)).size());
    }

    @Test
    public void testGrantRequestedScopesOnly() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName(UUID.randomUUID().toString());
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.setOwner("marta");
        resource.addScope(new String[]{"view", "delete"});
        ProtectionResource protection = this.getAuthzClient().protection("marta", "password");
        resource = protection.resource().create(resource);
        UmaPermissionRepresentation permission = new UmaPermissionRepresentation();
        permission.setName("Custom User-Managed Permission");
        permission.addScope(new String[]{"view"});
        permission.addUser(new String[]{"kolo"});
        permission = protection.policy(resource.getId()).create(permission);
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[]{"view"});
        AuthorizationResponse response = this.getAuthzClient().authorization("kolo", "password").authorize(request);
        AccessToken rpt = this.toAccessToken(response.getToken());
        Collection permissions = rpt.getAuthorization().getPermissions();
        this.assertPermissions(permissions, resource.getId(), "view");
        Assert.assertTrue((boolean)permissions.isEmpty());
        request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[]{"delete"});
        try {
            this.getAuthzClient().authorization("kolo", "password").authorize(request);
            Assert.fail((String)"User should not have permission");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
        }
        request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[]{"delete"});
        try {
            this.getAuthzClient().authorization("kolo", "password").authorize(request);
            Assert.fail((String)"User should not have permission");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
        }
        request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[0]);
        response = this.getAuthzClient().authorization("kolo", "password").authorize(request);
        rpt = this.toAccessToken(response.getToken());
        permissions = rpt.getAuthorization().getPermissions();
        this.assertPermissions(permissions, resource.getId(), "view");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testDoNotGrantPermissionWhenObtainAllEntitlements() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Resource A");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        resource = this.getAuthzClient().protection().resource().create(resource);
        UmaPermissionRepresentation permission = new UmaPermissionRepresentation();
        permission.setName("Custom User-Managed Permission");
        permission.addScope(new String[]{"Scope A", "Scope B"});
        permission.addUser(new String[]{"kolo"});
        ProtectionResource protection = this.getAuthzClient().protection("marta", "password");
        protection.policy(resource.getId()).create(permission);
        AuthorizationResource authorization = this.getAuthzClient().authorization("kolo", "password");
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission(resource.getId(), new String[]{"Scope A", "Scope B"});
        AuthorizationResponse authzResponse = authorization.authorize(request);
        Assert.assertNotNull((Object)authzResponse);
        AccessToken token = this.toAccessToken(authzResponse.getToken());
        Assert.assertNotNull((Object)token.getAuthorization());
        Collection permissions = token.getAuthorization().getPermissions();
        Assert.assertEquals((long)1L, (long)permissions.size());
        Assert.assertTrue((boolean)((Permission)permissions.iterator().next()).getScopes().containsAll(Arrays.asList("Scope A", "Scope B")));
        try {
            this.getAuthzClient().authorization("kolo", "password").authorize();
            Assert.fail((String)"User should not have permission");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)AuthorizationDeniedException.class.isInstance(e));
        }
    }

    @Test
    public void testRemovePoliciesOnResourceDelete() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Resource A");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        resource = this.getAuthzClient().protection().resource().create(resource);
        UmaPermissionRepresentation newPermission = new UmaPermissionRepresentation();
        newPermission.setName("Custom User-Managed Permission");
        newPermission.setDescription("Users from specific roles are allowed to access");
        newPermission.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        newPermission.addRole(new String[]{"role_a", "role_b", "role_c", "role_d"});
        newPermission.addGroup(new String[]{"/group_a", "/group_a/group_b", "/group_c"});
        newPermission.addClient(new String[]{"client-a", "resource-server-test"});
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPLOAD_SCRIPTS)) {
            newPermission.setCondition("$evaluation.grant()");
        }
        newPermission.addUser(new String[]{"kolo"});
        ProtectionResource protection = this.getAuthzClient().protection("marta", "password");
        protection.policy(resource.getId()).create(newPermission);
        this.getTestingClient().server().run(UserManagedPermissionServiceTest::testRemovePoliciesOnResourceDelete);
    }

    private static void testRemovePoliciesOnResourceDelete(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("authz-test");
        ClientModel client = realm.getClientByClientId("resource-server-test");
        AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        UserModel user = session.users().getUserByUsername(realm, "marta");
        HashMap<Policy.FilterOption, String[]> filters = new HashMap<Policy.FilterOption, String[]>();
        filters.put(Policy.FilterOption.TYPE, new String[]{"uma"});
        filters.put(Policy.FilterOption.OWNER, new String[]{user.getId()});
        List policies = provider.getStoreFactory().getPolicyStore().findByResourceServer(filters, client.getId(), -1, -1);
        Assert.assertEquals((long)1L, (long)policies.size());
        Policy policy = (Policy)policies.get(0);
        Assert.assertFalse((boolean)policy.getResources().isEmpty());
        Resource resource = (Resource)policy.getResources().iterator().next();
        Assert.assertEquals((Object)"Resource A", (Object)resource.getName());
        provider.getStoreFactory().getResourceStore().delete(resource.getId());
        filters = new HashMap();
        filters.put(Policy.FilterOption.OWNER, new String[]{user.getId()});
        policies = provider.getStoreFactory().getPolicyStore().findByResourceServer(filters, client.getId(), -1, -1);
        Assert.assertTrue((boolean)policies.isEmpty());
    }

    @Test
    public void testRemovePoliciesOnGroupDelete() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Resource A");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        resource = this.getAuthzClient().protection().resource().create(resource);
        UmaPermissionRepresentation newPermission = new UmaPermissionRepresentation();
        newPermission.setName("Custom User-Managed Permission");
        newPermission.addGroup(new String[]{"/group_remove"});
        ProtectionResource protection = this.getAuthzClient().protection("marta", "password");
        protection.policy(resource.getId()).create(newPermission);
        this.getTestingClient().server().run(UserManagedPermissionServiceTest::testRemovePoliciesOnGroupDelete);
    }

    private static void testRemovePoliciesOnGroupDelete(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("authz-test");
        ClientModel client = realm.getClientByClientId("resource-server-test");
        AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        UserModel user = session.users().getUserByUsername(realm, "marta");
        HashMap<Policy.FilterOption, String[]> filters = new HashMap<Policy.FilterOption, String[]>();
        filters.put(Policy.FilterOption.TYPE, new String[]{"uma"});
        filters.put(Policy.FilterOption.OWNER, new String[]{user.getId()});
        List policies = provider.getStoreFactory().getPolicyStore().findByResourceServer(filters, client.getId(), -1, -1);
        Assert.assertEquals((long)1L, (long)policies.size());
        Policy policy = (Policy)policies.get(0);
        Assert.assertFalse((boolean)policy.getResources().isEmpty());
        Resource resource = (Resource)policy.getResources().iterator().next();
        Assert.assertEquals((Object)"Resource A", (Object)resource.getName());
        realm.removeGroup((GroupModel)realm.searchForGroupByNameStream("group_remove", Integer.valueOf(-1), Integer.valueOf(-1)).findAny().get());
        filters = new HashMap();
        filters.put(Policy.FilterOption.OWNER, new String[]{user.getId()});
        policies = provider.getStoreFactory().getPolicyStore().findByResourceServer(filters, client.getId(), -1, -1);
        Assert.assertTrue((boolean)policies.isEmpty());
    }

    @Test
    public void testRemovePoliciesOnClientDelete() {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setName("Resource A");
        resource.setOwnerManagedAccess(Boolean.valueOf(true));
        resource.setOwner("marta");
        resource.addScope(new String[]{"Scope A", "Scope B", "Scope C"});
        resource = this.getAuthzClient().protection().resource().create(resource);
        UmaPermissionRepresentation newPermission = new UmaPermissionRepresentation();
        newPermission.setName("Custom User-Managed Permission");
        newPermission.addClient(new String[]{"client-remove"});
        ProtectionResource protection = this.getAuthzClient().protection("marta", "password");
        protection.policy(resource.getId()).create(newPermission);
        this.getTestingClient().server().run(UserManagedPermissionServiceTest::testRemovePoliciesOnClientDelete);
    }

    private static void testRemovePoliciesOnClientDelete(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("authz-test");
        ClientModel client = realm.getClientByClientId("resource-server-test");
        AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        UserModel user = session.users().getUserByUsername(realm, "marta");
        HashMap<Policy.FilterOption, String[]> filters = new HashMap<Policy.FilterOption, String[]>();
        filters.put(Policy.FilterOption.TYPE, new String[]{"uma"});
        filters.put(Policy.FilterOption.OWNER, new String[]{user.getId()});
        List policies = provider.getStoreFactory().getPolicyStore().findByResourceServer(filters, client.getId(), -1, -1);
        Assert.assertEquals((long)1L, (long)policies.size());
        Policy policy = (Policy)policies.get(0);
        Assert.assertFalse((boolean)policy.getResources().isEmpty());
        Resource resource = (Resource)policy.getResources().iterator().next();
        Assert.assertEquals((Object)"Resource A", (Object)resource.getName());
        realm.removeClient(realm.getClientByClientId("client-remove").getId());
        filters = new HashMap();
        filters.put(Policy.FilterOption.OWNER, new String[]{user.getId()});
        policies = provider.getStoreFactory().getPolicyStore().findByResourceServer(filters, client.getId(), -1, -1);
        Assert.assertTrue((boolean)policies.isEmpty());
    }

    private List<PolicyRepresentation> getAssociatedPolicies(UmaPermissionRepresentation permission) {
        return this.getClient(this.getRealm()).authorization().policies().policy(permission.getId()).associatedPolicies();
    }
}

