/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.resource.PermissionResource;
import org.keycloak.events.EventType;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionTicketRepresentation;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.authz.AbstractResourceServerTest;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UserManagedAccessTest
extends AbstractResourceServerTest {
    private ResourceRepresentation resource;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Before
    public void configureAuthorization() throws Exception {
        ClientResource client = this.getClient(this.getRealm());
        AuthorizationResource authorization = client.authorization();
        JSPolicyRepresentation policy = new JSPolicyRepresentation();
        policy.setName("Only Owner Policy");
        policy.setCode("if ($evaluation.getContext().getIdentity().getId() == $evaluation.getPermission().getResource().getOwner()) {$evaluation.grant();}");
        authorization.policies().js().create(policy).close();
    }

    @Test
    public void testOnlyOwnerCanAccess() throws Exception {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        this.resource = this.addResource("Resource A", "marta", true, "ScopeA", "ScopeB");
        permission.setName(this.resource.getName() + " Permission");
        permission.addResource(this.resource.getId());
        permission.addPolicy(new String[]{"Only Owner Policy"});
        this.getClient(this.getRealm()).authorization().permissions().resource().create(permission).close();
        AuthorizationResponse response = this.authorize("marta", "password", this.resource.getName(), new String[]{"ScopeA", "ScopeB"});
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, this.resource.getName(), "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        try {
            response = this.authorize("kolo", "password", this.resource.getId(), new String[]{"ScopeA", "ScopeB"});
            Assert.fail((String)"User should have access to resource from another user");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testOnlyOwnerCanAccessPermissionsToScope() throws Exception {
        this.resource = this.addResource("Resource A", "marta", true, "ScopeA", "ScopeB");
        ScopePermissionRepresentation permission = new ScopePermissionRepresentation();
        permission.setName(this.resource.getName() + " Scope A Permission");
        permission.addScope(new String[]{"ScopeA"});
        permission.addPolicy(new String[]{"Only Owner Policy"});
        this.getClient(this.getRealm()).authorization().permissions().scope().create(permission).close();
        permission = new ScopePermissionRepresentation();
        permission.setName(this.resource.getName() + " Scope B Permission");
        permission.addScope(new String[]{"ScopeB"});
        permission.addPolicy(new String[]{"Only Owner Policy"});
        this.getClient(this.getRealm()).authorization().permissions().scope().create(permission).close();
        AuthorizationResponse response = this.authorize("marta", "password", this.resource.getName(), new String[]{"ScopeA", "ScopeB"});
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, this.resource.getName(), "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        try {
            response = this.authorize("kolo", "password", this.resource.getId(), new String[]{"ScopeA", "ScopeB"});
            Assert.fail((String)"User should not have access to resource from another user");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        List tickets = this.getAuthzClient().protection().permission().find(this.resource.getId(), null, null, null, null, null, null, null);
        for (PermissionTicketRepresentation ticket : tickets) {
            ticket.setGranted(true);
            this.getAuthzClient().protection().permission().update(ticket);
        }
        try {
            response = this.authorize("kolo", "password", this.resource.getId(), new String[]{"ScopeA", "ScopeB"});
        }
        catch (AuthorizationDeniedException ade) {
            Assert.fail((String)"User should have access to resource from another user");
        }
        rpt = response.getToken();
        accessToken = this.toAccessToken(rpt);
        authorization = accessToken.getAuthorization();
        permissions = authorization.getPermissions();
        this.assertPermissions(permissions, this.resource.getName(), "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        try {
            response = this.authorize("marta", "password", this.resource.getId(), new String[]{"ScopeB"});
        }
        catch (AuthorizationDeniedException ade) {
            Assert.fail((String)"User should have access to his own resources");
        }
        rpt = response.getToken();
        accessToken = this.toAccessToken(rpt);
        authorization = accessToken.getAuthorization();
        permissions = authorization.getPermissions();
        this.assertPermissions(permissions, this.resource.getName(), "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    @Test
    public void testOnlyOwnerCanAccessResourceWithType() throws Exception {
        ResourceRepresentation typedResource = this.addResource("Typed Resource", this.getClient(this.getRealm()).toRepresentation().getId(), false, "ScopeA", "ScopeB");
        typedResource.setType("my:resource");
        this.getClient(this.getRealm()).authorization().resources().resource(typedResource.getId()).update(typedResource);
        this.resource = this.addResource("Resource A", "marta", true, "ScopeA", "ScopeB");
        this.resource.setType(typedResource.getType());
        this.getClient(this.getRealm()).authorization().resources().resource(this.resource.getId()).update(this.resource);
        ResourceRepresentation resourceB = this.addResource("Resource B", "marta", true, "ScopeA", "ScopeB");
        resourceB.setType(typedResource.getType());
        this.getClient(this.getRealm()).authorization().resources().resource(resourceB.getId()).update(resourceB);
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(this.resource.getType() + " Permission");
        permission.setResourceType(this.resource.getType());
        permission.addPolicy(new String[]{"Only Owner Policy"});
        this.getClient(this.getRealm()).authorization().permissions().resource().create(permission).close();
        AuthorizationResponse response = this.authorize("marta", "password", this.resource.getName(), new String[]{"ScopeA", "ScopeB"});
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, this.resource.getName(), "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        try {
            response = this.authorize("kolo", "password", this.resource.getId(), new String[]{"ScopeA", "ScopeB"});
            Assert.fail((String)"User should not have access to resource from another user");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        List tickets = this.getAuthzClient().protection().permission().find(this.resource.getId(), null, null, null, null, null, null, null);
        for (PermissionTicketRepresentation ticket : tickets) {
            ticket.setGranted(true);
            this.getAuthzClient().protection().permission().update(ticket);
        }
        try {
            response = this.authorize("kolo", "password", this.resource.getId(), new String[]{"ScopeA", "ScopeB"});
        }
        catch (AuthorizationDeniedException ade) {
            Assert.fail((String)"User should have access to resource from another user");
        }
        permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, this.resource.getName(), "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        for (PermissionTicketRepresentation ticket : tickets) {
            this.getAuthzClient().protection().permission().delete(ticket.getId());
        }
        tickets = this.getAuthzClient().protection().permission().find(this.resource.getId(), null, null, null, null, null, null, null);
        Assert.assertEquals((long)0L, (long)tickets.size());
        try {
            response = this.authorize("kolo", "password", this.resource.getId(), new String[]{"ScopeA", "ScopeB"});
            Assert.fail((String)"User should not have access to resource from another user");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testUserGrantsAccessToResource() throws Exception {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        this.resource = this.addResource("Resource A", "marta", true, "ScopeA", "ScopeB");
        permission.setName(this.resource.getName() + " Permission");
        permission.addResource(this.resource.getId());
        permission.addPolicy(new String[]{"Only Owner Policy"});
        ClientResource client = this.getClient(this.getRealm());
        client.authorization().permissions().resource().create(permission).close();
        AuthorizationResponse response = this.authorize("marta", "password", "Resource A", new String[]{"ScopeA", "ScopeB"});
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        this.getTestContext().getTestingClient().testing().clearEventQueue();
        try {
            response = this.authorize("kolo", "password", this.resource.getId(), new String[0]);
            Assert.fail((String)"User should not have access to resource from another user");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        String realmId = this.getRealm().toRepresentation().getId();
        String clientId = client.toRepresentation().getClientId();
        this.events.expectLogin().realm(realmId).client(clientId).user(AssertEvents.isUUID()).clearDetails().assertEvent();
        this.events.expectLogin().realm(realmId).client(clientId).user(AssertEvents.isUUID()).clearDetails().assertEvent();
        this.events.expect(EventType.PERMISSION_TOKEN_ERROR).realm(realmId).client(clientId).user(AssertEvents.isUUID()).session((String)null).error("access_denied").detail("reason", "request_submitted").assertEvent();
        PermissionResource permissionResource = this.getAuthzClient().protection().permission();
        List permissionTickets = permissionResource.findByResource(this.resource.getId());
        Assert.assertFalse((boolean)permissionTickets.isEmpty());
        Assert.assertEquals((long)2L, (long)permissionTickets.size());
        for (PermissionTicketRepresentation ticket : permissionTickets) {
            Assert.assertFalse((boolean)ticket.isGranted());
            ticket.setGranted(true);
            permissionResource.update(ticket);
        }
        permissionTickets = permissionResource.findByResource(this.resource.getId());
        Assert.assertFalse((boolean)permissionTickets.isEmpty());
        Assert.assertEquals((long)2L, (long)permissionTickets.size());
        for (PermissionTicketRepresentation ticket : permissionTickets) {
            Assert.assertTrue((boolean)ticket.isGranted());
        }
        this.getTestContext().getTestingClient().testing().clearEventQueue();
        response = this.authorize("kolo", "password", this.resource.getId(), new String[]{"ScopeA", "ScopeB"});
        rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        accessToken = this.toAccessToken(rpt);
        authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, this.resource.getName(), "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        this.events.expectLogin().realm(realmId).client(clientId).user(AssertEvents.isUUID()).clearDetails().assertEvent();
        this.events.expectLogin().realm(realmId).client(clientId).user(AssertEvents.isUUID()).clearDetails().assertEvent();
        this.events.expect(EventType.PERMISSION_TOKEN).realm(realmId).client(clientId).user(AssertEvents.isUUID()).session((String)null).clearDetails().assertEvent();
    }

    @Test
    public void testUserGrantedAccessConsideredWhenRequestingAuthorizationByResourceName() throws Exception {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        this.resource = this.addResource("Resource A", "marta", true, "ScopeA", "ScopeB");
        permission.setName(this.resource.getName() + " Permission");
        permission.addResource(this.resource.getId());
        permission.addPolicy(new String[]{"Only Owner Policy"});
        this.getClient(this.getRealm()).authorization().permissions().resource().create(permission).close();
        try {
            AuthorizationResponse response = this.authorize("kolo", "password", this.resource.getId(), new String[0]);
            Assert.fail((String)"User should not have access to resource from another user");
        }
        catch (AuthorizationDeniedException response) {
            // empty catch block
        }
        PermissionResource permissionResource = this.getAuthzClient().protection().permission();
        List permissionTickets = permissionResource.findByResource(this.resource.getId());
        Assert.assertFalse((boolean)permissionTickets.isEmpty());
        Assert.assertEquals((long)2L, (long)permissionTickets.size());
        for (PermissionTicketRepresentation ticket : permissionTickets) {
            Assert.assertFalse((boolean)ticket.isGranted());
            ticket.setGranted(true);
            permissionResource.update(ticket);
        }
        permissionTickets = permissionResource.findByResource(this.resource.getId());
        Assert.assertFalse((boolean)permissionTickets.isEmpty());
        Assert.assertEquals((long)2L, (long)permissionTickets.size());
        for (PermissionTicketRepresentation ticket : permissionTickets) {
            Assert.assertTrue((boolean)ticket.isGranted());
        }
        AuthorizationRequest request = new AuthorizationRequest();
        request.addPermission("Resource A", new String[]{"ScopeA", "ScopeB"});
        List<Permission> permissions = this.authorize("kolo", "password", request);
        Assert.assertEquals((long)1L, (long)permissions.size());
        Permission koloPermission = permissions.get(0);
        Assert.assertEquals((Object)"Resource A", (Object)koloPermission.getResourceName());
        Assert.assertTrue((boolean)koloPermission.getScopes().containsAll(Arrays.asList("ScopeA", "ScopeB")));
        ResourceRepresentation resourceRep = this.getAuthzClient().protection().resource().findById(this.resource.getId());
        resourceRep.setName("Resource A Changed");
        this.getAuthzClient().protection().resource().update(resourceRep);
        request = new AuthorizationRequest();
        request.addPermission("Resource A", new String[]{"ScopeA", "ScopeB"});
        try {
            this.authorize("kolo", "password", request);
            Assert.fail((String)"User should not have access to resource from another user");
        }
        catch (RuntimeException ade) {
            Assert.assertTrue((boolean)ade.getCause().toString().contains("invalid_resource"));
        }
        request = new AuthorizationRequest();
        request.addPermission(resourceRep.getName(), new String[]{"ScopeA", "ScopeB"});
        permissions = this.authorize("kolo", "password", request);
        Assert.assertEquals((long)1L, (long)permissions.size());
        koloPermission = permissions.get(0);
        Assert.assertEquals((Object)resourceRep.getName(), (Object)koloPermission.getResourceName());
        Assert.assertTrue((boolean)koloPermission.getScopes().containsAll(Arrays.asList("ScopeA", "ScopeB")));
    }

    @Test
    public void testUserGrantsAccessToResourceWithoutScopes() throws Exception {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        this.resource = this.addResource("Resource A", "marta", true, new String[0]);
        permission.setName(this.resource.getName() + " Permission");
        permission.addResource(this.resource.getId());
        permission.addPolicy(new String[]{"Only Owner Policy"});
        this.getClient(this.getRealm()).authorization().permissions().resource().create(permission).close();
        AuthorizationResponse response = this.authorize("marta", "password", "Resource A", new String[0]);
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", new String[0]);
        Assert.assertTrue((boolean)permissions.isEmpty());
        try {
            response = this.authorize("kolo", "password", this.resource.getId(), new String[0]);
            Assert.fail((String)"User should have access to resource from another user");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        PermissionResource permissionResource = this.getAuthzClient().protection().permission();
        List permissionTickets = permissionResource.findByResource(this.resource.getId());
        Assert.assertFalse((boolean)permissionTickets.isEmpty());
        Assert.assertEquals((long)1L, (long)permissionTickets.size());
        for (PermissionTicketRepresentation ticket : permissionTickets) {
            Assert.assertFalse((boolean)ticket.isGranted());
            ticket.setGranted(true);
            permissionResource.update(ticket);
        }
        permissionTickets = permissionResource.findByResource(this.resource.getId());
        Assert.assertFalse((boolean)permissionTickets.isEmpty());
        Assert.assertEquals((long)1L, (long)permissionTickets.size());
        for (PermissionTicketRepresentation ticket : permissionTickets) {
            Assert.assertTrue((boolean)ticket.isGranted());
        }
        response = this.authorize("kolo", "password", this.resource.getId(), new String[0]);
        rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        accessToken = this.toAccessToken(rpt);
        authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, this.resource.getName(), new String[0]);
        Assert.assertTrue((boolean)permissions.isEmpty());
        response = this.authorize("kolo", "password", this.resource.getId(), new String[0]);
        rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        accessToken = this.toAccessToken(rpt);
        authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, this.resource.getName(), new String[0]);
        Assert.assertTrue((boolean)permissions.isEmpty());
        permissionTickets = permissionResource.findByResource(this.resource.getId());
        Assert.assertFalse((boolean)permissionTickets.isEmpty());
        Assert.assertEquals((long)1L, (long)permissionTickets.size());
        for (PermissionTicketRepresentation ticket : permissionTickets) {
            Assert.assertTrue((boolean)ticket.isGranted());
        }
        for (PermissionTicketRepresentation ticket : permissionTickets) {
            permissionResource.delete(ticket.getId());
        }
        permissionTickets = permissionResource.findByResource(this.resource.getId());
        Assert.assertEquals((long)0L, (long)permissionTickets.size());
    }

    @Test
    public void testScopePermissionsToScopeOnly() throws Exception {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        this.resource = this.addResource("Resource A", "marta", true, "ScopeA", "ScopeB");
        permission.setName(this.resource.getName() + " Permission");
        permission.addResource(this.resource.getId());
        permission.addPolicy(new String[]{"Only Owner Policy"});
        this.getClient(this.getRealm()).authorization().permissions().resource().create(permission).close();
        AuthorizationResponse response = this.authorize("marta", "password", "Resource A", new String[]{"ScopeA", "ScopeB"});
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", "ScopeA", "ScopeB");
        Assert.assertTrue((boolean)permissions.isEmpty());
        try {
            response = this.authorize("kolo", "password", this.resource.getId(), new String[]{"ScopeA"});
            Assert.fail((String)"User should not have access to resource from another user");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        PermissionResource permissionResource = this.getAuthzClient().protection().permission();
        List permissionTickets = permissionResource.findByResource(this.resource.getId());
        Assert.assertFalse((boolean)permissionTickets.isEmpty());
        Assert.assertEquals((long)1L, (long)permissionTickets.size());
        PermissionTicketRepresentation ticket = (PermissionTicketRepresentation)permissionTickets.get(0);
        Assert.assertFalse((boolean)ticket.isGranted());
        ticket.setGranted(true);
        permissionResource.update(ticket);
        response = this.authorize("kolo", "password", this.resource.getId(), new String[]{"ScopeA", "ScopeB"});
        rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        accessToken = this.toAccessToken(rpt);
        authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, this.resource.getName(), "ScopeA");
        Assert.assertTrue((boolean)permissions.isEmpty());
        permissionTickets = permissionResource.findByResource(this.resource.getId());
        Assert.assertFalse((boolean)permissionTickets.isEmpty());
        Assert.assertEquals((long)2L, (long)permissionTickets.size());
        for (PermissionTicketRepresentation representation : new ArrayList(permissionTickets)) {
            if (!representation.isGranted()) continue;
            permissionResource.delete(representation.getId());
        }
        permissionTickets = permissionResource.findByResource(this.resource.getId());
        Assert.assertEquals((long)1L, (long)permissionTickets.size());
    }

    @Test
    public void testPermissiveModePermissions() throws Exception {
        this.resource = this.addResource("Resource A", new String[0]);
        try {
            this.authorize("kolo", "password", this.resource.getId(), null);
            Assert.fail((String)"Access should be denied, server in enforcing mode");
        }
        catch (AuthorizationDeniedException authorizationDeniedException) {
            // empty catch block
        }
        AuthorizationResource authorizationResource = this.getClient(this.getRealm()).authorization();
        ResourceServerRepresentation settings = authorizationResource.getSettings();
        settings.setPolicyEnforcementMode(PolicyEnforcementMode.PERMISSIVE);
        authorizationResource.update(settings);
        AuthorizationResponse response = this.authorize("marta", "password", "Resource A", null);
        String rpt = response.getToken();
        Assert.assertNotNull((Object)rpt);
        Assert.assertFalse((boolean)response.isUpgraded());
        AccessToken accessToken = this.toAccessToken(rpt);
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        Assert.assertNotNull((Object)authorization);
        Collection permissions = authorization.getPermissions();
        Assert.assertNotNull((Object)permissions);
        this.assertPermissions(permissions, "Resource A", new String[0]);
        Assert.assertTrue((boolean)permissions.isEmpty());
    }

    private List<Permission> authorize(String userName, String password, AuthorizationRequest request) {
        AuthorizationResponse response = this.getAuthzClient().authorization(userName, password).authorize(request);
        AccessToken token = this.toAccessToken(response.getToken());
        AccessToken.Authorization authorization = token.getAuthorization();
        return new ArrayList<Permission>(authorization.getPermissions());
    }
}

